/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.BitmapData;
import oracle.dss.graph.flash.jswiff.swfrecords.ColorMapData;
import oracle.dss.graph.flash.jswiff.swfrecords.ZlibBitmapData;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefinitionTag;

public final class DefineBitsLossless
extends DefinitionTag {
    public static final short FORMAT_8_BIT_COLORMAPPED = 3;
    public static final short FORMAT_15_BIT_RGB = 4;
    public static final short FORMAT_24_BIT_RGB = 5;
    private short format;
    private int width;
    private int height;
    private ZlibBitmapData zlibBitmapData;

    public DefineBitsLossless(int characterId, short format, int width, int height, ZlibBitmapData zlibBitmapData) {
        this.code = (short)20;
        this.characterId = characterId;
        this.format = format;
        this.width = width;
        this.height = height;
        this.zlibBitmapData = zlibBitmapData;
    }

    DefineBitsLossless() {
    }

    public void setFormat(short format) {
        this.format = format;
    }

    public short getFormat() {
        return this.format;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setZlibBitmapData(ZlibBitmapData zlibBitmapData) {
        this.zlibBitmapData = zlibBitmapData;
    }

    public ZlibBitmapData getZlibBitmapData() {
        return this.zlibBitmapData;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        this.forceLongHeader = true;
        outStream.writeUI16(this.characterId);
        outStream.writeUI8(this.format);
        outStream.writeUI16(this.width);
        outStream.writeUI16(this.height);
        if (this.format == 3) {
            int colorTableSize = ((ColorMapData)this.zlibBitmapData).getColorTableRGB().length;
            outStream.writeUI8((short)(colorTableSize - 1));
        }
        OutputBitStream zStream = new OutputBitStream();
        zStream.enableCompression();
        this.zlibBitmapData.write(zStream);
        byte[] zData = zStream.getData();
        outStream.writeBytes(zData);
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        this.characterId = inStream.readUI16();
        this.format = inStream.readUI8();
        this.width = inStream.readUI16();
        this.height = inStream.readUI16();
        short colorTableSize = 0;
        if (this.format == 3) {
            colorTableSize = (short)(inStream.readUI8() + 1);
        }
        int zLength = (int)((long)data.length - inStream.getOffset());
        byte[] zData = new byte[zLength];
        System.arraycopy(data, (int)inStream.getOffset(), zData, 0, zLength);
        InputBitStream zStream = new InputBitStream(zData);
        zStream.enableCompression();
        switch (this.format) {
            case 3: {
                this.zlibBitmapData = new ColorMapData(zStream, colorTableSize, this.width, this.height);
                break;
            }
            case 4: 
            case 5: {
                this.zlibBitmapData = new BitmapData(zStream, this.format, this.width, this.height);
                break;
            }
            default: {
                throw new IOException("Unknown bitmap format!");
            }
        }
    }
}

