/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import java.util.Vector;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.ButtonRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ActionBlock;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefinitionTag;

public final class DefineButton
extends DefinitionTag {
    private ButtonRecord[] characters;
    private ActionBlock actionBlock;

    public DefineButton(int characterId, ButtonRecord[] characters) {
        this.code = (short)7;
        if (characters == null || characters.length == 0) {
            throw new IllegalArgumentException("At least one button record is needed!");
        }
        this.characterId = characterId;
        this.characters = characters;
    }

    DefineButton() {
    }

    public ActionBlock getActions() {
        if (this.actionBlock == null) {
            this.actionBlock = new ActionBlock();
        }
        return this.actionBlock;
    }

    public void setCharacters(ButtonRecord[] characters) {
        this.characters = characters;
    }

    public ButtonRecord[] getCharacters() {
        return this.characters;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        outStream.writeUI16(this.characterId);
        int i = 0;
        while (i < this.characters.length) {
            this.characters[i].write(outStream, false);
            ++i;
        }
        outStream.writeUI8((short)0);
        this.getActions().write(outStream, true);
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        if (this.getSWFVersion() < 6) {
            if (this.isJapanese()) {
                inStream.setShiftJIS(true);
            } else {
                inStream.setANSI(true);
            }
        }
        this.characterId = inStream.readUI16();
        Vector<ButtonRecord> buttonRecords = new Vector<ButtonRecord>();
        while (true) {
            if (data[(int)inStream.getOffset()] == 0) break;
            buttonRecords.add(new ButtonRecord(inStream, false));
        }
        inStream.readUI8();
        this.characters = new ButtonRecord[buttonRecords.size()];
        buttonRecords.copyInto(this.characters);
        this.actionBlock = new ActionBlock(inStream);
    }
}

