/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import java.util.Vector;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.ButtonCondAction;
import oracle.dss.graph.flash.jswiff.swfrecords.ButtonRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefinitionTag;

public final class DefineButton2
extends DefinitionTag {
    private boolean trackAsMenu;
    private ButtonRecord[] characters;
    private ButtonCondAction[] actions;

    public DefineButton2(int characterId, ButtonRecord[] characters, boolean trackAsMenu) {
        this.code = (short)34;
        this.characterId = characterId;
        this.characters = characters;
        this.trackAsMenu = trackAsMenu;
    }

    DefineButton2() {
    }

    public void setActions(ButtonCondAction[] actions) {
        this.actions = actions;
    }

    public ButtonCondAction[] getActions() {
        return this.actions;
    }

    public void setCharacters(ButtonRecord[] characters) {
        this.characters = characters;
    }

    public ButtonRecord[] getCharacters() {
        return this.characters;
    }

    public void setTrackAsMenu(boolean trackAsMenu) {
        this.trackAsMenu = trackAsMenu;
    }

    public boolean isTrackAsMenu() {
        return this.trackAsMenu;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        this.forceLongHeader = true;
        outStream.writeUI16(this.characterId);
        outStream.writeUnsignedBits(0L, 7);
        outStream.writeBooleanBit(this.trackAsMenu);
        if (this.actions == null || this.actions.length == 0) {
            outStream.writeUI16(0);
            int i = 0;
            while (i < this.characters.length) {
                this.characters[i].write(outStream, true);
                ++i;
            }
            outStream.writeUI8((short)0);
        } else {
            OutputBitStream charStream = new OutputBitStream();
            int i = 0;
            while (i < this.characters.length) {
                this.characters[i].write(charStream, true);
                ++i;
            }
            charStream.writeUI8((short)0);
            byte[] charStreamBuffer = charStream.getData();
            outStream.writeUI16(charStreamBuffer.length + 2);
            outStream.writeBytes(charStreamBuffer);
            int i2 = 0;
            while (i2 < this.actions.length) {
                OutputBitStream bitStream = new OutputBitStream();
                bitStream.setANSI(outStream.isANSI());
                bitStream.setShiftJIS(outStream.isShiftJIS());
                this.actions[i2].write(bitStream);
                byte[] bitStreamData = bitStream.getData();
                if (i2 < this.actions.length - 1) {
                    outStream.writeUI16(bitStreamData.length + 2);
                } else {
                    outStream.writeUI16(0);
                }
                outStream.writeBytes(bitStreamData);
                ++i2;
            }
        }
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        if (this.getSWFVersion() < 6) {
            if (this.isJapanese()) {
                inStream.setShiftJIS(true);
            } else {
                inStream.setANSI(true);
            }
        }
        this.characterId = inStream.readUI16();
        this.trackAsMenu = (inStream.readUI8() & 1) != 0;
        int actionOffset = inStream.readUI16();
        Vector<ButtonRecord> buttonRecords = new Vector<ButtonRecord>();
        long startOffset = inStream.getOffset();
        while (true) {
            long remainingBytes = (long)data.length - inStream.getOffset();
            if (actionOffset == 0 && remainingBytes == 1L || inStream.getOffset() - startOffset == (long)(actionOffset - 3) || remainingBytes < (long)6) break;
            buttonRecords.add(new ButtonRecord(inStream, true));
        }
        inStream.readUI8();
        this.characters = new ButtonRecord[buttonRecords.size()];
        buttonRecords.copyInto(this.characters);
        if (actionOffset == 0) {
            return;
        }
        Vector<ButtonCondAction> buttonCondActions = new Vector<ButtonCondAction>();
        int condActionSize = -1;
        do {
            condActionSize = inStream.readUI16();
            buttonCondActions.add(new ButtonCondAction(inStream));
        } while (condActionSize != 0);
        this.actions = new ButtonCondAction[buttonCondActions.size()];
        buttonCondActions.copyInto(this.actions);
    }
}

