/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.RGBA;
import oracle.dss.graph.flash.jswiff.swfrecords.Rect;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefinitionTag;

public final class DefineEditText
extends DefinitionTag {
    public static final short ALIGN_LEFT = 0;
    public static final short ALIGN_RIGHT = 1;
    public static final short ALIGN_CENTER = 2;
    public static final short ALIGN_JUSTIFY = 3;
    private Rect bounds;
    private boolean wordWrap;
    private boolean multiline;
    private boolean password;
    private boolean readOnly;
    private boolean autoSize;
    private boolean noSelect;
    private boolean border;
    private boolean html;
    private boolean useOutlines;
    private int fontId;
    private int fontHeight;
    private RGBA textColor;
    private int maxLength;
    private short align;
    private int leftMargin;
    private int rightMargin;
    private int indent;
    private int leading;
    private String variableName;
    private String initialText;
    private boolean hasText;
    private boolean hasTextColor;
    private boolean hasMaxLength;
    private boolean hasFont;
    private boolean hasLayout;

    private void $init$() {
        this.fontId = -1;
    }

    public DefineEditText(int characterId, Rect bounds, String variableName) {
        this.$init$();
        this.code = (short)37;
        this.characterId = characterId;
        this.bounds = bounds;
        this.variableName = variableName;
    }

    DefineEditText() {
        this.$init$();
    }

    public short getAlign() {
        return this.align;
    }

    public void setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
    }

    public boolean isAutoSize() {
        return this.autoSize;
    }

    public void setBorder(boolean border) {
        this.border = border;
    }

    public boolean isBorder() {
        return this.border;
    }

    public Rect getBounds() {
        return this.bounds;
    }

    public void setFont(int fontId, int fontHeight) {
        this.fontId = fontId;
        this.fontHeight = fontHeight;
        this.hasFont = true;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public int getFontId() {
        return this.fontId;
    }

    public void setHtml(boolean html) {
        this.html = html;
    }

    public boolean isHtml() {
        return this.html;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setInitialText(String initialText) {
        this.initialText = initialText;
        this.hasText = true;
    }

    public String getInitialText() {
        return this.initialText;
    }

    public void setLayout(short align, int leftMargin, int rightMargin, int indent, int leading) {
        this.align = align;
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
        this.indent = indent;
        this.leading = leading;
        this.hasLayout = true;
    }

    public int getLeading() {
        return this.leading;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        this.hasMaxLength = true;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setNoSelect(boolean noSelect) {
        this.noSelect = noSelect;
    }

    public boolean isNoSelect() {
        return this.noSelect;
    }

    public void setPassword(boolean password) {
        this.password = password;
    }

    public boolean isPassword() {
        return this.password;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public void setTextColor(RGBA textColor) {
        this.textColor = textColor;
        this.hasTextColor = true;
    }

    public RGBA getTextColor() {
        return this.textColor;
    }

    public void setUseOutlines(boolean useOutlines) {
        this.useOutlines = useOutlines;
    }

    public boolean isUseOutlines() {
        return this.useOutlines;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setWordWrap(boolean wordWrap) {
        this.wordWrap = wordWrap;
    }

    public boolean isWordWrap() {
        return this.wordWrap;
    }

    public boolean hasFont() {
        return this.hasFont;
    }

    public boolean hasLayout() {
        return this.hasLayout;
    }

    public boolean hasMaxLength() {
        return this.hasMaxLength;
    }

    public boolean hasText() {
        return this.hasText;
    }

    public boolean hasTextColor() {
        return this.hasTextColor;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        outStream.writeUI16(this.characterId);
        this.bounds.write(outStream);
        outStream.writeBooleanBit(this.hasText);
        outStream.writeBooleanBit(this.wordWrap);
        outStream.writeBooleanBit(this.multiline);
        outStream.writeBooleanBit(this.password);
        outStream.writeBooleanBit(this.readOnly);
        outStream.writeBooleanBit(this.hasTextColor);
        outStream.writeBooleanBit(this.hasMaxLength);
        outStream.writeBooleanBit(this.hasFont);
        outStream.writeUnsignedBits(0L, 1);
        outStream.writeBooleanBit(this.autoSize);
        outStream.writeBooleanBit(this.hasLayout);
        outStream.writeBooleanBit(this.noSelect);
        outStream.writeBooleanBit(this.border);
        outStream.writeUnsignedBits(0L, 1);
        outStream.writeBooleanBit(this.html);
        outStream.writeBooleanBit(this.useOutlines);
        if (this.hasFont) {
            outStream.writeUI16(this.fontId);
            outStream.writeUI16(this.fontHeight);
        }
        if (this.hasTextColor) {
            this.textColor.write(outStream);
        }
        if (this.hasMaxLength) {
            outStream.writeUI16(this.maxLength);
        }
        if (this.hasLayout) {
            outStream.writeUI8(this.align);
            outStream.writeUI16(this.leftMargin);
            outStream.writeUI16(this.rightMargin);
            outStream.writeUI16(this.indent);
            outStream.writeUI16(this.leading);
        }
        if (this.variableName != null) {
            outStream.writeString(this.variableName);
        } else {
            outStream.writeString("");
        }
        if (this.hasText) {
            outStream.writeString(this.initialText);
        }
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        if (this.getSWFVersion() < 6) {
            if (this.isJapanese()) {
                inStream.setShiftJIS(true);
            } else {
                inStream.setANSI(true);
            }
        }
        this.characterId = inStream.readUI16();
        this.bounds = new Rect(inStream);
        this.hasText = inStream.readBooleanBit();
        this.wordWrap = inStream.readBooleanBit();
        this.multiline = inStream.readBooleanBit();
        this.password = inStream.readBooleanBit();
        this.readOnly = inStream.readBooleanBit();
        this.hasTextColor = inStream.readBooleanBit();
        this.hasMaxLength = inStream.readBooleanBit();
        this.hasFont = inStream.readBooleanBit();
        inStream.readBooleanBit();
        this.autoSize = inStream.readBooleanBit();
        this.hasLayout = inStream.readBooleanBit();
        this.noSelect = inStream.readBooleanBit();
        this.border = inStream.readBooleanBit();
        inStream.readBooleanBit();
        this.html = inStream.readBooleanBit();
        this.useOutlines = inStream.readBooleanBit();
        if (this.hasFont) {
            this.fontId = inStream.readUI16();
            this.fontHeight = inStream.readUI16();
        }
        if (this.hasTextColor) {
            this.textColor = new RGBA(inStream);
        }
        if (this.hasMaxLength) {
            this.maxLength = inStream.readUI16();
        }
        if (this.hasLayout) {
            this.align = inStream.readUI8();
            this.leftMargin = inStream.readUI16();
            this.rightMargin = inStream.readUI16();
            this.indent = inStream.readUI16();
            this.leading = inStream.readUI16();
        }
        this.variableName = inStream.readString();
        if (this.hasText) {
            this.initialText = inStream.readString();
        }
    }
}

