/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.Shape;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefinitionTag;

public final class DefineFont
extends DefinitionTag {
    private Shape[] glyphShapeTable;

    public DefineFont(int characterId, Shape[] glyphShapeTable) {
        this.code = (short)10;
        this.characterId = characterId;
        this.glyphShapeTable = glyphShapeTable;
    }

    DefineFont() {
    }

    public void setGlyphShapeTable(Shape[] glyphShapeTable) {
        this.glyphShapeTable = glyphShapeTable;
    }

    public Shape[] getGlyphShapeTable() {
        return this.glyphShapeTable;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        outStream.writeUI16(this.characterId);
        int shapeTableOffset = this.glyphShapeTable.length * 2;
        outStream.writeUI16(shapeTableOffset);
        OutputBitStream glyphShapeTableStream = new OutputBitStream();
        this.glyphShapeTable[0].write(glyphShapeTableStream);
        int i = 1;
        while (i < this.glyphShapeTable.length) {
            outStream.writeUI16((int)((long)shapeTableOffset + glyphShapeTableStream.getOffset()));
            this.glyphShapeTable[i].write(glyphShapeTableStream);
            ++i;
        }
        outStream.writeBytes(glyphShapeTableStream.getData());
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        this.characterId = inStream.readUI16();
        int shapeTableOffset = inStream.readUI16();
        int tableSize = shapeTableOffset / 2;
        inStream.readBytes(shapeTableOffset - 2);
        this.glyphShapeTable = new Shape[tableSize];
        int i = 0;
        while (i < tableSize) {
            this.glyphShapeTable[i] = new Shape(inStream);
            ++i;
        }
    }
}

