/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.KerningRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.LangCode;
import oracle.dss.graph.flash.jswiff.swfrecords.Rect;
import oracle.dss.graph.flash.jswiff.swfrecords.Shape;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefinitionTag;

public class DefineFont2
extends DefinitionTag {
    private boolean shiftJIS;
    private boolean smallText;
    private boolean ansi;
    private boolean italic;
    private boolean bold;
    private LangCode languageCode;
    private String fontName;
    private Shape[] glyphShapeTable;
    private char[] codeTable;
    private short ascent;
    private short descent;
    private short leading;
    private short[] advanceTable;
    private Rect[] boundsTable;
    private KerningRecord[] kerningTable;
    private int numGlyphs;
    private boolean hasLayout;

    public DefineFont2(int characterId, String fontName, Shape[] glyphShapeTable, char[] codeTable) {
        this.code = (short)48;
        this.characterId = characterId;
        this.fontName = fontName;
        if (glyphShapeTable != null) {
            this.glyphShapeTable = glyphShapeTable;
            this.numGlyphs = glyphShapeTable.length;
            if (codeTable.length != this.numGlyphs) {
                throw new IllegalArgumentException("Size of codeTable must be equal to glyph count!");
            }
            this.codeTable = codeTable;
        }
    }

    DefineFont2() {
    }

    public void setANSI(boolean ansi) {
        this.ansi = ansi;
        if (ansi) {
            this.shiftJIS = false;
        }
    }

    public boolean isANSI() {
        return this.ansi;
    }

    public short[] getAdvanceTable() {
        return this.advanceTable;
    }

    public short getAscent() {
        return this.ascent;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public boolean isBold() {
        return this.bold;
    }

    public Rect[] getBoundsTable() {
        return this.boundsTable;
    }

    public void setCodeTable(char[] codeTable) {
        this.codeTable = codeTable;
    }

    public char[] getCodeTable() {
        return this.codeTable;
    }

    public short getDescent() {
        return this.descent;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setGlyphShapeTable(Shape[] glyphShapeTable) {
        this.glyphShapeTable = glyphShapeTable;
    }

    public Shape[] getGlyphShapeTable() {
        return this.glyphShapeTable;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public KerningRecord[] getKerningTable() {
        return this.kerningTable;
    }

    public void setLanguageCode(LangCode languageCode) {
        this.languageCode = languageCode;
    }

    public LangCode getLanguageCode() {
        return this.languageCode;
    }

    public void setLayout(short ascent, short descent, short leading, short[] advanceTable, Rect[] boundsTable, KerningRecord[] kerningTable) {
        this.hasLayout = true;
        this.ascent = ascent;
        this.descent = descent;
        this.leading = leading;
        this.advanceTable = advanceTable;
        if (advanceTable == null || advanceTable.length != this.numGlyphs) {
            throw new IllegalArgumentException("Size of advanceTable must be equal to glyph count!");
        }
        if (boundsTable != null && boundsTable.length != this.numGlyphs) {
            throw new IllegalArgumentException("Size of boundsTable must be equal to glyph count!");
        }
        this.boundsTable = boundsTable;
        this.kerningTable = kerningTable;
    }

    public short getLeading() {
        return this.leading;
    }

    public void setShiftJIS(boolean shiftJIS) {
        this.shiftJIS = shiftJIS;
        if (shiftJIS) {
            this.ansi = false;
        }
    }

    public boolean isShiftJIS() {
        return this.shiftJIS;
    }

    public void setSmallText(boolean smallText) {
        this.smallText = smallText;
    }

    public boolean isSmallText() {
        return this.smallText;
    }

    public boolean hasLayout() {
        return this.hasLayout;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        outStream.writeUI16(this.characterId);
        outStream.writeBooleanBit(this.hasLayout);
        outStream.writeBooleanBit(this.shiftJIS);
        outStream.writeBooleanBit(this.smallText);
        outStream.writeBooleanBit(this.ansi);
        long[] offsetTable = new long[this.numGlyphs];
        OutputBitStream shapeTableStream = new OutputBitStream();
        if (this.numGlyphs > 0) {
            this.glyphShapeTable[0].write(shapeTableStream);
        }
        int i = 1;
        while (i < this.numGlyphs) {
            offsetTable[i] = shapeTableStream.getOffset();
            this.glyphShapeTable[i].write(shapeTableStream);
            ++i;
        }
        long codeTableOffset = shapeTableStream.getOffset();
        boolean wideOffsets = false;
        if (this.numGlyphs > 0) {
            wideOffsets = offsetTable[this.numGlyphs - 1] + (long)(2 * (this.numGlyphs + 1)) > 65535L;
        }
        long offsetCorrection = (this.numGlyphs + 1) * (wideOffsets ? 4 : 2);
        int i2 = 0;
        while (i2 < this.numGlyphs) {
            int n = i2++;
            offsetTable[n] = offsetTable[n] + offsetCorrection;
        }
        codeTableOffset += offsetCorrection;
        outStream.writeBooleanBit(wideOffsets);
        boolean wideCodes = (this.ansi || this.shiftJIS) ^ true;
        outStream.writeBooleanBit(wideCodes);
        outStream.writeBooleanBit(this.italic);
        outStream.writeBooleanBit(this.bold);
        if (this.languageCode != null) {
            outStream.writeUI8(this.languageCode.getLanguageCode());
        } else {
            outStream.writeUI8((short)0);
        }
        byte[] fontNameBuffer = this.fontName != null ? this.fontName.getBytes("UTF-8") : new byte[]{};
        outStream.writeUI8((short)(fontNameBuffer.length + 1));
        outStream.writeBytes(fontNameBuffer);
        outStream.writeUI8((short)0);
        outStream.writeUI16(this.numGlyphs);
        if (wideOffsets) {
            int i3 = 0;
            while (i3 < this.numGlyphs) {
                outStream.writeUI32(offsetTable[i3]);
                ++i3;
            }
            outStream.writeUI32(codeTableOffset);
        } else {
            int i4 = 0;
            while (i4 < this.numGlyphs) {
                outStream.writeUI16((int)offsetTable[i4]);
                ++i4;
            }
            outStream.writeUI16((int)codeTableOffset);
        }
        byte[] shapeTableBuffer = shapeTableStream.getData();
        if (shapeTableBuffer.length > 0) {
            outStream.writeBytes(shapeTableBuffer);
        }
        if (wideCodes) {
            int i5 = 0;
            while (i5 < this.numGlyphs) {
                outStream.writeUI16(this.codeTable[i5]);
                ++i5;
            }
        } else {
            int i6 = 0;
            while (i6 < this.numGlyphs) {
                outStream.writeUI8((short)this.codeTable[i6]);
                ++i6;
            }
        }
        if (this.hasLayout) {
            outStream.writeSI16(this.ascent);
            outStream.writeSI16(this.descent);
            outStream.writeSI16(this.leading);
            int i7 = 0;
            while (i7 < this.numGlyphs) {
                outStream.writeSI16(this.advanceTable[i7]);
                ++i7;
            }
            if (this.boundsTable == null) {
                int i8 = 0;
                while (i8 < this.numGlyphs) {
                    new Rect(0L, 0L, 0L, 0L).write(outStream);
                    ++i8;
                }
            } else {
                int i9 = 0;
                while (i9 < this.numGlyphs) {
                    this.boundsTable[i9].write(outStream);
                    ++i9;
                }
            }
            if (this.kerningTable == null) {
                outStream.writeUI16(0);
            } else {
                outStream.writeUI16(this.kerningTable.length);
                int i10 = 0;
                while (i10 < this.kerningTable.length) {
                    this.kerningTable[i10].write(outStream, wideCodes);
                    ++i10;
                }
            }
        }
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        this.characterId = inStream.readUI16();
        this.hasLayout = inStream.readBooleanBit();
        this.shiftJIS = inStream.readBooleanBit();
        this.smallText = inStream.readBooleanBit();
        this.ansi = inStream.readBooleanBit();
        boolean wideOffsets = inStream.readBooleanBit();
        boolean wideCodes = inStream.readBooleanBit();
        this.italic = inStream.readBooleanBit();
        this.bold = inStream.readBooleanBit();
        this.languageCode = new LangCode((byte)inStream.readUI8());
        short fontNameLen = inStream.readUI8();
        byte[] fontNameBuffer = inStream.readBytes(fontNameLen);
        if (fontNameLen > 0 && fontNameBuffer[fontNameLen - 1] == 0) {
            fontNameLen = (short)(fontNameLen - 1);
        }
        this.fontName = new String(fontNameBuffer, 0, (int)fontNameLen, "UTF-8");
        this.numGlyphs = inStream.readUI16();
        if (wideOffsets) {
            inStream.readBytes(this.numGlyphs * 4);
            inStream.readBytes(4);
        } else {
            inStream.readBytes(this.numGlyphs * 2);
            inStream.readBytes(2);
        }
        if (this.numGlyphs > 0) {
            this.glyphShapeTable = new Shape[this.numGlyphs];
            int i = 0;
            while (i < this.numGlyphs) {
                this.glyphShapeTable[i] = new Shape(inStream);
                ++i;
            }
            this.codeTable = new char[this.numGlyphs];
            if (wideCodes) {
                int i2 = 0;
                while (i2 < this.numGlyphs) {
                    this.codeTable[i2] = (char)inStream.readUI16();
                    ++i2;
                }
            } else {
                int i3 = 0;
                while (i3 < this.numGlyphs) {
                    this.codeTable[i3] = (char)inStream.readUI8();
                    ++i3;
                }
            }
        }
        if (this.hasLayout) {
            int kerningCount;
            this.ascent = inStream.readSI16();
            this.descent = inStream.readSI16();
            this.leading = inStream.readSI16();
            if (this.numGlyphs > 0) {
                this.advanceTable = new short[this.numGlyphs];
                int i = 0;
                while (i < this.numGlyphs) {
                    this.advanceTable[i] = inStream.readSI16();
                    ++i;
                }
                this.boundsTable = new Rect[this.numGlyphs];
                int i4 = 0;
                while (i4 < this.numGlyphs) {
                    this.boundsTable[i4] = new Rect(inStream);
                    ++i4;
                }
            }
            if ((kerningCount = inStream.readUI16()) > 0) {
                this.kerningTable = new KerningRecord[kerningCount];
                int i = 0;
                while (i < kerningCount) {
                    this.kerningTable[i] = new KerningRecord(inStream, wideCodes);
                    ++i;
                }
            }
        }
    }
}

