/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.AlignmentZone;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;

public class DefineFontAlignment
extends Tag {
    public static final byte THIN = 0;
    public static final byte MEDIUM = 1;
    public static final byte THICK = 2;
    private int fontId;
    private byte thickness;
    private AlignmentZone[] alignmentZones;

    public DefineFontAlignment(int fontId, byte thickness, AlignmentZone[] alignmentZones) {
        this.fontId = fontId;
        this.thickness = thickness;
        this.alignmentZones = alignmentZones;
        this.code = (short)73;
    }

    DefineFontAlignment() {
    }

    public void setAlignmentZones(AlignmentZone[] alignmentZones) {
        this.alignmentZones = alignmentZones;
    }

    public AlignmentZone[] getAlignmentZones() {
        return this.alignmentZones;
    }

    public void setFontId(int fontId) {
        this.fontId = fontId;
    }

    public int getFontId() {
        return this.fontId;
    }

    public void setThickness(byte thickness) {
        this.thickness = thickness;
    }

    public byte getThickness() {
        return this.thickness;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        outStream.writeUI16(this.fontId);
        outStream.writeUnsignedBits(this.thickness, 2);
        outStream.writeUnsignedBits(0L, 6);
        if (this.alignmentZones != null) {
            int i = 0;
            while (i < this.alignmentZones.length) {
                this.alignmentZones[i].write(outStream);
                ++i;
            }
        }
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        this.fontId = inStream.readUI16();
        this.thickness = (byte)inStream.readUnsignedBits(2);
        inStream.readUnsignedBits(6);
        int glyphCount = inStream.available() / 10;
        this.alignmentZones = new AlignmentZone[glyphCount];
        int i = 0;
        while (i < glyphCount) {
            this.alignmentZones[i] = new AlignmentZone(inStream);
            ++i;
        }
    }
}

