/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;

public final class DefineFontInfo
extends Tag {
    private int fontId;
    private String fontName;
    private boolean smallText;
    private boolean shiftJIS;
    private boolean ansi;
    private boolean italic;
    private boolean bold;
    private char[] codeTable;

    public DefineFontInfo(int fontId, String fontName, char[] codeTable) {
        this.code = (short)13;
        this.fontId = fontId;
        this.fontName = fontName;
        this.codeTable = codeTable;
    }

    DefineFontInfo() {
    }

    public void setANSI(boolean ansi) {
        this.ansi = ansi;
        if (ansi) {
            this.shiftJIS = false;
        }
    }

    public boolean isANSI() {
        return this.ansi;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setCodeTable(char[] codeTable) {
        this.codeTable = codeTable;
    }

    public char[] getCodeTable() {
        return this.codeTable;
    }

    public void setFontId(int fontId) {
        this.fontId = fontId;
    }

    public int getFontId() {
        return this.fontId;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setShiftJIS(boolean shiftJIS) {
        this.shiftJIS = shiftJIS;
        if (shiftJIS) {
            this.ansi = false;
        }
    }

    public boolean isShiftJIS() {
        return this.shiftJIS;
    }

    public void setSmallText(boolean smallText) {
        this.smallText = smallText;
    }

    public boolean isSmallText() {
        return this.smallText;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        outStream.writeUI16(this.fontId);
        byte[] fontNameBuffer = this.fontName != null ? this.fontName.getBytes("UTF-8") : new byte[]{};
        outStream.writeUI8((short)fontNameBuffer.length);
        outStream.writeBytes(fontNameBuffer);
        outStream.writeUnsignedBits(0L, 2);
        outStream.writeBooleanBit(this.smallText);
        outStream.writeBooleanBit(this.shiftJIS);
        outStream.writeBooleanBit(this.ansi);
        outStream.writeBooleanBit(this.italic);
        outStream.writeBooleanBit(this.bold);
        boolean wideCodes = (this.shiftJIS || this.ansi) ^ true;
        outStream.writeBooleanBit(wideCodes);
        if (wideCodes) {
            int i = 0;
            while (i < this.codeTable.length) {
                outStream.writeUI16(this.codeTable[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.codeTable.length) {
                outStream.writeUI8((short)this.codeTable[i]);
                ++i;
            }
        }
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        this.fontId = inStream.readUI16();
        short fontNameLen = inStream.readUI8();
        this.fontName = new String(inStream.readBytes(fontNameLen), "UTF-8");
        inStream.readUnsignedBits(2);
        this.smallText = inStream.readBooleanBit();
        this.shiftJIS = inStream.readBooleanBit();
        this.ansi = inStream.readBooleanBit();
        this.italic = inStream.readBooleanBit();
        this.bold = inStream.readBooleanBit();
        boolean wideCodes = inStream.readBooleanBit();
        if (wideCodes) {
            int codeTableSize = (int)(((long)data.length - inStream.getOffset()) / (long)2);
            this.codeTable = new char[codeTableSize];
            int i = 0;
            while (i < codeTableSize) {
                this.codeTable[i] = (char)inStream.readUI16();
                ++i;
            }
        } else {
            int codeTableSize = (int)((long)data.length - inStream.getOffset());
            this.codeTable = new char[codeTableSize];
            int i = 0;
            while (i < codeTableSize) {
                this.codeTable[i] = (char)inStream.readUI8();
                ++i;
            }
        }
    }
}

