/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.LangCode;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;

public final class DefineFontInfo2
extends Tag {
    private int fontId;
    private String fontName;
    private boolean smallText;
    private boolean italic;
    private boolean bold;
    private LangCode langCode;
    private char[] codeTable;

    public DefineFontInfo2(int fontId, String fontName, char[] codeTable, LangCode langCode) {
        this.code = (short)62;
        this.fontId = fontId;
        this.fontName = fontName;
        this.codeTable = codeTable;
        this.langCode = langCode;
    }

    DefineFontInfo2() {
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setCodeTable(char[] codeTable) {
        this.codeTable = codeTable;
    }

    public char[] getCodeTable() {
        return this.codeTable;
    }

    public void setFontId(int fontId) {
        this.fontId = fontId;
    }

    public int getFontId() {
        return this.fontId;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setLangCode(LangCode langCode) {
        this.langCode = langCode;
    }

    public LangCode getLangCode() {
        return this.langCode;
    }

    public void setSmallText(boolean smallText) {
        this.smallText = smallText;
    }

    public boolean isSmallText() {
        return this.smallText;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        outStream.writeUI16(this.fontId);
        byte[] fontNameBuffer = this.fontName != null ? this.fontName.getBytes("UTF-8") : new byte[]{};
        outStream.writeUI8((short)fontNameBuffer.length);
        outStream.writeBytes(fontNameBuffer);
        outStream.writeUnsignedBits(0L, 2);
        outStream.writeBooleanBit(this.smallText);
        outStream.writeUnsignedBits(0L, 2);
        outStream.writeBooleanBit(this.italic);
        outStream.writeBooleanBit(this.bold);
        outStream.writeBooleanBit(true);
        outStream.writeUI8(this.langCode.getLanguageCode());
        int i = 0;
        while (i < this.codeTable.length) {
            outStream.writeUI16(this.codeTable[i]);
            ++i;
        }
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        this.fontId = inStream.readUI16();
        short fontNameLen = inStream.readUI8();
        this.fontName = new String(inStream.readBytes(fontNameLen), "UTF-8");
        inStream.readUnsignedBits(2);
        this.smallText = inStream.readBooleanBit();
        inStream.readBooleanBit();
        inStream.readBooleanBit();
        this.italic = inStream.readBooleanBit();
        this.bold = inStream.readBooleanBit();
        this.langCode = new LangCode((byte)inStream.readUI8());
        int codeTableSize = (int)(((long)data.length - inStream.getOffset()) / (long)2);
        this.codeTable = new char[codeTableSize];
        int i = 0;
        while (i < codeTableSize) {
            this.codeTable[i] = (char)inStream.readUI16();
            ++i;
        }
    }
}

