/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.EdgeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphFillStyles;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphLineStyles;
import oracle.dss.graph.flash.jswiff.swfrecords.Rect;
import oracle.dss.graph.flash.jswiff.swfrecords.Shape;
import oracle.dss.graph.flash.jswiff.swfrecords.ShapeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefinitionTag;

public final class DefineMorphShape
extends DefinitionTag {
    private Rect startBounds;
    private Rect endBounds;
    private MorphFillStyles morphFillStyles;
    private MorphLineStyles morphLineStyles;
    private Shape startShape;
    private Shape endShape;

    public DefineMorphShape(int characterId, Rect startBounds, Rect endBounds, MorphFillStyles morphFillStyles, MorphLineStyles morphLineStyles, Shape startShape, Shape endShape) throws IllegalArgumentException {
        this.code = (short)46;
        this.characterId = characterId;
        this.startBounds = startBounds;
        this.endBounds = endBounds;
        this.morphFillStyles = morphFillStyles;
        this.morphLineStyles = morphLineStyles;
        this.checkEdges(startShape, endShape);
        this.startShape = startShape;
        this.endShape = endShape;
    }

    DefineMorphShape() {
    }

    public void setEndBounds(Rect endBounds) {
        this.endBounds = endBounds;
    }

    public Rect getEndBounds() {
        return this.endBounds;
    }

    public void setEndShape(Shape endShape) {
        this.endShape = endShape;
    }

    public Shape getEndShape() {
        return this.endShape;
    }

    public void setMorphFillStyles(MorphFillStyles morphFillStyles) {
        this.morphFillStyles = morphFillStyles;
    }

    public MorphFillStyles getMorphFillStyles() {
        return this.morphFillStyles;
    }

    public void setMorphLineStyles(MorphLineStyles morphLineStyles) {
        this.morphLineStyles = morphLineStyles;
    }

    public MorphLineStyles getMorphLineStyles() {
        return this.morphLineStyles;
    }

    public void setStartBounds(Rect startBounds) {
        this.startBounds = startBounds;
    }

    public Rect getStartBounds() {
        return this.startBounds;
    }

    public void setStartShape(Shape startShape) {
        this.startShape = startShape;
    }

    public Shape getStartShape() {
        return this.startShape;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        outStream.writeUI16(this.characterId);
        this.startBounds.write(outStream);
        this.endBounds.write(outStream);
        if (this.startShape == null && this.endShape == null && this.morphFillStyles == null && this.morphLineStyles == null) {
            outStream.writeUI32(0L);
            outStream.writeUI16(0);
            outStream.writeUI32(0L);
            return;
        }
        OutputBitStream bitStream = new OutputBitStream();
        this.morphFillStyles.write(bitStream);
        this.morphLineStyles.write(bitStream);
        this.startShape.write(bitStream);
        byte[] bitStreamData = bitStream.getData();
        outStream.writeUI32(bitStreamData.length);
        outStream.writeBytes(bitStreamData);
        this.endShape.write(outStream);
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        this.characterId = inStream.readUI16();
        this.startBounds = new Rect(inStream);
        this.endBounds = new Rect(inStream);
        long endEdgesOffset = inStream.readUI32();
        if (endEdgesOffset == 0L) {
            return;
        }
        this.morphFillStyles = new MorphFillStyles(inStream);
        this.morphLineStyles = new MorphLineStyles(inStream, false);
        long startEdgesOffset = inStream.getOffset();
        byte[] startEdgesBuffer = new byte[(int)((endEdgesOffset += inStream.getOffset()) - startEdgesOffset)];
        System.arraycopy(data, (int)startEdgesOffset, startEdgesBuffer, 0, startEdgesBuffer.length);
        this.startShape = new Shape(new InputBitStream(startEdgesBuffer));
        byte[] endEdgesBuffer = new byte[(int)((long)data.length - endEdgesOffset)];
        System.arraycopy(data, (int)endEdgesOffset, endEdgesBuffer, 0, endEdgesBuffer.length);
        this.endShape = new Shape(new InputBitStream(endEdgesBuffer));
    }

    private void checkEdges(Shape edges1, Shape edges2) {
        ShapeRecord[] endShapeRecs;
        if (edges1 == null || edges2 == null) {
            return;
        }
        ShapeRecord[] startShapeRecs = edges1.getShapeRecords();
        if (startShapeRecs.length != (endShapeRecs = edges1.getShapeRecords()).length) {
            throw new IllegalArgumentException("Start and end shapes must have the same number of shape records!");
        }
        int i = 0;
        while (i < startShapeRecs.length) {
            ShapeRecord startRec = startShapeRecs[i];
            ShapeRecord endRec = endShapeRecs[i];
            if (startRec instanceof EdgeRecord) {
                if (!(endRec instanceof EdgeRecord)) {
                    throw new IllegalArgumentException("Edge record in start shape must have corresponding record in end shape!");
                }
            } else if (endRec instanceof EdgeRecord) {
                throw new IllegalArgumentException("Style change record in start shape must have corresponding record in end shape!");
            }
            ++i;
        }
    }
}

