/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.EdgeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphFillStyles;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphLineStyle2;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphLineStyles;
import oracle.dss.graph.flash.jswiff.swfrecords.Rect;
import oracle.dss.graph.flash.jswiff.swfrecords.Shape;
import oracle.dss.graph.flash.jswiff.swfrecords.ShapeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefinitionTag;

public final class DefineMorphShape2
extends DefinitionTag {
    private Rect startShapeBounds;
    private Rect endShapeBounds;
    private Rect startEdgeBounds;
    private Rect endEdgeBounds;
    private MorphFillStyles morphFillStyles;
    private MorphLineStyles morphLineStyles;
    private Shape startShape;
    private Shape endShape;
    private boolean hasNonscalingStrokes;
    private boolean hasScalingStrokes;

    public DefineMorphShape2(int characterId, Rect startShapeBounds, Rect endShapeBounds, Rect startEdgeBounds, Rect endEdgeBounds, MorphFillStyles morphFillStyles, MorphLineStyles morphLineStyles, Shape startShape, Shape endShape) throws IllegalArgumentException {
        this.code = (short)84;
        this.characterId = characterId;
        this.startShapeBounds = startShapeBounds;
        this.endShapeBounds = endShapeBounds;
        this.startEdgeBounds = startEdgeBounds;
        this.endEdgeBounds = endEdgeBounds;
        this.morphFillStyles = morphFillStyles;
        this.morphLineStyles = morphLineStyles;
        this.checkEdges(startShape, endShape);
        this.startShape = startShape;
        this.endShape = endShape;
    }

    DefineMorphShape2() {
    }

    public void setEndEdgeBounds(Rect endEdgeBounds) {
        this.endEdgeBounds = endEdgeBounds;
    }

    public Rect getEndEdgeBounds() {
        return this.endEdgeBounds;
    }

    public void setEndShape(Shape endShape) {
        this.endShape = endShape;
    }

    public Shape getEndShape() {
        return this.endShape;
    }

    public void setEndShapeBounds(Rect endBounds) {
        this.endShapeBounds = endBounds;
    }

    public Rect getEndShapeBounds() {
        return this.endShapeBounds;
    }

    public void setMorphFillStyles(MorphFillStyles morphFillStyles) {
        this.morphFillStyles = morphFillStyles;
    }

    public MorphFillStyles getMorphFillStyles() {
        return this.morphFillStyles;
    }

    public void setMorphLineStyles(MorphLineStyles morphLineStyles) {
        this.morphLineStyles = morphLineStyles;
    }

    public MorphLineStyles getMorphLineStyles() {
        return this.morphLineStyles;
    }

    public void setStartEdgeBounds(Rect startEdgeBounds) {
        this.startEdgeBounds = startEdgeBounds;
    }

    public Rect getStartEdgeBounds() {
        return this.startEdgeBounds;
    }

    public void setStartShape(Shape startShape) {
        this.startShape = startShape;
    }

    public Shape getStartShape() {
        return this.startShape;
    }

    public void setStartShapeBounds(Rect startBounds) {
        this.startShapeBounds = startBounds;
    }

    public Rect getStartShapeBounds() {
        return this.startShapeBounds;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        outStream.writeUI16(this.characterId);
        this.startShapeBounds.write(outStream);
        this.endShapeBounds.write(outStream);
        this.startEdgeBounds.write(outStream);
        this.endEdgeBounds.write(outStream);
        outStream.writeUnsignedBits(0L, 6);
        this.checkStrokeScaling();
        outStream.writeBooleanBit(this.hasNonscalingStrokes);
        outStream.writeBooleanBit(this.hasScalingStrokes);
        if (this.startShape == null && this.endShape == null && this.morphFillStyles == null && this.morphLineStyles == null) {
            outStream.writeUI32(0L);
            outStream.writeUI16(0);
            outStream.writeUI32(0L);
            return;
        }
        OutputBitStream bitStream = new OutputBitStream();
        this.morphFillStyles.write(bitStream);
        this.morphLineStyles.write(bitStream);
        this.startShape.write(bitStream);
        byte[] bitStreamData = bitStream.getData();
        outStream.writeUI32(bitStreamData.length);
        outStream.writeBytes(bitStreamData);
        this.endShape.write(outStream);
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        this.characterId = inStream.readUI16();
        this.startShapeBounds = new Rect(inStream);
        this.endShapeBounds = new Rect(inStream);
        this.startEdgeBounds = new Rect(inStream);
        this.endEdgeBounds = new Rect(inStream);
        inStream.readUI8();
        long endEdgesOffset = inStream.readUI32();
        if (endEdgesOffset == 0L) {
            return;
        }
        this.morphFillStyles = new MorphFillStyles(inStream);
        this.morphLineStyles = new MorphLineStyles(inStream, true);
        long startEdgesOffset = inStream.getOffset();
        byte[] startEdgesBuffer = new byte[(int)((endEdgesOffset += inStream.getOffset()) - startEdgesOffset)];
        System.arraycopy(data, (int)startEdgesOffset, startEdgesBuffer, 0, startEdgesBuffer.length);
        this.startShape = new Shape(new InputBitStream(startEdgesBuffer));
        byte[] endEdgesBuffer = new byte[(int)((long)data.length - endEdgesOffset)];
        System.arraycopy(data, (int)endEdgesOffset, endEdgesBuffer, 0, endEdgesBuffer.length);
        this.endShape = new Shape(new InputBitStream(endEdgesBuffer));
    }

    private void checkEdges(Shape edges1, Shape edges2) {
        ShapeRecord[] endShapeRecs;
        if (edges1 == null || edges2 == null) {
            return;
        }
        ShapeRecord[] startShapeRecs = edges1.getShapeRecords();
        if (startShapeRecs.length != (endShapeRecs = edges1.getShapeRecords()).length) {
            throw new IllegalArgumentException("Start and end shapes must have the same number of shape records!");
        }
        int i = 0;
        while (i < startShapeRecs.length) {
            ShapeRecord startRec = startShapeRecs[i];
            ShapeRecord endRec = endShapeRecs[i];
            if (startRec instanceof EdgeRecord) {
                if (!(endRec instanceof EdgeRecord)) {
                    throw new IllegalArgumentException("Edge record in start shape must have corresponding record in end shape!");
                }
            } else if (endRec instanceof EdgeRecord) {
                throw new IllegalArgumentException("Style change record in start shape must have corresponding record in end shape!");
            }
            ++i;
        }
    }

    private void checkStrokeScaling() {
        this.hasNonscalingStrokes = false;
        this.hasScalingStrokes = false;
        if (this.morphLineStyles == null) {
            return;
        }
        int i = 1;
        while (i <= this.morphLineStyles.getSize()) {
            MorphLineStyle2 style = (MorphLineStyle2)this.morphLineStyles.getStyle(i);
            if (style.getScaleStroke() == 0) {
                this.hasNonscalingStrokes = true;
            } else {
                this.hasScalingStrokes = true;
            }
            if (this.hasNonscalingStrokes && this.hasScalingStrokes) break;
            ++i;
        }
    }
}

