/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.LineStyle2;
import oracle.dss.graph.flash.jswiff.swfrecords.LineStyleArray;
import oracle.dss.graph.flash.jswiff.swfrecords.Rect;
import oracle.dss.graph.flash.jswiff.swfrecords.ShapeWithStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefinitionTag;

public final class DefineShape4
extends DefinitionTag {
    private Rect shapeBounds;
    private Rect edgeBounds;
    private ShapeWithStyle shapes;
    private boolean hasScalingStrokes;
    private boolean hasNonscalingStrokes;

    public DefineShape4(int characterId, Rect shapeBounds, Rect edgeBounds, ShapeWithStyle shapes) {
        this.code = (short)83;
        this.characterId = characterId;
        this.shapeBounds = shapeBounds;
        this.edgeBounds = edgeBounds;
        this.shapes = shapes;
    }

    DefineShape4() {
    }

    public void setEdgeBounds(Rect edgeBounds) {
        this.edgeBounds = edgeBounds;
    }

    public Rect getEdgeBounds() {
        return this.edgeBounds;
    }

    public void setShapeBounds(Rect shapeBounds) {
        this.shapeBounds = shapeBounds;
    }

    public Rect getShapeBounds() {
        return this.shapeBounds;
    }

    public void setShapes(ShapeWithStyle shapes) {
        this.shapes = shapes;
    }

    public ShapeWithStyle getShapes() {
        return this.shapes;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        outStream.writeUI16(this.characterId);
        this.shapeBounds.write(outStream);
        this.edgeBounds.write(outStream);
        outStream.writeUnsignedBits(0L, 6);
        this.checkStrokeScaling();
        outStream.writeBooleanBit(this.hasNonscalingStrokes);
        outStream.writeBooleanBit(this.hasScalingStrokes);
        this.shapes.write(outStream);
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        this.characterId = inStream.readUI16();
        this.shapeBounds = new Rect(inStream);
        this.edgeBounds = new Rect(inStream);
        inStream.readUI8();
        this.shapes = new ShapeWithStyle(inStream);
    }

    private void checkStrokeScaling() {
        if (this.shapes == null) {
            return;
        }
        this.hasNonscalingStrokes = false;
        this.hasScalingStrokes = false;
        LineStyleArray lineStyles = this.shapes.getLineStyles();
        int i = 1;
        while (i <= lineStyles.getSize()) {
            LineStyle2 style = (LineStyle2)lineStyles.getStyle(i);
            if (style.getScaleStroke() == 0) {
                this.hasNonscalingStrokes = true;
            } else {
                this.hasScalingStrokes = true;
            }
            if (this.hasNonscalingStrokes && this.hasScalingStrokes) break;
            ++i;
        }
    }
}

