/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefinitionTag;

public final class DefineSound
extends DefinitionTag {
    public static final byte FORMAT_UNCOMPRESSED = 0;
    public static final byte FORMAT_ADPCM = 1;
    public static final byte FORMAT_MP3 = 2;
    public static final byte FORMAT_UNCOMPRESSED_LITTLE_ENDIAN = 3;
    public static final byte FORMAT_NELLYMOSER = 6;
    public static final byte RATE_5500_HZ = 0;
    public static final byte RATE_11000_HZ = 1;
    public static final byte RATE_22000_HZ = 2;
    public static final byte RATE_44000_HZ = 3;
    private byte format;
    private byte rate;
    private boolean is16BitSample;
    private boolean isStereo;
    private long sampleCount;
    private byte[] soundData;

    public DefineSound(int characterId, byte format, byte rate, boolean is16BitSample, boolean isStereo, long sampleCount, byte[] soundData) {
        this.code = (short)14;
        this.characterId = characterId;
        this.format = format;
        this.rate = rate;
        this.is16BitSample = is16BitSample;
        this.isStereo = isStereo;
        this.sampleCount = sampleCount;
        this.soundData = soundData;
    }

    DefineSound() {
    }

    public void setFormat(byte format) {
        this.format = format;
    }

    public byte getFormat() {
        return this.format;
    }

    public byte getRate() {
        return this.rate;
    }

    public void setSampleCount(long sampleCount) {
        this.sampleCount = sampleCount;
    }

    public long getSampleCount() {
        return this.sampleCount;
    }

    public void setSoundData(byte[] soundData) {
        this.soundData = soundData;
    }

    public byte[] getSoundData() {
        return this.soundData;
    }

    public void setStereo(boolean isStereo) {
        this.isStereo = isStereo;
    }

    public boolean isStereo() {
        return this.isStereo;
    }

    public boolean is16BitSample() {
        return this.is16BitSample;
    }

    public void set16BitSample(boolean is16BitSample) {
        this.is16BitSample = is16BitSample;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        outStream.writeUI16(this.characterId);
        outStream.writeUnsignedBits(this.format, 4);
        outStream.writeUnsignedBits(this.rate, 2);
        outStream.writeBooleanBit(this.is16BitSample);
        outStream.writeBooleanBit(this.isStereo);
        outStream.writeUI32(this.sampleCount);
        outStream.writeBytes(this.soundData);
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        this.characterId = inStream.readUI16();
        this.format = (byte)inStream.readUnsignedBits(4);
        this.rate = (byte)inStream.readUnsignedBits(2);
        this.is16BitSample = inStream.readBooleanBit();
        this.isStereo = inStream.readBooleanBit();
        this.sampleCount = inStream.readUI32();
        this.soundData = new byte[data.length - 7];
        System.arraycopy(data, 7, this.soundData, 0, data.length - 7);
    }
}

