/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import java.util.Vector;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.GlyphEntry;
import oracle.dss.graph.flash.jswiff.swfrecords.Matrix;
import oracle.dss.graph.flash.jswiff.swfrecords.Rect;
import oracle.dss.graph.flash.jswiff.swfrecords.TextRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefinitionTag;

public final class DefineText
extends DefinitionTag {
    private Rect textBounds;
    private Matrix textMatrix;
    private TextRecord[] textRecords;

    public DefineText(int characterId, Rect textBounds, Matrix textMatrix, TextRecord[] textRecords) {
        this.code = (short)11;
        this.characterId = characterId;
        this.textBounds = textBounds;
        this.textMatrix = textMatrix;
        this.textRecords = textRecords;
    }

    DefineText() {
    }

    public void setTextBounds(Rect textBounds) {
        this.textBounds = textBounds;
    }

    public Rect getTextBounds() {
        return this.textBounds;
    }

    public void setTextMatrix(Matrix textMatrix) {
        this.textMatrix = textMatrix;
    }

    public Matrix getTextMatrix() {
        return this.textMatrix;
    }

    public void setTextRecords(TextRecord[] textRecords) {
        this.textRecords = textRecords;
    }

    public TextRecord[] getTextRecords() {
        return this.textRecords;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        this.forceLongHeader = true;
        outStream.writeUI16(this.characterId);
        this.textBounds.write(outStream);
        this.textMatrix.write(outStream);
        int glyphBits = 0;
        int advanceBits = 0;
        int i = 0;
        while (i < this.textRecords.length) {
            GlyphEntry[] glyphs = this.textRecords[i].getGlyphEntries();
            int j = 0;
            while (j < glyphs.length) {
                glyphBits = Math.max(glyphBits, OutputBitStream.getUnsignedBitsLength(glyphs[j].getGlyphIndex()));
                advanceBits = Math.max(advanceBits, OutputBitStream.getSignedBitsLength(glyphs[j].getGlyphAdvance()));
                ++j;
            }
            ++i;
        }
        outStream.writeUI8((short)glyphBits);
        outStream.writeUI8((short)advanceBits);
        int i2 = 0;
        while (i2 < this.textRecords.length) {
            this.textRecords[i2].write(outStream, (short)glyphBits, (short)advanceBits);
            ++i2;
        }
        outStream.writeUI8((short)0);
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        this.characterId = inStream.readUI16();
        this.textBounds = new Rect(inStream);
        this.textMatrix = new Matrix(inStream);
        short glyphBits = inStream.readUI8();
        short advanceBits = inStream.readUI8();
        Vector<TextRecord> records = new Vector<TextRecord>();
        while (data[(int)inStream.getOffset()] != 0) {
            TextRecord record = new TextRecord(inStream, glyphBits, advanceBits, false);
            records.add(record);
        }
        this.textRecords = new TextRecord[records.size()];
        records.copyInto(this.textRecords);
    }
}

