/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefinitionTag;

public final class DefineVideoStream
extends DefinitionTag {
    public static final byte DEBLOCKING_PACKET = 0;
    public static final byte DEBLOCKING_OFF = 1;
    public static final byte DEBLOCKING_ON = 2;
    public static final short CODEC_UNDEFINED = 0;
    public static final short CODEC_SORENSON_H263 = 2;
    public static final short CODEC_SCREEN_VIDEO = 3;
    public static final short CODEC_VP6 = 4;
    public static final short CODEC_VP6_ALPHA = 5;
    public static final short CODEC_SCREEN_VIDEO_V2 = 6;
    private int numFrames;
    private int width;
    private int height;
    private byte deblocking;
    private boolean smoothing;
    private short codecId;

    public DefineVideoStream(int characterId, int numFrames, int width, int height, byte deblocking, boolean smoothing, short codecId) {
        this.code = (short)60;
        this.characterId = characterId;
        this.numFrames = numFrames;
        this.width = width;
        this.height = height;
        this.deblocking = deblocking;
        this.smoothing = smoothing;
        this.codecId = codecId;
    }

    DefineVideoStream() {
    }

    public void setCodecId(short codecId) {
        this.codecId = codecId;
    }

    public short getCodecId() {
        return this.codecId;
    }

    public void setDeblocking(byte deblocking) {
        this.deblocking = deblocking;
    }

    public byte getDeblocking() {
        return this.deblocking;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public void setNumFrames(int numFrames) {
        this.numFrames = numFrames;
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public void setSmoothing(boolean smoothing) {
        this.smoothing = smoothing;
    }

    public boolean isSmoothing() {
        return this.smoothing;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        outStream.writeUI16(this.characterId);
        outStream.writeUI16(this.numFrames);
        outStream.writeUI16(this.width);
        outStream.writeUI16(this.height);
        outStream.writeUnsignedBits(0L, 5);
        outStream.writeUnsignedBits(this.deblocking, 2);
        outStream.writeBooleanBit(this.smoothing);
        outStream.writeUI8(this.codecId);
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        this.characterId = inStream.readUI16();
        this.numFrames = inStream.readUI16();
        this.width = inStream.readUI16();
        this.height = inStream.readUI16();
        inStream.readUnsignedBits(5);
        this.deblocking = (byte)inStream.readUnsignedBits(2);
        this.smoothing = inStream.readBooleanBit();
        this.codecId = inStream.readUI8();
    }
}

