/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import java.io.Serializable;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;

public final class ExportAssets
extends Tag {
    private ExportMapping[] exportMappings;

    public ExportAssets(ExportMapping[] exportMappings) {
        this.code = (short)56;
        this.exportMappings = exportMappings;
    }

    ExportAssets() {
    }

    public void setExportMappings(ExportMapping[] exportMappings) {
        this.exportMappings = exportMappings;
    }

    public ExportMapping[] getExportMappings() {
        return this.exportMappings;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        int count = this.exportMappings.length;
        outStream.writeUI16(count);
        int i = 0;
        while (i < count) {
            outStream.writeUI16(this.exportMappings[i].getCharacterId());
            outStream.writeString(this.exportMappings[i].getName());
            ++i;
        }
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        if (this.getSWFVersion() < 6) {
            if (this.isJapanese()) {
                inStream.setShiftJIS(true);
            } else {
                inStream.setANSI(true);
            }
        }
        int count = inStream.readUI16();
        this.exportMappings = new ExportMapping[count];
        int i = 0;
        while (i < count) {
            this.exportMappings[i] = new ExportMapping(inStream.readUI16(), inStream.readString());
            ++i;
        }
    }

    public static class ExportMapping
    implements Serializable {
        private int characterId;
        private String name;

        public ExportMapping(int characterId, String name) {
            this.characterId = characterId;
            this.name = name;
        }

        public int getCharacterId() {
            return this.characterId;
        }

        public void setCharacterId(int id) {
            this.characterId = id;
        }

        public String getName() {
            return this.name;
        }
    }
}

