/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;

public class FileAttributes
extends Tag {
    private boolean allowNetworkAccess;
    private boolean hasMetadata;

    public FileAttributes() {
        this.code = (short)69;
    }

    public void setAllowNetworkAccess(boolean allowNetworkAccess) {
        this.allowNetworkAccess = allowNetworkAccess;
    }

    public boolean isAllowNetworkAccess() {
        return this.allowNetworkAccess;
    }

    public void setHasMetadata(boolean hasMetadata) {
        this.hasMetadata = hasMetadata;
    }

    public boolean hasMetadata() {
        return this.hasMetadata;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        int flags = 0;
        if (this.allowNetworkAccess) {
            flags |= 1;
        }
        if (this.hasMetadata) {
            flags |= 0x10;
        }
        outStream.writeSI32(flags);
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        int flags = inStream.readSI32();
        this.allowNetworkAccess = (flags & 1) != 0;
        this.hasMetadata = (flags & 0x10) != 0;
    }
}

