/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;

public final class FlashTypeSettings
extends Tag {
    public static final byte GRID_FIT_NONE = 0;
    public static final byte GRID_FIT_PIXEL = 1;
    public static final byte GRID_FIT_SUBPIXEL = 2;
    private int textId;
    private boolean flashType;
    private byte gridFit;
    private float thickness;
    private float sharpness;

    public FlashTypeSettings(int textId, boolean flashType) {
        this.code = (short)74;
        this.textId = textId;
        this.flashType = flashType;
    }

    FlashTypeSettings() {
    }

    public void setFlashType(boolean flashType) {
        this.flashType = flashType;
    }

    public boolean isFlashType() {
        return this.flashType;
    }

    public void setGridFit(byte gridFit) {
        this.gridFit = gridFit;
    }

    public byte getGridFit() {
        return this.gridFit;
    }

    public void setSharpness(float sharpness) {
        this.sharpness = sharpness;
    }

    public double getSharpness() {
        return this.sharpness;
    }

    public void setTextId(int textId) {
        this.textId = textId;
    }

    public int getTextId() {
        return this.textId;
    }

    public void setThickness(float thickness) {
        this.thickness = thickness;
    }

    public double getThickness() {
        return this.thickness;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        outStream.writeUI16(this.textId);
        outStream.writeUnsignedBits(this.flashType ? 1 : 0, 2);
        outStream.writeUnsignedBits(this.gridFit, 3);
        outStream.writeUnsignedBits(0L, 3);
        outStream.writeFloat(this.thickness);
        outStream.writeFloat(this.sharpness);
        outStream.writeUI8((short)0);
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        this.textId = inStream.readUI16();
        this.flashType = inStream.readUnsignedBits(2) == 1L;
        this.gridFit = (byte)inStream.readUnsignedBits(3);
        inStream.readUnsignedBits(3);
        this.thickness = inStream.readFloat();
        this.sharpness = inStream.readFloat();
        inStream.readUI8();
    }
}

