/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;

public final class FrameLabel
extends Tag {
    private String name;
    private boolean isNamedAnchor;

    public FrameLabel(String name, boolean isNamedAnchor) {
        this.code = (short)43;
        this.name = name;
        this.isNamedAnchor = isNamedAnchor;
    }

    FrameLabel() {
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setNamedAnchor(boolean isNamedAnchor) {
        this.isNamedAnchor = isNamedAnchor;
    }

    public boolean isNamedAnchor() {
        return this.isNamedAnchor;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        this.forceLongHeader = true;
        outStream.writeString(this.name);
        if (this.getSWFVersion() >= 6 && this.isNamedAnchor) {
            outStream.writeUI8((short)1);
        }
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        if (this.getSWFVersion() < 6) {
            if (this.isJapanese()) {
                inStream.setShiftJIS(true);
            } else {
                inStream.setANSI(true);
            }
        }
        this.name = inStream.readString();
        if (this.getSWFVersion() >= 6 && inStream.available() > 0) {
            this.isNamedAnchor = inStream.readUI8() != 0;
        }
    }
}

