/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import java.io.Serializable;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;

public class ImportAssets
extends Tag {
    protected String url;
    protected ImportMapping[] importMappings;

    public ImportAssets(String url, ImportMapping[] importMappings) {
        this.code = (short)57;
        this.url = url;
        this.importMappings = importMappings;
    }

    ImportAssets() {
    }

    public void setImportMappings(ImportMapping[] importMappings) {
        this.importMappings = importMappings;
    }

    public ImportMapping[] getImportMappings() {
        return this.importMappings;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        outStream.writeString(this.url);
        int count = this.importMappings.length;
        outStream.writeUI16(count);
        int i = 0;
        while (i < count) {
            outStream.writeUI16(this.importMappings[i].getCharacterId());
            outStream.writeString(this.importMappings[i].getName());
            ++i;
        }
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        if (this.getSWFVersion() < 6) {
            if (this.isJapanese()) {
                inStream.setShiftJIS(true);
            } else {
                inStream.setANSI(true);
            }
        }
        this.url = inStream.readString();
        int count = inStream.readUI16();
        this.importMappings = new ImportMapping[count];
        int i = 0;
        while (i < count) {
            int characterId = inStream.readUI16();
            String name = inStream.readString();
            this.importMappings[i] = new ImportMapping(name, characterId);
            ++i;
        }
    }

    public static class ImportMapping
    implements Serializable {
        private int characterId;
        private String name;

        public ImportMapping(String name, int characterId) {
            this.name = name;
            this.characterId = characterId;
        }

        public int getCharacterId() {
            return this.characterId;
        }

        public String getName() {
            return this.name;
        }
    }
}

