/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.CXform;
import oracle.dss.graph.flash.jswiff.swfrecords.Matrix;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;

public final class PlaceObject
extends Tag {
    private int characterId;
    private int depth;
    private Matrix matrix;
    private CXform colorTransform;

    public PlaceObject(int characterId, int depth, Matrix matrix, CXform colorTransform) {
        this.code = (short)4;
        this.characterId = characterId;
        this.depth = depth;
        this.matrix = matrix;
        this.colorTransform = colorTransform;
    }

    PlaceObject() {
    }

    public void setCharacterId(int characterId) {
        this.characterId = characterId;
    }

    public int getCharacterId() {
        return this.characterId;
    }

    public CXform getColorTransform() {
        return this.colorTransform;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        outStream.writeUI16(this.characterId);
        outStream.writeUI16(this.depth);
        this.matrix.write(outStream);
        if (this.colorTransform != null) {
            this.colorTransform.write(outStream);
        }
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        this.characterId = inStream.readUI16();
        this.depth = inStream.readUI16();
        this.matrix = new Matrix(inStream);
        try {
            this.colorTransform = new CXform(inStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

