/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.CXformWithAlpha;
import oracle.dss.graph.flash.jswiff.swfrecords.ClipActions;
import oracle.dss.graph.flash.jswiff.swfrecords.Matrix;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;

public final class PlaceObject2
extends Tag {
    private boolean move;
    private int depth;
    private int characterId;
    private Matrix matrix;
    private CXformWithAlpha colorTransform;
    private int ratio;
    private String name;
    private int clipDepth;
    private ClipActions clipActions;
    private boolean hasClipActions;
    private boolean hasClipDepth;
    private boolean hasName;
    private boolean hasRatio;
    private boolean hasColorTransform;
    private boolean hasMatrix;
    private boolean hasCharacter;

    public PlaceObject2(int depth) {
        this.code = (short)26;
        this.depth = depth;
    }

    PlaceObject2() {
    }

    public void setCharacterId(int characterId) {
        this.characterId = characterId;
        this.hasCharacter = true;
    }

    public int getCharacterId() {
        return this.characterId;
    }

    public void setClipActions(ClipActions clipActions) {
        this.clipActions = clipActions;
        this.hasClipActions = clipActions != null;
    }

    public ClipActions getClipActions() {
        return this.clipActions;
    }

    public void setClipDepth(int clipDepth) {
        this.clipDepth = clipDepth;
        this.hasClipDepth = true;
    }

    public int getClipDepth() {
        return this.clipDepth;
    }

    public void setColorTransform(CXformWithAlpha colorTransform) {
        this.colorTransform = colorTransform;
        this.hasColorTransform = colorTransform != null;
    }

    public CXformWithAlpha getColorTransform() {
        return this.colorTransform;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
        this.hasMatrix = matrix != null;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public void setMove() {
        this.move = true;
    }

    public void setMove(boolean move) {
        this.move = move;
    }

    public boolean isMove() {
        return this.move;
    }

    public void setName(String name) {
        this.name = name;
        this.hasName = name != null;
    }

    public String getName() {
        return this.name;
    }

    public void setRatio(int ratio) {
        this.ratio = ratio < 0 ? 0 : (ratio > 65535 ? 65535 : ratio);
        this.hasRatio = true;
    }

    public int getRatio() {
        return this.ratio;
    }

    public boolean hasCharacter() {
        return this.hasCharacter;
    }

    public boolean hasClipActions() {
        return this.hasClipActions;
    }

    public boolean hasClipDepth() {
        return this.hasClipDepth;
    }

    public boolean hasColorTransform() {
        return this.hasColorTransform;
    }

    public boolean hasMatrix() {
        return this.hasMatrix;
    }

    public boolean hasName() {
        return this.hasName;
    }

    public boolean hasRatio() {
        return this.hasRatio;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        outStream.writeBooleanBit(this.hasClipActions);
        outStream.writeBooleanBit(this.hasClipDepth);
        outStream.writeBooleanBit(this.hasName);
        outStream.writeBooleanBit(this.hasRatio);
        outStream.writeBooleanBit(this.hasColorTransform);
        outStream.writeBooleanBit(this.hasMatrix);
        outStream.writeBooleanBit(this.hasCharacter);
        outStream.writeBooleanBit(this.move);
        outStream.writeUI16(this.depth);
        if (this.hasCharacter) {
            outStream.writeUI16(this.characterId);
        }
        if (this.hasMatrix) {
            this.matrix.write(outStream);
        }
        if (this.hasColorTransform) {
            this.colorTransform.write(outStream);
        }
        if (this.hasRatio) {
            outStream.writeUI16(this.ratio);
        }
        if (this.hasName) {
            outStream.writeString(this.name);
        }
        if (this.hasClipDepth) {
            outStream.writeUI16(this.clipDepth);
        }
        if (this.hasClipActions) {
            this.clipActions.write(outStream, this.getSWFVersion());
        }
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        if (this.getSWFVersion() < 6) {
            if (this.isJapanese()) {
                inStream.setShiftJIS(true);
            } else {
                inStream.setANSI(true);
            }
        }
        this.hasClipActions = inStream.readBooleanBit();
        this.hasClipDepth = inStream.readBooleanBit();
        this.hasName = inStream.readBooleanBit();
        this.hasRatio = inStream.readBooleanBit();
        this.hasColorTransform = inStream.readBooleanBit();
        this.hasMatrix = inStream.readBooleanBit();
        this.hasCharacter = inStream.readBooleanBit();
        this.move = inStream.readBooleanBit();
        this.depth = inStream.readUI16();
        if (this.hasCharacter) {
            this.characterId = inStream.readUI16();
        }
        if (this.hasMatrix) {
            this.matrix = new Matrix(inStream);
        }
        if (this.hasColorTransform) {
            this.colorTransform = new CXformWithAlpha(inStream);
        }
        if (this.hasRatio) {
            this.ratio = inStream.readUI16();
        }
        if (this.hasName) {
            this.name = inStream.readString();
        }
        if (this.hasClipDepth) {
            this.clipDepth = inStream.readUI16();
        }
        if (this.getSWFVersion() >= 5 && this.hasClipActions) {
            this.clipActions = new ClipActions(inStream, this.getSWFVersion());
        }
    }
}

