/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;

public final class SoundStreamHead
extends Tag {
    public static final byte FORMAT_ADPCM = 1;
    public static final byte FORMAT_MP3 = 2;
    public static final byte RATE_5500_HZ = 0;
    public static final byte RATE_11000_HZ = 1;
    public static final byte RATE_22000_HZ = 2;
    public static final byte RATE_44000_HZ = 3;
    private byte playbackRate;
    private boolean playbackStereo;
    private byte streamFormat;
    private byte streamRate;
    private boolean streamStereo;
    private int streamSampleCount;
    private short latencySeek;

    public SoundStreamHead(byte streamFormat, byte rate, boolean stereo, int sampleCount) {
        this.code = (short)18;
        this.streamFormat = streamFormat;
        this.streamRate = rate;
        this.playbackRate = rate;
        this.streamStereo = stereo;
        this.playbackStereo = stereo;
        this.streamSampleCount = sampleCount;
    }

    SoundStreamHead() {
    }

    public void setLatencySeek(short latencySeek) {
        this.latencySeek = latencySeek;
    }

    public short getLatencySeek() {
        return this.latencySeek;
    }

    public void setPlaybackRate(byte rate) {
        this.playbackRate = rate;
    }

    public byte getPlaybackRate() {
        return this.playbackRate;
    }

    public void setPlaybackStereo(boolean isStereo) {
        this.playbackStereo = isStereo;
    }

    public boolean isPlaybackStereo() {
        return this.playbackStereo;
    }

    public void setStreamFormat(byte streamFormat) {
        this.streamFormat = streamFormat;
    }

    public byte getStreamFormat() {
        return this.streamFormat;
    }

    public void setStreamRate(byte streamRate) {
        this.streamRate = streamRate;
    }

    public byte getStreamRate() {
        return this.streamRate;
    }

    public void setStreamSampleCount(int streamSampleCount) {
        this.streamSampleCount = streamSampleCount;
    }

    public int getStreamSampleCount() {
        return this.streamSampleCount;
    }

    public void setStreamStereo(boolean streamStereo) {
        this.streamStereo = streamStereo;
    }

    public boolean isStreamStereo() {
        return this.streamStereo;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        outStream.writeUnsignedBits(0L, 4);
        outStream.writeUnsignedBits(this.playbackRate, 2);
        outStream.writeUnsignedBits(1L, 1);
        outStream.writeBooleanBit(this.playbackStereo);
        outStream.writeUnsignedBits(this.streamFormat, 4);
        outStream.writeUnsignedBits(this.streamRate, 2);
        outStream.writeUnsignedBits(1L, 1);
        outStream.writeBooleanBit(this.streamStereo);
        outStream.writeUI16(this.streamSampleCount);
        if (this.streamFormat == 2) {
            outStream.writeSI16(this.latencySeek);
        }
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        inStream.readUnsignedBits(4);
        this.playbackRate = (byte)inStream.readUnsignedBits(2);
        inStream.readUnsignedBits(1);
        this.playbackStereo = inStream.readBooleanBit();
        this.streamFormat = (byte)inStream.readUnsignedBits(4);
        this.streamRate = (byte)inStream.readUnsignedBits(2);
        inStream.readUnsignedBits(1);
        this.streamStereo = inStream.readBooleanBit();
        this.streamSampleCount = inStream.readUI16();
        if (this.streamFormat == 2 && data.length > 4) {
            this.latencySeek = inStream.readSI16();
        }
    }
}

