/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;

public final class SoundStreamHead2
extends Tag {
    public static final byte FORMAT_UNCOMPRESSED = 0;
    public static final byte FORMAT_ADPCM = 1;
    public static final byte FORMAT_MP3 = 2;
    public static final byte FORMAT_UNCOMPRESSED_LITTLE_ENDIAN = 3;
    public static final byte FORMAT_NELLYMOSER = 6;
    public static final byte RATE_5500_HZ = 0;
    public static final byte RATE_11000_HZ = 1;
    public static final byte RATE_22000_HZ = 2;
    public static final byte RATE_44000_HZ = 3;
    private byte playbackRate;
    private boolean isPlayback16BitSample;
    private boolean isPlaybackStereo;
    private byte streamFormat;
    private byte streamRate;
    private boolean isStream16BitSample;
    private boolean isStreamStereo;
    private int streamSampleCount;
    private short latencySeek;

    public SoundStreamHead2(byte format, byte rate, boolean is16BitSample, boolean isStereo, int sampleCount) {
        this.code = (short)45;
        this.streamFormat = format;
        this.streamRate = rate;
        this.playbackRate = rate;
        this.isStream16BitSample = is16BitSample;
        this.isPlayback16BitSample = is16BitSample;
        this.isStreamStereo = isStereo;
        this.isPlaybackStereo = isStereo;
        this.streamSampleCount = sampleCount;
    }

    SoundStreamHead2() {
    }

    public void setLatencySeek(short latencySeek) {
        this.latencySeek = latencySeek;
    }

    public short getLatencySeek() {
        return this.latencySeek;
    }

    public void setPlayback16BitSample(boolean is16BitSample) {
        this.isPlayback16BitSample = is16BitSample;
    }

    public boolean isPlayback16BitSample() {
        return this.isPlayback16BitSample;
    }

    public void setPlaybackRate(byte rate) {
        this.playbackRate = rate;
    }

    public byte getPlaybackRate() {
        return this.playbackRate;
    }

    public void setPlaybackStereo(boolean isStereo) {
        this.isPlaybackStereo = isStereo;
    }

    public boolean isPlaybackStereo() {
        return this.isPlaybackStereo;
    }

    public void setStream16BitSample(boolean isStream16BitSample) {
        this.isStream16BitSample = isStream16BitSample;
    }

    public boolean isStream16BitSample() {
        return this.isStream16BitSample;
    }

    public void setStreamFormat(byte streamFormat) {
        this.streamFormat = streamFormat;
    }

    public byte getStreamFormat() {
        return this.streamFormat;
    }

    public void setStreamRate(byte streamRate) {
        this.streamRate = streamRate;
    }

    public byte getStreamRate() {
        return this.streamRate;
    }

    public void setStreamSampleCount(int streamSampleCount) {
        this.streamSampleCount = streamSampleCount;
    }

    public int getStreamSampleCount() {
        return this.streamSampleCount;
    }

    public void setStreamStereo(boolean isStreamStereo) {
        this.isStreamStereo = isStreamStereo;
    }

    public boolean isStreamStereo() {
        return this.isStreamStereo;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        outStream.writeUnsignedBits(0L, 4);
        outStream.writeUnsignedBits(this.playbackRate, 2);
        outStream.writeBooleanBit(this.isPlayback16BitSample);
        outStream.writeBooleanBit(this.isPlaybackStereo);
        outStream.writeUnsignedBits(this.streamFormat, 4);
        outStream.writeUnsignedBits(this.streamRate, 2);
        outStream.writeBooleanBit(this.isStream16BitSample);
        outStream.writeBooleanBit(this.isStreamStereo);
        outStream.writeUI16(this.streamSampleCount);
        if (this.streamFormat == 2) {
            outStream.writeSI16(this.latencySeek);
        }
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        inStream.readUnsignedBits(4);
        this.playbackRate = (byte)inStream.readUnsignedBits(2);
        this.isPlayback16BitSample = inStream.readBooleanBit();
        this.isPlaybackStereo = inStream.readBooleanBit();
        this.streamFormat = (byte)inStream.readUnsignedBits(4);
        this.streamRate = (byte)inStream.readUnsignedBits(2);
        this.isStream16BitSample = inStream.readBooleanBit();
        this.isStreamStereo = inStream.readBooleanBit();
        this.streamSampleCount = inStream.readUI16();
        if (this.streamFormat == 2 && data.length > 4) {
            this.latencySeek = inStream.readSI16();
        }
    }
}

