/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;

public abstract class Tag
implements Serializable {
    protected boolean forceLongHeader;
    protected short code;
    protected int length;
    private byte[] outData;
    private short swfVersion;
    private boolean shiftJIS;

    private void $init$() {
        this.swfVersion = (short)7;
    }

    public int getCode() {
        return this.code;
    }

    public Tag copy() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            Tag tag = (Tag)ois.readObject();
            return tag;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected abstract void writeData(OutputBitStream var1) throws IOException;

    void setCode(short code) {
        this.code = code;
    }

    abstract void setData(byte[] var1) throws IOException;

    void setSWFVersion(short swfVersion) {
        this.swfVersion = swfVersion;
    }

    short getSWFVersion() {
        return this.swfVersion;
    }

    void setJapanese(boolean shiftJIS) {
        this.shiftJIS = shiftJIS;
    }

    boolean isJapanese() {
        return this.shiftJIS;
    }

    void write(OutputBitStream stream) throws IOException {
        this.initData(stream);
        stream.writeBytes(this.getHeaderData());
        stream.writeBytes(this.outData);
    }

    private byte[] getHeaderData() throws IOException {
        OutputBitStream headerStream = new OutputBitStream();
        int typeAndLength = this.code << 6;
        this.length = this.outData.length;
        if (this.forceLongHeader || this.length >= 63) {
            headerStream.writeUI16(typeAndLength |= 0x3F);
            headerStream.writeUI32(this.length);
        } else {
            headerStream.writeUI16(typeAndLength |= this.length);
        }
        return headerStream.getData();
    }

    private void initData(OutputBitStream parentStream) throws IOException {
        OutputBitStream outStream = new OutputBitStream();
        outStream.setANSI(parentStream.isANSI());
        outStream.setShiftJIS(parentStream.isShiftJIS());
        this.writeData(outStream);
        this.outData = outStream.getData();
    }

    public Tag() {
        this.$init$();
    }
}

