/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.swfrecords.tags;

import java.io.IOException;
import oracle.dss.graph.flash.jswiff.io.InputBitStream;
import oracle.dss.graph.flash.jswiff.io.OutputBitStream;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;

public final class VideoFrame
extends Tag {
    private int streamId;
    private int frameNum;
    private byte[] videoData;

    public VideoFrame(int streamId, int frameNum, byte[] videoData) {
        this.code = (short)61;
        this.streamId = streamId;
        this.frameNum = frameNum;
        this.videoData = videoData;
    }

    VideoFrame() {
    }

    public void setFrameNum(int frameNum) {
        this.frameNum = frameNum;
    }

    public int getFrameNum() {
        return this.frameNum;
    }

    public void setStreamId(int streamId) {
        this.streamId = streamId;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public void setVideoData(byte[] videoData) {
        this.videoData = videoData;
    }

    public byte[] getVideoData() {
        return this.videoData;
    }

    protected void writeData(OutputBitStream outStream) throws IOException {
        outStream.writeUI16(this.streamId);
        outStream.writeUI16(this.frameNum);
        outStream.writeBytes(this.videoData);
    }

    void setData(byte[] data) throws IOException {
        InputBitStream inStream = new InputBitStream(data);
        this.streamId = inStream.readUI16();
        this.frameNum = inStream.readUI16();
        int videoDataLength = data.length - 4;
        this.videoData = new byte[videoDataLength];
        System.arraycopy(data, 4, this.videoData, 0, videoDataLength);
    }
}

