/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.util;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import oracle.dss.graph.flash.jswiff.swfrecords.RGBA;

public class ImageUtilities {
    public static String getFormat(InputStream stream) throws IOException {
        ImageInputStream iis = ImageIO.createImageInputStream(stream);
        Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
        if (!iter.hasNext()) {
            throw new IOException("Unsupported image format!");
        }
        ImageReader reader = iter.next();
        iis.close();
        return reader.getFormatName();
    }

    public static RGBA[] getRGBAArray(BufferedImage image) {
        BufferedImage argbImage = image.getType() != 2 ? ImageUtilities.convertToARGB(image) : image;
        int height = argbImage.getHeight();
        int width = argbImage.getWidth();
        RGBA[] values = new RGBA[height * width];
        int i = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int rgb = argbImage.getRGB(x, y);
                int a = (rgb & 0xFF000000) >> 24 & 0xFF;
                int r = (rgb & 0xFF0000) >> 16 & 0xFF;
                int g = (rgb & 0xFF00) >> 8 & 0xFF;
                int b = rgb & 0xFF;
                values[i++] = new RGBA(r, g, b, a);
                ++x;
            }
            ++y;
        }
        return values;
    }

    public static BufferedImage loadImage(InputStream stream) throws IOException {
        return ImageIO.read(stream);
    }

    public static void saveImageAsJPEG(BufferedImage image, OutputStream stream) throws IOException {
        ImageIO.write((RenderedImage)image, "jpg", stream);
    }

    public static void saveImageAsJPEG(BufferedImage image, OutputStream stream, int qualityPercent) throws IOException {
        if (qualityPercent < 0 || qualityPercent > 100) {
            throw new IllegalArgumentException("Quality out of bounds!");
        }
        float quality = (float)qualityPercent / 100.0f;
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
        if (iter.hasNext()) {
            writer = iter.next();
        }
        ImageOutputStream ios = ImageIO.createImageOutputStream(stream);
        writer.setOutput(ios);
        JPEGImageWriteParam iwparam = new JPEGImageWriteParam(Locale.getDefault());
        iwparam.setCompressionMode(2);
        iwparam.setCompressionQuality(quality);
        writer.write(null, new IIOImage(image, null, null), iwparam);
        ios.flush();
        writer.dispose();
        ios.close();
    }

    public static void saveImageAsPNG(BufferedImage image, OutputStream stream) throws IOException {
        ImageIO.write((RenderedImage)image, "png", stream);
    }

    private static BufferedImage convertToARGB(BufferedImage srcImage) {
        BufferedImage newImage = new BufferedImage(srcImage.getWidth(null), srcImage.getHeight(null), 2);
        Graphics bg = newImage.getGraphics();
        bg.drawImage(srcImage, 0, 0, null);
        bg.dispose();
        return newImage;
    }
}

