/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.util;

import java.text.DecimalFormat;
import java.util.Locale;

public class StringUtilities {
    public static final int DEFAULT_ROUND_PRECISION = 16;
    private static DecimalFormat df;

    static {
        Locale.setDefault(Locale.US);
        df = new DecimalFormat();
        df.setGroupingUsed(false);
    }

    public static boolean containsIllegalChars(String text) {
        int size = text.length();
        boolean illegal = false;
        int i = 0;
        while (i < size) {
            char c = text.charAt(i);
            if (c < ' ' && c != '\t' && c != '\n' && c != '\r') {
                illegal = true;
                break;
            }
            ++i;
        }
        return illegal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doubleToString(double d, int precision) {
        DecimalFormat decimalFormat = df;
        synchronized (decimalFormat) {
            df.setMaximumFractionDigits(precision);
            String string = df.format(d);
            return string;
        }
    }

    public static String doubleToString(double d) {
        return StringUtilities.doubleToString(d, 16);
    }

    public static String purgeString(String text) {
        char[] block = null;
        StringBuffer buffer = new StringBuffer();
        int last = 0;
        int size = text.length();
        int i = 0;
        while (i < size) {
            char c = text.charAt(i);
            if (c < ' ' && c != '\t' && c != '\n' && c != '\r') {
                if (block == null) {
                    block = text.toCharArray();
                }
                buffer.append(block, last, i - last);
                last = i + 1;
            }
            ++i;
        }
        if (last == 0) {
            return text;
        }
        if (last < size) {
            if (block == null) {
                block = text.toCharArray();
            }
            buffer.append(block, last, i - last);
        }
        return buffer.toString();
    }
}

