/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.xml;

import java.util.List;
import oracle.dss.graph.flash.jswiff.swfrecords.RegisterParam;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Action;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ConstantPool;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.DefineFunction;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.DefineFunction2;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.GetURL;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.GetURL2;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.GoToFrame;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.GoToFrame2;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.GoToLabel;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.If;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Jump;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Push;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.SetTarget;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.StoreRegister;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Try;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.UnknownAction;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.WaitForFrame;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.WaitForFrame2;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.With;
import oracle.dss.graph.flash.jswiff.util.Base64;
import oracle.dss.graph.flash.jswiff.util.StringUtilities;
import oracle.dss.graph.flash.jswiff.xml.RecordXMLWriter;
import org.dom4j.Element;

class ActionXMLWriter {
    static void writeAction(Element parentElement, Action action) {
        Element element;
        short actionCode = action.getCode();
        switch (actionCode) {
            case 10: {
                element = parentElement.addElement("add");
                break;
            }
            case 71: {
                element = parentElement.addElement("add2");
                break;
            }
            case 16: {
                element = parentElement.addElement("and");
                break;
            }
            case 51: {
                element = parentElement.addElement("asciitochar");
                break;
            }
            case 96: {
                element = parentElement.addElement("bitand");
                break;
            }
            case 99: {
                element = parentElement.addElement("bitlshift");
                break;
            }
            case 97: {
                element = parentElement.addElement("bitor");
                break;
            }
            case 100: {
                element = parentElement.addElement("bitrshift");
                break;
            }
            case 101: {
                element = parentElement.addElement("biturshift");
                break;
            }
            case 98: {
                element = parentElement.addElement("bitxor");
                break;
            }
            case 158: {
                element = parentElement.addElement("call");
                break;
            }
            case 61: {
                element = parentElement.addElement("callfunction");
                break;
            }
            case 82: {
                element = parentElement.addElement("callmethod");
                break;
            }
            case 43: {
                element = parentElement.addElement("castop");
                break;
            }
            case 50: {
                element = parentElement.addElement("chartoascii");
                break;
            }
            case 36: {
                element = parentElement.addElement("clonesprite");
                break;
            }
            case 136: {
                element = ActionXMLWriter.writeConstantPool(parentElement, (ConstantPool)action);
                break;
            }
            case 81: {
                element = parentElement.addElement("decrement");
                break;
            }
            case 155: {
                element = ActionXMLWriter.writeDefineFunction(parentElement, (DefineFunction)action);
                break;
            }
            case 142: {
                element = ActionXMLWriter.writeDefineFunction2(parentElement, (DefineFunction2)action);
                break;
            }
            case 60: {
                element = parentElement.addElement("definelocal");
                break;
            }
            case 65: {
                element = parentElement.addElement("definelocal2");
                break;
            }
            case 58: {
                element = parentElement.addElement("delete");
                break;
            }
            case 59: {
                element = parentElement.addElement("delete2");
                break;
            }
            case 13: {
                element = parentElement.addElement("divide");
                break;
            }
            case 40: {
                element = parentElement.addElement("enddrag");
                break;
            }
            case 70: {
                element = parentElement.addElement("enumerate");
                break;
            }
            case 85: {
                element = parentElement.addElement("enumerate2");
                break;
            }
            case 14: {
                element = parentElement.addElement("equals");
                break;
            }
            case 73: {
                element = parentElement.addElement("equals2");
                break;
            }
            case 105: {
                element = parentElement.addElement("extends");
                break;
            }
            case 78: {
                element = parentElement.addElement("getmember");
                break;
            }
            case 34: {
                element = parentElement.addElement("getproperty");
                break;
            }
            case 52: {
                element = parentElement.addElement("gettime");
                break;
            }
            case 131: {
                element = ActionXMLWriter.writeGetURL(parentElement, (GetURL)action);
                break;
            }
            case 154: {
                element = ActionXMLWriter.writeGetURL2(parentElement, (GetURL2)action);
                break;
            }
            case 28: {
                element = parentElement.addElement("getvariable");
                break;
            }
            case 129: {
                element = ActionXMLWriter.writeGoToFrame(parentElement, (GoToFrame)action);
                break;
            }
            case 159: {
                element = ActionXMLWriter.writeGoToFrame2(parentElement, (GoToFrame2)action);
                break;
            }
            case 140: {
                element = ActionXMLWriter.writeGoToLabel(parentElement, (GoToLabel)action);
                break;
            }
            case 103: {
                element = parentElement.addElement("greater");
                break;
            }
            case 157: {
                element = ActionXMLWriter.writeIf(parentElement, (If)action);
                break;
            }
            case 44: {
                element = parentElement.addElement("implementsop");
                break;
            }
            case 80: {
                element = parentElement.addElement("increment");
                break;
            }
            case 66: {
                element = parentElement.addElement("initarray");
                break;
            }
            case 67: {
                element = parentElement.addElement("initobject");
                break;
            }
            case 84: {
                element = parentElement.addElement("instanceof");
                break;
            }
            case 153: {
                element = ActionXMLWriter.writeJump(parentElement, (Jump)action);
                break;
            }
            case 15: {
                element = parentElement.addElement("less");
                break;
            }
            case 72: {
                element = parentElement.addElement("less2");
                break;
            }
            case 55: {
                element = parentElement.addElement("mbasciitochar");
                break;
            }
            case 54: {
                element = parentElement.addElement("mbchartoascii");
                break;
            }
            case 53: {
                element = parentElement.addElement("mbstringextract");
                break;
            }
            case 49: {
                element = parentElement.addElement("mbstringlength");
                break;
            }
            case 63: {
                element = parentElement.addElement("modulo");
                break;
            }
            case 12: {
                element = parentElement.addElement("multiply");
                break;
            }
            case 83: {
                element = parentElement.addElement("newmethod");
                break;
            }
            case 64: {
                element = parentElement.addElement("newobject");
                break;
            }
            case 4: {
                element = parentElement.addElement("nextframe");
                break;
            }
            case 18: {
                element = parentElement.addElement("not");
                break;
            }
            case 17: {
                element = parentElement.addElement("or");
                break;
            }
            case 6: {
                element = parentElement.addElement("play");
                break;
            }
            case 23: {
                element = parentElement.addElement("pop");
                break;
            }
            case 5: {
                element = parentElement.addElement("previousframe");
                break;
            }
            case 150: {
                element = ActionXMLWriter.writePush(parentElement, (Push)action);
                break;
            }
            case 76: {
                element = parentElement.addElement("pushduplicate");
                break;
            }
            case 48: {
                element = parentElement.addElement("randomnumber");
                break;
            }
            case 37: {
                element = parentElement.addElement("removesprite");
                break;
            }
            case 62: {
                element = parentElement.addElement("return");
                break;
            }
            case 79: {
                element = parentElement.addElement("setmember");
                break;
            }
            case 35: {
                element = parentElement.addElement("setproperty");
                break;
            }
            case 139: {
                element = ActionXMLWriter.writeSetTarget(parentElement, (SetTarget)action);
                break;
            }
            case 32: {
                element = parentElement.addElement("settarget2");
                break;
            }
            case 29: {
                element = parentElement.addElement("setvariable");
                break;
            }
            case 77: {
                element = parentElement.addElement("stackswap");
                break;
            }
            case 39: {
                element = parentElement.addElement("startdrag");
                break;
            }
            case 7: {
                element = parentElement.addElement("stop");
                break;
            }
            case 9: {
                element = parentElement.addElement("stopsounds");
                break;
            }
            case 135: {
                element = ActionXMLWriter.writeStoreRegister(parentElement, (StoreRegister)action);
                break;
            }
            case 102: {
                element = parentElement.addElement("strictequals");
                break;
            }
            case 33: {
                element = parentElement.addElement("stringadd");
                break;
            }
            case 19: {
                element = parentElement.addElement("stringequals");
                break;
            }
            case 21: {
                element = parentElement.addElement("stringextract");
                break;
            }
            case 104: {
                element = parentElement.addElement("stringgreater");
                break;
            }
            case 20: {
                element = parentElement.addElement("stringlength");
                break;
            }
            case 41: {
                element = parentElement.addElement("stringless");
                break;
            }
            case 11: {
                element = parentElement.addElement("subtract");
                break;
            }
            case 69: {
                element = parentElement.addElement("targetpath");
                break;
            }
            case 42: {
                element = parentElement.addElement("throw");
                break;
            }
            case 24: {
                element = parentElement.addElement("tointeger");
                break;
            }
            case 74: {
                element = parentElement.addElement("tonumber");
                break;
            }
            case 75: {
                element = parentElement.addElement("tostring");
                break;
            }
            case 8: {
                element = parentElement.addElement("togglequality");
                break;
            }
            case 38: {
                element = parentElement.addElement("trace");
                break;
            }
            case 143: {
                element = ActionXMLWriter.writeTry(parentElement, (Try)action);
                break;
            }
            case 68: {
                element = parentElement.addElement("typeof");
                break;
            }
            case 138: {
                element = ActionXMLWriter.writeWaitForFrame(parentElement, (WaitForFrame)action);
                break;
            }
            case 141: {
                element = ActionXMLWriter.writeWaitForFrame2(parentElement, (WaitForFrame2)action);
                break;
            }
            case 148: {
                element = ActionXMLWriter.writeWith(parentElement, (With)action);
                break;
            }
            default: {
                element = ActionXMLWriter.writeUnknown(parentElement, (UnknownAction)action);
            }
        }
        String label = action.getLabel();
        if (label != null) {
            element.addAttribute("label", label);
        }
    }

    private static Element writeConstantPool(Element parentElement, ConstantPool constantPool) {
        Element element = parentElement.addElement("constantpool");
        List constants = constantPool.getConstants();
        int id = 0;
        for (String constant : constants) {
            Element constantElement = element.addElement("constant");
            constantElement.addAttribute("id", Integer.toString(id++));
            if (StringUtilities.containsIllegalChars(constant)) {
                constantElement.addElement("value").addAttribute("base64", "true").addText(Base64.encodeString(constant));
                continue;
            }
            constantElement.addElement("value").addText(constant);
        }
        return element;
    }

    private static Element writeDefineFunction(Element parentElement, DefineFunction defineFunction) {
        Element element = parentElement.addElement("definefunction");
        element.addAttribute("name", defineFunction.getName());
        String[] parameters = defineFunction.getParameters();
        Element parametersElement = element.addElement("parameters");
        int i = 0;
        while (i < parameters.length) {
            parametersElement.addElement("parameter").addAttribute("name", parameters[i]);
            ++i;
        }
        RecordXMLWriter.writeActionBlock(element, defineFunction.getBody());
        return element;
    }

    private static Element writeDefineFunction2(Element parentElement, DefineFunction2 defineFunction2) {
        Element element = parentElement.addElement("definefunction2");
        element.addAttribute("name", defineFunction2.getName());
        element.addAttribute("registercount", Short.toString(defineFunction2.getRegisterCount()));
        RegisterParam[] parameters = defineFunction2.getParameters();
        Element parametersElement = element.addElement("parameters");
        int i = 0;
        while (i < parameters.length) {
            RegisterParam parameter = parameters[i];
            Element paramElement = parametersElement.addElement("registerparam");
            paramElement.addAttribute("name", parameter.getParamName());
            paramElement.addAttribute("register", Short.toString(parameter.getRegister()));
            ++i;
        }
        Element preloadElement = element.addElement("preload");
        if (defineFunction2.preloadsArguments()) {
            preloadElement.addAttribute("arguments", "true");
        }
        if (defineFunction2.preloadsGlobal()) {
            preloadElement.addAttribute("global", "true");
        }
        if (defineFunction2.preloadsParent()) {
            preloadElement.addAttribute("parent", "true");
        }
        if (defineFunction2.preloadsRoot()) {
            preloadElement.addAttribute("root", "true");
        }
        if (defineFunction2.preloadsSuper()) {
            preloadElement.addAttribute("super", "true");
        }
        if (defineFunction2.preloadsThis()) {
            preloadElement.addAttribute("this", "true");
        }
        Element suppressElement = element.addElement("suppress");
        if (defineFunction2.suppressesArguments()) {
            suppressElement.addAttribute("arguments", "true");
        }
        if (defineFunction2.suppressesSuper()) {
            suppressElement.addAttribute("super", "true");
        }
        if (defineFunction2.suppressesThis()) {
            suppressElement.addAttribute("this", "true");
        }
        RecordXMLWriter.writeActionBlock(element, defineFunction2.getBody());
        return element;
    }

    private static Element writeGetURL(Element parentElement, GetURL getURL) {
        Element element = parentElement.addElement("geturl");
        element.addAttribute("url", getURL.getURL());
        element.addAttribute("target", getURL.getTarget());
        return element;
    }

    private static Element writeGetURL2(Element parentElement, GetURL2 getURL2) {
        Element element = parentElement.addElement("geturl2");
        switch (getURL2.getSendVarsMethod()) {
            case 1: {
                element.addAttribute("sendvarsmethod", "get");
                break;
            }
            case 2: {
                element.addAttribute("sendvarsmethod", "post");
                break;
            }
            default: {
                element.addAttribute("sendvarsmethod", "none");
            }
        }
        if (getURL2.isLoadTarget()) {
            element.addAttribute("loadtarget", "true");
        }
        if (getURL2.isLoadVariables()) {
            element.addAttribute("loadvariables", "true");
        }
        return element;
    }

    private static Element writeGoToFrame(Element parentElement, GoToFrame goToFrame) {
        Element element = parentElement.addElement("gotoframe");
        element.addAttribute("frame", Integer.toString(goToFrame.getFrame()));
        return element;
    }

    private static Element writeGoToFrame2(Element parentElement, GoToFrame2 goToFrame2) {
        Element element = parentElement.addElement("gotoframe2");
        element.addAttribute("scenebias", Integer.toString(goToFrame2.getSceneBias()));
        if (goToFrame2.play()) {
            element.addAttribute("play", "true");
        }
        return element;
    }

    private static Element writeGoToLabel(Element parentElement, GoToLabel goToLabel) {
        Element element = parentElement.addElement("gotolabel");
        element.addAttribute("framelabel", goToLabel.getFrameLabel());
        return element;
    }

    private static Element writeIf(Element parentElement, If ifAction) {
        Element element = parentElement.addElement("if");
        element.addAttribute("branchlabel", ifAction.getBranchLabel());
        return element;
    }

    private static Element writeJump(Element parentElement, Jump jump) {
        Element element = parentElement.addElement("jump");
        element.addAttribute("branchlabel", jump.getBranchLabel());
        return element;
    }

    private static Element writePush(Element parentElement, Push push) {
        Element element = parentElement.addElement("push");
        List values = push.getValues();
        for (Push.StackValue value : values) {
            switch (value.getType()) {
                case 5: {
                    element.addElement("boolean").addAttribute("value", Boolean.toString(value.getBoolean()));
                    break;
                }
                case 9: {
                    element.addElement("constant16").addAttribute("id", Integer.toString(value.getConstant16()));
                    break;
                }
                case 8: {
                    element.addElement("constant8").addAttribute("id", Integer.toString(value.getConstant8()));
                    break;
                }
                case 6: {
                    element.addElement("double").addAttribute("value", Double.toString(value.getDouble()));
                    break;
                }
                case 1: {
                    element.addElement("float").addAttribute("value", Float.toString(value.getFloat()));
                    break;
                }
                case 7: {
                    element.addElement("integer").addAttribute("value", Long.toString(value.getInteger()));
                    break;
                }
                case 2: {
                    element.addElement("null");
                    break;
                }
                case 4: {
                    element.addElement("register").addAttribute("number", Short.toString(value.getRegisterNumber()));
                    break;
                }
                case 0: {
                    element.addElement("string").addAttribute("value", value.getString());
                    break;
                }
                case 3: {
                    element.addElement("undefined");
                    break;
                }
            }
        }
        return element;
    }

    private static Element writeSetTarget(Element parentElement, SetTarget setTarget) {
        Element element = parentElement.addElement("settarget");
        element.addAttribute("name", setTarget.getName());
        return element;
    }

    private static Element writeStoreRegister(Element parentElement, StoreRegister storeRegister) {
        Element element = parentElement.addElement("storeregister");
        element.addAttribute("number", Short.toString(storeRegister.getNumber()));
        return element;
    }

    private static Element writeTry(Element parentElement, Try tryAction) {
        Element element = parentElement.addElement("try");
        if (tryAction.catchInRegister()) {
            element.addAttribute("catchregister", Short.toString(tryAction.getCatchRegister()));
        } else {
            element.addAttribute("catchvariable", tryAction.getCatchVariable());
        }
        RecordXMLWriter.writeActionBlock(element.addElement("try"), tryAction.getTryBlock());
        if (tryAction.hasCatchBlock()) {
            RecordXMLWriter.writeActionBlock(element.addElement("catch"), tryAction.getCatchBlock());
        }
        if (tryAction.hasFinallyBlock()) {
            RecordXMLWriter.writeActionBlock(element.addElement("finally"), tryAction.getFinallyBlock());
        }
        return element;
    }

    private static Element writeUnknown(Element parentElement, UnknownAction action) {
        Element element = parentElement.addElement("unknownaction");
        element.addAttribute("code", Integer.toString(action.getCode()));
        element.addText(Base64.encode(action.getData()));
        return element;
    }

    private static Element writeWaitForFrame(Element parentElement, WaitForFrame waitForFrame) {
        Element element = parentElement.addElement("waitforframe");
        element.addAttribute("frame", Integer.toString(waitForFrame.getFrame()));
        element.addAttribute("skipcount", Short.toString(waitForFrame.getSkipCount()));
        return element;
    }

    private static Element writeWaitForFrame2(Element parentElement, WaitForFrame2 waitForFrame2) {
        Element element = parentElement.addElement("waitforframe2");
        element.addAttribute("skipcount", Short.toString(waitForFrame2.getSkipCount()));
        return element;
    }

    private static Element writeWith(Element parentElement, With with) {
        Element element = parentElement.addElement("with");
        RecordXMLWriter.writeActionBlock(element, with.getWithBlock());
        return element;
    }

    ActionXMLWriter() {
    }
}

