/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.xml;

import java.util.ArrayList;
import java.util.List;
import oracle.dss.graph.flash.jswiff.swfrecords.AlignmentZone;
import oracle.dss.graph.flash.jswiff.swfrecords.AlphaBitmapData;
import oracle.dss.graph.flash.jswiff.swfrecords.AlphaColorMapData;
import oracle.dss.graph.flash.jswiff.swfrecords.BevelFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.BitmapData;
import oracle.dss.graph.flash.jswiff.swfrecords.BitmapPixelData;
import oracle.dss.graph.flash.jswiff.swfrecords.BlurFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.ButtonCondAction;
import oracle.dss.graph.flash.jswiff.swfrecords.ButtonRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.CXform;
import oracle.dss.graph.flash.jswiff.swfrecords.CXformWithAlpha;
import oracle.dss.graph.flash.jswiff.swfrecords.ClipActionRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.ClipActions;
import oracle.dss.graph.flash.jswiff.swfrecords.ClipEventFlags;
import oracle.dss.graph.flash.jswiff.swfrecords.Color;
import oracle.dss.graph.flash.jswiff.swfrecords.ColorMapData;
import oracle.dss.graph.flash.jswiff.swfrecords.ColorMatrixFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.ConvolutionFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.CurvedEdgeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.DropShadowFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.FillStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.FillStyleArray;
import oracle.dss.graph.flash.jswiff.swfrecords.Filter;
import oracle.dss.graph.flash.jswiff.swfrecords.FocalGradient;
import oracle.dss.graph.flash.jswiff.swfrecords.FocalMorphGradient;
import oracle.dss.graph.flash.jswiff.swfrecords.GlowFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.GlyphEntry;
import oracle.dss.graph.flash.jswiff.swfrecords.GradRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.Gradient;
import oracle.dss.graph.flash.jswiff.swfrecords.GradientBevelFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.GradientGlowFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.LineStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.LineStyle2;
import oracle.dss.graph.flash.jswiff.swfrecords.LineStyleArray;
import oracle.dss.graph.flash.jswiff.swfrecords.Matrix;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphFillStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphFillStyles;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphGradRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphGradient;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphLineStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphLineStyle2;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphLineStyles;
import oracle.dss.graph.flash.jswiff.swfrecords.Pix15;
import oracle.dss.graph.flash.jswiff.swfrecords.Pix24;
import oracle.dss.graph.flash.jswiff.swfrecords.RGB;
import oracle.dss.graph.flash.jswiff.swfrecords.RGBA;
import oracle.dss.graph.flash.jswiff.swfrecords.Rect;
import oracle.dss.graph.flash.jswiff.swfrecords.Shape;
import oracle.dss.graph.flash.jswiff.swfrecords.ShapeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.ShapeWithStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.SoundEnvelope;
import oracle.dss.graph.flash.jswiff.swfrecords.SoundInfo;
import oracle.dss.graph.flash.jswiff.swfrecords.StraightEdgeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.StyleChangeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.TextRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.ZlibBitmapData;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Action;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ActionBlock;
import oracle.dss.graph.flash.jswiff.util.Base64;
import oracle.dss.graph.flash.jswiff.xml.ActionXMLReader;
import oracle.dss.graph.flash.jswiff.xml.MalformedElementException;
import oracle.dss.graph.flash.jswiff.xml.MissingAttributeException;
import oracle.dss.graph.flash.jswiff.xml.MissingElementException;
import oracle.dss.graph.flash.jswiff.xml.MissingNodeException;
import org.dom4j.Attribute;
import org.dom4j.Element;

class RecordXMLReader {
    static boolean getBooleanAttribute(String name, Element parentElement) {
        Attribute attribute = parentElement.attribute(name);
        return attribute != null && attribute.getValue().equalsIgnoreCase("true");
    }

    static int getCharacterId(Element parentElement) {
        return RecordXMLReader.getIntAttribute("charid", parentElement);
    }

    static byte[] getDataElement(String elementName, Element parentElement) {
        Element element = parentElement.element(elementName);
        if (element == null) {
            throw new MissingElementException(elementName, parentElement.getPath());
        }
        return Base64.decode(element.getText());
    }

    static double getDoubleAttribute(String attributeName, Element parentElement) {
        return Double.parseDouble(RecordXMLReader.getStringAttribute(attributeName, parentElement));
    }

    static Element getElement(String elementName, Element parentElement) {
        Element result = parentElement.element(elementName);
        if (result == null) {
            throw new MissingElementException(elementName, parentElement.getPath());
        }
        return result;
    }

    static float getFloatAttribute(String attributeName, Element parentElement) {
        return Float.parseFloat(RecordXMLReader.getStringAttribute(attributeName, parentElement));
    }

    static int getIntAttribute(String attributeName, Element parentElement) {
        return Integer.parseInt(RecordXMLReader.getStringAttribute(attributeName, parentElement));
    }

    static long getLongAttribute(String attributeName, Element parentElement) {
        return Long.parseLong(RecordXMLReader.getStringAttribute(attributeName, parentElement));
    }

    static short getShortAttribute(String attributeName, Element parentElement) {
        return Short.parseShort(RecordXMLReader.getStringAttribute(attributeName, parentElement));
    }

    static String getStringAttribute(String attributeName, Element parentElement) {
        Attribute attribute = parentElement.attribute(attributeName);
        if (attribute == null) {
            throw new MissingAttributeException(attributeName, parentElement.getPath());
        }
        return attribute.getValue();
    }

    static void readActionBlock(ActionBlock actionBlock, Element parentElement) {
        Element blockElement = RecordXMLReader.getElement("actionblock", parentElement);
        List actionElements = blockElement.elements();
        for (Element actionElement : actionElements) {
            Action action = ActionXMLReader.readAction(actionElement);
            actionBlock.addAction(action);
        }
    }

    static AlignmentZone[] readAlignmentZones(Element parentElement) {
        Element zonesElement = RecordXMLReader.getElement("zones", parentElement);
        List zoneElements = zonesElement.elements("zone");
        int zonesCount = zoneElements.size();
        AlignmentZone[] zones = new AlignmentZone[zonesCount];
        int i = 0;
        while (i < zonesCount) {
            Attribute baselineAttribute;
            Element zoneElement = (Element)zoneElements.get(i);
            AlignmentZone zone = new AlignmentZone();
            Attribute leftAttribute = zoneElement.attribute("left");
            if (leftAttribute != null) {
                float left = Float.parseFloat(leftAttribute.getValue());
                float width = RecordXMLReader.getFloatAttribute("width", zoneElement);
                zone.setX(left, width);
            }
            if ((baselineAttribute = zoneElement.attribute("baseline")) != null) {
                float baseline = Float.parseFloat(baselineAttribute.getValue());
                float height = RecordXMLReader.getFloatAttribute("height", zoneElement);
                zone.setY(baseline, height);
            }
            zones[i] = zone;
            ++i;
        }
        return zones;
    }

    static ButtonCondAction[] readButtonCondActions(Element parentElement) {
        Element actionsElement = parentElement.element("actions");
        if (actionsElement != null) {
            List actions = actionsElement.elements();
            int arraySize = actions.size();
            ButtonCondAction[] actionArray = new ButtonCondAction[arraySize];
            int i = 0;
            while (i < arraySize) {
                Attribute keyPress;
                ButtonCondAction action = new ButtonCondAction();
                Element actionElement = (Element)actions.get(i);
                if (RecordXMLReader.getBooleanAttribute("outdowntoidle", actionElement)) {
                    action.setOutDownToIdle();
                }
                if (RecordXMLReader.getBooleanAttribute("outdowntooverdown", actionElement)) {
                    action.setOutDownToOverDown();
                }
                if (RecordXMLReader.getBooleanAttribute("idletooverdown", actionElement)) {
                    action.setIdleToOverDown();
                }
                if (RecordXMLReader.getBooleanAttribute("idletooverup", actionElement)) {
                    action.setIdleToOverUp();
                }
                if (RecordXMLReader.getBooleanAttribute("overdowntoidle", actionElement)) {
                    action.setOverDownToIdle();
                }
                if (RecordXMLReader.getBooleanAttribute("overdowntooutdown", actionElement)) {
                    action.setOverDownToOutDown();
                }
                if (RecordXMLReader.getBooleanAttribute("overdowntooverup", actionElement)) {
                    action.setOverDownToOverUp();
                }
                if (RecordXMLReader.getBooleanAttribute("overuptoidle", actionElement)) {
                    action.setOverUpToIdle();
                }
                if (RecordXMLReader.getBooleanAttribute("overuptooverdown", actionElement)) {
                    action.setOverUpToOverDown();
                }
                if ((keyPress = actionElement.attribute("keypress")) != null) {
                    action.setKeyPress(Byte.parseByte(keyPress.getValue()));
                }
                RecordXMLReader.readActionBlock(action.getActions(), actionElement);
                actionArray[i] = action;
                ++i;
            }
            return actionArray;
        }
        return null;
    }

    static ButtonRecord[] readButtonRecords(Element parentElement) {
        Element charsElement = RecordXMLReader.getElement("chars", parentElement);
        List recordElements = charsElement.elements();
        int arrayLength = recordElements.size();
        ButtonRecord[] records = new ButtonRecord[arrayLength];
        int i = 0;
        while (i < arrayLength) {
            Element recordElement = (Element)recordElements.get(i);
            int charId = RecordXMLReader.getIntAttribute("charid", recordElement);
            int depth = RecordXMLReader.getIntAttribute("depth", recordElement);
            Element state = RecordXMLReader.getElement("state", recordElement);
            boolean up = RecordXMLReader.getBooleanAttribute("up", state);
            boolean down = RecordXMLReader.getBooleanAttribute("down", state);
            boolean over = RecordXMLReader.getBooleanAttribute("over", state);
            boolean hit = RecordXMLReader.getBooleanAttribute("hit", state);
            Matrix placeMatrix = RecordXMLReader.readMatrix("matrix", recordElement);
            ButtonRecord record = new ButtonRecord(charId, depth, placeMatrix, up, over, down, hit);
            Element colorTransform = recordElement.element("cxformwithalpha");
            if (colorTransform != null) {
                record.setColorTransform(RecordXMLReader.readCXformWithAlpha(colorTransform));
            }
            records[i] = record;
            ++i;
        }
        return records;
    }

    static CXform readCXform(Element element) {
        Element mult;
        CXform colorTransform = new CXform();
        Element add = element.element("add");
        if (add != null) {
            int redAdd = RecordXMLReader.getIntAttribute("r", add);
            int greenAdd = RecordXMLReader.getIntAttribute("g", add);
            int blueAdd = RecordXMLReader.getIntAttribute("b", add);
            colorTransform.setAddTerms(redAdd, greenAdd, blueAdd);
        }
        if ((mult = element.element("mult")) != null) {
            int redMult = RecordXMLReader.getIntAttribute("r", mult);
            int greenMult = RecordXMLReader.getIntAttribute("g", mult);
            int blueMult = RecordXMLReader.getIntAttribute("b", mult);
            colorTransform.setMultTerms(redMult, greenMult, blueMult);
        }
        return colorTransform;
    }

    static CXformWithAlpha readCXformWithAlpha(Element element) {
        Element mult;
        CXformWithAlpha colorTransform = new CXformWithAlpha();
        Element add = element.element("add");
        if (add != null) {
            int redAdd = RecordXMLReader.getIntAttribute("r", add);
            int greenAdd = RecordXMLReader.getIntAttribute("g", add);
            int blueAdd = RecordXMLReader.getIntAttribute("b", add);
            int alphaAdd = RecordXMLReader.getIntAttribute("a", add);
            colorTransform.setAddTerms(redAdd, greenAdd, blueAdd, alphaAdd);
        }
        if ((mult = element.element("mult")) != null) {
            int redMult = RecordXMLReader.getIntAttribute("r", mult);
            int greenMult = RecordXMLReader.getIntAttribute("g", mult);
            int blueMult = RecordXMLReader.getIntAttribute("b", mult);
            int alphaMult = RecordXMLReader.getIntAttribute("a", mult);
            colorTransform.setMultTerms(redMult, greenMult, blueMult, alphaMult);
        }
        return colorTransform;
    }

    static ClipActions readClipActions(Element element) {
        ClipEventFlags eventFlags = RecordXMLReader.readClipEventFlags(element);
        List recordElements = element.elements("clipactionrecord");
        ArrayList<ClipActionRecord> records = new ArrayList<ClipActionRecord>();
        for (Element recordElement : recordElements) {
            ClipActionRecord record = new ClipActionRecord(RecordXMLReader.readClipEventFlags(recordElement));
            Attribute keyCode = recordElement.attribute("keycode");
            if (keyCode != null) {
                record.setKeyCode(Short.parseShort(keyCode.getValue()));
            }
            RecordXMLReader.readActionBlock(record.getActions(), recordElement);
            records.add(record);
        }
        return new ClipActions(eventFlags, records);
    }

    static Color readColor(Element element) {
        if (element.attribute("a") == null) {
            return RecordXMLReader.readRGB(element);
        }
        return RecordXMLReader.readRGBA(element);
    }

    static List readFilters(Element element) {
        List filterElements = element.elements();
        int filterCount = filterElements.size();
        ArrayList<Filter> filters = new ArrayList<Filter>(filterCount);
        int j = 0;
        while (j < filterCount) {
            Element filterElement = (Element)filterElements.get(j);
            if (filterElement.getName().equals("colormatrix")) {
                List valElements = filterElement.elements("val");
                int valCount = valElements.size();
                if (valCount != 20) {
                    throw new MalformedElementException("colormatrix must contain 20 values!");
                }
                float[] matrix = new float[20];
                int i = 0;
                while (i < 20) {
                    Element valElement = (Element)valElements.get(i);
                    matrix[i] = Float.parseFloat(valElement.getText());
                    ++i;
                }
                ColorMatrixFilter colorMatrixFilter = new ColorMatrixFilter(matrix);
                filters.add(colorMatrixFilter);
            } else if (filterElement.getName().equals("convolution")) {
                Element matrixElement = filterElement.element("matrix");
                List valElements = matrixElement.elements("val");
                float[] matrix = new float[valElements.size()];
                int i = 0;
                while (i < matrix.length) {
                    Element valElement = (Element)valElements.get(i);
                    matrix[i] = Float.parseFloat(valElement.getText());
                    ++i;
                }
                int matrixRows = RecordXMLReader.getIntAttribute("rows", matrixElement);
                ConvolutionFilter convolutionFilter = new ConvolutionFilter(matrix, matrixRows);
                convolutionFilter.setColor(RecordXMLReader.readRGBA(RecordXMLReader.getElement("color", filterElement)));
                convolutionFilter.setDivisor(RecordXMLReader.getFloatAttribute("divisor", filterElement));
                convolutionFilter.setBias(RecordXMLReader.getFloatAttribute("bias", filterElement));
                convolutionFilter.setClamp(RecordXMLReader.getBooleanAttribute("clamp", filterElement));
                convolutionFilter.setPreserveAlpha(RecordXMLReader.getBooleanAttribute("preservealpha", filterElement));
                filters.add(convolutionFilter);
            } else if (filterElement.getName().equals("blur")) {
                BlurFilter blurFilter = new BlurFilter(RecordXMLReader.getDoubleAttribute("x", filterElement), RecordXMLReader.getDoubleAttribute("y", filterElement));
                blurFilter.setQuality(RecordXMLReader.getIntAttribute("quality", filterElement));
                filters.add(blurFilter);
            } else if (filterElement.getName().equals("dropshadow")) {
                DropShadowFilter dropShadowFilter = new DropShadowFilter();
                dropShadowFilter.setColor(RecordXMLReader.readRGBA(RecordXMLReader.getElement("color", filterElement)));
                dropShadowFilter.setX(RecordXMLReader.getDoubleAttribute("x", filterElement));
                dropShadowFilter.setY(RecordXMLReader.getDoubleAttribute("y", filterElement));
                dropShadowFilter.setAngle(RecordXMLReader.getDoubleAttribute("angle", filterElement));
                dropShadowFilter.setDistance(RecordXMLReader.getDoubleAttribute("distance", filterElement));
                dropShadowFilter.setStrength(RecordXMLReader.getDoubleAttribute("strength", filterElement));
                dropShadowFilter.setQuality(RecordXMLReader.getIntAttribute("quality", filterElement));
                dropShadowFilter.setInner(RecordXMLReader.getBooleanAttribute("inner", filterElement));
                dropShadowFilter.setKnockout(RecordXMLReader.getBooleanAttribute("knockout", filterElement));
                dropShadowFilter.setHideObject(RecordXMLReader.getBooleanAttribute("hideobject", filterElement));
                filters.add(dropShadowFilter);
            } else if (filterElement.getName().equals("glow")) {
                GlowFilter glowFilter = new GlowFilter();
                glowFilter.setColor(RecordXMLReader.readRGBA(RecordXMLReader.getElement("color", filterElement)));
                glowFilter.setX(RecordXMLReader.getDoubleAttribute("x", filterElement));
                glowFilter.setY(RecordXMLReader.getDoubleAttribute("y", filterElement));
                glowFilter.setStrength(RecordXMLReader.getDoubleAttribute("strength", filterElement));
                glowFilter.setQuality(RecordXMLReader.getIntAttribute("quality", filterElement));
                glowFilter.setInner(RecordXMLReader.getBooleanAttribute("inner", filterElement));
                glowFilter.setKnockout(RecordXMLReader.getBooleanAttribute("knockout", filterElement));
                filters.add(glowFilter);
            } else if (filterElement.getName().equals("bevel")) {
                BevelFilter bevelFilter = new BevelFilter();
                bevelFilter.setHighlightColor(RecordXMLReader.readRGBA(RecordXMLReader.getElement("highlightcolor", filterElement)));
                bevelFilter.setShadowColor(RecordXMLReader.readRGBA(RecordXMLReader.getElement("shadowcolor", filterElement)));
                bevelFilter.setX(RecordXMLReader.getDoubleAttribute("x", filterElement));
                bevelFilter.setY(RecordXMLReader.getDoubleAttribute("y", filterElement));
                bevelFilter.setAngle(RecordXMLReader.getDoubleAttribute("angle", filterElement));
                bevelFilter.setDistance(RecordXMLReader.getDoubleAttribute("distance", filterElement));
                bevelFilter.setStrength(RecordXMLReader.getDoubleAttribute("strength", filterElement));
                bevelFilter.setQuality(RecordXMLReader.getIntAttribute("quality", filterElement));
                bevelFilter.setInner(RecordXMLReader.getBooleanAttribute("inner", filterElement));
                bevelFilter.setKnockout(RecordXMLReader.getBooleanAttribute("knockout", filterElement));
                bevelFilter.setOnTop(RecordXMLReader.getBooleanAttribute("ontop", filterElement));
                filters.add(bevelFilter);
            } else if (filterElement.getName().equals("gradientglow")) {
                Element pointsElement = RecordXMLReader.getElement("controlpoints", filterElement);
                List pointElements = pointsElement.elements("controlpoint");
                int controlPointsCount = pointElements.size();
                RGBA[] colors = new RGBA[controlPointsCount];
                short[] ratios = new short[controlPointsCount];
                int i = 0;
                while (i < controlPointsCount) {
                    Element pointElement = (Element)pointElements.get(i);
                    colors[i] = RecordXMLReader.readRGBA(RecordXMLReader.getElement("color", pointElement));
                    ratios[i] = RecordXMLReader.getShortAttribute("ratio", pointElement);
                    ++i;
                }
                GradientGlowFilter gradientGlowFilter = new GradientGlowFilter(colors, ratios);
                gradientGlowFilter.setX(RecordXMLReader.getDoubleAttribute("x", filterElement));
                gradientGlowFilter.setY(RecordXMLReader.getDoubleAttribute("y", filterElement));
                gradientGlowFilter.setAngle(RecordXMLReader.getDoubleAttribute("angle", filterElement));
                gradientGlowFilter.setDistance(RecordXMLReader.getDoubleAttribute("distance", filterElement));
                gradientGlowFilter.setStrength(RecordXMLReader.getDoubleAttribute("strength", filterElement));
                gradientGlowFilter.setQuality(RecordXMLReader.getIntAttribute("quality", filterElement));
                gradientGlowFilter.setInner(RecordXMLReader.getBooleanAttribute("inner", filterElement));
                gradientGlowFilter.setKnockout(RecordXMLReader.getBooleanAttribute("knockout", filterElement));
                gradientGlowFilter.setOnTop(RecordXMLReader.getBooleanAttribute("ontop", filterElement));
                filters.add(gradientGlowFilter);
            } else if (filterElement.getName().equals("gradientbevel")) {
                Element pointsElement = RecordXMLReader.getElement("controlpoints", filterElement);
                List pointElements = pointsElement.elements("controlpoint");
                int controlPointsCount = pointElements.size();
                RGBA[] colors = new RGBA[controlPointsCount];
                short[] ratios = new short[controlPointsCount];
                int i = 0;
                while (i < controlPointsCount) {
                    Element pointElement = (Element)pointElements.get(i);
                    colors[i] = RecordXMLReader.readRGBA(RecordXMLReader.getElement("color", pointElement));
                    ratios[i] = RecordXMLReader.getShortAttribute("ratio", pointElement);
                    ++i;
                }
                GradientBevelFilter gradientBevelFilter = new GradientBevelFilter(colors, ratios);
                gradientBevelFilter.setX(RecordXMLReader.getDoubleAttribute("x", filterElement));
                gradientBevelFilter.setY(RecordXMLReader.getDoubleAttribute("y", filterElement));
                gradientBevelFilter.setAngle(RecordXMLReader.getDoubleAttribute("angle", filterElement));
                gradientBevelFilter.setDistance(RecordXMLReader.getDoubleAttribute("distance", filterElement));
                gradientBevelFilter.setStrength(RecordXMLReader.getDoubleAttribute("strength", filterElement));
                gradientBevelFilter.setQuality(RecordXMLReader.getIntAttribute("quality", filterElement));
                gradientBevelFilter.setInner(RecordXMLReader.getBooleanAttribute("inner", filterElement));
                gradientBevelFilter.setKnockout(RecordXMLReader.getBooleanAttribute("knockout", filterElement));
                gradientBevelFilter.setOnTop(RecordXMLReader.getBooleanAttribute("ontop", filterElement));
                filters.add(gradientBevelFilter);
            }
            ++j;
        }
        return filters;
    }

    static Matrix readMatrix(Element element) {
        Element scale;
        Element translate = RecordXMLReader.getElement("translate", element);
        int translateX = RecordXMLReader.getIntAttribute("x", translate);
        int translateY = RecordXMLReader.getIntAttribute("y", translate);
        Matrix matrix = new Matrix(translateX, translateY);
        Element rotateSkew = element.element("rotateskew");
        if (rotateSkew != null) {
            matrix.setRotateSkew(RecordXMLReader.getDoubleAttribute("rs0", rotateSkew), RecordXMLReader.getDoubleAttribute("rs1", rotateSkew));
        }
        if ((scale = element.element("scale")) != null) {
            matrix.setScale(RecordXMLReader.getDoubleAttribute("x", scale), RecordXMLReader.getDoubleAttribute("y", scale));
        }
        return matrix;
    }

    static Matrix readMatrix(String elementName, Element parentElement) {
        Element matrixElement = RecordXMLReader.getElement(elementName, parentElement);
        return RecordXMLReader.readMatrix(matrixElement);
    }

    static MorphFillStyle readMorphFillStyle(Element element) {
        Element startElement = RecordXMLReader.getElement("start", element);
        Element endElement = RecordXMLReader.getElement("end", element);
        String type = RecordXMLReader.getStringAttribute("type", element);
        if (type.equals("solid")) {
            RGBA startColor = RecordXMLReader.readRGBA(RecordXMLReader.getElement("color", startElement));
            RGBA endColor = RecordXMLReader.readRGBA(RecordXMLReader.getElement("color", endElement));
            return new MorphFillStyle(startColor, endColor);
        }
        if (type.equals("lineargradient")) {
            return new MorphFillStyle(RecordXMLReader.readMorphGradient(element), RecordXMLReader.readMatrix("gradientmatrix", startElement), RecordXMLReader.readMatrix("gradientmatrix", endElement), 16);
        }
        if (type.equals("focalradialgradient")) {
            return new MorphFillStyle(RecordXMLReader.readMorphGradient(element), RecordXMLReader.readMatrix("gradientmatrix", startElement), RecordXMLReader.readMatrix("gradientmatrix", endElement), 19);
        }
        if (type.equals("radialgradient")) {
            return new MorphFillStyle(RecordXMLReader.readMorphGradient(element), RecordXMLReader.readMatrix("gradientmatrix", startElement), RecordXMLReader.readMatrix("gradientmatrix", endElement), 18);
        }
        if (type.equals("tiledbitmap")) {
            return new MorphFillStyle(RecordXMLReader.getIntAttribute("bitmapid", element), RecordXMLReader.readMatrix("bitmapmatrix", startElement), RecordXMLReader.readMatrix("bitmapmatrix", endElement), 64);
        }
        if (type.equals("clippedbitmap")) {
            return new MorphFillStyle(RecordXMLReader.getIntAttribute("bitmapid", element), RecordXMLReader.readMatrix("bitmapmatrix", startElement), RecordXMLReader.readMatrix("bitmapmatrix", endElement), 65);
        }
        if (type.equals("nonsmoothedtiledbitmap")) {
            return new MorphFillStyle(RecordXMLReader.getIntAttribute("bitmapid", element), RecordXMLReader.readMatrix("bitmapmatrix", startElement), RecordXMLReader.readMatrix("bitmapmatrix", endElement), 66);
        }
        if (type.equals("nonsmoothedclippedbitmap")) {
            return new MorphFillStyle(RecordXMLReader.getIntAttribute("bitmapid", element), RecordXMLReader.readMatrix("bitmapmatrix", startElement), RecordXMLReader.readMatrix("bitmapmatrix", endElement), 67);
        }
        throw new IllegalArgumentException("Illegal morph fill type: " + type);
    }

    static MorphFillStyles readMorphFillStyles(Element parentElement) {
        Element element = RecordXMLReader.getElement("morphfillstyles", parentElement);
        List styleElements = element.elements();
        MorphFillStyles styles = new MorphFillStyles();
        for (Element styleElement : styleElements) {
            styles.addStyle(RecordXMLReader.readMorphFillStyle(styleElement));
        }
        return styles;
    }

    static MorphLineStyles readMorphLineStyles(Element parentElement) {
        Element element = RecordXMLReader.getElement("morphlinestyles", parentElement);
        MorphLineStyles styles = new MorphLineStyles();
        List styleElements = element.elements();
        for (Element styleElement : styleElements) {
            if (styleElement.getName().equals("morphlinestyle")) {
                styles.addStyle(RecordXMLReader.readMorphLineStyle(styleElement));
                continue;
            }
            if (!styleElement.getName().equals("morphlinestyle2")) continue;
            styles.addStyle(RecordXMLReader.readMorphLineStyle2(styleElement));
        }
        return styles;
    }

    static RGB readRGB(Element element) {
        short red = RecordXMLReader.getShortAttribute("r", element);
        short green = RecordXMLReader.getShortAttribute("g", element);
        short blue = RecordXMLReader.getShortAttribute("b", element);
        return new RGB(red, green, blue);
    }

    static RGBA readRGBA(Element element) {
        short red = RecordXMLReader.getShortAttribute("r", element);
        short green = RecordXMLReader.getShortAttribute("g", element);
        short blue = RecordXMLReader.getShortAttribute("b", element);
        short alpha = RecordXMLReader.getShortAttribute("a", element);
        return new RGBA(red, green, blue, alpha);
    }

    static Rect readRect(Element element) {
        long xMin = RecordXMLReader.getLongAttribute("xmin", element);
        long xMax = RecordXMLReader.getLongAttribute("xmax", element);
        long yMin = RecordXMLReader.getLongAttribute("ymin", element);
        long yMax = RecordXMLReader.getLongAttribute("ymax", element);
        return new Rect(xMin, xMax, yMin, yMax);
    }

    static Shape readShape(Element element) {
        List shapeRecordElements = element.elements();
        int arrayLength = shapeRecordElements.size();
        ShapeRecord[] shapeRecords = new ShapeRecord[arrayLength];
        int i = 0;
        while (i < arrayLength) {
            Element shapeRecordElement = (Element)shapeRecordElements.get(i);
            if (shapeRecordElement.getName().equals("straightedgerecord")) {
                shapeRecords[i] = RecordXMLReader.readStraightEdgeRecord(shapeRecordElement);
            } else if (shapeRecordElement.getName().equals("curvededgerecord")) {
                shapeRecords[i] = RecordXMLReader.readCurvedEdgeRecord(shapeRecordElement);
            } else if (shapeRecordElement.getName().equals("stylechangerecord")) {
                shapeRecords[i] = RecordXMLReader.readStyleChangeRecord(shapeRecordElement);
            }
            ++i;
        }
        return new Shape(shapeRecords);
    }

    static ShapeWithStyle readShapeWithStyle(Element parentElement) {
        Element element = RecordXMLReader.getElement("shapewithstyle", parentElement);
        Element shape = RecordXMLReader.getElement("shape", element);
        List shapeRecordElements = shape.elements();
        int arrayLength = shapeRecordElements.size();
        ShapeRecord[] shapeRecords = new ShapeRecord[arrayLength];
        int i = 0;
        while (i < arrayLength) {
            Element shapeRecordElement = (Element)shapeRecordElements.get(i);
            if (shapeRecordElement.getName().equals("straightedgerecord")) {
                shapeRecords[i] = RecordXMLReader.readStraightEdgeRecord(shapeRecordElement);
            } else if (shapeRecordElement.getName().equals("curvededgerecord")) {
                shapeRecords[i] = RecordXMLReader.readCurvedEdgeRecord(shapeRecordElement);
            } else if (shapeRecordElement.getName().equals("stylechangerecord")) {
                shapeRecords[i] = RecordXMLReader.readStyleChangeRecord(shapeRecordElement);
            }
            ++i;
        }
        Element lineStyles = element.element("linestyles");
        Element fillStyles = element.element("fillstyles");
        return new ShapeWithStyle(RecordXMLReader.readFillStyles(fillStyles), RecordXMLReader.readLineStyles(lineStyles), shapeRecords);
    }

    static SoundInfo readSoundInfo(Element parentElement) {
        Element envelopeRecordsElement;
        Attribute inPoint;
        Attribute loopCount;
        Element element = RecordXMLReader.getElement("soundinfo", parentElement);
        SoundInfo soundInfo = new SoundInfo();
        if (RecordXMLReader.getBooleanAttribute("syncstop", element)) {
            soundInfo.setSyncStop();
        }
        if (RecordXMLReader.getBooleanAttribute("syncnomultiple", element)) {
            soundInfo.setSyncNoMultiple();
        }
        if ((loopCount = element.attribute("loopcount")) != null) {
            soundInfo.setLoopCount(Integer.parseInt(loopCount.getValue()));
        }
        if ((inPoint = element.attribute("inpoint")) != null) {
            soundInfo.setInPoint(Integer.parseInt(inPoint.getValue()));
        }
        if ((envelopeRecordsElement = element.element("enveloperecords")) != null) {
            soundInfo.setEnvelopeRecords(RecordXMLReader.readSoundEnvelopeRecords(envelopeRecordsElement));
        }
        return soundInfo;
    }

    static TextRecord[] readTextRecords(Element parentElement) {
        Element element = RecordXMLReader.getElement("textrecords", parentElement);
        List recordElements = element.elements();
        int arrayLength = recordElements.size();
        TextRecord[] records = new TextRecord[arrayLength];
        int i = 0;
        while (i < arrayLength) {
            Element color;
            Attribute yOffset;
            Attribute xOffset;
            Element recordElement = (Element)recordElements.get(i);
            GlyphEntry[] glyphEntries = RecordXMLReader.readGlyphEntries(recordElement);
            TextRecord record = new TextRecord(glyphEntries);
            Attribute fontId = recordElement.attribute("fontid");
            if (fontId != null) {
                record.setFont(Integer.parseInt(fontId.getValue()), RecordXMLReader.getIntAttribute("height", recordElement));
            }
            if ((xOffset = recordElement.attribute("xoffset")) != null) {
                record.setXOffset(Short.parseShort(xOffset.getValue()));
            }
            if ((yOffset = recordElement.attribute("yoffset")) != null) {
                record.setYOffset(Short.parseShort(yOffset.getValue()));
            }
            if ((color = recordElement.element("color")) != null) {
                record.setTextColor(RecordXMLReader.readColor(color));
            }
            records[i] = record;
            ++i;
        }
        return records;
    }

    static ZlibBitmapData readZlibBitmapData(Element parentElement) {
        Element element = parentElement.element("bitmapdata");
        if (element != null) {
            return new BitmapData(RecordXMLReader.readBitmapPixelData(element));
        }
        element = parentElement.element("colormapdata");
        if (element != null) {
            Element colorTableElement = RecordXMLReader.getElement("colortable", element);
            RGB[] colorTable = RecordXMLReader.readRGBArray(colorTableElement);
            Element pixelDataElement = RecordXMLReader.getElement("pixeldata", element);
            short[] pixelData = Base64.decodeUnsigned(pixelDataElement.getText());
            return new ColorMapData(colorTable, pixelData);
        }
        throw new MissingNodeException("Element " + parentElement.getPath() + " must contain either a bitmapdata or a colormapdata element!");
    }

    static ZlibBitmapData readZlibBitmapData2(Element parentElement) {
        Element element = parentElement.element("alphabitmapdata");
        if (element != null) {
            return new AlphaBitmapData(RecordXMLReader.readRGBAArray(element));
        }
        element = parentElement.element("alphacolormapdata");
        if (element != null) {
            Element colorTableElement = RecordXMLReader.getElement("colortable", element);
            RGBA[] colorTable = RecordXMLReader.readRGBAArray(colorTableElement);
            Element pixelDataElement = RecordXMLReader.getElement("pixeldata", element);
            short[] pixelData = Base64.decodeUnsigned(pixelDataElement.getText());
            return new AlphaColorMapData(colorTable, pixelData);
        }
        throw new MissingNodeException("Element " + parentElement.getPath() + " must contain either an alphabitmapdata or an alphacolormapdata element!");
    }

    private static BitmapPixelData[] readBitmapPixelData(Element parentElement) {
        Element element = parentElement.element("pix15array");
        if (element != null) {
            byte[] buffer = Base64.decode(element.getText());
            int arrayLength = buffer.length / 3;
            BitmapPixelData[] array = new Pix15[arrayLength];
            int i = 0;
            while (i < arrayLength) {
                int j = i * 3;
                array[i] = new Pix15(buffer[j], buffer[j + 1], buffer[j + 2]);
                ++i;
            }
            return array;
        }
        element = parentElement.element("pix24array");
        if (element != null) {
            short[] buffer = Base64.decodeUnsigned(element.getText());
            int arrayLength = buffer.length / 3;
            BitmapPixelData[] array = new Pix24[arrayLength];
            int i = 0;
            while (i < arrayLength) {
                int j = i * 3;
                array[i] = new Pix24(buffer[j], buffer[j + 1], buffer[j + 2]);
                ++i;
            }
            return array;
        }
        throw new MissingNodeException("Element " + parentElement.getPath() + " must contain either a pix15array or a pix24array element!");
    }

    private static byte readCapStyle(String attrName, Element element) {
        String capStyle = RecordXMLReader.getStringAttribute(attrName, element);
        if (capStyle.equals("none")) {
            return 1;
        }
        if (capStyle.equals("round")) {
            return 0;
        }
        if (capStyle.equals("square")) {
            return 2;
        }
        return -1;
    }

    private static ClipEventFlags readClipEventFlags(Element parentElement) {
        Element element = RecordXMLReader.getElement("clipeventflags", parentElement);
        ClipEventFlags clipEventFlags = new ClipEventFlags();
        if (RecordXMLReader.getBooleanAttribute("keyup", element)) {
            clipEventFlags.setKeyUp();
        }
        if (RecordXMLReader.getBooleanAttribute("keydown", element)) {
            clipEventFlags.setKeyDown();
        }
        if (RecordXMLReader.getBooleanAttribute("keypress", element)) {
            clipEventFlags.setKeyPress();
        }
        if (RecordXMLReader.getBooleanAttribute("mouseup", element)) {
            clipEventFlags.setMouseUp();
        }
        if (RecordXMLReader.getBooleanAttribute("mousedown", element)) {
            clipEventFlags.setMouseDown();
        }
        if (RecordXMLReader.getBooleanAttribute("mousemove", element)) {
            clipEventFlags.setMouseMove();
        }
        if (RecordXMLReader.getBooleanAttribute("load", element)) {
            clipEventFlags.setLoad();
        }
        if (RecordXMLReader.getBooleanAttribute("unload", element)) {
            clipEventFlags.setUnload();
        }
        if (RecordXMLReader.getBooleanAttribute("enterframe", element)) {
            clipEventFlags.setEnterFrame();
        }
        if (RecordXMLReader.getBooleanAttribute("dragover", element)) {
            clipEventFlags.setDragOver();
        }
        if (RecordXMLReader.getBooleanAttribute("dragout", element)) {
            clipEventFlags.setDragOut();
        }
        if (RecordXMLReader.getBooleanAttribute("rollover", element)) {
            clipEventFlags.setRollOver();
        }
        if (RecordXMLReader.getBooleanAttribute("rollout", element)) {
            clipEventFlags.setRollOut();
        }
        if (RecordXMLReader.getBooleanAttribute("releaseoutside", element)) {
            clipEventFlags.setReleaseOutside();
        }
        if (RecordXMLReader.getBooleanAttribute("release", element)) {
            clipEventFlags.setRelease();
        }
        if (RecordXMLReader.getBooleanAttribute("press", element)) {
            clipEventFlags.setPress();
        }
        if (RecordXMLReader.getBooleanAttribute("initialize", element)) {
            clipEventFlags.setInitialize();
        }
        if (RecordXMLReader.getBooleanAttribute("data", element)) {
            clipEventFlags.setData();
        }
        if (RecordXMLReader.getBooleanAttribute("construct", element)) {
            clipEventFlags.setConstruct();
        }
        return clipEventFlags;
    }

    private static ShapeRecord readCurvedEdgeRecord(Element element) {
        int anchorDeltaX = RecordXMLReader.getIntAttribute("anchordx", element);
        int anchorDeltaY = RecordXMLReader.getIntAttribute("anchordy", element);
        int controlDeltaX = RecordXMLReader.getIntAttribute("controldx", element);
        int controlDeltaY = RecordXMLReader.getIntAttribute("controldy", element);
        return new CurvedEdgeRecord(controlDeltaX, controlDeltaY, anchorDeltaX, anchorDeltaY);
    }

    private static FillStyle readFillStyle(Element element) {
        String type = RecordXMLReader.getStringAttribute("type", element);
        if (type.equals("solid")) {
            Color color = RecordXMLReader.readColor(RecordXMLReader.getElement("color", element));
            return new FillStyle(color);
        }
        if (type.equals("lineargradient")) {
            return new FillStyle(RecordXMLReader.readGradient(element), RecordXMLReader.readMatrix("gradientmatrix", element), 16);
        }
        if (type.equals("focalradialgradient")) {
            return new FillStyle(RecordXMLReader.readGradient(element), RecordXMLReader.readMatrix("gradientmatrix", element), 19);
        }
        if (type.equals("radialgradient")) {
            return new FillStyle(RecordXMLReader.readGradient(element), RecordXMLReader.readMatrix("gradientmatrix", element), 18);
        }
        if (type.equals("tiledbitmap")) {
            return new FillStyle(RecordXMLReader.getIntAttribute("bitmapid", element), RecordXMLReader.readMatrix("bitmapmatrix", element), 64);
        }
        if (type.equals("clippedbitmap")) {
            return new FillStyle(RecordXMLReader.getIntAttribute("bitmapid", element), RecordXMLReader.readMatrix("bitmapmatrix", element), 65);
        }
        if (type.equals("nonsmoothedtiledbitmap")) {
            return new FillStyle(RecordXMLReader.getIntAttribute("bitmapid", element), RecordXMLReader.readMatrix("bitmapmatrix", element), 66);
        }
        if (type.equals("nonsmoothedclippedbitmap")) {
            return new FillStyle(RecordXMLReader.getIntAttribute("bitmapid", element), RecordXMLReader.readMatrix("bitmapmatrix", element), 67);
        }
        throw new IllegalArgumentException("Illegal fill type: " + type);
    }

    private static FillStyleArray readFillStyles(Element element) {
        List styleElements = element.elements();
        FillStyleArray styleArray = new FillStyleArray();
        for (Element styleElement : styleElements) {
            styleArray.addStyle(RecordXMLReader.readFillStyle(styleElement));
        }
        return styleArray;
    }

    private static GlyphEntry[] readGlyphEntries(Element parentElement) {
        Element element = RecordXMLReader.getElement("glyphentries", parentElement);
        List entryElements = element.elements();
        int arrayLength = entryElements.size();
        GlyphEntry[] entries = new GlyphEntry[arrayLength];
        int i = 0;
        while (i < arrayLength) {
            Element entryElement = (Element)entryElements.get(i);
            entries[i] = new GlyphEntry(RecordXMLReader.getIntAttribute("index", entryElement), RecordXMLReader.getIntAttribute("advance", entryElement));
            ++i;
        }
        return entries;
    }

    private static Gradient readGradient(Element parentElement) {
        Element element = parentElement.element("gradient");
        boolean focal = false;
        if (element == null) {
            element = RecordXMLReader.getElement("focalgradient", parentElement);
            focal = true;
        }
        List recordElements = element.elements("gradrecord");
        int arrayLength = recordElements.size();
        GradRecord[] records = new GradRecord[arrayLength];
        int i = 0;
        while (i < arrayLength) {
            Element recordElement = (Element)recordElements.get(i);
            records[i] = new GradRecord(RecordXMLReader.getShortAttribute("ratio", recordElement), RecordXMLReader.readColor(RecordXMLReader.getElement("color", recordElement)));
            ++i;
        }
        Gradient gradient = focal ? new FocalGradient(records, RecordXMLReader.getDoubleAttribute("focalpointratio", element)) : new Gradient(records);
        gradient.setInterpolationMethod(RecordXMLReader.readInterpolationMethod(element));
        gradient.setSpreadMethod(RecordXMLReader.readSpreadMethod(element));
        return gradient;
    }

    private static byte readInterpolationMethod(Element element) {
        String interpolation = RecordXMLReader.getStringAttribute("interpolation", element);
        if (interpolation.equals("linear-rgb")) {
            return 1;
        }
        if (interpolation.equals("rgb")) {
            return 0;
        }
        return -1;
    }

    private static byte readJointStyle(Element element) {
        String jointStyle = RecordXMLReader.getStringAttribute("joint", element);
        if (jointStyle.equals("round")) {
            return 0;
        }
        if (jointStyle.equals("miter")) {
            return 0;
        }
        if (jointStyle.equals("bevel")) {
            return 0;
        }
        return -1;
    }

    private static LineStyle readLineStyle(Element element) {
        int width = RecordXMLReader.getIntAttribute("width", element);
        Color color = RecordXMLReader.readColor(RecordXMLReader.getElement("color", element));
        return new LineStyle(width, color);
    }

    private static LineStyle2 readLineStyle2(Element element) {
        LineStyle2 lineStyle2 = new LineStyle2(RecordXMLReader.getIntAttribute("width", element));
        byte jointStyle = RecordXMLReader.readJointStyle(element);
        lineStyle2.setJointStyle(jointStyle);
        if (jointStyle == 2) {
            lineStyle2.setMiterLimit(RecordXMLReader.getDoubleAttribute("miterlimit", element));
        }
        Element capStyleElement = RecordXMLReader.getElement("capstyle", element);
        lineStyle2.setStartCapStyle(RecordXMLReader.readCapStyle("start", capStyleElement));
        lineStyle2.setStartCapStyle(RecordXMLReader.readCapStyle("end", capStyleElement));
        lineStyle2.setScaleStroke(RecordXMLReader.readScaleStroke(element));
        lineStyle2.setClose(RecordXMLReader.getBooleanAttribute("close", element));
        lineStyle2.setPixelHinting(RecordXMLReader.getBooleanAttribute("pixelhinting", element));
        Element fillStyleElement = element.element("fillstyle");
        if (fillStyleElement == null) {
            Element colorElement = RecordXMLReader.getElement("color", element);
            lineStyle2.setColor(RecordXMLReader.readRGBA(colorElement));
        } else {
            lineStyle2.setFillStyle(RecordXMLReader.readFillStyle(fillStyleElement));
        }
        return lineStyle2;
    }

    private static LineStyleArray readLineStyles(Element element) {
        LineStyleArray styleArray = new LineStyleArray();
        List styleElements = element.elements();
        for (Element styleElement : styleElements) {
            if (styleElement.getName().equals("linestyle")) {
                styleArray.addStyle(RecordXMLReader.readLineStyle(styleElement));
                continue;
            }
            if (!styleElement.getName().equals("linestyle2")) continue;
            styleArray.addStyle(RecordXMLReader.readLineStyle2(styleElement));
        }
        return styleArray;
    }

    private static MorphGradient readMorphGradient(Element parentElement) {
        MorphGradient morphGradient;
        Element element = parentElement.element("morphgradient");
        boolean focal = false;
        if (element == null) {
            element = RecordXMLReader.getElement("focalmorphgradient", parentElement);
            focal = true;
        }
        List recordElements = element.elements("morphgradrecord");
        int arrayLength = recordElements.size();
        MorphGradRecord[] records = new MorphGradRecord[arrayLength];
        int i = 0;
        while (i < arrayLength) {
            Element recordElement = (Element)recordElements.get(i);
            Element start = RecordXMLReader.getElement("start", recordElement);
            short startRatio = RecordXMLReader.getShortAttribute("ratio", start);
            RGBA startColor = RecordXMLReader.readRGBA(RecordXMLReader.getElement("color", start));
            Element end = RecordXMLReader.getElement("end", recordElement);
            short endRatio = RecordXMLReader.getShortAttribute("ratio", end);
            RGBA endColor = RecordXMLReader.readRGBA(RecordXMLReader.getElement("color", end));
            records[i] = new MorphGradRecord(startRatio, startColor, endRatio, endColor);
            ++i;
        }
        if (focal) {
            double startFocalpointratio = RecordXMLReader.getDoubleAttribute("startfocalpointratio", element);
            double endfocalpointratio = RecordXMLReader.getDoubleAttribute("endfocalpointratio", element);
            morphGradient = new FocalMorphGradient(records, startFocalpointratio, endfocalpointratio);
        } else {
            morphGradient = new MorphGradient(records);
        }
        morphGradient.setInterpolationMethod(RecordXMLReader.readInterpolationMethod(element));
        morphGradient.setSpreadMethod(RecordXMLReader.readSpreadMethod(element));
        return morphGradient;
    }

    private static MorphLineStyle readMorphLineStyle(Element element) {
        Element startElement = RecordXMLReader.getElement("start", element);
        int startWidth = RecordXMLReader.getIntAttribute("width", startElement);
        RGBA startColor = RecordXMLReader.readRGBA(RecordXMLReader.getElement("color", startElement));
        Element endElement = RecordXMLReader.getElement("end", element);
        int endWidth = RecordXMLReader.getIntAttribute("width", endElement);
        RGBA endColor = RecordXMLReader.readRGBA(RecordXMLReader.getElement("color", endElement));
        return new MorphLineStyle(startWidth, startColor, endWidth, endColor);
    }

    private static MorphLineStyle2 readMorphLineStyle2(Element element) {
        MorphLineStyle2 lineStyle2;
        Element startElement = RecordXMLReader.getElement("start", element);
        int startWidth = RecordXMLReader.getIntAttribute("width", startElement);
        Element endElement = RecordXMLReader.getElement("end", element);
        int endWidth = RecordXMLReader.getIntAttribute("width", endElement);
        Element fillStyleElement = element.element("morphfillstyle");
        if (fillStyleElement == null) {
            RGBA startColor = RecordXMLReader.readRGBA(RecordXMLReader.getElement("color", startElement));
            RGBA endColor = RecordXMLReader.readRGBA(RecordXMLReader.getElement("color", endElement));
            lineStyle2 = new MorphLineStyle2(startWidth, startColor, endWidth, endColor);
        } else {
            MorphFillStyle fillStyle = RecordXMLReader.readMorphFillStyle(fillStyleElement);
            lineStyle2 = new MorphLineStyle2(startWidth, endWidth, fillStyle);
        }
        byte jointStyle = RecordXMLReader.readJointStyle(element);
        lineStyle2.setJointStyle(jointStyle);
        if (jointStyle == 2) {
            lineStyle2.setMiterLimit(RecordXMLReader.getDoubleAttribute("miterlimit", element));
        }
        Element capStyleElement = RecordXMLReader.getElement("capstyle", element);
        lineStyle2.setStartCapStyle(RecordXMLReader.readCapStyle("start", capStyleElement));
        lineStyle2.setStartCapStyle(RecordXMLReader.readCapStyle("end", capStyleElement));
        lineStyle2.setScaleStroke(RecordXMLReader.readScaleStroke(element));
        lineStyle2.setClose(RecordXMLReader.getBooleanAttribute("close", element));
        lineStyle2.setPixelHinting(RecordXMLReader.getBooleanAttribute("pixelhinting", element));
        return lineStyle2;
    }

    private static RGBA[] readRGBAArray(Element parentElement) {
        Element rgbaArrayElement = RecordXMLReader.getElement("rgbaarray", parentElement);
        short[] buffer = Base64.decodeUnsigned(rgbaArrayElement.getText());
        int arrayLength = buffer.length / 4;
        RGBA[] rgbaArray = new RGBA[arrayLength];
        int i = 0;
        while (i < arrayLength) {
            int j = i * 4;
            rgbaArray[i] = new RGBA(buffer[j], buffer[j + 1], buffer[j + 2], buffer[j + 3]);
            ++i;
        }
        return rgbaArray;
    }

    private static RGB[] readRGBArray(Element parentElement) {
        Element rgbArrayElement = RecordXMLReader.getElement("rgbarray", parentElement);
        short[] buffer = Base64.decodeUnsigned(rgbArrayElement.getText());
        int arrayLength = buffer.length / 3;
        RGB[] rgbArray = new RGB[arrayLength];
        int i = 0;
        while (i < arrayLength) {
            int j = i * 3;
            rgbArray[i] = new RGB(buffer[j], buffer[j + 1], buffer[j + 2]);
            ++i;
        }
        return rgbArray;
    }

    private static byte readScaleStroke(Element element) {
        String scaleStroke = RecordXMLReader.getStringAttribute("scalestroke", element);
        if (scaleStroke.equals("none")) {
            return 0;
        }
        if (scaleStroke.equals("horizontal")) {
            return 2;
        }
        if (scaleStroke.equals("vertical")) {
            return 1;
        }
        if (scaleStroke.equals("both")) {
            return 3;
        }
        return -1;
    }

    private static SoundEnvelope[] readSoundEnvelopeRecords(Element parentElement) {
        List recordElements = parentElement.elements();
        int arrayLength = recordElements.size();
        SoundEnvelope[] records = new SoundEnvelope[arrayLength];
        int i = 0;
        while (i < arrayLength) {
            SoundEnvelope record;
            Element recordElement = (Element)recordElements.get(i);
            long pos44 = RecordXMLReader.getLongAttribute("pos44", recordElement);
            int leftLevel = RecordXMLReader.getIntAttribute("leftlevel", recordElement);
            int rightLevel = RecordXMLReader.getIntAttribute("rightlevel", recordElement);
            records[i] = record = new SoundEnvelope(pos44, leftLevel, rightLevel);
            ++i;
        }
        return records;
    }

    private static byte readSpreadMethod(Element element) {
        String spread = RecordXMLReader.getStringAttribute("spread", element);
        if (spread.equals("pad")) {
            return 0;
        }
        if (spread.equals("reflect")) {
            return 1;
        }
        if (spread.equals("repeat")) {
            return 2;
        }
        return -1;
    }

    private static ShapeRecord readStraightEdgeRecord(Element element) {
        int deltaX = RecordXMLReader.getIntAttribute("dx", element);
        int deltaY = RecordXMLReader.getIntAttribute("dy", element);
        return new StraightEdgeRecord(deltaX, deltaY);
    }

    private static ShapeRecord readStyleChangeRecord(Element element) {
        Element styles;
        StyleChangeRecord record = new StyleChangeRecord();
        Element moveTo = element.element("moveto");
        if (moveTo != null) {
            record.setMoveTo(RecordXMLReader.getIntAttribute("x", moveTo), RecordXMLReader.getIntAttribute("y", moveTo));
        }
        if ((styles = element.element("styles")) != null) {
            Element newLineStyles;
            Attribute fill1;
            Attribute fill0;
            Attribute line = styles.attribute("line");
            if (line != null) {
                record.setLineStyle(Integer.parseInt(line.getValue()));
            }
            if ((fill0 = styles.attribute("fill0")) != null) {
                record.setFillStyle0(Integer.parseInt(fill0.getValue()));
            }
            if ((fill1 = styles.attribute("fill1")) != null) {
                record.setFillStyle1(Integer.parseInt(fill1.getValue()));
            }
            if ((newLineStyles = styles.element("linestyles")) != null) {
                Element newFillStyles = RecordXMLReader.getElement("fillstyles", styles);
                record.setNewStyles(RecordXMLReader.readLineStyles(newLineStyles), RecordXMLReader.readFillStyles(newFillStyles));
            }
        }
        return record;
    }

    RecordXMLReader() {
    }
}

