/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.xml;

import java.util.List;
import oracle.dss.graph.flash.jswiff.swfrecords.AlignmentZone;
import oracle.dss.graph.flash.jswiff.swfrecords.AlphaBitmapData;
import oracle.dss.graph.flash.jswiff.swfrecords.AlphaColorMapData;
import oracle.dss.graph.flash.jswiff.swfrecords.BevelFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.BitmapData;
import oracle.dss.graph.flash.jswiff.swfrecords.BitmapPixelData;
import oracle.dss.graph.flash.jswiff.swfrecords.BlendMode;
import oracle.dss.graph.flash.jswiff.swfrecords.BlurFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.ButtonCondAction;
import oracle.dss.graph.flash.jswiff.swfrecords.ButtonRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.CXform;
import oracle.dss.graph.flash.jswiff.swfrecords.CXformWithAlpha;
import oracle.dss.graph.flash.jswiff.swfrecords.ClipActionRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.ClipActions;
import oracle.dss.graph.flash.jswiff.swfrecords.ClipEventFlags;
import oracle.dss.graph.flash.jswiff.swfrecords.Color;
import oracle.dss.graph.flash.jswiff.swfrecords.ColorMapData;
import oracle.dss.graph.flash.jswiff.swfrecords.ColorMatrixFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.ConvolutionFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.CurvedEdgeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.DropShadowFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.FillStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.FillStyleArray;
import oracle.dss.graph.flash.jswiff.swfrecords.FocalGradient;
import oracle.dss.graph.flash.jswiff.swfrecords.FocalMorphGradient;
import oracle.dss.graph.flash.jswiff.swfrecords.GlowFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.GlyphEntry;
import oracle.dss.graph.flash.jswiff.swfrecords.GradRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.Gradient;
import oracle.dss.graph.flash.jswiff.swfrecords.GradientBevelFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.GradientGlowFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.LineStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.LineStyle2;
import oracle.dss.graph.flash.jswiff.swfrecords.LineStyleArray;
import oracle.dss.graph.flash.jswiff.swfrecords.Matrix;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphFillStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphFillStyles;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphGradRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphGradient;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphLineStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphLineStyle2;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphLineStyles;
import oracle.dss.graph.flash.jswiff.swfrecords.Pix15;
import oracle.dss.graph.flash.jswiff.swfrecords.Pix24;
import oracle.dss.graph.flash.jswiff.swfrecords.RGB;
import oracle.dss.graph.flash.jswiff.swfrecords.RGBA;
import oracle.dss.graph.flash.jswiff.swfrecords.Rect;
import oracle.dss.graph.flash.jswiff.swfrecords.Shape;
import oracle.dss.graph.flash.jswiff.swfrecords.ShapeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.ShapeWithStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.SoundEnvelope;
import oracle.dss.graph.flash.jswiff.swfrecords.SoundInfo;
import oracle.dss.graph.flash.jswiff.swfrecords.StraightEdgeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.StyleChangeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.TextRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.ZlibBitmapData;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Action;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ActionBlock;
import oracle.dss.graph.flash.jswiff.util.Base64;
import oracle.dss.graph.flash.jswiff.util.StringUtilities;
import oracle.dss.graph.flash.jswiff.xml.ActionXMLWriter;
import org.dom4j.Element;

class RecordXMLWriter {
    static void writeActionBlock(Element parentElement, ActionBlock actionBlock) {
        List actions = actionBlock.getActions();
        Element element = parentElement.addElement("actionblock");
        for (Action action : actions) {
            ActionXMLWriter.writeAction(element, action);
        }
    }

    static void writeAlignmentZones(Element parentElement, AlignmentZone[] alignmentZones) {
        Element element = parentElement.addElement("zones");
        int i = 0;
        while (i < alignmentZones.length) {
            AlignmentZone zone = alignmentZones[i];
            Element zoneElement = element.addElement("zone");
            if (zone.hasX()) {
                zoneElement.addAttribute("left", StringUtilities.doubleToString(zone.getLeft()));
                zoneElement.addAttribute("width", StringUtilities.doubleToString(zone.getWidth()));
            }
            if (zone.hasY()) {
                zoneElement.addAttribute("baseline", StringUtilities.doubleToString(zone.getBaseline()));
                zoneElement.addAttribute("height", StringUtilities.doubleToString(zone.getHeight()));
            }
            ++i;
        }
    }

    static void writeButtonCondAction(Element parentElement, ButtonCondAction buttonCondAction) {
        byte keyPress;
        Element element = parentElement.addElement("buttoncondaction");
        if (buttonCondAction.isOutDownToIdle()) {
            element.addAttribute("outdowntoidle", "true");
        }
        if (buttonCondAction.isOutDownToOverDown()) {
            element.addAttribute("outdowntooverdown", "true");
        }
        if (buttonCondAction.isIdleToOverDown()) {
            element.addAttribute("idletooverdown", "true");
        }
        if (buttonCondAction.isIdleToOverUp()) {
            element.addAttribute("idletooverup", "true");
        }
        if (buttonCondAction.isOverDownToIdle()) {
            element.addAttribute("overdowntoidle", "true");
        }
        if (buttonCondAction.isOverDownToOutDown()) {
            element.addAttribute("overdowntooutdown", "true");
        }
        if (buttonCondAction.isOverDownToOverUp()) {
            element.addAttribute("overdowntooverup", "true");
        }
        if (buttonCondAction.isOverUpToIdle()) {
            element.addAttribute("overuptoidle", "true");
        }
        if (buttonCondAction.isOverUpToOverDown()) {
            element.addAttribute("overuptooverdown", "true");
        }
        if ((keyPress = buttonCondAction.getKeyPress()) != 0) {
            element.addAttribute("keypress", Byte.toString(keyPress));
        }
        RecordXMLWriter.writeActionBlock(element, buttonCondAction.getActions());
    }

    static void writeButtonRecord(Element parentElement, ButtonRecord buttonRecord) {
        Element element = parentElement.addElement("buttonrecord");
        element.addAttribute("charid", Integer.toString(buttonRecord.getCharacterId()));
        element.addAttribute("depth", Integer.toString(buttonRecord.getPlaceDepth()));
        if (buttonRecord.hasBlendMode()) {
            element.addAttribute("blendmode", BlendMode.getDescription(buttonRecord.getBlendMode()));
        }
        Element state = element.addElement("state");
        if (buttonRecord.isUpState()) {
            state.addAttribute("up", "true");
        }
        if (buttonRecord.isDownState()) {
            state.addAttribute("down", "true");
        }
        if (buttonRecord.isOverState()) {
            state.addAttribute("over", "true");
        }
        if (buttonRecord.isHitState()) {
            state.addAttribute("hit", "true");
        }
        RecordXMLWriter.writeMatrix(element, buttonRecord.getPlaceMatrix());
        CXformWithAlpha colorTransform = buttonRecord.getColorTransform();
        if (colorTransform != null) {
            RecordXMLWriter.writeCXFormWithAlpha(element, colorTransform);
        }
        if (buttonRecord.hasFilters()) {
            RecordXMLWriter.writeFilters(element, buttonRecord.getFilters());
        }
    }

    static void writeCXForm(Element parentElement, CXform cXform) {
        Element element = parentElement.addElement("cxform");
        if (cXform.hasAddTerms()) {
            Element add = element.addElement("add");
            add.addAttribute("r", Integer.toString(cXform.getRedAddTerm()));
            add.addAttribute("g", Integer.toString(cXform.getGreenAddTerm()));
            add.addAttribute("b", Integer.toString(cXform.getBlueAddTerm()));
        }
        if (cXform.hasMultTerms()) {
            Element mult = element.addElement("mult");
            mult.addAttribute("r", Integer.toString(cXform.getRedMultTerm()));
            mult.addAttribute("g", Integer.toString(cXform.getGreenMultTerm()));
            mult.addAttribute("b", Integer.toString(cXform.getBlueMultTerm()));
        }
    }

    static void writeCXFormWithAlpha(Element parentElement, CXformWithAlpha cXformWithAlpha) {
        Element element = parentElement.addElement("cxformwithalpha");
        if (cXformWithAlpha.hasAddTerms()) {
            Element add = element.addElement("add");
            add.addAttribute("r", Integer.toString(cXformWithAlpha.getRedAddTerm()));
            add.addAttribute("g", Integer.toString(cXformWithAlpha.getGreenAddTerm()));
            add.addAttribute("b", Integer.toString(cXformWithAlpha.getBlueAddTerm()));
            add.addAttribute("a", Integer.toString(cXformWithAlpha.getAlphaAddTerm()));
        }
        if (cXformWithAlpha.hasMultTerms()) {
            Element mult = element.addElement("mult");
            mult.addAttribute("r", Integer.toString(cXformWithAlpha.getRedMultTerm()));
            mult.addAttribute("g", Integer.toString(cXformWithAlpha.getGreenMultTerm()));
            mult.addAttribute("b", Integer.toString(cXformWithAlpha.getBlueMultTerm()));
            mult.addAttribute("a", Integer.toString(cXformWithAlpha.getAlphaMultTerm()));
        }
    }

    static void writeClipActions(Element parentElement, ClipActions clipActions) {
        Element element = parentElement.addElement("clipactions");
        RecordXMLWriter.writeClipEventFlags(element, clipActions.getEventFlags());
        List records = clipActions.getClipActionRecords();
        for (ClipActionRecord record : records) {
            Element recordElement = element.addElement("clipactionrecord");
            ClipEventFlags eventFlags = record.getEventFlags();
            RecordXMLWriter.writeClipEventFlags(recordElement, eventFlags);
            if (eventFlags.isKeyPress()) {
                recordElement.addAttribute("keycode", Short.toString(record.getKeyCode()));
            }
            RecordXMLWriter.writeActionBlock(recordElement, record.getActions());
        }
    }

    static void writeColor(Element parentElement, String elementName, Color color) {
        if (color instanceof RGB) {
            RecordXMLWriter.writeRGB(parentElement, elementName, (RGB)color);
        } else {
            RecordXMLWriter.writeRGBA(parentElement, elementName, (RGBA)color);
        }
    }

    static void writeFilters(Element parentElement, List filters) {
        Element element = parentElement.addElement("filters");
        int j = 0;
        while (j < filters.size()) {
            Object filter = filters.get(j);
            if (filter instanceof ColorMatrixFilter) {
                ColorMatrixFilter colorMatrixFilter = (ColorMatrixFilter)filter;
                Element filterElement = element.addElement("colormatrix");
                float[] matrix = colorMatrixFilter.getMatrix();
                int i = 0;
                while (i < matrix.length) {
                    filterElement.addElement("val").addText(StringUtilities.doubleToString(matrix[i]));
                    ++i;
                }
            } else if (filter instanceof ConvolutionFilter) {
                ConvolutionFilter convolutionFilter = (ConvolutionFilter)filter;
                Element filterElement = element.addElement("convolution");
                Element matrixElement = filterElement.addElement("matrix");
                matrixElement.addAttribute("rows", Integer.toString(convolutionFilter.getMatrixRows()));
                float[] matrix = convolutionFilter.getMatrix();
                int i = 0;
                while (i < matrix.length) {
                    matrixElement.addElement("val").addText(StringUtilities.doubleToString(matrix[i]));
                    ++i;
                }
                RecordXMLWriter.writeRGBA(filterElement, "color", convolutionFilter.getColor());
                filterElement.addAttribute("divisor", StringUtilities.doubleToString(convolutionFilter.getDivisor()));
                filterElement.addAttribute("bias", StringUtilities.doubleToString(convolutionFilter.getBias()));
                if (convolutionFilter.isClamp()) {
                    filterElement.addAttribute("clamp", "true");
                }
                if (convolutionFilter.isPreserveAlpha()) {
                    filterElement.addAttribute("preservealpha", "true");
                }
            } else if (filter instanceof BlurFilter) {
                BlurFilter blurFilter = (BlurFilter)filter;
                Element filterElement = element.addElement("blur");
                filterElement.addAttribute("x", StringUtilities.doubleToString(blurFilter.getX()));
                filterElement.addAttribute("y", StringUtilities.doubleToString(blurFilter.getY()));
                filterElement.addAttribute("quality", Integer.toString(blurFilter.getQuality()));
            } else if (filter instanceof DropShadowFilter) {
                DropShadowFilter dropShadowFilter = (DropShadowFilter)filter;
                Element filterElement = element.addElement("dropshadow");
                RecordXMLWriter.writeRGBA(filterElement, "color", dropShadowFilter.getColor());
                filterElement.addAttribute("x", StringUtilities.doubleToString(dropShadowFilter.getX()));
                filterElement.addAttribute("y", StringUtilities.doubleToString(dropShadowFilter.getY()));
                filterElement.addAttribute("angle", StringUtilities.doubleToString(dropShadowFilter.getAngle()));
                filterElement.addAttribute("distance", StringUtilities.doubleToString(dropShadowFilter.getDistance()));
                filterElement.addAttribute("strength", StringUtilities.doubleToString(dropShadowFilter.getStrength()));
                filterElement.addAttribute("quality", Integer.toString(dropShadowFilter.getQuality()));
                if (dropShadowFilter.isInner()) {
                    filterElement.addAttribute("inner", "true");
                }
                if (dropShadowFilter.isKnockout()) {
                    filterElement.addAttribute("knockout", "true");
                }
                if (dropShadowFilter.isHideObject()) {
                    filterElement.addAttribute("hideobject", "true");
                }
            } else if (filter instanceof GlowFilter) {
                GlowFilter glowFilter = (GlowFilter)filter;
                Element filterElement = element.addElement("glow");
                RecordXMLWriter.writeRGBA(filterElement, "color", glowFilter.getColor());
                filterElement.addAttribute("x", StringUtilities.doubleToString(glowFilter.getX()));
                filterElement.addAttribute("y", StringUtilities.doubleToString(glowFilter.getY()));
                filterElement.addAttribute("strength", StringUtilities.doubleToString(glowFilter.getStrength()));
                filterElement.addAttribute("quality", Integer.toString(glowFilter.getQuality()));
                if (glowFilter.isInner()) {
                    filterElement.addAttribute("inner", "true");
                }
                if (glowFilter.isKnockout()) {
                    filterElement.addAttribute("knockout", "true");
                }
            } else if (filter instanceof BevelFilter) {
                BevelFilter bevelFilter = (BevelFilter)filter;
                Element filterElement = element.addElement("bevel");
                RecordXMLWriter.writeRGBA(filterElement, "highlightcolor", bevelFilter.getHighlightColor());
                RecordXMLWriter.writeRGBA(filterElement, "shadowcolor", bevelFilter.getShadowColor());
                filterElement.addAttribute("x", StringUtilities.doubleToString(bevelFilter.getX()));
                filterElement.addAttribute("y", StringUtilities.doubleToString(bevelFilter.getY()));
                filterElement.addAttribute("angle", StringUtilities.doubleToString(bevelFilter.getAngle()));
                filterElement.addAttribute("distance", StringUtilities.doubleToString(bevelFilter.getDistance()));
                filterElement.addAttribute("strength", StringUtilities.doubleToString(bevelFilter.getStrength()));
                filterElement.addAttribute("quality", Integer.toString(bevelFilter.getQuality()));
                if (bevelFilter.isInner()) {
                    filterElement.addAttribute("inner", "true");
                }
                if (bevelFilter.isKnockout()) {
                    filterElement.addAttribute("knockout", "true");
                }
                if (bevelFilter.isOnTop()) {
                    filterElement.addAttribute("ontop", "true");
                }
            } else if (filter instanceof GradientGlowFilter) {
                GradientGlowFilter gradientGlowFilter = (GradientGlowFilter)filter;
                Element filterElement = element.addElement("gradientglow");
                RGBA[] colors = gradientGlowFilter.getColors();
                short[] ratios = gradientGlowFilter.getRatios();
                int controlPointsCount = colors.length;
                Element pointsElement = filterElement.addElement("controlpoints");
                int i = 0;
                while (i < controlPointsCount) {
                    Element pointElement = pointsElement.addElement("controlpoint");
                    pointElement.addAttribute("ratio", Short.toString(ratios[i]));
                    RecordXMLWriter.writeRGBA(pointElement, "color", colors[i]);
                    ++i;
                }
                filterElement.addAttribute("x", StringUtilities.doubleToString(gradientGlowFilter.getX()));
                filterElement.addAttribute("y", StringUtilities.doubleToString(gradientGlowFilter.getY()));
                filterElement.addAttribute("angle", StringUtilities.doubleToString(gradientGlowFilter.getAngle()));
                filterElement.addAttribute("distance", StringUtilities.doubleToString(gradientGlowFilter.getDistance()));
                filterElement.addAttribute("strength", StringUtilities.doubleToString(gradientGlowFilter.getStrength()));
                filterElement.addAttribute("quality", Integer.toString(gradientGlowFilter.getQuality()));
                if (gradientGlowFilter.isInner()) {
                    filterElement.addAttribute("inner", "true");
                }
                if (gradientGlowFilter.isKnockout()) {
                    filterElement.addAttribute("knockout", "true");
                }
                if (gradientGlowFilter.isOnTop()) {
                    filterElement.addAttribute("ontop", "true");
                }
            } else if (filter instanceof GradientBevelFilter) {
                GradientBevelFilter gradientBevelFilter = (GradientBevelFilter)filter;
                Element filterElement = element.addElement("gradientbevel");
                RGBA[] colors = gradientBevelFilter.getColors();
                short[] ratios = gradientBevelFilter.getRatios();
                int controlPointsCount = colors.length;
                Element pointsElement = filterElement.addElement("controlpoints");
                int i = 0;
                while (i < controlPointsCount) {
                    Element pointElement = pointsElement.addElement("controlpoint");
                    pointElement.addAttribute("ratio", Short.toString(ratios[i]));
                    RecordXMLWriter.writeRGBA(pointElement, "color", colors[i]);
                    ++i;
                }
                filterElement.addAttribute("x", StringUtilities.doubleToString(gradientBevelFilter.getX()));
                filterElement.addAttribute("y", StringUtilities.doubleToString(gradientBevelFilter.getY()));
                filterElement.addAttribute("angle", StringUtilities.doubleToString(gradientBevelFilter.getAngle()));
                filterElement.addAttribute("distance", StringUtilities.doubleToString(gradientBevelFilter.getDistance()));
                filterElement.addAttribute("strength", StringUtilities.doubleToString(gradientBevelFilter.getStrength()));
                filterElement.addAttribute("quality", Integer.toString(gradientBevelFilter.getQuality()));
                if (gradientBevelFilter.isInner()) {
                    filterElement.addAttribute("inner", "true");
                }
                if (gradientBevelFilter.isKnockout()) {
                    filterElement.addAttribute("knockout", "true");
                }
                if (gradientBevelFilter.isOnTop()) {
                    filterElement.addAttribute("ontop", "true");
                }
            }
            ++j;
        }
    }

    static void writeMatrix(Element parentElement, Matrix matrix) {
        RecordXMLWriter.writeMatrix(parentElement, "matrix", matrix);
    }

    static void writeMatrix(Element parentElement, String elementName, Matrix matrix) {
        Element element = parentElement.addElement(elementName);
        Element translate = element.addElement("translate");
        translate.addAttribute("x", Integer.toString(matrix.getTranslateX()));
        translate.addAttribute("y", Integer.toString(matrix.getTranslateY()));
        if (matrix.hasRotateSkew()) {
            Element rotateSkew = element.addElement("rotateskew");
            rotateSkew.addAttribute("rs0", StringUtilities.doubleToString(matrix.getRotateSkew0()));
            rotateSkew.addAttribute("rs1", StringUtilities.doubleToString(matrix.getRotateSkew1()));
        }
        if (matrix.hasScale()) {
            Element scale = element.addElement("scale");
            scale.addAttribute("x", StringUtilities.doubleToString(matrix.getScaleX()));
            scale.addAttribute("y", StringUtilities.doubleToString(matrix.getScaleY()));
        }
    }

    static void writeMorphFillStyles(Element parentElement, MorphFillStyles fillStyles) {
        int size = fillStyles.getSize();
        Element fillStylesElement = parentElement.addElement("morphfillstyles");
        int i = 1;
        while (i <= size) {
            MorphFillStyle fillStyle = fillStyles.getStyle(i);
            RecordXMLWriter.writeMorphFillStyle(fillStylesElement, fillStyle);
            ++i;
        }
    }

    static void writeMorphLineStyles(Element parentElement, MorphLineStyles lineStyles) {
        int size = lineStyles.getSize();
        Element lineStylesElement = parentElement.addElement("morphlinestyles");
        int i = 1;
        while (i <= size) {
            Object style = lineStyles.getStyle(i);
            if (style instanceof MorphLineStyle) {
                MorphLineStyle lineStyle = (MorphLineStyle)style;
                Element lineStyleElement = lineStylesElement.addElement("morphlinestyle");
                Element startElement = lineStyleElement.addElement("start");
                startElement.addAttribute("width", Integer.toString(lineStyle.getStartWidth()));
                RecordXMLWriter.writeRGBA(startElement, "color", lineStyle.getStartColor());
                Element endElement = lineStyleElement.addElement("end");
                endElement.addAttribute("width", Integer.toString(lineStyle.getEndWidth()));
                RecordXMLWriter.writeRGBA(endElement, "color", lineStyle.getEndColor());
            } else {
                MorphFillStyle fillStyle;
                MorphLineStyle2 lineStyle2 = (MorphLineStyle2)style;
                Element lineStyle2Element = lineStylesElement.addElement("morphlinestyle2");
                Element startElement = lineStyle2Element.addElement("start");
                Element end = lineStyle2Element.addElement("end");
                startElement.addAttribute("width", Integer.toString(lineStyle2.getStartWidth()));
                end.addAttribute("width", Integer.toString(lineStyle2.getEndWidth()));
                RecordXMLWriter.writeEnhancedStrokeStyles(lineStyle2Element, lineStyle2.getJointStyle(), lineStyle2.getStartCapStyle(), lineStyle2.getEndCapStyle(), lineStyle2.getMiterLimit(), lineStyle2.getScaleStroke());
                if (lineStyle2.isClose()) {
                    parentElement.addAttribute("close", "true");
                }
                if (lineStyle2.isPixelHinting()) {
                    parentElement.addAttribute("pixelhinting", "true");
                }
                if ((fillStyle = lineStyle2.getFillStyle()) == null) {
                    RecordXMLWriter.writeColor(startElement, "color", lineStyle2.getStartColor());
                    RecordXMLWriter.writeColor(end, "color", lineStyle2.getEndColor());
                } else {
                    RecordXMLWriter.writeMorphFillStyle(lineStyle2Element, fillStyle);
                }
            }
            ++i;
        }
    }

    static void writeRGB(Element parentElement, String elementName, RGB rgbColor) {
        Element element = parentElement.addElement(elementName);
        element.addAttribute("r", Integer.toString(rgbColor.getRed()));
        element.addAttribute("g", Integer.toString(rgbColor.getGreen()));
        element.addAttribute("b", Integer.toString(rgbColor.getBlue()));
    }

    static void writeRGBA(Element parentElement, String elementName, RGBA rgbaColor) {
        Element element = parentElement.addElement(elementName);
        element.addAttribute("r", Integer.toString(rgbaColor.getRed()));
        element.addAttribute("g", Integer.toString(rgbaColor.getGreen()));
        element.addAttribute("b", Integer.toString(rgbaColor.getBlue()));
        element.addAttribute("a", Integer.toString(rgbaColor.getAlpha()));
    }

    static void writeRect(Element parentElement, String elementName, Rect rect) {
        Element element = parentElement.addElement(elementName);
        element.addAttribute("xmin", Long.toString(rect.getXMin()));
        element.addAttribute("xmax", Long.toString(rect.getXMax()));
        element.addAttribute("ymin", Long.toString(rect.getYMin()));
        element.addAttribute("ymax", Long.toString(rect.getYMax()));
    }

    static void writeShape(Element parentElement, Shape shape) {
        Element element = parentElement.addElement("shape");
        ShapeRecord[] records = shape.getShapeRecords();
        int i = 0;
        while (i < records.length) {
            RecordXMLWriter.writeShapeRecord(element, records[i]);
            ++i;
        }
    }

    static void writeShapeRecord(Element parentElement, ShapeRecord shapeRecord) {
        if (shapeRecord instanceof CurvedEdgeRecord) {
            RecordXMLWriter.writeCurvedEdgeRecord(parentElement, (CurvedEdgeRecord)shapeRecord);
        } else if (shapeRecord instanceof StraightEdgeRecord) {
            RecordXMLWriter.writeStraightEdgeRecord(parentElement, (StraightEdgeRecord)shapeRecord);
        } else {
            RecordXMLWriter.writeStyleChangeRecord(parentElement, (StyleChangeRecord)shapeRecord);
        }
    }

    static void writeShapeWithStyle(Element parentElement, ShapeWithStyle shapeWithStyle) {
        Element element = parentElement.addElement("shapewithstyle");
        Element shapeElement = element.addElement("shape");
        ShapeRecord[] records = shapeWithStyle.getShapeRecords();
        int i = 0;
        while (i < records.length) {
            RecordXMLWriter.writeShapeRecord(shapeElement, records[i]);
            ++i;
        }
        RecordXMLWriter.writeLineStyles(element, shapeWithStyle.getLineStyles());
        RecordXMLWriter.writeFillStyles(element, shapeWithStyle.getFillStyles());
    }

    static void writeSoundInfo(Element parentElement, SoundInfo soundInfo) {
        Element element = parentElement.addElement("soundinfo");
        if (soundInfo.isSyncStop()) {
            element.addAttribute("syncstop", "true");
        }
        if (soundInfo.isSyncNoMultiple()) {
            element.addAttribute("syncnomultiple", "true");
        }
        if (soundInfo.hasLoops()) {
            element.addAttribute("loopcount", Integer.toString(soundInfo.getLoopCount()));
        }
        if (soundInfo.hasInPoint()) {
            element.addAttribute("inpoint", Long.toString(soundInfo.getInPoint()));
        }
        if (soundInfo.hasOutPoint()) {
            element.addAttribute("outpoint", Long.toString(soundInfo.getOutPoint()));
        }
        if (soundInfo.hasEnvelope()) {
            Element recordsElement = element.addElement("enveloperecords");
            SoundEnvelope[] records = soundInfo.getEnvelopeRecords();
            int i = 0;
            while (i < records.length) {
                RecordXMLWriter.writeSoundEnvelope(recordsElement, records[i]);
                ++i;
            }
        }
    }

    static void writeTextRecord(Element parentElement, TextRecord record) {
        Element element = parentElement.addElement("textrecord");
        if (record.hasFont()) {
            element.addAttribute("fontid", Integer.toString(record.getFontId()));
            element.addAttribute("height", Integer.toString(record.getTextHeight()));
        }
        if (record.hasXOffset()) {
            element.addAttribute("xoffset", Short.toString(record.getXOffset()));
        }
        if (record.hasYOffset()) {
            element.addAttribute("yoffset", Short.toString(record.getYOffset()));
        }
        if (record.hasColor()) {
            RecordXMLWriter.writeColor(element, "color", record.getTextColor());
        }
        GlyphEntry[] glyphEntries = record.getGlyphEntries();
        Element glyphEntriesElement = element.addElement("glyphentries");
        int i = 0;
        while (i < glyphEntries.length) {
            GlyphEntry glyphEntry = glyphEntries[i];
            Element glyphEntryElement = glyphEntriesElement.addElement("glyphentry");
            glyphEntryElement.addAttribute("index", Integer.toString(glyphEntry.getGlyphIndex()));
            glyphEntryElement.addAttribute("advance", Integer.toString(glyphEntry.getGlyphAdvance()));
            ++i;
        }
    }

    static void writeZlibBitmapData(Element parentElement, ZlibBitmapData data) {
        if (data instanceof BitmapData) {
            RecordXMLWriter.writeBitmapData(parentElement, (BitmapData)data);
        } else if (data instanceof ColorMapData) {
            RecordXMLWriter.writeColorMapData(parentElement, (ColorMapData)data);
        } else if (data instanceof AlphaBitmapData) {
            RecordXMLWriter.writeAlphaBitmapData(parentElement, (AlphaBitmapData)data);
        } else {
            RecordXMLWriter.writeAlphaColorMapData(parentElement, (AlphaColorMapData)data);
        }
    }

    private static void writeAlphaBitmapData(Element parentElement, AlphaBitmapData data) {
        Element element = parentElement.addElement("alphabitmapdata");
        RGBA[] pixelData = data.getBitmapPixelData();
        RecordXMLWriter.writeRGBAArray(element, pixelData);
    }

    private static void writeAlphaColorMapData(Element parentElement, AlphaColorMapData data) {
        Element element = parentElement.addElement("alphacolormapdata");
        Element colorTableElement = element.addElement("colortable");
        RGBA[] colorTable = data.getColorTableRGBA();
        RecordXMLWriter.writeRGBAArray(colorTableElement, colorTable);
        Element pixelDataElement = element.addElement("pixeldata");
        short[] pixelData = data.getColorMapPixelData();
        pixelDataElement.addText(Base64.encodeUnsigned(pixelData));
    }

    private static void writeBitmapData(Element parentElement, BitmapData data) {
        Element element = parentElement.addElement("bitmapdata");
        BitmapPixelData[] pixelData = data.getBitmapPixelData();
        if (pixelData[0] instanceof Pix15) {
            RecordXMLWriter.writePix15Array(element, (Pix15[])pixelData);
        } else {
            RecordXMLWriter.writePix24Array(element, (Pix24[])pixelData);
        }
    }

    private static void writeClipEventFlags(Element parentElement, ClipEventFlags flags) {
        Element element = parentElement.addElement("clipeventflags");
        if (flags.isKeyUp()) {
            element.addAttribute("keyup", "true");
        }
        if (flags.isKeyDown()) {
            element.addAttribute("keydown", "true");
        }
        if (flags.isKeyPress()) {
            element.addAttribute("keypress", "true");
        }
        if (flags.isMouseUp()) {
            element.addAttribute("mouseup", "true");
        }
        if (flags.isMouseDown()) {
            element.addAttribute("mousedown", "true");
        }
        if (flags.isMouseMove()) {
            element.addAttribute("mousemove", "true");
        }
        if (flags.isLoad()) {
            element.addAttribute("load", "true");
        }
        if (flags.isUnload()) {
            element.addAttribute("unload", "true");
        }
        if (flags.isEnterFrame()) {
            element.addAttribute("enterframe", "true");
        }
        if (flags.isDragOver()) {
            element.addAttribute("dragover", "true");
        }
        if (flags.isDragOut()) {
            element.addAttribute("dragout", "true");
        }
        if (flags.isRollOver()) {
            element.addAttribute("rollover", "true");
        }
        if (flags.isRollOut()) {
            element.addAttribute("rollout", "true");
        }
        if (flags.isReleaseOutside()) {
            element.addAttribute("releaseoutside", "true");
        }
        if (flags.isRelease()) {
            element.addAttribute("release", "true");
        }
        if (flags.isPress()) {
            element.addAttribute("press", "true");
        }
        if (flags.isInitialize()) {
            element.addAttribute("initialize", "true");
        }
        if (flags.isData()) {
            element.addAttribute("data", "true");
        }
        if (flags.isConstruct()) {
            element.addAttribute("construct", "true");
        }
    }

    private static void writeColorMapData(Element parentElement, ColorMapData data) {
        Element element = parentElement.addElement("colormapdata");
        Element colorTableElement = element.addElement("colortable");
        RGB[] colorTable = data.getColorTableRGB();
        RecordXMLWriter.writeRGBArray(colorTableElement, colorTable);
        Element pixelDataElement = element.addElement("pixeldata");
        short[] pixelData = data.getColorMapPixelData();
        pixelDataElement.addText(Base64.encodeUnsigned(pixelData));
    }

    private static void writeCurvedEdgeRecord(Element parentElement, CurvedEdgeRecord curvedEdgeRecord) {
        Element element = parentElement.addElement("curvededgerecord");
        element.addAttribute("anchordx", Integer.toString(curvedEdgeRecord.getAnchorDeltaX()));
        element.addAttribute("anchordy", Integer.toString(curvedEdgeRecord.getAnchorDeltaY()));
        element.addAttribute("controldx", Integer.toString(curvedEdgeRecord.getControlDeltaX()));
        element.addAttribute("controldy", Integer.toString(curvedEdgeRecord.getControlDeltaY()));
    }

    private static void writeEnhancedStrokeStyles(Element parentElement, byte jointStyle, byte startCapStyle, byte endCapStyle, double miterLimit, byte scaleStroke) {
        switch (jointStyle) {
            case 0: {
                parentElement.addAttribute("joint", "round");
                break;
            }
            case 2: {
                parentElement.addAttribute("joint", "miter");
                parentElement.addAttribute("miterlimit", StringUtilities.doubleToString(miterLimit));
                break;
            }
            case 1: {
                parentElement.addAttribute("joint", "bevel");
                break;
            }
        }
        Element capStyleElement = parentElement.addElement("capstyle");
        switch (startCapStyle) {
            case 1: {
                capStyleElement.addAttribute("start", "none");
                break;
            }
            case 0: {
                capStyleElement.addAttribute("start", "round");
                break;
            }
            case 2: {
                capStyleElement.addAttribute("start", "square");
                break;
            }
        }
        switch (endCapStyle) {
            case 1: {
                capStyleElement.addAttribute("end", "none");
                break;
            }
            case 0: {
                capStyleElement.addAttribute("end", "round");
                break;
            }
            case 2: {
                capStyleElement.addAttribute("end", "square");
                break;
            }
        }
        switch (scaleStroke) {
            case 0: {
                parentElement.addAttribute("scalestroke", "none");
                break;
            }
            case 2: {
                parentElement.addAttribute("scalestroke", "horizontal");
                break;
            }
            case 1: {
                parentElement.addAttribute("scalestroke", "vertical");
                break;
            }
            case 3: {
                parentElement.addAttribute("scalestroke", "both");
                break;
            }
        }
    }

    private static void writeFillStyle(Element parentElement, FillStyle fillStyle) {
        Element fillStyleElement = parentElement.addElement("fillstyle");
        boolean isGradient = false;
        boolean isFocal = false;
        boolean isBitmap = false;
        switch (fillStyle.getType()) {
            case 0: {
                fillStyleElement.addAttribute("type", "solid");
                RecordXMLWriter.writeColor(fillStyleElement, "color", fillStyle.getColor());
                break;
            }
            case 16: {
                fillStyleElement.addAttribute("type", "lineargradient");
                isGradient = true;
                break;
            }
            case 19: {
                fillStyleElement.addAttribute("type", "focalradialgradient");
                isGradient = true;
                isFocal = true;
                break;
            }
            case 18: {
                fillStyleElement.addAttribute("type", "radialgradient");
                isGradient = true;
                break;
            }
            case 64: {
                fillStyleElement.addAttribute("type", "tiledbitmap");
                isBitmap = true;
                break;
            }
            case 65: {
                fillStyleElement.addAttribute("type", "clippedbitmap");
                isBitmap = true;
                break;
            }
            case 66: {
                fillStyleElement.addAttribute("type", "nonsmoothedtiledbitmap");
                isBitmap = true;
                break;
            }
            case 67: {
                fillStyleElement.addAttribute("type", "nonsmoothedclippedbitmap");
                isBitmap = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal fill type: " + fillStyle.getType());
            }
        }
        if (isGradient) {
            if (isFocal) {
                RecordXMLWriter.writeFocalGradient(fillStyleElement.addElement("focalgradient"), (FocalGradient)fillStyle.getGradient());
            } else {
                RecordXMLWriter.writeGradient(fillStyleElement.addElement("gradient"), fillStyle.getGradient());
            }
            RecordXMLWriter.writeMatrix(fillStyleElement, "gradientmatrix", fillStyle.getGradientMatrix());
        } else if (isBitmap) {
            fillStyleElement.addAttribute("bitmapid", Integer.toString(fillStyle.getBitmapId()));
            RecordXMLWriter.writeMatrix(fillStyleElement, "bitmapmatrix", fillStyle.getBitmapMatrix());
        }
    }

    private static void writeFillStyles(Element parentElement, FillStyleArray fillStyles) {
        int size = fillStyles.getSize();
        Element fillStylesElement = parentElement.addElement("fillstyles");
        int i = 1;
        while (i <= size) {
            FillStyle fillStyle = fillStyles.getStyle(i);
            RecordXMLWriter.writeFillStyle(fillStylesElement, fillStyle);
            ++i;
        }
    }

    private static void writeFocalGradient(Element gradientElement, FocalGradient gradient) {
        RecordXMLWriter.writeGradient(gradientElement, gradient);
        gradientElement.addAttribute("focalpointratio", StringUtilities.doubleToString(gradient.getFocalPointRatio()));
    }

    private static void writeFocalMorphGradient(Element gradientElement, FocalMorphGradient gradient) {
        RecordXMLWriter.writeMorphGradient(gradientElement, gradient);
        gradientElement.addAttribute("startfocalpointratio", StringUtilities.doubleToString(gradient.getStartFocalPointRatio()));
        gradientElement.addAttribute("endfocalpointratio", StringUtilities.doubleToString(gradient.getEndFocalPointRatio()));
    }

    private static void writeGradient(Element gradientElement, Gradient gradient) {
        switch (gradient.getInterpolationMethod()) {
            case 1: {
                gradientElement.addAttribute("interpolation", "linear-rgb");
                break;
            }
            case 0: {
                gradientElement.addAttribute("interpolation", "rgb");
                break;
            }
        }
        switch (gradient.getSpreadMethod()) {
            case 0: {
                gradientElement.addAttribute("spread", "pad");
                break;
            }
            case 1: {
                gradientElement.addAttribute("spread", "reflect");
                break;
            }
            case 2: {
                gradientElement.addAttribute("spread", "repeat");
                break;
            }
        }
        GradRecord[] records = gradient.getGradientRecords();
        int i = 0;
        while (i < records.length) {
            GradRecord record = records[i];
            Element recordElement = gradientElement.addElement("gradrecord");
            recordElement.addAttribute("ratio", Short.toString(record.getRatio()));
            RecordXMLWriter.writeColor(recordElement, "color", record.getColor());
            ++i;
        }
    }

    private static void writeLineStyles(Element parentElement, LineStyleArray lineStyles) {
        int size = lineStyles.getSize();
        Element lineStylesElement = parentElement.addElement("linestyles");
        int i = 1;
        while (i <= size) {
            Object style = lineStyles.getStyle(i);
            if (style instanceof LineStyle) {
                LineStyle lineStyle = (LineStyle)style;
                Element lineStyleElement = lineStylesElement.addElement("linestyle");
                lineStyleElement.addAttribute("width", Integer.toString(lineStyle.getWidth()));
                RecordXMLWriter.writeColor(lineStyleElement, "color", lineStyle.getColor());
            } else {
                FillStyle fillStyle;
                LineStyle2 lineStyle2 = (LineStyle2)style;
                Element lineStyle2Element = lineStylesElement.addElement("linestyle2");
                lineStyle2Element.addAttribute("width", Integer.toString(lineStyle2.getWidth()));
                RecordXMLWriter.writeEnhancedStrokeStyles(lineStyle2Element, lineStyle2.getJointStyle(), lineStyle2.getStartCapStyle(), lineStyle2.getEndCapStyle(), lineStyle2.getMiterLimit(), lineStyle2.getScaleStroke());
                if (lineStyle2.isClose()) {
                    parentElement.addAttribute("close", "true");
                }
                if (lineStyle2.isPixelHinting()) {
                    parentElement.addAttribute("pixelhinting", "true");
                }
                if ((fillStyle = lineStyle2.getFillStyle()) == null) {
                    RecordXMLWriter.writeColor(lineStyle2Element, "color", lineStyle2.getColor());
                } else {
                    RecordXMLWriter.writeFillStyle(lineStyle2Element, fillStyle);
                }
            }
            ++i;
        }
    }

    private static void writeMorphFillStyle(Element parentElement, MorphFillStyle fillStyle) {
        Element fillStyleElement = parentElement.addElement("morphfillstyle");
        Element start = fillStyleElement.addElement("start");
        Element end = fillStyleElement.addElement("end");
        boolean isGradient = false;
        boolean isFocal = false;
        boolean isBitmap = false;
        switch (fillStyle.getType()) {
            case 0: {
                fillStyleElement.addAttribute("type", "solid");
                RecordXMLWriter.writeRGBA(start, "color", fillStyle.getStartColor());
                RecordXMLWriter.writeRGBA(end, "color", fillStyle.getEndColor());
                break;
            }
            case 16: {
                fillStyleElement.addAttribute("type", "lineargradient");
                isGradient = true;
                break;
            }
            case 19: {
                fillStyleElement.addAttribute("type", "focalradialgradient");
                isGradient = true;
                isFocal = true;
                break;
            }
            case 18: {
                fillStyleElement.addAttribute("type", "radialgradient");
                isGradient = true;
                break;
            }
            case 64: {
                fillStyleElement.addAttribute("type", "tiledbitmap");
                isBitmap = true;
                break;
            }
            case 65: {
                fillStyleElement.addAttribute("type", "clippedbitmap");
                isBitmap = true;
                break;
            }
            case 66: {
                fillStyleElement.addAttribute("type", "nonsmoothedtiledbitmap");
                isBitmap = true;
                break;
            }
            case 67: {
                fillStyleElement.addAttribute("type", "nonsmoothedclippedbitmap");
                isBitmap = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal morph fill type: " + fillStyle.getType());
            }
        }
        if (isGradient) {
            if (isFocal) {
                RecordXMLWriter.writeFocalMorphGradient(fillStyleElement.addElement("focalmorphgradient"), (FocalMorphGradient)fillStyle.getGradient());
            } else {
                RecordXMLWriter.writeMorphGradient(fillStyleElement.addElement("morphgradient"), fillStyle.getGradient());
            }
            RecordXMLWriter.writeMatrix(start, "gradientmatrix", fillStyle.getStartGradientMatrix());
            RecordXMLWriter.writeMatrix(end, "gradientmatrix", fillStyle.getEndGradientMatrix());
        } else if (isBitmap) {
            fillStyleElement.addAttribute("bitmapid", Integer.toString(fillStyle.getBitmapId()));
            RecordXMLWriter.writeMatrix(start, "bitmapmatrix", fillStyle.getStartBitmapMatrix());
            RecordXMLWriter.writeMatrix(end, "bitmapmatrix", fillStyle.getEndBitmapMatrix());
        }
    }

    private static void writeMorphGradient(Element gradientElement, MorphGradient gradient) {
        switch (gradient.getInterpolationMethod()) {
            case 1: {
                gradientElement.addAttribute("interpolation", "linear-rgb");
                break;
            }
            case 0: {
                gradientElement.addAttribute("interpolation", "rgb");
                break;
            }
        }
        switch (gradient.getSpreadMethod()) {
            case 0: {
                gradientElement.addAttribute("spread", "pad");
                break;
            }
            case 1: {
                gradientElement.addAttribute("spread", "reflect");
                break;
            }
            case 2: {
                gradientElement.addAttribute("spread", "repeat");
                break;
            }
        }
        MorphGradRecord[] records = gradient.getGradientRecords();
        int i = 0;
        while (i < records.length) {
            MorphGradRecord record = records[i];
            Element recordElement = gradientElement.addElement("morphgradrecord");
            Element start = recordElement.addElement("start");
            start.addAttribute("ratio", Short.toString(record.getStartRatio()));
            RecordXMLWriter.writeRGBA(start, "color", record.getStartColor());
            Element end = recordElement.addElement("end");
            end.addAttribute("ratio", Short.toString(record.getEndRatio()));
            RecordXMLWriter.writeRGBA(end, "color", record.getEndColor());
            ++i;
        }
    }

    private static void writePix15Array(Element parentElement, Pix15[] data) {
        Element element = parentElement.addElement("pix15array");
        byte[] buffer = new byte[data.length * 3];
        int i = 0;
        while (i < data.length) {
            Pix15 pix15 = data[i];
            buffer[i * 3] = pix15.getRed();
            buffer[i * 3 + 1] = pix15.getGreen();
            buffer[i * 3 + 2] = pix15.getBlue();
            ++i;
        }
        element.addText(Base64.encode(buffer));
    }

    private static void writePix24Array(Element parentElement, Pix24[] data) {
        Element element = parentElement.addElement("pix24array");
        short[] buffer = new short[data.length * 3];
        int i = 0;
        while (i < data.length) {
            Pix24 pix24 = data[i];
            buffer[i * 3] = pix24.getRed();
            buffer[i * 3 + 1] = pix24.getGreen();
            buffer[i * 3 + 2] = pix24.getBlue();
            ++i;
        }
        element.addText(Base64.encodeUnsigned(buffer));
    }

    private static void writeRGBAArray(Element parentElement, RGBA[] data) {
        Element element = parentElement.addElement("rgbaarray");
        short[] buffer = new short[data.length * 4];
        int i = 0;
        while (i < data.length) {
            RGBA rgba = data[i];
            buffer[i * 4] = rgba.getRed();
            buffer[i * 4 + 1] = rgba.getGreen();
            buffer[i * 4 + 2] = rgba.getBlue();
            buffer[i * 4 + 3] = rgba.getAlpha();
            ++i;
        }
        element.addText(Base64.encodeUnsigned(buffer));
    }

    private static void writeRGBArray(Element parentElement, RGB[] data) {
        Element element = parentElement.addElement("rgbarray");
        short[] buffer = new short[data.length * 3];
        int i = 0;
        while (i < data.length) {
            RGB rgb = data[i];
            buffer[i * 3] = rgb.getRed();
            buffer[i * 3 + 1] = rgb.getGreen();
            buffer[i * 3 + 2] = rgb.getBlue();
            ++i;
        }
        element.addText(Base64.encodeUnsigned(buffer));
    }

    private static void writeSoundEnvelope(Element parentElement, SoundEnvelope soundEnvelope) {
        Element element = parentElement.addElement("soundenvelope");
        element.addAttribute("pos44", Long.toString(soundEnvelope.getPos44()));
        element.addAttribute("leftlevel", Integer.toString(soundEnvelope.getLeftLevel()));
        element.addAttribute("rightlevel", Integer.toString(soundEnvelope.getRightLevel()));
    }

    private static void writeStraightEdgeRecord(Element parentElement, StraightEdgeRecord straightEdgeRecord) {
        Element element = parentElement.addElement("straightedgerecord");
        element.addAttribute("dx", Integer.toString(straightEdgeRecord.getDeltaX()));
        element.addAttribute("dy", Integer.toString(straightEdgeRecord.getDeltaY()));
    }

    private static void writeStyleChangeRecord(Element parentElement, StyleChangeRecord styleChangeRecord) {
        Element element = parentElement.addElement("stylechangerecord");
        if (styleChangeRecord.hasMoveTo()) {
            Element moveTo = element.addElement("moveto");
            moveTo.addAttribute("x", Integer.toString(styleChangeRecord.getMoveToX()));
            moveTo.addAttribute("y", Integer.toString(styleChangeRecord.getMoveToY()));
        }
        if (styleChangeRecord.hasLineStyle() || styleChangeRecord.hasFillStyle0() || styleChangeRecord.hasFillStyle1() || styleChangeRecord.hasNewStyles()) {
            Element styles = element.addElement("styles");
            if (styleChangeRecord.hasLineStyle()) {
                styles.addAttribute("line", Integer.toString(styleChangeRecord.getLineStyle()));
            }
            if (styleChangeRecord.hasFillStyle0()) {
                styles.addAttribute("fill0", Integer.toString(styleChangeRecord.getFillStyle0()));
            }
            if (styleChangeRecord.hasFillStyle1()) {
                styles.addAttribute("fill1", Integer.toString(styleChangeRecord.getFillStyle1()));
            }
            if (styleChangeRecord.hasNewStyles()) {
                RecordXMLWriter.writeLineStyles(styles, styleChangeRecord.getNewLineStyles());
                RecordXMLWriter.writeFillStyles(styles, styleChangeRecord.getNewFillStyles());
            }
        }
    }

    RecordXMLWriter() {
    }
}

