/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.xml;

import java.util.List;
import oracle.dss.graph.flash.jswiff.swfrecords.AlignmentZone;
import oracle.dss.graph.flash.jswiff.swfrecords.BlendMode;
import oracle.dss.graph.flash.jswiff.swfrecords.ButtonRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.CXform;
import oracle.dss.graph.flash.jswiff.swfrecords.KerningRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.LangCode;
import oracle.dss.graph.flash.jswiff.swfrecords.Matrix;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphFillStyles;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphLineStyles;
import oracle.dss.graph.flash.jswiff.swfrecords.Rect;
import oracle.dss.graph.flash.jswiff.swfrecords.Shape;
import oracle.dss.graph.flash.jswiff.swfrecords.ShapeWithStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.TextRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.ZlibBitmapData;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineBits;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineBitsJPEG2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineBitsJPEG3;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineBitsLossless;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineBitsLossless2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineButton;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineButton2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineButtonCXform;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineButtonSound;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineEditText;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineFont;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineFont2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineFont3;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineFontAlignment;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineFontInfo;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineFontInfo2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineMorphShape;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineMorphShape2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineShape;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineShape2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineShape3;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineShape4;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineSound;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineSprite;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineText;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineText2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineVideoStream;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DoAction;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DoInitAction;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.EnableDebugger;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.EnableDebugger2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ExportAssets;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.FlashTypeSettings;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.FrameLabel;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.FreeCharacter;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ImportAssets;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ImportAssets2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.JPEGTables;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Metadata;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.PlaceObject;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.PlaceObject2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.PlaceObject3;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Protect;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.RemoveObject;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.RemoveObject2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Scale9Grid;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ScriptLimits;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.SetTabIndex;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ShowFrame;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.SoundStreamBlock;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.SoundStreamHead;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.SoundStreamHead2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.StartSound;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.UnknownTag;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.VideoFrame;
import oracle.dss.graph.flash.jswiff.util.Base64;
import oracle.dss.graph.flash.jswiff.xml.MissingAttributeException;
import oracle.dss.graph.flash.jswiff.xml.RecordXMLReader;
import org.dom4j.Attribute;
import org.dom4j.Element;

class TagXMLReader {
    static Tag readTag(Element tagElement, int tagCode) {
        Tag tag;
        switch (tagCode) {
            case 6: {
                tag = TagXMLReader.readDefineBits(tagElement);
                break;
            }
            case 21: {
                tag = TagXMLReader.readDefineBitsJPEG2(tagElement);
                break;
            }
            case 35: {
                tag = TagXMLReader.readDefineBitsJPEG3(tagElement);
                break;
            }
            case 20: {
                tag = TagXMLReader.readDefineBitsLossless(tagElement);
                break;
            }
            case 36: {
                tag = TagXMLReader.readDefineBitsLossless2(tagElement);
                break;
            }
            case 7: {
                tag = TagXMLReader.readDefineButton(tagElement);
                break;
            }
            case 34: {
                tag = TagXMLReader.readDefineButton2(tagElement);
                break;
            }
            case 23: {
                tag = TagXMLReader.readDefineButtonCXform(tagElement);
                break;
            }
            case 17: {
                tag = TagXMLReader.readDefineButtonSound(tagElement);
                break;
            }
            case 37: {
                tag = TagXMLReader.readDefineEditText(tagElement);
                break;
            }
            case 10: {
                tag = TagXMLReader.readDefineFont(tagElement);
                break;
            }
            case 48: {
                tag = TagXMLReader.readDefineFont2(tagElement);
                break;
            }
            case 75: {
                tag = TagXMLReader.readDefineFont3(tagElement);
                break;
            }
            case 13: {
                tag = TagXMLReader.readDefineFontInfo(tagElement);
                break;
            }
            case 62: {
                tag = TagXMLReader.readDefineFontInfo2(tagElement);
                break;
            }
            case 73: {
                tag = TagXMLReader.readDefineFontAlignment(tagElement);
                break;
            }
            case 46: {
                tag = TagXMLReader.readDefineMorphShape(tagElement);
                break;
            }
            case 84: {
                tag = TagXMLReader.readDefineMorphShape2(tagElement);
                break;
            }
            case 2: {
                tag = TagXMLReader.readDefineShape(tagElement);
                break;
            }
            case 22: {
                tag = TagXMLReader.readDefineShape2(tagElement);
                break;
            }
            case 32: {
                tag = TagXMLReader.readDefineShape3(tagElement);
                break;
            }
            case 83: {
                tag = TagXMLReader.readDefineShape4(tagElement);
                break;
            }
            case 14: {
                tag = TagXMLReader.readDefineSound(tagElement);
                break;
            }
            case 39: {
                tag = TagXMLReader.readDefineSprite(tagElement);
                break;
            }
            case 11: {
                tag = TagXMLReader.readDefineText(tagElement);
                break;
            }
            case 33: {
                tag = TagXMLReader.readDefineText2(tagElement);
                break;
            }
            case 60: {
                tag = TagXMLReader.readDefineVideoStream(tagElement);
                break;
            }
            case 12: {
                tag = TagXMLReader.readDoAction(tagElement);
                break;
            }
            case 59: {
                tag = TagXMLReader.readDoInitAction(tagElement);
                break;
            }
            case 58: {
                tag = TagXMLReader.readEnableDebugger(tagElement);
                break;
            }
            case 64: {
                tag = TagXMLReader.readEnableDebugger2(tagElement);
                break;
            }
            case 56: {
                tag = TagXMLReader.readExportAssets(tagElement);
                break;
            }
            case 74: {
                tag = TagXMLReader.readFlashTypeSettings(tagElement);
                break;
            }
            case 43: {
                tag = TagXMLReader.readFrameLabel(tagElement);
                break;
            }
            case 3: {
                tag = TagXMLReader.readFreeCharacter(tagElement);
                break;
            }
            case 57: {
                tag = TagXMLReader.readImportAssets(tagElement);
                break;
            }
            case 71: {
                tag = TagXMLReader.readImportAssets2(tagElement);
                break;
            }
            case 8: {
                tag = TagXMLReader.readJPEGTables(tagElement);
                break;
            }
            case -1: {
                tag = TagXMLReader.readMalformedTag(tagElement);
                break;
            }
            case 77: {
                tag = TagXMLReader.readMetadata(tagElement);
                break;
            }
            case 4: {
                tag = TagXMLReader.readPlaceObject(tagElement);
                break;
            }
            case 26: {
                tag = TagXMLReader.readPlaceObject2(tagElement);
                break;
            }
            case 70: {
                tag = TagXMLReader.readPlaceObject3(tagElement);
                break;
            }
            case 24: {
                tag = TagXMLReader.readProtect(tagElement);
                break;
            }
            case 5: {
                tag = TagXMLReader.readRemoveObject(tagElement);
                break;
            }
            case 28: {
                tag = TagXMLReader.readRemoveObject2(tagElement);
                break;
            }
            case 65: {
                tag = TagXMLReader.readScriptLimits(tagElement);
                break;
            }
            case 78: {
                tag = TagXMLReader.readScale9Grid(tagElement);
                break;
            }
            case 66: {
                tag = TagXMLReader.readSetTabIndex(tagElement);
                break;
            }
            case 1: {
                tag = TagXMLReader.readShowFrame(tagElement);
                break;
            }
            case 19: {
                tag = TagXMLReader.readSoundStreamBlock(tagElement);
                break;
            }
            case 18: {
                tag = TagXMLReader.readSoundStreamHead(tagElement);
                break;
            }
            case 45: {
                tag = TagXMLReader.readSoundStreamHead2(tagElement);
                break;
            }
            case 15: {
                tag = TagXMLReader.readStartSound(tagElement);
                break;
            }
            case 61: {
                tag = TagXMLReader.readVideoFrame(tagElement);
                break;
            }
            default: {
                tag = TagXMLReader.readUnknownTag(tagElement);
            }
        }
        return tag;
    }

    static Tag readUnknownTag(Element tagElement) {
        short code = RecordXMLReader.getShortAttribute("code", tagElement);
        byte[] data = Base64.decode(tagElement.getText());
        return new UnknownTag(code, data);
    }

    private static byte getSoundFormat(String format) {
        if (format.equals("adpcm")) {
            return 1;
        }
        if (format.equals("mp3")) {
            return 2;
        }
        if (format.equals("nellymoser")) {
            return 6;
        }
        if (format.equals("uncompressed")) {
            return 0;
        }
        if (format.equals("uncompressedle")) {
            return 3;
        }
        throw new IllegalArgumentException("Illegal sound format: " + format);
    }

    private static byte getSoundRate(String rate) {
        if (rate.equals("5500")) {
            return 0;
        }
        if (rate.equals("11000")) {
            return 1;
        }
        if (rate.equals("22000")) {
            return 2;
        }
        if (rate.equals("44000")) {
            return 3;
        }
        throw new IllegalArgumentException("Illegal sound rate: " + rate);
    }

    private static String getStringAttribute(String attributeName, Element parentElement) {
        Attribute attribute = (Attribute)parentElement.selectSingleNode("@" + attributeName);
        if (attribute == null) {
            throw new MissingAttributeException(attributeName, parentElement.getPath());
        }
        return attribute.getValue();
    }

    private static short getVideoCodecId(String codec) {
        if (codec.equals("screenvideo")) {
            return 3;
        }
        if (codec.equals("h263")) {
            return 2;
        }
        if (codec.equals("vp6")) {
            return 4;
        }
        if (codec.equals("vp6alpha")) {
            return 5;
        }
        if (codec.equals("screenvideov2")) {
            return 6;
        }
        if (codec.equals("undefined")) {
            return 0;
        }
        throw new IllegalArgumentException("Illegal video codec ID: " + codec);
    }

    private static byte getVideoDeblocking(String deblocking) {
        if (deblocking.equals("on")) {
            return 2;
        }
        if (deblocking.equals("off")) {
            return 1;
        }
        if (deblocking.equals("packet")) {
            return 0;
        }
        throw new IllegalArgumentException("Illegal video deblocking setting: " + deblocking);
    }

    private static Tag readDefineBits(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        byte[] jpegData = RecordXMLReader.getDataElement("jpegdata", tagElement);
        return new DefineBits(characterId, jpegData);
    }

    private static Tag readDefineBitsJPEG2(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        byte[] jpegData = RecordXMLReader.getDataElement("jpegdata", tagElement);
        return new DefineBitsJPEG2(characterId, jpegData);
    }

    private static Tag readDefineBitsJPEG3(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        byte[] jpegData = RecordXMLReader.getDataElement("jpegdata", tagElement);
        byte[] alphaData = RecordXMLReader.getDataElement("alphadata", tagElement);
        return new DefineBitsJPEG3(characterId, jpegData, alphaData);
    }

    private static Tag readDefineBitsLossless(Element tagElement) {
        short format;
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        String formatString = TagXMLReader.getStringAttribute("format", tagElement);
        if (formatString.equals("24bit")) {
            format = 5;
        } else if (formatString.equals("8bit")) {
            format = 3;
        } else if (formatString.equals("15bit")) {
            format = 4;
        } else {
            throw new IllegalArgumentException("Illegal lossless bitmap format: " + formatString);
        }
        int width = RecordXMLReader.getIntAttribute("width", tagElement);
        int height = RecordXMLReader.getIntAttribute("height", tagElement);
        ZlibBitmapData data = RecordXMLReader.readZlibBitmapData(tagElement);
        return new DefineBitsLossless(characterId, format, width, height, data);
    }

    private static Tag readDefineBitsLossless2(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        String formatString = TagXMLReader.getStringAttribute("format", tagElement);
        short format = formatString.equals("32bit") ? (short)5 : 3;
        int width = RecordXMLReader.getIntAttribute("width", tagElement);
        int height = RecordXMLReader.getIntAttribute("height", tagElement);
        ZlibBitmapData data = RecordXMLReader.readZlibBitmapData2(tagElement);
        return new DefineBitsLossless2(characterId, format, width, height, data);
    }

    private static Tag readDefineButton(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        ButtonRecord[] characters = RecordXMLReader.readButtonRecords(tagElement);
        DefineButton defineButton = new DefineButton(characterId, characters);
        RecordXMLReader.readActionBlock(defineButton.getActions(), tagElement);
        return defineButton;
    }

    private static Tag readDefineButton2(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        boolean trackAsMenu = RecordXMLReader.getBooleanAttribute("trackasmenu", tagElement);
        ButtonRecord[] characters = RecordXMLReader.readButtonRecords(tagElement);
        DefineButton2 defineButton2 = new DefineButton2(characterId, characters, trackAsMenu);
        defineButton2.setActions(RecordXMLReader.readButtonCondActions(tagElement));
        return defineButton2;
    }

    private static Tag readDefineButtonCXform(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        CXform colorTransform = RecordXMLReader.readCXform(RecordXMLReader.getElement("cxform", tagElement));
        return new DefineButtonCXform(characterId, colorTransform);
    }

    private static Tag readDefineButtonSound(Element tagElement) {
        Element overDownToOverUp;
        Element overUpToOverDown;
        Element idleToOverUp;
        int buttonId = RecordXMLReader.getIntAttribute("buttonid", tagElement);
        DefineButtonSound defineButtonSound = new DefineButtonSound(buttonId);
        Element overUpToIdle = tagElement.element("overuptoidle");
        if (overUpToIdle != null) {
            int soundId = RecordXMLReader.getIntAttribute("soundid", overUpToIdle);
            defineButtonSound.setOverUpToIdleSoundId(soundId);
            defineButtonSound.setOverUpToIdleSoundInfo(RecordXMLReader.readSoundInfo(overUpToIdle));
        }
        if ((idleToOverUp = tagElement.element("idletooverup")) != null) {
            int soundId = RecordXMLReader.getIntAttribute("soundid", idleToOverUp);
            defineButtonSound.setIdleToOverUpSoundId(soundId);
            defineButtonSound.setIdleToOverUpSoundInfo(RecordXMLReader.readSoundInfo(idleToOverUp));
        }
        if ((overUpToOverDown = tagElement.element("overuptooverdown")) != null) {
            int soundId = RecordXMLReader.getIntAttribute("soundid", overUpToOverDown);
            defineButtonSound.setOverUpToOverDownSoundId(soundId);
            defineButtonSound.setOverUpToOverDownSoundInfo(RecordXMLReader.readSoundInfo(overUpToOverDown));
        }
        if ((overDownToOverUp = tagElement.element("overdowntooverup")) != null) {
            int soundId = RecordXMLReader.getIntAttribute("soundid", overDownToOverUp);
            defineButtonSound.setOverDownToOverUpSoundId(soundId);
            defineButtonSound.setOverDownToOverUpSoundInfo(RecordXMLReader.readSoundInfo(overDownToOverUp));
        }
        return defineButtonSound;
    }

    private static Tag readDefineEditText(Element tagElement) {
        Element layout;
        Element font;
        Element color;
        Element initialText;
        Attribute maxLength;
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        Rect bounds = RecordXMLReader.readRect(RecordXMLReader.getElement("bounds", tagElement));
        String var = tagElement.attributeValue("variable");
        DefineEditText defineEditText = new DefineEditText(characterId, bounds, var);
        if (RecordXMLReader.getBooleanAttribute("wordwrap", tagElement)) {
            defineEditText.setWordWrap(true);
        }
        if (RecordXMLReader.getBooleanAttribute("multiline", tagElement)) {
            defineEditText.setMultiline(true);
        }
        if (RecordXMLReader.getBooleanAttribute("password", tagElement)) {
            defineEditText.setPassword(true);
        }
        if (RecordXMLReader.getBooleanAttribute("readonly", tagElement)) {
            defineEditText.setReadOnly(true);
        }
        if (RecordXMLReader.getBooleanAttribute("autosize", tagElement)) {
            defineEditText.setAutoSize(true);
        }
        if (RecordXMLReader.getBooleanAttribute("noselect", tagElement)) {
            defineEditText.setNoSelect(true);
        }
        if (RecordXMLReader.getBooleanAttribute("border", tagElement)) {
            defineEditText.setBorder(true);
        }
        if (RecordXMLReader.getBooleanAttribute("border", tagElement)) {
            defineEditText.setBorder(true);
        }
        if (RecordXMLReader.getBooleanAttribute("html", tagElement)) {
            defineEditText.setHtml(true);
        }
        if (RecordXMLReader.getBooleanAttribute("useoutlines", tagElement)) {
            defineEditText.setUseOutlines(true);
        }
        if ((maxLength = tagElement.attribute("maxlength")) != null) {
            defineEditText.setMaxLength(Integer.parseInt(maxLength.getValue()));
        }
        if ((initialText = tagElement.element("initialtext")) != null) {
            defineEditText.setInitialText(initialText.getText());
        }
        if ((color = tagElement.element("color")) != null) {
            defineEditText.setTextColor(RecordXMLReader.readRGBA(color));
        }
        if ((font = tagElement.element("font")) != null) {
            defineEditText.setFont(RecordXMLReader.getIntAttribute("fontid", font), RecordXMLReader.getIntAttribute("height", font));
        }
        if ((layout = tagElement.element("layout")) != null) {
            String alignString = TagXMLReader.getStringAttribute("align", layout);
            short align = alignString.equals("center") ? (short)2 : (alignString.equals("justify") ? (short)3 : (alignString.equals("right") ? (short)1 : 0));
            int leftMargin = RecordXMLReader.getIntAttribute("leftmargin", layout);
            int rightMargin = RecordXMLReader.getIntAttribute("rightmargin", layout);
            int indent = RecordXMLReader.getIntAttribute("indent", layout);
            int leading = RecordXMLReader.getIntAttribute("leading", layout);
            defineEditText.setLayout(align, leftMargin, rightMargin, indent, leading);
        }
        return defineEditText;
    }

    private static Tag readDefineFont(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        Element glyphShapeTable = RecordXMLReader.getElement("glyphshapetable", tagElement);
        List shapeElements = glyphShapeTable.selectNodes("shape");
        int arrayLength = shapeElements.size();
        Shape[] shapes = new Shape[arrayLength];
        int i = 0;
        while (i < arrayLength) {
            Element shapeElement = (Element)shapeElements.get(i);
            shapes[i] = RecordXMLReader.readShape(shapeElement);
            ++i;
        }
        DefineFont defineFont = new DefineFont(characterId, shapes);
        return defineFont;
    }

    private static Tag readDefineFont2(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        String fontName = TagXMLReader.getStringAttribute("fontname", tagElement);
        Shape[] glyphShapes = null;
        char[] codeTable = null;
        short[] advanceTable = null;
        Rect[] boundsTable = null;
        boolean hasLayout = false;
        Element glyphShapeTableElement = tagElement.element("glyphshapetable");
        if (glyphShapeTableElement != null) {
            List glyphElements = glyphShapeTableElement.elements();
            int numGlyphs = glyphElements.size();
            advanceTable = new short[numGlyphs];
            boundsTable = new Rect[numGlyphs];
            glyphShapes = new Shape[numGlyphs];
            codeTable = new char[numGlyphs];
            int i = 0;
            while (i < numGlyphs) {
                Element glyphElement = (Element)glyphElements.get(i);
                codeTable[i] = TagXMLReader.getStringAttribute("char", glyphElement).charAt(0);
                glyphShapes[i] = RecordXMLReader.readShape(RecordXMLReader.getElement("shape", glyphElement));
                Attribute advance = glyphElement.attribute("advance");
                if (advance != null) {
                    hasLayout = true;
                    advanceTable[i] = Short.parseShort(advance.getValue());
                    boundsTable[i] = RecordXMLReader.readRect(RecordXMLReader.getElement("bounds", glyphElement));
                }
                ++i;
            }
        }
        DefineFont2 defineFont2 = new DefineFont2(characterId, fontName, glyphShapes, codeTable);
        if (hasLayout) {
            Element layout = RecordXMLReader.getElement("layout", tagElement);
            short ascent = RecordXMLReader.getShortAttribute("ascent", layout);
            short descent = RecordXMLReader.getShortAttribute("descent", layout);
            short leading = RecordXMLReader.getShortAttribute("leading", layout);
            KerningRecord[] kerningTable = null;
            Element kerningTableElement = layout.element("kerningtable");
            if (kerningTableElement != null) {
                List recordElements = kerningTableElement.elements();
                int arrayLength = recordElements.size();
                kerningTable = new KerningRecord[arrayLength];
                int i = 0;
                while (i < arrayLength) {
                    Element recordElement = (Element)recordElements.get(i);
                    char left = TagXMLReader.getStringAttribute("left", recordElement).charAt(0);
                    char right = TagXMLReader.getStringAttribute("right", recordElement).charAt(0);
                    short adjustment = RecordXMLReader.getShortAttribute("adjust", recordElement);
                    kerningTable[i] = new KerningRecord(left, right, adjustment);
                    ++i;
                }
            }
            defineFont2.setLayout(ascent, descent, leading, advanceTable, boundsTable, kerningTable);
        }
        if (RecordXMLReader.getBooleanAttribute("ansi", tagElement)) {
            defineFont2.setANSI(true);
        }
        if (RecordXMLReader.getBooleanAttribute("shiftjis", tagElement)) {
            defineFont2.setShiftJIS(true);
        }
        if (RecordXMLReader.getBooleanAttribute("bold", tagElement)) {
            defineFont2.setBold(true);
        }
        if (RecordXMLReader.getBooleanAttribute("italic", tagElement)) {
            defineFont2.setItalic(true);
        }
        if (RecordXMLReader.getBooleanAttribute("smalltext", tagElement)) {
            defineFont2.setSmallText(true);
        }
        defineFont2.setLanguageCode(TagXMLReader.readLangCode(tagElement));
        return defineFont2;
    }

    private static Tag readDefineFont3(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        String fontName = TagXMLReader.getStringAttribute("fontname", tagElement);
        Shape[] glyphShapes = null;
        char[] codeTable = null;
        short[] advanceTable = null;
        Rect[] boundsTable = null;
        boolean hasLayout = false;
        Element glyphShapeTableElement = tagElement.element("glyphshapetable");
        if (glyphShapeTableElement != null) {
            List glyphElements = glyphShapeTableElement.elements();
            int numGlyphs = glyphElements.size();
            advanceTable = new short[numGlyphs];
            boundsTable = new Rect[numGlyphs];
            glyphShapes = new Shape[numGlyphs];
            codeTable = new char[numGlyphs];
            int i = 0;
            while (i < numGlyphs) {
                Element glyphElement = (Element)glyphElements.get(i);
                codeTable[i] = TagXMLReader.getStringAttribute("char", glyphElement).charAt(0);
                glyphShapes[i] = RecordXMLReader.readShape(RecordXMLReader.getElement("shape", glyphElement));
                Attribute advance = glyphElement.attribute("advance");
                if (advance != null) {
                    hasLayout = true;
                    advanceTable[i] = Short.parseShort(advance.getValue());
                    boundsTable[i] = RecordXMLReader.readRect(RecordXMLReader.getElement("bounds", glyphElement));
                }
                ++i;
            }
        }
        DefineFont3 defineFont3 = new DefineFont3(characterId, fontName, glyphShapes, codeTable);
        if (hasLayout) {
            Element layout = RecordXMLReader.getElement("layout", tagElement);
            short ascent = RecordXMLReader.getShortAttribute("ascent", layout);
            short descent = RecordXMLReader.getShortAttribute("descent", layout);
            short leading = RecordXMLReader.getShortAttribute("leading", layout);
            KerningRecord[] kerningTable = null;
            Element kerningTableElement = layout.element("kerningtable");
            if (kerningTableElement != null) {
                List recordElements = kerningTableElement.elements();
                int arrayLength = recordElements.size();
                kerningTable = new KerningRecord[arrayLength];
                int i = 0;
                while (i < arrayLength) {
                    Element recordElement = (Element)recordElements.get(i);
                    char left = TagXMLReader.getStringAttribute("left", recordElement).charAt(0);
                    char right = TagXMLReader.getStringAttribute("right", recordElement).charAt(0);
                    short adjustment = RecordXMLReader.getShortAttribute("adjust", recordElement);
                    kerningTable[i] = new KerningRecord(left, right, adjustment);
                    ++i;
                }
            }
            defineFont3.setLayout(ascent, descent, leading, advanceTable, boundsTable, kerningTable);
        }
        if (RecordXMLReader.getBooleanAttribute("bold", tagElement)) {
            defineFont3.setBold(true);
        }
        if (RecordXMLReader.getBooleanAttribute("italic", tagElement)) {
            defineFont3.setItalic(true);
        }
        if (RecordXMLReader.getBooleanAttribute("smalltext", tagElement)) {
            defineFont3.setSmallText(true);
        }
        defineFont3.setLanguageCode(TagXMLReader.readLangCode(tagElement));
        return defineFont3;
    }

    private static Tag readDefineFontInfo(Element tagElement) {
        int fontId = RecordXMLReader.getIntAttribute("fontid", tagElement);
        String fontName = TagXMLReader.getStringAttribute("fontname", tagElement);
        List charElements = tagElement.elements();
        int arrayLength = charElements.size();
        char[] codeTable = new char[arrayLength];
        int i = 0;
        while (i < arrayLength) {
            Element charElement = (Element)charElements.get(i);
            codeTable[i] = charElement.getText().charAt(0);
            ++i;
        }
        DefineFontInfo defineFontInfo = new DefineFontInfo(fontId, fontName, codeTable);
        if (RecordXMLReader.getBooleanAttribute("ansi", tagElement)) {
            defineFontInfo.setANSI(true);
        }
        if (RecordXMLReader.getBooleanAttribute("shiftjis", tagElement)) {
            defineFontInfo.setShiftJIS(true);
        }
        if (RecordXMLReader.getBooleanAttribute("bold", tagElement)) {
            defineFontInfo.setBold(true);
        }
        if (RecordXMLReader.getBooleanAttribute("italic", tagElement)) {
            defineFontInfo.setItalic(true);
        }
        if (RecordXMLReader.getBooleanAttribute("smalltext", tagElement)) {
            defineFontInfo.setSmallText(true);
        }
        return defineFontInfo;
    }

    private static Tag readDefineFontInfo2(Element tagElement) {
        int fontId = RecordXMLReader.getIntAttribute("fontid", tagElement);
        String fontName = TagXMLReader.getStringAttribute("fontname", tagElement);
        List charElements = tagElement.elements();
        int arrayLength = charElements.size();
        char[] codeTable = new char[arrayLength];
        int i = 0;
        while (i < arrayLength) {
            Element charElement = (Element)charElements.get(i);
            codeTable[i] = charElement.getText().charAt(0);
            ++i;
        }
        DefineFontInfo2 defineFontInfo2 = new DefineFontInfo2(fontId, fontName, codeTable, TagXMLReader.readLangCode(tagElement));
        if (RecordXMLReader.getBooleanAttribute("bold", tagElement)) {
            defineFontInfo2.setBold(true);
        }
        if (RecordXMLReader.getBooleanAttribute("italic", tagElement)) {
            defineFontInfo2.setItalic(true);
        }
        if (RecordXMLReader.getBooleanAttribute("smalltext", tagElement)) {
            defineFontInfo2.setSmallText(true);
        }
        return defineFontInfo2;
    }

    private static Tag readDefineFontAlignment(Element tagElement) {
        byte thickness = -1;
        int fontId = RecordXMLReader.getIntAttribute("fontid", tagElement);
        String thicknessString = RecordXMLReader.getStringAttribute("thickness", tagElement);
        if (thicknessString.equals("thin")) {
            thickness = 0;
        } else if (thicknessString.equals("medium")) {
            thickness = 1;
        } else if (thicknessString.equals("thick")) {
            thickness = 2;
        }
        AlignmentZone[] alignmentZones = RecordXMLReader.readAlignmentZones(tagElement);
        DefineFontAlignment defineFontAlignment = new DefineFontAlignment(fontId, thickness, alignmentZones);
        return defineFontAlignment;
    }

    private static Tag readDefineMorphShape(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        Element startElement = RecordXMLReader.getElement("start", tagElement);
        Rect startBounds = RecordXMLReader.readRect(RecordXMLReader.getElement("bounds", startElement));
        Element endElement = RecordXMLReader.getElement("end", tagElement);
        Rect endBounds = RecordXMLReader.readRect(RecordXMLReader.getElement("bounds", endElement));
        Element startShapeElement = startElement.element("shape");
        Element endShapeElement = endElement.element("shape");
        Shape startShape = null;
        Shape endShape = null;
        MorphLineStyles morphLineStyles = null;
        MorphFillStyles morphFillStyles = null;
        if (startShapeElement != null && endShapeElement != null) {
            startShape = RecordXMLReader.readShape(startShapeElement);
            endShape = RecordXMLReader.readShape(RecordXMLReader.getElement("shape", endElement));
            morphLineStyles = RecordXMLReader.readMorphLineStyles(tagElement);
            morphFillStyles = RecordXMLReader.readMorphFillStyles(tagElement);
        }
        return new DefineMorphShape(characterId, startBounds, endBounds, morphFillStyles, morphLineStyles, startShape, endShape);
    }

    private static Tag readDefineMorphShape2(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        Element startElement = RecordXMLReader.getElement("start", tagElement);
        Rect startShapeBounds = RecordXMLReader.readRect(RecordXMLReader.getElement("shapebounds", startElement));
        Rect startEdgeBounds = RecordXMLReader.readRect(RecordXMLReader.getElement("edgebounds", startElement));
        Element endElement = RecordXMLReader.getElement("end", tagElement);
        Rect endShapeBounds = RecordXMLReader.readRect(RecordXMLReader.getElement("shapebounds", endElement));
        Rect endEdgeBounds = RecordXMLReader.readRect(RecordXMLReader.getElement("edgebounds", endElement));
        Element startShapeElement = startElement.element("shape");
        Element endShapeElement = endElement.element("shape");
        Shape startShape = null;
        Shape endShape = null;
        MorphLineStyles morphLineStyles = null;
        MorphFillStyles morphFillStyles = null;
        if (startShapeElement != null && endShapeElement != null) {
            startShape = RecordXMLReader.readShape(startShapeElement);
            endShape = RecordXMLReader.readShape(RecordXMLReader.getElement("shape", endElement));
            morphLineStyles = RecordXMLReader.readMorphLineStyles(tagElement);
            morphFillStyles = RecordXMLReader.readMorphFillStyles(tagElement);
        }
        return new DefineMorphShape2(characterId, startShapeBounds, endShapeBounds, startEdgeBounds, endEdgeBounds, morphFillStyles, morphLineStyles, startShape, endShape);
    }

    private static Tag readDefineShape(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        Rect shapeBounds = RecordXMLReader.readRect(RecordXMLReader.getElement("bounds", tagElement));
        ShapeWithStyle shapes = RecordXMLReader.readShapeWithStyle(tagElement);
        return new DefineShape(characterId, shapeBounds, shapes);
    }

    private static Tag readDefineShape2(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        Rect shapeBounds = RecordXMLReader.readRect(RecordXMLReader.getElement("bounds", tagElement));
        ShapeWithStyle shapes = RecordXMLReader.readShapeWithStyle(tagElement);
        return new DefineShape2(characterId, shapeBounds, shapes);
    }

    private static Tag readDefineShape3(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        Rect shapeBounds = RecordXMLReader.readRect(RecordXMLReader.getElement("bounds", tagElement));
        ShapeWithStyle shapes = RecordXMLReader.readShapeWithStyle(tagElement);
        return new DefineShape3(characterId, shapeBounds, shapes);
    }

    private static Tag readDefineShape4(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        Rect shapeBounds = RecordXMLReader.readRect(RecordXMLReader.getElement("shapebounds", tagElement));
        Rect edgeBounds = RecordXMLReader.readRect(RecordXMLReader.getElement("edgebounds", tagElement));
        ShapeWithStyle shapes = RecordXMLReader.readShapeWithStyle(tagElement);
        return new DefineShape4(characterId, shapeBounds, edgeBounds, shapes);
    }

    private static Tag readDefineSound(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        byte format = TagXMLReader.getSoundFormat(TagXMLReader.getStringAttribute("format", tagElement));
        byte rate = TagXMLReader.getSoundRate(TagXMLReader.getStringAttribute("rate", tagElement));
        boolean is16BitSample = RecordXMLReader.getBooleanAttribute("sample16bit", tagElement);
        boolean isStereo = RecordXMLReader.getBooleanAttribute("stereo", tagElement);
        long sampleCount = RecordXMLReader.getLongAttribute("samplecount", tagElement);
        byte[] soundData = Base64.decode(tagElement.getText());
        return new DefineSound(characterId, format, rate, is16BitSample, isStereo, sampleCount, soundData);
    }

    private static Tag readDefineSprite(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        List controlTagElements = tagElement.elements();
        DefineSprite defineSprite = new DefineSprite(characterId);
        for (Element controlTagElement : controlTagElements) {
            Tag tag;
            String tagName = controlTagElement.getName();
            if (tagName.equals("showframe")) {
                tag = TagXMLReader.readShowFrame(controlTagElement);
            } else if (tagName.equals("placeobject")) {
                tag = TagXMLReader.readPlaceObject(controlTagElement);
            } else if (tagName.equals("placeobject2")) {
                tag = TagXMLReader.readPlaceObject2(controlTagElement);
            } else if (tagName.equals("placeobject3")) {
                tag = TagXMLReader.readPlaceObject3(controlTagElement);
            } else if (tagName.equals("removeobject")) {
                tag = TagXMLReader.readRemoveObject(controlTagElement);
            } else if (tagName.equals("removeobject2")) {
                tag = TagXMLReader.readRemoveObject2(controlTagElement);
            } else if (tagName.equals("startsound")) {
                tag = TagXMLReader.readStartSound(controlTagElement);
            } else if (tagName.equals("framelabel")) {
                tag = TagXMLReader.readFrameLabel(controlTagElement);
            } else if (tagName.equals("soundstreamhead")) {
                tag = TagXMLReader.readSoundStreamHead(controlTagElement);
            } else if (tagName.equals("soundstreamhead2")) {
                tag = TagXMLReader.readSoundStreamHead2(controlTagElement);
            } else if (tagName.equals("soundstreamblock")) {
                tag = TagXMLReader.readSoundStreamBlock(controlTagElement);
            } else if (tagName.equals("doaction")) {
                tag = TagXMLReader.readDoAction(controlTagElement);
            } else if (tagName.equals("doinitaction")) {
                tag = TagXMLReader.readDoInitAction(controlTagElement);
            } else if (tagName.equals("settabindex")) {
                tag = TagXMLReader.readSetTabIndex(controlTagElement);
            } else if (tagName.equals("videoframe")) {
                tag = TagXMLReader.readVideoFrame(controlTagElement);
            } else if (tagName.equals("unknowntag")) {
                tag = TagXMLReader.readUnknownTag(controlTagElement);
            } else if (tagName.equals("malformedtag")) {
                tag = TagXMLReader.readMalformedTag(controlTagElement);
            } else {
                throw new IllegalArgumentException(tagName + " tag not expected within definesprite!");
            }
            defineSprite.addControlTag(tag);
        }
        return defineSprite;
    }

    private static Tag readDefineText(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        Rect textBounds = RecordXMLReader.readRect(RecordXMLReader.getElement("bounds", tagElement));
        Matrix textMatrix = RecordXMLReader.readMatrix("matrix", tagElement);
        TextRecord[] textRecords = RecordXMLReader.readTextRecords(tagElement);
        return new DefineText(characterId, textBounds, textMatrix, textRecords);
    }

    private static Tag readDefineText2(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        Rect textBounds = RecordXMLReader.readRect(RecordXMLReader.getElement("bounds", tagElement));
        Matrix textMatrix = RecordXMLReader.readMatrix("matrix", tagElement);
        TextRecord[] textRecords = RecordXMLReader.readTextRecords(tagElement);
        return new DefineText2(characterId, textBounds, textMatrix, textRecords);
    }

    private static Tag readDefineVideoStream(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        int numFrames = RecordXMLReader.getIntAttribute("numframes", tagElement);
        int width = RecordXMLReader.getIntAttribute("width", tagElement);
        int height = RecordXMLReader.getIntAttribute("height", tagElement);
        byte deblocking = TagXMLReader.getVideoDeblocking(TagXMLReader.getStringAttribute("deblocking", tagElement));
        boolean smoothing = RecordXMLReader.getBooleanAttribute("smoothing", tagElement);
        short codecId = TagXMLReader.getVideoCodecId(TagXMLReader.getStringAttribute("codec", tagElement));
        return new DefineVideoStream(characterId, numFrames, width, height, deblocking, smoothing, codecId);
    }

    private static Tag readDoAction(Element tagElement) {
        DoAction doAction = new DoAction();
        RecordXMLReader.readActionBlock(doAction.getActions(), tagElement);
        return doAction;
    }

    private static Tag readDoInitAction(Element tagElement) {
        int spriteId = RecordXMLReader.getIntAttribute("spriteid", tagElement);
        DoInitAction doInitAction = new DoInitAction(spriteId);
        RecordXMLReader.readActionBlock(doInitAction.getInitActions(), tagElement);
        return doInitAction;
    }

    private static Tag readEnableDebugger(Element tagElement) {
        Attribute password = tagElement.attribute("password");
        return new EnableDebugger(password == null ? null : password.getValue());
    }

    private static Tag readEnableDebugger2(Element tagElement) {
        Attribute password = tagElement.attribute("password");
        return new EnableDebugger2(password == null ? null : password.getValue());
    }

    private static Tag readExportAssets(Element tagElement) {
        List mappingElements = tagElement.elements();
        int arrayLength = mappingElements.size();
        ExportAssets.ExportMapping[] mappings = new ExportAssets.ExportMapping[arrayLength];
        int i = 0;
        while (i < arrayLength) {
            Element mappingElement = (Element)mappingElements.get(i);
            mappings[i] = new ExportAssets.ExportMapping(RecordXMLReader.getIntAttribute("charid", mappingElement), TagXMLReader.getStringAttribute("name", mappingElement));
            ++i;
        }
        return new ExportAssets(mappings);
    }

    private static Tag readFlashTypeSettings(Element tagElement) {
        FlashTypeSettings flashTypeSettings = new FlashTypeSettings(RecordXMLReader.getIntAttribute("textid", tagElement), RecordXMLReader.getBooleanAttribute("flashtype", tagElement));
        String gridFit = RecordXMLReader.getStringAttribute("gridfit", tagElement);
        if (gridFit.equals("none")) {
            flashTypeSettings.setGridFit((byte)0);
        } else if (gridFit.equals("pixel")) {
            flashTypeSettings.setGridFit((byte)1);
        } else if (gridFit.equals("subpixel")) {
            flashTypeSettings.setGridFit((byte)2);
        }
        flashTypeSettings.setThickness(RecordXMLReader.getFloatAttribute("thickness", tagElement));
        flashTypeSettings.setSharpness(RecordXMLReader.getFloatAttribute("sharpness", tagElement));
        return flashTypeSettings;
    }

    private static Tag readFrameLabel(Element tagElement) {
        return new FrameLabel(TagXMLReader.getStringAttribute("name", tagElement), RecordXMLReader.getBooleanAttribute("namedanchor", tagElement));
    }

    private static Tag readFreeCharacter(Element tagElement) {
        return new FreeCharacter(RecordXMLReader.getCharacterId(tagElement));
    }

    private static Tag readImportAssets(Element tagElement) {
        List mappingElements = tagElement.elements();
        String url = TagXMLReader.getStringAttribute("url", tagElement);
        int arrayLength = mappingElements.size();
        ImportAssets.ImportMapping[] mappings = new ImportAssets.ImportMapping[arrayLength];
        int i = 0;
        while (i < arrayLength) {
            Element mappingElement = (Element)mappingElements.get(i);
            mappings[i] = new ImportAssets.ImportMapping(TagXMLReader.getStringAttribute("name", mappingElement), RecordXMLReader.getIntAttribute("charid", mappingElement));
            ++i;
        }
        return new ImportAssets(url, mappings);
    }

    private static Tag readImportAssets2(Element tagElement) {
        List mappingElements = tagElement.elements();
        String url = TagXMLReader.getStringAttribute("url", tagElement);
        int arrayLength = mappingElements.size();
        ImportAssets.ImportMapping[] mappings = new ImportAssets.ImportMapping[arrayLength];
        int i = 0;
        while (i < arrayLength) {
            Element mappingElement = (Element)mappingElements.get(i);
            mappings[i] = new ImportAssets.ImportMapping(TagXMLReader.getStringAttribute("name", mappingElement), RecordXMLReader.getIntAttribute("charid", mappingElement));
            ++i;
        }
        return new ImportAssets2(url, mappings);
    }

    private static Tag readJPEGTables(Element tagElement) {
        Element jpegDataElement = RecordXMLReader.getElement("jpegdata", tagElement);
        byte[] jpegData = Base64.decode(jpegDataElement.getText());
        return new JPEGTables(jpegData);
    }

    private static LangCode readLangCode(Element parentElement) {
        LangCode langCode;
        String language = TagXMLReader.getStringAttribute("language", parentElement);
        if (language.equals("latin")) {
            langCode = new LangCode(1);
        } else if (language.equals("undefined")) {
            langCode = new LangCode(0);
        } else if (language.equals("japanese")) {
            langCode = new LangCode(2);
        } else if (language.equals("korean")) {
            langCode = new LangCode(3);
        } else if (language.equals("simpchinese")) {
            langCode = new LangCode(4);
        } else if (language.equals("tradchinese")) {
            langCode = new LangCode(5);
        } else {
            throw new IllegalArgumentException("Illegal language: " + language);
        }
        return langCode;
    }

    private static Tag readMalformedTag(Element tagElement) {
        throw new IllegalArgumentException("'malformedtag' element encountered! Your source SWF is probably corrupted.");
    }

    private static Tag readMetadata(Element tagElement) {
        return new Metadata(tagElement.getText());
    }

    private static Tag readPlaceObject(Element tagElement) {
        int characterId = RecordXMLReader.getCharacterId(tagElement);
        int depth = RecordXMLReader.getIntAttribute("depth", tagElement);
        Matrix matrix = RecordXMLReader.readMatrix(RecordXMLReader.getElement("matrix", tagElement));
        Element colorTransFormElement = tagElement.element("cxform");
        CXform colorTransform = null;
        if (colorTransFormElement != null) {
            colorTransform = RecordXMLReader.readCXform(colorTransFormElement);
        }
        return new PlaceObject(characterId, depth, matrix, colorTransform);
    }

    private static Tag readPlaceObject2(Element tagElement) {
        Element clipActions;
        Attribute clipDepth;
        Attribute ratio;
        Element colorTransform;
        Element matrix;
        Attribute name;
        int depth = RecordXMLReader.getIntAttribute("depth", tagElement);
        PlaceObject2 placeObject2 = new PlaceObject2(depth);
        Attribute characterId = tagElement.attribute("charid");
        if (characterId != null) {
            placeObject2.setCharacterId(Integer.parseInt(characterId.getValue()));
        }
        if ((name = tagElement.attribute("name")) != null) {
            placeObject2.setName(name.getValue());
        }
        if (RecordXMLReader.getBooleanAttribute("move", tagElement)) {
            placeObject2.setMove();
        }
        if ((matrix = tagElement.element("matrix")) != null) {
            placeObject2.setMatrix(RecordXMLReader.readMatrix(matrix));
        }
        if ((colorTransform = tagElement.element("cxformwithalpha")) != null) {
            placeObject2.setColorTransform(RecordXMLReader.readCXformWithAlpha(colorTransform));
        }
        if ((ratio = tagElement.attribute("ratio")) != null) {
            placeObject2.setRatio(Integer.parseInt(ratio.getValue()));
        }
        if ((clipDepth = tagElement.attribute("clipdepth")) != null) {
            placeObject2.setClipDepth(Integer.parseInt(clipDepth.getValue()));
        }
        if ((clipActions = tagElement.element("clipactions")) != null) {
            placeObject2.setClipActions(RecordXMLReader.readClipActions(clipActions));
        }
        return placeObject2;
    }

    private static Tag readPlaceObject3(Element tagElement) {
        Attribute blendMode;
        Element clipActions;
        Attribute clipDepth;
        Attribute ratio;
        Element colorTransform;
        Element matrix;
        Attribute name;
        int depth = RecordXMLReader.getIntAttribute("depth", tagElement);
        PlaceObject3 placeObject3 = new PlaceObject3(depth);
        Attribute characterId = tagElement.attribute("charid");
        if (characterId != null) {
            placeObject3.setCharacterId(Integer.parseInt(characterId.getValue()));
        }
        if ((name = tagElement.attribute("name")) != null) {
            placeObject3.setName(name.getValue());
        }
        if (RecordXMLReader.getBooleanAttribute("move", tagElement)) {
            placeObject3.setMove();
        }
        if ((matrix = tagElement.element("matrix")) != null) {
            placeObject3.setMatrix(RecordXMLReader.readMatrix(matrix));
        }
        if ((colorTransform = tagElement.element("cxformwithalpha")) != null) {
            placeObject3.setColorTransform(RecordXMLReader.readCXformWithAlpha(colorTransform));
        }
        if ((ratio = tagElement.attribute("ratio")) != null) {
            placeObject3.setRatio(Integer.parseInt(ratio.getValue()));
        }
        if ((clipDepth = tagElement.attribute("clipdepth")) != null) {
            placeObject3.setClipDepth(Integer.parseInt(clipDepth.getValue()));
        }
        if ((clipActions = tagElement.element("clipactions")) != null) {
            placeObject3.setClipActions(RecordXMLReader.readClipActions(clipActions));
        }
        if ((blendMode = tagElement.attribute("blendmode")) != null) {
            placeObject3.setBlendMode(BlendMode.getFromDescription(blendMode.getValue()));
        }
        placeObject3.setCacheAsBitmap(RecordXMLReader.getBooleanAttribute("cacheasbitmap", tagElement));
        Element filters = tagElement.element("filters");
        if (filters != null) {
            placeObject3.setFilters(RecordXMLReader.readFilters(filters));
        }
        return placeObject3;
    }

    private static Tag readProtect(Element tagElement) {
        Attribute password = tagElement.attribute("password");
        return new Protect(password == null ? null : password.getValue());
    }

    private static Tag readRemoveObject(Element tagElement) {
        return new RemoveObject(RecordXMLReader.getCharacterId(tagElement), RecordXMLReader.getIntAttribute("depth", tagElement));
    }

    private static Tag readRemoveObject2(Element tagElement) {
        return new RemoveObject2(RecordXMLReader.getIntAttribute("depth", tagElement));
    }

    private static Tag readScale9Grid(Element tagElement) {
        int characterId = RecordXMLReader.getIntAttribute("charid", tagElement);
        Rect grid = RecordXMLReader.readRect(RecordXMLReader.getElement("grid", tagElement));
        Scale9Grid scale9Grid = new Scale9Grid(characterId, grid);
        return scale9Grid;
    }

    private static Tag readScriptLimits(Element tagElement) {
        return new ScriptLimits(RecordXMLReader.getIntAttribute("maxrecursiondepth", tagElement), RecordXMLReader.getIntAttribute("scripttimeout", tagElement));
    }

    private static Tag readSetTabIndex(Element tagElement) {
        return new SetTabIndex(RecordXMLReader.getIntAttribute("depth", tagElement), RecordXMLReader.getIntAttribute("tabindex", tagElement));
    }

    private static Tag readShowFrame(Element tagElement) {
        return new ShowFrame();
    }

    private static Tag readSoundStreamBlock(Element tagElement) {
        return new SoundStreamBlock(Base64.decode(RecordXMLReader.getElement("streamsounddata", tagElement).getText()));
    }

    private static Tag readSoundStreamHead(Element tagElement) {
        byte format = TagXMLReader.getSoundFormat(TagXMLReader.getStringAttribute("streamformat", tagElement));
        byte rate = TagXMLReader.getSoundRate(TagXMLReader.getStringAttribute("streamrate", tagElement));
        boolean stereo = RecordXMLReader.getBooleanAttribute("streamstereo", tagElement);
        int sampleCount = RecordXMLReader.getIntAttribute("streamsamplecount", tagElement);
        SoundStreamHead soundStreamHead = new SoundStreamHead(format, rate, stereo, sampleCount);
        soundStreamHead.setPlaybackRate(TagXMLReader.getSoundRate(TagXMLReader.getStringAttribute("playbackrate", tagElement)));
        soundStreamHead.setPlaybackStereo(RecordXMLReader.getBooleanAttribute("playbackstereo", tagElement));
        if (soundStreamHead.getStreamFormat() == 2) {
            soundStreamHead.setLatencySeek(RecordXMLReader.getShortAttribute("latencyseek", tagElement));
        }
        return soundStreamHead;
    }

    private static Tag readSoundStreamHead2(Element tagElement) {
        byte format = TagXMLReader.getSoundFormat(TagXMLReader.getStringAttribute("streamformat", tagElement));
        byte rate = TagXMLReader.getSoundRate(TagXMLReader.getStringAttribute("streamrate", tagElement));
        boolean is16BitSample = RecordXMLReader.getBooleanAttribute("streamsample16bit", tagElement);
        boolean stereo = RecordXMLReader.getBooleanAttribute("streamstereo", tagElement);
        int sampleCount = RecordXMLReader.getIntAttribute("streamsamplecount", tagElement);
        SoundStreamHead2 soundStreamHead2 = new SoundStreamHead2(format, rate, is16BitSample, stereo, sampleCount);
        soundStreamHead2.setPlaybackRate(TagXMLReader.getSoundRate(TagXMLReader.getStringAttribute("playbackrate", tagElement)));
        soundStreamHead2.setPlayback16BitSample(RecordXMLReader.getBooleanAttribute("playbacksample16bit", tagElement));
        soundStreamHead2.setPlaybackStereo(RecordXMLReader.getBooleanAttribute("playbackstereo", tagElement));
        if (soundStreamHead2.getStreamFormat() == 2) {
            soundStreamHead2.setLatencySeek(RecordXMLReader.getShortAttribute("latencyseek", tagElement));
        }
        return soundStreamHead2;
    }

    private static Tag readStartSound(Element tagElement) {
        return new StartSound(RecordXMLReader.getIntAttribute("soundid", tagElement), RecordXMLReader.readSoundInfo(tagElement));
    }

    private static Tag readVideoFrame(Element tagElement) {
        int streamId = RecordXMLReader.getIntAttribute("streamid", tagElement);
        int frameNum = RecordXMLReader.getIntAttribute("framenum", tagElement);
        byte[] videoData = Base64.decode(tagElement.getText());
        return new VideoFrame(streamId, frameNum, videoData);
    }

    TagXMLReader() {
    }
}

