/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.xml;

import oracle.dss.graph.flash.jswiff.swfrecords.BlendMode;
import oracle.dss.graph.flash.jswiff.swfrecords.ButtonCondAction;
import oracle.dss.graph.flash.jswiff.swfrecords.ButtonRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.CXform;
import oracle.dss.graph.flash.jswiff.swfrecords.KerningRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.LangCode;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphFillStyles;
import oracle.dss.graph.flash.jswiff.swfrecords.MorphLineStyles;
import oracle.dss.graph.flash.jswiff.swfrecords.Shape;
import oracle.dss.graph.flash.jswiff.swfrecords.TextRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineBits;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineBitsJPEG2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineBitsJPEG3;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineBitsLossless;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineBitsLossless2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineButton;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineButton2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineButtonCXform;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineButtonSound;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineEditText;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineFont;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineFont2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineFont3;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineFontAlignment;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineFontInfo;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineFontInfo2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineMorphShape;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineMorphShape2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineShape;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineShape2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineShape3;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineShape4;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineSound;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineSprite;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineText;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineText2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineVideoStream;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DoAction;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DoInitAction;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.EnableDebugger;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.EnableDebugger2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ExportAssets;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.FlashTypeSettings;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.FrameLabel;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.FreeCharacter;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ImportAssets;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ImportAssets2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.JPEGTables;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.MalformedTag;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.PlaceObject;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.PlaceObject2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.PlaceObject3;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Protect;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.RemoveObject;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.RemoveObject2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Scale9Grid;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ScriptLimits;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.SetTabIndex;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ShowFrame;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.SoundStreamBlock;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.SoundStreamHead;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.SoundStreamHead2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.StartSound;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.UnknownTag;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.VideoFrame;
import oracle.dss.graph.flash.jswiff.util.Base64;
import oracle.dss.graph.flash.jswiff.util.StringUtilities;
import oracle.dss.graph.flash.jswiff.xml.RecordXMLWriter;
import org.dom4j.Element;

class TagXMLWriter {
    static void writeTag(Element parentElement, Tag tag) {
        int tagCode = tag.getCode();
        switch (tagCode) {
            case 6: {
                TagXMLWriter.writeDefineBits(parentElement, (DefineBits)tag);
                break;
            }
            case 21: {
                TagXMLWriter.writeDefineBitsJPEG2(parentElement, (DefineBitsJPEG2)tag);
                break;
            }
            case 35: {
                TagXMLWriter.writeDefineBitsJPEG3(parentElement, (DefineBitsJPEG3)tag);
                break;
            }
            case 20: {
                TagXMLWriter.writeDefineBitsLossless(parentElement, (DefineBitsLossless)tag);
                break;
            }
            case 36: {
                TagXMLWriter.writeDefineBitsLossless2(parentElement, (DefineBitsLossless2)tag);
                break;
            }
            case 7: {
                TagXMLWriter.writeDefineButton(parentElement, (DefineButton)tag);
                break;
            }
            case 34: {
                TagXMLWriter.writeDefineButton2(parentElement, (DefineButton2)tag);
                break;
            }
            case 23: {
                TagXMLWriter.writeDefineButtonCXform(parentElement, (DefineButtonCXform)tag);
                break;
            }
            case 17: {
                TagXMLWriter.writeDefineButtonSound(parentElement, (DefineButtonSound)tag);
                break;
            }
            case 37: {
                TagXMLWriter.writeDefineEditText(parentElement, (DefineEditText)tag);
                break;
            }
            case 10: {
                TagXMLWriter.writeDefineFont(parentElement, (DefineFont)tag);
                break;
            }
            case 48: {
                TagXMLWriter.writeDefineFont2(parentElement, (DefineFont2)tag);
                break;
            }
            case 75: {
                TagXMLWriter.writeDefineFont3(parentElement, (DefineFont3)tag);
                break;
            }
            case 13: {
                TagXMLWriter.writeDefineFontInfo(parentElement, (DefineFontInfo)tag);
                break;
            }
            case 62: {
                TagXMLWriter.writeDefineFontInfo2(parentElement, (DefineFontInfo2)tag);
                break;
            }
            case 73: {
                TagXMLWriter.writeDefineFontAlignment(parentElement, (DefineFontAlignment)tag);
                break;
            }
            case 74: {
                TagXMLWriter.writeFlashTypeSettings(parentElement, (FlashTypeSettings)tag);
                break;
            }
            case 46: {
                TagXMLWriter.writeDefineMorphShape(parentElement, (DefineMorphShape)tag);
                break;
            }
            case 84: {
                TagXMLWriter.writeDefineMorphShape2(parentElement, (DefineMorphShape2)tag);
                break;
            }
            case 2: {
                TagXMLWriter.writeDefineShape(parentElement, (DefineShape)tag);
                break;
            }
            case 22: {
                TagXMLWriter.writeDefineShape2(parentElement, (DefineShape2)tag);
                break;
            }
            case 32: {
                TagXMLWriter.writeDefineShape3(parentElement, (DefineShape3)tag);
                break;
            }
            case 83: {
                TagXMLWriter.writeDefineShape4(parentElement, (DefineShape4)tag);
                break;
            }
            case 14: {
                TagXMLWriter.writeDefineSound(parentElement, (DefineSound)tag);
                break;
            }
            case 39: {
                TagXMLWriter.writeDefineSprite(parentElement, (DefineSprite)tag);
                break;
            }
            case 11: {
                TagXMLWriter.writeDefineText(parentElement, (DefineText)tag);
                break;
            }
            case 33: {
                TagXMLWriter.writeDefineText2(parentElement, (DefineText2)tag);
                break;
            }
            case 60: {
                TagXMLWriter.writeDefineVideoStream(parentElement, (DefineVideoStream)tag);
                break;
            }
            case 12: {
                TagXMLWriter.writeDoAction(parentElement, (DoAction)tag);
                break;
            }
            case 59: {
                TagXMLWriter.writeDoInitAction(parentElement, (DoInitAction)tag);
                break;
            }
            case 58: {
                TagXMLWriter.writeEnableDebugger(parentElement, (EnableDebugger)tag);
                break;
            }
            case 64: {
                TagXMLWriter.writeEnableDebugger2(parentElement, (EnableDebugger2)tag);
                break;
            }
            case 56: {
                TagXMLWriter.writeExportAssets(parentElement, (ExportAssets)tag);
                break;
            }
            case 43: {
                TagXMLWriter.writeFrameLabel(parentElement, (FrameLabel)tag);
                break;
            }
            case 3: {
                TagXMLWriter.writeFreeCharacter(parentElement, (FreeCharacter)tag);
                break;
            }
            case 57: {
                TagXMLWriter.writeImportAssets(parentElement, (ImportAssets)tag);
                break;
            }
            case 71: {
                TagXMLWriter.writeImportAssets2(parentElement, (ImportAssets2)tag);
                break;
            }
            case 8: {
                TagXMLWriter.writeJPEGTables(parentElement, (JPEGTables)tag);
                break;
            }
            case -1: {
                TagXMLWriter.writeMalformedTag(parentElement, (MalformedTag)tag);
                break;
            }
            case 4: {
                TagXMLWriter.writePlaceObject(parentElement, (PlaceObject)tag);
                break;
            }
            case 26: {
                TagXMLWriter.writePlaceObject2(parentElement, (PlaceObject2)tag);
                break;
            }
            case 70: {
                TagXMLWriter.writePlaceObject3(parentElement, (PlaceObject3)tag);
                break;
            }
            case 24: {
                TagXMLWriter.writeProtect(parentElement, (Protect)tag);
                break;
            }
            case 5: {
                TagXMLWriter.writeRemoveObject(parentElement, (RemoveObject)tag);
                break;
            }
            case 28: {
                TagXMLWriter.writeRemoveObject2(parentElement, (RemoveObject2)tag);
                break;
            }
            case 65: {
                TagXMLWriter.writeScriptLimits(parentElement, (ScriptLimits)tag);
                break;
            }
            case 66: {
                TagXMLWriter.writeSetTabIndex(parentElement, (SetTabIndex)tag);
                break;
            }
            case 1: {
                TagXMLWriter.writeShowFrame(parentElement, (ShowFrame)tag);
                break;
            }
            case 78: {
                TagXMLWriter.writeScale9Grid(parentElement, (Scale9Grid)tag);
                break;
            }
            case 19: {
                TagXMLWriter.writeSoundStreamBlock(parentElement, (SoundStreamBlock)tag);
                break;
            }
            case 18: {
                TagXMLWriter.writeSoundStreamHead(parentElement, (SoundStreamHead)tag);
                break;
            }
            case 45: {
                TagXMLWriter.writeSoundStreamHead2(parentElement, (SoundStreamHead2)tag);
                break;
            }
            case 15: {
                TagXMLWriter.writeStartSound(parentElement, (StartSound)tag);
                break;
            }
            case 61: {
                TagXMLWriter.writeVideoFrame(parentElement, (VideoFrame)tag);
                break;
            }
            default: {
                TagXMLWriter.writeUnknownTag(parentElement, (UnknownTag)tag);
            }
        }
    }

    private static String getSoundFormatString(byte format) {
        switch (format) {
            case 1: {
                return "adpcm";
            }
            case 2: {
                return "mp3";
            }
            case 6: {
                return "nellymoser";
            }
            case 0: {
                return "uncompressed";
            }
            case 3: {
                return "uncompressedle";
            }
        }
        throw new IllegalArgumentException("Illegal sound format: " + format);
    }

    private static String getSoundRateString(byte rate) {
        switch (rate) {
            case 0: {
                return "5500";
            }
            case 1: {
                return "11000";
            }
            case 2: {
                return "22000";
            }
            case 3: {
                return "44000";
            }
        }
        throw new IllegalArgumentException("Illegal sound rate: " + rate);
    }

    private static void writeDefineBits(Element parentElement, DefineBits tag) {
        Element element = parentElement.addElement("definebits");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        element.addElement("jpegdata").addText(Base64.encode(tag.getJpegData()));
    }

    private static void writeDefineBitsJPEG2(Element parentElement, DefineBitsJPEG2 tag) {
        Element element = parentElement.addElement("definebitsjpeg2");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        element.addElement("jpegdata").addText(Base64.encode(tag.getJpegData()));
    }

    private static void writeDefineBitsJPEG3(Element parentElement, DefineBitsJPEG3 tag) {
        Element element = parentElement.addElement("definebitsjpeg3");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        element.addElement("jpegdata").addText(Base64.encode(tag.getJpegData()));
        element.addElement("alphadata").addText(Base64.encode(tag.getBitmapAlphaData()));
    }

    private static void writeDefineBitsLossless(Element parentElement, DefineBitsLossless tag) {
        String format;
        Element element = parentElement.addElement("definebitslossless");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        switch (tag.getFormat()) {
            case 3: {
                format = "8bit";
                break;
            }
            case 4: {
                format = "15bit";
                break;
            }
            case 5: {
                format = "24bit";
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal lossless bitmap format: " + tag.getFormat());
            }
        }
        element.addAttribute("format", format);
        element.addAttribute("width", Integer.toString(tag.getWidth()));
        element.addAttribute("height", Integer.toString(tag.getHeight()));
        RecordXMLWriter.writeZlibBitmapData(element, tag.getZlibBitmapData());
    }

    private static void writeDefineBitsLossless2(Element parentElement, DefineBitsLossless2 tag) {
        String format;
        Element element = parentElement.addElement("definebitslossless2");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        switch (tag.getFormat()) {
            case 3: {
                format = "8bit";
                break;
            }
            case 5: {
                format = "32bit";
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal lossless bitmap format: " + tag.getFormat());
            }
        }
        element.addAttribute("format", format);
        element.addAttribute("width", Integer.toString(tag.getWidth()));
        element.addAttribute("height", Integer.toString(tag.getHeight()));
        RecordXMLWriter.writeZlibBitmapData(element, tag.getZlibBitmapData());
    }

    private static void writeDefineButton(Element parentElement, DefineButton tag) {
        Element element = parentElement.addElement("definebutton");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        Element charsElement = element.addElement("chars");
        ButtonRecord[] characters = tag.getCharacters();
        int i = 0;
        while (i < characters.length) {
            RecordXMLWriter.writeButtonRecord(charsElement, characters[i]);
            ++i;
        }
        RecordXMLWriter.writeActionBlock(element, tag.getActions());
    }

    private static void writeDefineButton2(Element parentElement, DefineButton2 tag) {
        Element element = parentElement.addElement("definebutton2");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        if (tag.isTrackAsMenu()) {
            element.addAttribute("trackasmenu", "true");
        }
        Element charsElement = element.addElement("chars");
        ButtonRecord[] characters = tag.getCharacters();
        int i = 0;
        while (i < characters.length) {
            RecordXMLWriter.writeButtonRecord(charsElement, characters[i]);
            ++i;
        }
        Element actionsElement = element.addElement("actions");
        ButtonCondAction[] actions = tag.getActions();
        if (actions != null) {
            int i2 = 0;
            while (i2 < actions.length) {
                RecordXMLWriter.writeButtonCondAction(actionsElement, actions[i2]);
                ++i2;
            }
        }
    }

    private static void writeDefineButtonCXform(Element parentElement, DefineButtonCXform tag) {
        Element element = parentElement.addElement("definebuttoncxform");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        RecordXMLWriter.writeCXForm(element, tag.getColorTransform());
    }

    private static void writeDefineButtonSound(Element parentElement, DefineButtonSound tag) {
        Element element = parentElement.addElement("definebuttonsound");
        element.addAttribute("buttonid", Integer.toString(tag.getButtonId()));
        if (tag.getOverUpToIdleSoundId() != 0) {
            Element overUpToIdle = element.addElement("overuptoidle");
            overUpToIdle.addAttribute("soundid", Integer.toString(tag.getOverUpToIdleSoundId()));
            RecordXMLWriter.writeSoundInfo(overUpToIdle, tag.getOverUpToIdleSoundInfo());
        }
        if (tag.getIdleToOverUpSoundId() != 0) {
            Element idleToOverUp = element.addElement("idletooverup");
            idleToOverUp.addAttribute("soundid", Integer.toString(tag.getIdleToOverUpSoundId()));
            RecordXMLWriter.writeSoundInfo(idleToOverUp, tag.getIdleToOverUpSoundInfo());
        }
        if (tag.getOverUpToOverDownSoundId() != 0) {
            Element overUpToOverDown = element.addElement("overuptooverdown");
            overUpToOverDown.addAttribute("soundid", Integer.toString(tag.getOverUpToOverDownSoundId()));
            RecordXMLWriter.writeSoundInfo(overUpToOverDown, tag.getOverUpToOverDownSoundInfo());
        }
        if (tag.getOverDownToOverUpSoundId() != 0) {
            Element overDownToOverUp = element.addElement("overdowntooverup");
            overDownToOverUp.addAttribute("soundid", Integer.toString(tag.getOverDownToOverUpSoundId()));
            RecordXMLWriter.writeSoundInfo(overDownToOverUp, tag.getOverDownToOverUpSoundInfo());
        }
    }

    private static void writeDefineEditText(Element parentElement, DefineEditText tag) {
        String var;
        Element element = parentElement.addElement("defineedittext");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        if (tag.isWordWrap()) {
            element.addAttribute("wordwrap", "true");
        }
        if (tag.isMultiline()) {
            element.addAttribute("multiline", "true");
        }
        if (tag.isPassword()) {
            element.addAttribute("password", "true");
        }
        if (tag.isReadOnly()) {
            element.addAttribute("readonly", "true");
        }
        if (tag.isAutoSize()) {
            element.addAttribute("autosize", "true");
        }
        if (tag.isNoSelect()) {
            element.addAttribute("noselect", "true");
        }
        if (tag.isBorder()) {
            element.addAttribute("border", "true");
        }
        if (tag.isHtml()) {
            element.addAttribute("html", "true");
        }
        if (tag.isUseOutlines()) {
            element.addAttribute("useoutlines", "true");
        }
        if (tag.hasMaxLength()) {
            element.addAttribute("maxlength", Integer.toString(tag.getMaxLength()));
        }
        if ((var = tag.getVariableName()) != null && var.length() > 0) {
            element.addAttribute("variable", var);
        }
        RecordXMLWriter.writeRect(element, "bounds", tag.getBounds());
        if (tag.hasText()) {
            element.addElement("initialtext").addText(tag.getInitialText());
        }
        if (tag.hasTextColor()) {
            RecordXMLWriter.writeRGBA(element, "color", tag.getTextColor());
        }
        if (tag.hasFont()) {
            Element font = element.addElement("font");
            font.addAttribute("fontid", Integer.toString(tag.getFontId()));
            font.addAttribute("height", Integer.toString(tag.getFontHeight()));
        }
        if (tag.hasLayout()) {
            String align;
            Element layout = element.addElement("layout");
            switch (tag.getAlign()) {
                case 0: {
                    align = "left";
                    break;
                }
                case 2: {
                    align = "center";
                    break;
                }
                case 3: {
                    align = "justify";
                    break;
                }
                case 1: {
                    align = "right";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal text alignment: " + tag.getAlign());
                }
            }
            layout.addAttribute("align", align);
            layout.addAttribute("leftmargin", Integer.toString(tag.getLeftMargin()));
            layout.addAttribute("rightmargin", Integer.toString(tag.getRightMargin()));
            layout.addAttribute("indent", Integer.toString(tag.getIndent()));
            layout.addAttribute("leading", Integer.toString(tag.getLeading()));
        }
    }

    private static void writeDefineFont(Element parentElement, DefineFont tag) {
        Element element = parentElement.addElement("definefont");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        Element glyphShapeTableElement = element.addElement("glyphshapetable");
        Shape[] glyphShapeTable = tag.getGlyphShapeTable();
        int i = 0;
        while (i < glyphShapeTable.length) {
            RecordXMLWriter.writeShape(glyphShapeTableElement, glyphShapeTable[i]);
            ++i;
        }
    }

    private static void writeDefineFont2(Element parentElement, DefineFont2 tag) {
        Element element = parentElement.addElement("definefont2");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        element.addAttribute("fontname", tag.getFontName());
        if (tag.isANSI()) {
            element.addAttribute("ansi", "true");
        } else if (tag.isShiftJIS()) {
            element.addAttribute("shiftjis", "true");
        }
        if (tag.isBold()) {
            element.addAttribute("bold", "true");
        }
        if (tag.isItalic()) {
            element.addAttribute("italic", "true");
        }
        if (tag.isSmallText()) {
            element.addAttribute("smalltext", "true");
        }
        TagXMLWriter.writeLanguage(element, tag.getLanguageCode());
        Shape[] table = tag.getGlyphShapeTable();
        if (table != null) {
            Element glyphShapeTableElement = element.addElement("glyphshapetable");
            char[] codeTable = tag.getCodeTable();
            int i = 0;
            while (i < table.length) {
                Element glyphElement = glyphShapeTableElement.addElement("glyph");
                glyphElement.addAttribute("char", Character.toString(codeTable[i]));
                RecordXMLWriter.writeShape(glyphElement, table[i]);
                if (tag.hasLayout()) {
                    glyphElement.addAttribute("advance", Short.toString(tag.getAdvanceTable()[i]));
                    RecordXMLWriter.writeRect(glyphElement, "bounds", tag.getBoundsTable()[i]);
                }
                ++i;
            }
        }
        if (tag.hasLayout()) {
            Element layout = element.addElement("layout");
            layout.addAttribute("ascent", Integer.toString(tag.getAscent()));
            layout.addAttribute("descent", Integer.toString(tag.getDescent()));
            layout.addAttribute("leading", Integer.toString(tag.getLeading()));
            KerningRecord[] kerningTable = tag.getKerningTable();
            if (kerningTable != null && kerningTable.length > 0) {
                Element kerningTableElement = layout.addElement("kerningtable");
                int i = 0;
                while (i < kerningTable.length) {
                    KerningRecord record = kerningTable[i];
                    Element recordElement = kerningTableElement.addElement("kerningrecord");
                    recordElement.addAttribute("left", Character.toString(record.getLeft()));
                    recordElement.addAttribute("right", Character.toString(record.getRight()));
                    recordElement.addAttribute("adjust", Short.toString(record.getAdjustment()));
                    ++i;
                }
            }
        }
    }

    private static void writeDefineFont3(Element parentElement, DefineFont3 tag) {
        Element element = parentElement.addElement("definefont3");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        element.addAttribute("fontname", tag.getFontName());
        if (tag.isBold()) {
            element.addAttribute("bold", "true");
        }
        if (tag.isItalic()) {
            element.addAttribute("italic", "true");
        }
        if (tag.isSmallText()) {
            element.addAttribute("smalltext", "true");
        }
        TagXMLWriter.writeLanguage(element, tag.getLanguageCode());
        Shape[] table = tag.getGlyphShapeTable();
        if (table != null) {
            Element glyphShapeTableElement = element.addElement("glyphshapetable");
            char[] codeTable = tag.getCodeTable();
            int i = 0;
            while (i < table.length) {
                Element glyphElement = glyphShapeTableElement.addElement("glyph");
                glyphElement.addAttribute("char", Character.toString(codeTable[i]));
                RecordXMLWriter.writeShape(glyphElement, table[i]);
                if (tag.hasLayout()) {
                    glyphElement.addAttribute("advance", Short.toString(tag.getAdvanceTable()[i]));
                    RecordXMLWriter.writeRect(glyphElement, "bounds", tag.getBoundsTable()[i]);
                }
                ++i;
            }
        }
        if (tag.hasLayout()) {
            Element layout = element.addElement("layout");
            layout.addAttribute("ascent", Integer.toString(tag.getAscent()));
            layout.addAttribute("descent", Integer.toString(tag.getDescent()));
            layout.addAttribute("leading", Integer.toString(tag.getLeading()));
            KerningRecord[] kerningTable = tag.getKerningTable();
            if (kerningTable != null && kerningTable.length > 0) {
                Element kerningTableElement = layout.addElement("kerningtable");
                int i = 0;
                while (i < kerningTable.length) {
                    KerningRecord record = kerningTable[i];
                    Element recordElement = kerningTableElement.addElement("kerningrecord");
                    recordElement.addAttribute("left", Character.toString(record.getLeft()));
                    recordElement.addAttribute("right", Character.toString(record.getRight()));
                    recordElement.addAttribute("adjust", Short.toString(record.getAdjustment()));
                    ++i;
                }
            }
        }
    }

    private static void writeDefineFontAlignment(Element parentElement, DefineFontAlignment tag) {
        Element element = parentElement.addElement("definefontalignment");
        element.addAttribute("fontid", Integer.toString(tag.getFontId()));
        switch (tag.getThickness()) {
            case 0: {
                element.addAttribute("thickness", "thin");
                break;
            }
            case 1: {
                element.addAttribute("thickness", "medium");
                break;
            }
            case 2: {
                element.addAttribute("thickness", "thick");
                break;
            }
        }
        RecordXMLWriter.writeAlignmentZones(element, tag.getAlignmentZones());
    }

    private static void writeDefineFontInfo(Element parentElement, DefineFontInfo tag) {
        Element element = parentElement.addElement("definefontinfo");
        element.addAttribute("fontid", Integer.toString(tag.getFontId()));
        element.addAttribute("fontname", tag.getFontName());
        if (tag.isANSI()) {
            element.addAttribute("ansi", "true");
        } else if (tag.isShiftJIS()) {
            element.addAttribute("shiftjis", "true");
        }
        if (tag.isBold()) {
            element.addAttribute("bold", "true");
        }
        if (tag.isItalic()) {
            element.addAttribute("italic", "true");
        }
        if (tag.isSmallText()) {
            element.addAttribute("smalltext", "true");
        }
        char[] codeTable = tag.getCodeTable();
        int i = 0;
        while (i < codeTable.length) {
            element.addElement("char").addText(Character.toString(codeTable[i]));
            ++i;
        }
    }

    private static void writeDefineFontInfo2(Element parentElement, DefineFontInfo2 tag) {
        Element element = parentElement.addElement("definefontinfo2");
        element.addAttribute("fontid", Integer.toString(tag.getFontId()));
        element.addAttribute("fontname", tag.getFontName());
        if (tag.isBold()) {
            element.addAttribute("bold", "true");
        }
        if (tag.isItalic()) {
            element.addAttribute("italic", "true");
        }
        if (tag.isSmallText()) {
            element.addAttribute("smalltext", "true");
        }
        TagXMLWriter.writeLanguage(element, tag.getLangCode());
        char[] codeTable = tag.getCodeTable();
        int i = 0;
        while (i < codeTable.length) {
            element.addElement("char").addText(Character.toString(codeTable[i]));
            ++i;
        }
    }

    private static void writeDefineMorphShape(Element parentElement, DefineMorphShape tag) {
        Element element = parentElement.addElement("definemorphshape");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        Shape startShape = tag.getStartShape();
        Shape endShape = tag.getEndShape();
        MorphLineStyles morphLineStyles = tag.getMorphLineStyles();
        MorphFillStyles morphFillStyles = tag.getMorphFillStyles();
        boolean zeroOffset = startShape == null || endShape == null || morphLineStyles == null || morphFillStyles == null;
        Element startElement = element.addElement("start");
        RecordXMLWriter.writeRect(startElement, "bounds", tag.getStartBounds());
        Element endElement = element.addElement("end");
        RecordXMLWriter.writeRect(endElement, "bounds", tag.getEndBounds());
        if (!zeroOffset) {
            RecordXMLWriter.writeShape(startElement, startShape);
            RecordXMLWriter.writeShape(endElement, endShape);
            RecordXMLWriter.writeMorphLineStyles(element, morphLineStyles);
            RecordXMLWriter.writeMorphFillStyles(element, morphFillStyles);
        }
    }

    private static void writeDefineMorphShape2(Element parentElement, DefineMorphShape2 tag) {
        Element element = parentElement.addElement("definemorphshape2");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        Shape startShape = tag.getStartShape();
        Shape endShape = tag.getEndShape();
        MorphLineStyles morphLineStyles = tag.getMorphLineStyles();
        MorphFillStyles morphFillStyles = tag.getMorphFillStyles();
        boolean zeroOffset = startShape == null || endShape == null || morphLineStyles == null || morphFillStyles == null;
        Element startElement = element.addElement("start");
        RecordXMLWriter.writeRect(startElement, "shapebounds", tag.getStartShapeBounds());
        RecordXMLWriter.writeRect(startElement, "edgebounds", tag.getStartEdgeBounds());
        Element endElement = element.addElement("end");
        RecordXMLWriter.writeRect(endElement, "shapebounds", tag.getEndShapeBounds());
        RecordXMLWriter.writeRect(endElement, "edgebounds", tag.getEndEdgeBounds());
        if (!zeroOffset) {
            RecordXMLWriter.writeShape(startElement, startShape);
            RecordXMLWriter.writeShape(endElement, endShape);
            RecordXMLWriter.writeMorphLineStyles(element, morphLineStyles);
            RecordXMLWriter.writeMorphFillStyles(element, morphFillStyles);
        }
    }

    private static void writeDefineShape(Element parentElement, DefineShape tag) {
        Element element = parentElement.addElement("defineshape");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        RecordXMLWriter.writeRect(element, "bounds", tag.getShapeBounds());
        RecordXMLWriter.writeShapeWithStyle(element, tag.getShapes());
    }

    private static void writeDefineShape2(Element parentElement, DefineShape2 tag) {
        Element element = parentElement.addElement("defineshape2");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        RecordXMLWriter.writeRect(element, "bounds", tag.getShapeBounds());
        RecordXMLWriter.writeShapeWithStyle(element, tag.getShapes());
    }

    private static void writeDefineShape3(Element parentElement, DefineShape3 tag) {
        Element element = parentElement.addElement("defineshape3");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        RecordXMLWriter.writeRect(element, "bounds", tag.getShapeBounds());
        RecordXMLWriter.writeShapeWithStyle(element, tag.getShapes());
    }

    private static void writeDefineShape4(Element parentElement, DefineShape4 tag) {
        Element element = parentElement.addElement("defineshape4");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        RecordXMLWriter.writeRect(element, "shapebounds", tag.getShapeBounds());
        RecordXMLWriter.writeRect(element, "edgebounds", tag.getEdgeBounds());
        RecordXMLWriter.writeShapeWithStyle(element, tag.getShapes());
    }

    private static void writeDefineSound(Element parentElement, DefineSound tag) {
        Element element = parentElement.addElement("definesound");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        element.addAttribute("format", TagXMLWriter.getSoundFormatString(tag.getFormat()));
        element.addAttribute("rate", TagXMLWriter.getSoundRateString(tag.getRate()));
        if (tag.is16BitSample()) {
            element.addAttribute("sample16bit", "true");
        }
        if (tag.isStereo()) {
            element.addAttribute("stereo", "true");
        }
        element.addAttribute("samplecount", Long.toString(tag.getSampleCount()));
        element.addText(Base64.encode(tag.getSoundData()));
    }

    private static void writeDefineSprite(Element parentElement, DefineSprite tag) {
        Element element = parentElement.addElement("definesprite");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        for (Tag controlTag : tag.getControlTags()) {
            TagXMLWriter.writeTag(element, controlTag);
        }
    }

    private static void writeDefineText(Element parentElement, DefineText tag) {
        Element element = parentElement.addElement("definetext");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        RecordXMLWriter.writeRect(element, "bounds", tag.getTextBounds());
        RecordXMLWriter.writeMatrix(element, "matrix", tag.getTextMatrix());
        Element textRecordsElement = element.addElement("textrecords");
        TextRecord[] textRecords = tag.getTextRecords();
        int i = 0;
        while (i < textRecords.length) {
            RecordXMLWriter.writeTextRecord(textRecordsElement, textRecords[i]);
            ++i;
        }
    }

    private static void writeDefineText2(Element parentElement, DefineText2 tag) {
        Element element = parentElement.addElement("definetext2");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        RecordXMLWriter.writeRect(element, "bounds", tag.getTextBounds());
        RecordXMLWriter.writeMatrix(element, "matrix", tag.getTextMatrix());
        Element textRecordsElement = element.addElement("textrecords");
        TextRecord[] textRecords = tag.getTextRecords();
        int i = 0;
        while (i < textRecords.length) {
            RecordXMLWriter.writeTextRecord(textRecordsElement, textRecords[i]);
            ++i;
        }
    }

    private static void writeDefineVideoStream(Element parentElement, DefineVideoStream tag) {
        Element element = parentElement.addElement("definevideostream");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        element.addAttribute("numframes", Integer.toString(tag.getNumFrames()));
        element.addAttribute("width", Integer.toString(tag.getWidth()));
        element.addAttribute("height", Integer.toString(tag.getHeight()));
        switch (tag.getDeblocking()) {
            case 1: {
                element.addAttribute("deblocking", "off");
                break;
            }
            case 2: {
                element.addAttribute("deblocking", "on");
                break;
            }
            case 0: {
                element.addAttribute("deblocking", "packet");
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal video deblocking setting: " + tag.getDeblocking());
            }
        }
        if (tag.isSmoothing()) {
            element.addAttribute("smoothing", "true");
        }
        switch (tag.getCodecId()) {
            case 3: {
                element.addAttribute("codec", "screenvideo");
                break;
            }
            case 2: {
                element.addAttribute("codec", "h263");
                break;
            }
            case 4: {
                element.addAttribute("codec", "vp6");
                break;
            }
            case 5: {
                element.addAttribute("codec", "vp6alpha");
                break;
            }
            case 6: {
                element.addAttribute("codec", "screenvideov2");
                break;
            }
            case 0: {
                element.addAttribute("codec", "undefined");
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal video codec ID: " + tag.getCodecId());
            }
        }
    }

    private static void writeDoAction(Element parentElement, DoAction tag) {
        Element element = parentElement.addElement("doaction");
        RecordXMLWriter.writeActionBlock(element, tag.getActions());
    }

    private static void writeDoInitAction(Element parentElement, DoInitAction tag) {
        Element element = parentElement.addElement("doinitaction");
        element.addAttribute("spriteid", Integer.toString(tag.getSpriteId()));
        RecordXMLWriter.writeActionBlock(element, tag.getInitActions());
    }

    private static void writeEnableDebugger(Element parentElement, EnableDebugger tag) {
        Element element = parentElement.addElement("enabledebugger");
        String password = tag.getPassword();
        if (password != null) {
            element.addAttribute("password", password);
        }
    }

    private static void writeEnableDebugger2(Element parentElement, EnableDebugger2 tag) {
        Element element = parentElement.addElement("enabledebugger2");
        String password = tag.getPassword();
        if (password != null) {
            element.addAttribute("password", password);
        }
    }

    private static void writeExportAssets(Element parentElement, ExportAssets tag) {
        Element element = parentElement.addElement("exportassets");
        ExportAssets.ExportMapping[] mappings = tag.getExportMappings();
        int i = 0;
        while (i < mappings.length) {
            ExportAssets.ExportMapping mapping = mappings[i];
            Element mappingElement = element.addElement("exportmapping");
            mappingElement.addAttribute("charid", Integer.toString(mapping.getCharacterId()));
            mappingElement.addAttribute("name", mapping.getName());
            ++i;
        }
    }

    private static void writeFlashTypeSettings(Element parentElement, FlashTypeSettings tag) {
        Element element = parentElement.addElement("flashtypesettings");
        element.addAttribute("textid", Integer.toString(tag.getTextId()));
        element.addAttribute("flashtype", Boolean.toString(tag.isFlashType()));
        switch (tag.getGridFit()) {
            case 0: {
                element.addAttribute("gridfit", "none");
                break;
            }
            case 1: {
                element.addAttribute("gridfit", "pixel");
                break;
            }
            case 2: {
                element.addAttribute("gridfit", "subpixel");
                break;
            }
        }
        element.addAttribute("thickness", StringUtilities.doubleToString(tag.getThickness()));
        element.addAttribute("sharpness", StringUtilities.doubleToString(tag.getSharpness()));
    }

    private static void writeFrameLabel(Element parentElement, FrameLabel tag) {
        Element element = parentElement.addElement("framelabel");
        element.addAttribute("name", tag.getName());
        if (tag.isNamedAnchor()) {
            element.addAttribute("namedanchor", "true");
        }
    }

    private static void writeFreeCharacter(Element parentElement, FreeCharacter tag) {
        Element element = parentElement.addElement("freecharacter");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
    }

    private static void writeImportAssets(Element parentElement, ImportAssets tag) {
        Element element = parentElement.addElement("importassets");
        element.addAttribute("url", tag.getUrl());
        ImportAssets.ImportMapping[] mappings = tag.getImportMappings();
        int i = 0;
        while (i < mappings.length) {
            ImportAssets.ImportMapping mapping = mappings[i];
            Element mappingElement = element.addElement("importmapping");
            mappingElement.addAttribute("name", mapping.getName());
            mappingElement.addAttribute("charid", Integer.toString(mapping.getCharacterId()));
            ++i;
        }
    }

    private static void writeImportAssets2(Element parentElement, ImportAssets2 tag) {
        Element element = parentElement.addElement("importassets2");
        element.addAttribute("url", tag.getUrl());
        ImportAssets.ImportMapping[] mappings = tag.getImportMappings();
        int i = 0;
        while (i < mappings.length) {
            ImportAssets.ImportMapping mapping = mappings[i];
            Element mappingElement = element.addElement("importmapping");
            mappingElement.addAttribute("name", mapping.getName());
            mappingElement.addAttribute("charid", Integer.toString(mapping.getCharacterId()));
            ++i;
        }
    }

    private static void writeJPEGTables(Element parentElement, JPEGTables tag) {
        Element element = parentElement.addElement("jpegtables");
        element.addElement("jpegdata").addText(Base64.encode(tag.getJpegData()));
    }

    private static void writeLanguage(Element parentElement, LangCode langCode) {
        if (langCode != null) {
            switch (langCode.getLanguageCode()) {
                case 1: {
                    parentElement.addAttribute("language", "latin");
                    break;
                }
                case 0: {
                    parentElement.addAttribute("language", "undefined");
                    break;
                }
                case 2: {
                    parentElement.addAttribute("language", "japanese");
                    break;
                }
                case 3: {
                    parentElement.addAttribute("language", "korean");
                    break;
                }
                case 4: {
                    parentElement.addAttribute("language", "simpchinese");
                    break;
                }
                case 5: {
                    parentElement.addAttribute("language", "tradchinese");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal language code: " + langCode.getLanguageCode());
                }
            }
        }
    }

    private static void writeMalformedTag(Element parentElement, MalformedTag tag) {
        Element element = parentElement.addElement("malformedtag");
        element.addAttribute("code", Integer.toString(tag.getCode()));
        Exception exception = tag.getException();
        Element exceptionElement = element.addElement("exception");
        exceptionElement.addAttribute("class", exception.getClass().getName());
        exceptionElement.addAttribute("message", exception.toString());
        element.addElement("data").addText(Base64.encode(tag.getData()));
    }

    private static void writePlaceObject(Element parentElement, PlaceObject tag) {
        Element element = parentElement.addElement("placeobject");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        element.addAttribute("depth", Integer.toString(tag.getDepth()));
        RecordXMLWriter.writeMatrix(element, tag.getMatrix());
        CXform colorTransform = tag.getColorTransform();
        if (colorTransform != null) {
            RecordXMLWriter.writeCXForm(element, colorTransform);
        }
    }

    private static void writePlaceObject2(Element parentElement, PlaceObject2 tag) {
        Element element = parentElement.addElement("placeobject2");
        element.addAttribute("depth", Integer.toString(tag.getDepth()));
        if (tag.hasCharacter()) {
            element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        }
        if (tag.hasName()) {
            element.addAttribute("name", tag.getName());
        }
        if (tag.isMove()) {
            element.addAttribute("move", "true");
        }
        if (tag.hasMatrix()) {
            RecordXMLWriter.writeMatrix(element, tag.getMatrix());
        }
        if (tag.hasColorTransform()) {
            RecordXMLWriter.writeCXFormWithAlpha(element, tag.getColorTransform());
        }
        if (tag.hasRatio()) {
            element.addAttribute("ratio", Integer.toString(tag.getRatio()));
        }
        if (tag.hasClipDepth()) {
            element.addAttribute("clipdepth", Integer.toString(tag.getClipDepth()));
        }
        if (tag.hasClipActions()) {
            RecordXMLWriter.writeClipActions(element, tag.getClipActions());
        }
    }

    private static void writePlaceObject3(Element parentElement, PlaceObject3 tag) {
        Element element = parentElement.addElement("placeobject3");
        element.addAttribute("depth", Integer.toString(tag.getDepth()));
        if (tag.hasCharacter()) {
            element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        }
        if (tag.hasName()) {
            element.addAttribute("name", tag.getName());
        }
        if (tag.isMove()) {
            element.addAttribute("move", "true");
        }
        if (tag.hasMatrix()) {
            RecordXMLWriter.writeMatrix(element, tag.getMatrix());
        }
        if (tag.hasColorTransform()) {
            RecordXMLWriter.writeCXFormWithAlpha(element, tag.getColorTransform());
        }
        if (tag.hasRatio()) {
            element.addAttribute("ratio", Integer.toString(tag.getRatio()));
        }
        if (tag.hasClipDepth()) {
            element.addAttribute("clipdepth", Integer.toString(tag.getClipDepth()));
        }
        if (tag.hasClipActions()) {
            RecordXMLWriter.writeClipActions(element, tag.getClipActions());
        }
        if (tag.hasBlendMode()) {
            element.addAttribute("blendmode", BlendMode.getDescription(tag.getBlendMode()));
        }
        if (tag.isCacheAsBitmap()) {
            element.addAttribute("cacheasbitmap", "true");
        }
        if (tag.hasFilters()) {
            RecordXMLWriter.writeFilters(element, tag.getFilters());
        }
    }

    private static void writeProtect(Element parentElement, Protect tag) {
        Element element = parentElement.addElement("protect");
        String password = tag.getPassword();
        if (password != null) {
            element.addElement("password", tag.getPassword());
        }
    }

    private static void writeRemoveObject(Element parentElement, RemoveObject tag) {
        Element element = parentElement.addElement("removeobject");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        element.addAttribute("depth", Integer.toString(tag.getDepth()));
    }

    private static void writeRemoveObject2(Element parentElement, RemoveObject2 tag) {
        Element element = parentElement.addElement("removeobject2");
        element.addAttribute("depth", Integer.toString(tag.getDepth()));
    }

    private static void writeScale9Grid(Element parentElement, Scale9Grid tag) {
        Element element = parentElement.addElement("scale9grid");
        element.addAttribute("charid", Integer.toString(tag.getCharacterId()));
        RecordXMLWriter.writeRect(element, "grid", tag.getGrid());
    }

    private static void writeScriptLimits(Element parentElement, ScriptLimits tag) {
        Element element = parentElement.addElement("scriptlimits");
        element.addAttribute("maxrecursiondepth", Integer.toString(tag.getMaxRecursionDepth()));
        element.addAttribute("scripttimeout", Integer.toString(tag.getScriptTimeoutSeconds()));
    }

    private static void writeSetTabIndex(Element parentElement, SetTabIndex tag) {
        Element element = parentElement.addElement("settabindex");
        element.addAttribute("depth", Integer.toString(tag.getDepth()));
        element.addAttribute("tabindex", Integer.toString(tag.getTabIndex()));
    }

    private static void writeShowFrame(Element parentElement, ShowFrame tag) {
        parentElement.addElement("showframe");
    }

    private static void writeSoundStreamBlock(Element parentElement, SoundStreamBlock tag) {
        Element element = parentElement.addElement("soundstreamblock");
        element.addElement("streamsounddata").addText(Base64.encode(tag.getStreamSoundData()));
    }

    private static void writeSoundStreamHead(Element parentElement, SoundStreamHead tag) {
        Element element = parentElement.addElement("soundstreamhead");
        element.addAttribute("streamformat", TagXMLWriter.getSoundFormatString(tag.getStreamFormat()));
        element.addAttribute("streamrate", TagXMLWriter.getSoundRateString(tag.getStreamRate()));
        if (tag.isStreamStereo()) {
            element.addAttribute("streamstereo", "true");
        }
        element.addAttribute("streamsamplecount", Integer.toString(tag.getStreamSampleCount()));
        element.addAttribute("playbackrate", TagXMLWriter.getSoundRateString(tag.getPlaybackRate()));
        if (tag.isPlaybackStereo()) {
            element.addAttribute("playbackstereo", "true");
        }
        if (tag.getStreamFormat() == 2) {
            element.addAttribute("latencyseek", Short.toString(tag.getLatencySeek()));
        }
    }

    private static void writeSoundStreamHead2(Element parentElement, SoundStreamHead2 tag) {
        Element element = parentElement.addElement("soundstreamhead2");
        element.addAttribute("streamformat", TagXMLWriter.getSoundFormatString(tag.getStreamFormat()));
        element.addAttribute("streamrate", TagXMLWriter.getSoundRateString(tag.getStreamRate()));
        if (tag.isStream16BitSample()) {
            element.addAttribute("streamsample16bit", "true");
        }
        if (tag.isStreamStereo()) {
            element.addAttribute("streamstereo", "true");
        }
        element.addAttribute("streamsamplecount", Integer.toString(tag.getStreamSampleCount()));
        element.addAttribute("playbackrate", TagXMLWriter.getSoundRateString(tag.getPlaybackRate()));
        if (tag.isPlayback16BitSample()) {
            element.addAttribute("playbacksample16bit", "true");
        }
        if (tag.isPlaybackStereo()) {
            element.addAttribute("playbackstereo", "true");
        }
        if (tag.getStreamFormat() == 2) {
            element.addAttribute("latencyseek", Short.toString(tag.getLatencySeek()));
        }
    }

    private static void writeStartSound(Element parentElement, StartSound tag) {
        Element element = parentElement.addElement("startsound");
        element.addAttribute("soundid", Integer.toString(tag.getSoundId()));
        RecordXMLWriter.writeSoundInfo(element, tag.getSoundInfo());
    }

    private static void writeUnknownTag(Element parentElement, UnknownTag tag) {
        Element element = parentElement.addElement("unknowntag");
        element.addAttribute("code", Integer.toString(tag.getCode()));
        element.addText(Base64.encode(tag.getData()));
    }

    private static void writeVideoFrame(Element parentElement, VideoFrame tag) {
        Element element = parentElement.addElement("videoframe");
        element.addAttribute("streamid", Integer.toString(tag.getStreamId()));
        element.addAttribute("framenum", Integer.toString(tag.getFrameNum()));
        element.addElement("videodata").addText(Base64.encode(tag.getVideoData()));
    }

    TagXMLWriter() {
    }
}

