/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.xml;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import oracle.dss.graph.flash.jswiff.SWFDocument;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;
import oracle.dss.graph.flash.jswiff.util.Base64;
import oracle.dss.graph.flash.jswiff.xml.RecordXMLReader;
import oracle.dss.graph.flash.jswiff.xml.TagXMLReader;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;
import org.dom4j.io.SAXReader;

public class XMLReader {
    private SWFDocument swfDocument;
    private ArrayList tags;
    private SAXReader saxReader;

    private void $init$() {
        this.swfDocument = new SWFDocument();
        this.tags = new ArrayList();
        this.saxReader = new SAXReader();
        this.addHandlers();
    }

    public XMLReader(InputStream stream) throws DocumentException {
        this.$init$();
        this.saxReader.read(stream);
    }

    public XMLReader(Reader reader) throws DocumentException {
        this.$init$();
        this.saxReader.read(reader);
    }

    public SWFDocument getDocument() {
        this.swfDocument.addTags(this.tags);
        return this.swfDocument;
    }

    private void addHandlers() {
        HeaderHandler headerHandler = new HeaderHandler(null);
        this.saxReader.addHandler("/swfdocument/header", (ElementHandler)headerHandler);
        this.saxReader.addHandler("/swfdocument/definebits", (ElementHandler)new TagHandler(6));
        this.saxReader.addHandler("/swfdocument/definebitsjpeg2", (ElementHandler)new TagHandler(21));
        this.saxReader.addHandler("/swfdocument/definebitsjpeg3", (ElementHandler)new TagHandler(35));
        this.saxReader.addHandler("/swfdocument/definebitslossless", (ElementHandler)new TagHandler(20));
        this.saxReader.addHandler("/swfdocument/definebitslossless2", (ElementHandler)new TagHandler(36));
        this.saxReader.addHandler("/swfdocument/definebutton", (ElementHandler)new TagHandler(7));
        this.saxReader.addHandler("/swfdocument/definebutton2", (ElementHandler)new TagHandler(34));
        this.saxReader.addHandler("/swfdocument/definebuttoncxform", (ElementHandler)new TagHandler(23));
        this.saxReader.addHandler("/swfdocument/definebuttonsound", (ElementHandler)new TagHandler(17));
        this.saxReader.addHandler("/swfdocument/defineedittext", (ElementHandler)new TagHandler(37));
        this.saxReader.addHandler("/swfdocument/definefont", (ElementHandler)new TagHandler(10));
        this.saxReader.addHandler("/swfdocument/definefont2", (ElementHandler)new TagHandler(48));
        this.saxReader.addHandler("/swfdocument/definefont3", (ElementHandler)new TagHandler(75));
        this.saxReader.addHandler("/swfdocument/definefontinfo", (ElementHandler)new TagHandler(13));
        this.saxReader.addHandler("/swfdocument/definefontalignment", (ElementHandler)new TagHandler(73));
        this.saxReader.addHandler("/swfdocument/definefontinfo2", (ElementHandler)new TagHandler(62));
        this.saxReader.addHandler("/swfdocument/definemorphshape", (ElementHandler)new TagHandler(46));
        this.saxReader.addHandler("/swfdocument/definemorphshape2", (ElementHandler)new TagHandler(84));
        this.saxReader.addHandler("/swfdocument/defineshape", (ElementHandler)new TagHandler(2));
        this.saxReader.addHandler("/swfdocument/defineshape2", (ElementHandler)new TagHandler(22));
        this.saxReader.addHandler("/swfdocument/defineshape3", (ElementHandler)new TagHandler(32));
        this.saxReader.addHandler("/swfdocument/defineshape4", (ElementHandler)new TagHandler(83));
        this.saxReader.addHandler("/swfdocument/definesound", (ElementHandler)new TagHandler(14));
        this.saxReader.addHandler("/swfdocument/definesprite", (ElementHandler)new TagHandler(39));
        this.saxReader.addHandler("/swfdocument/definetext", (ElementHandler)new TagHandler(11));
        this.saxReader.addHandler("/swfdocument/definetext2", (ElementHandler)new TagHandler(33));
        this.saxReader.addHandler("/swfdocument/definevideostream", (ElementHandler)new TagHandler(60));
        this.saxReader.addHandler("/swfdocument/doaction", (ElementHandler)new TagHandler(12));
        this.saxReader.addHandler("/swfdocument/doinitaction", (ElementHandler)new TagHandler(59));
        this.saxReader.addHandler("/swfdocument/enabledebugger", (ElementHandler)new TagHandler(58));
        this.saxReader.addHandler("/swfdocument/enabledebugger", (ElementHandler)new TagHandler(64));
        this.saxReader.addHandler("/swfdocument/exportassets", (ElementHandler)new TagHandler(56));
        this.saxReader.addHandler("/swfdocument/flashtypesettings", (ElementHandler)new TagHandler(74));
        this.saxReader.addHandler("/swfdocument/framelabel", (ElementHandler)new TagHandler(43));
        this.saxReader.addHandler("/swfdocument/freecharacter", (ElementHandler)new TagHandler(3));
        this.saxReader.addHandler("/swfdocument/importassets", (ElementHandler)new TagHandler(57));
        this.saxReader.addHandler("/swfdocument/importassets2", (ElementHandler)new TagHandler(71));
        this.saxReader.addHandler("/swfdocument/jpegtables", (ElementHandler)new TagHandler(8));
        this.saxReader.addHandler("/swfdocument/malformedtag", (ElementHandler)new TagHandler(-1));
        this.saxReader.addHandler("/swfdocument/metadata", (ElementHandler)new TagHandler(77));
        this.saxReader.addHandler("/swfdocument/placeobject", (ElementHandler)new TagHandler(4));
        this.saxReader.addHandler("/swfdocument/placeobject2", (ElementHandler)new TagHandler(26));
        this.saxReader.addHandler("/swfdocument/placeobject3", (ElementHandler)new TagHandler(70));
        this.saxReader.addHandler("/swfdocument/protect", (ElementHandler)new TagHandler(24));
        this.saxReader.addHandler("/swfdocument/removeobject", (ElementHandler)new TagHandler(5));
        this.saxReader.addHandler("/swfdocument/removeobject2", (ElementHandler)new TagHandler(28));
        this.saxReader.addHandler("/swfdocument/scale9grid", (ElementHandler)new TagHandler(78));
        this.saxReader.addHandler("/swfdocument/scriptlimits", (ElementHandler)new TagHandler(65));
        this.saxReader.addHandler("/swfdocument/settabindex", (ElementHandler)new TagHandler(66));
        this.saxReader.addHandler("/swfdocument/showframe", (ElementHandler)new TagHandler(1));
        this.saxReader.addHandler("/swfdocument/soundstreamblock", (ElementHandler)new TagHandler(19));
        this.saxReader.addHandler("/swfdocument/soundstreamhead", (ElementHandler)new TagHandler(18));
        this.saxReader.addHandler("/swfdocument/soundstreamhead2", (ElementHandler)new TagHandler(45));
        this.saxReader.addHandler("/swfdocument/startsound", (ElementHandler)new TagHandler(15));
        this.saxReader.addHandler("/swfdocument/videoframe", (ElementHandler)new TagHandler(61));
        this.saxReader.addHandler("/swfdocument/unknowntag", (ElementHandler)new UnknownTagHandler(null));
    }

    private void parseHeader(Element headerElement) {
        short swfVersion = RecordXMLReader.getShortAttribute("swfversion", headerElement);
        this.swfDocument.setVersion(swfVersion);
        this.swfDocument.setCompressed(RecordXMLReader.getBooleanAttribute("compressed", headerElement));
        Element framesElement = RecordXMLReader.getElement("frames", headerElement);
        this.swfDocument.setFrameCount(RecordXMLReader.getIntAttribute("count", framesElement));
        this.swfDocument.setFrameRate(RecordXMLReader.getShortAttribute("rate", framesElement));
        Element sizeElement = RecordXMLReader.getElement("size", framesElement);
        this.swfDocument.setFrameSize(RecordXMLReader.readRect(sizeElement));
        Element backgroundColorElement = RecordXMLReader.getElement("bgcolor", headerElement);
        this.swfDocument.setBackgroundColor(RecordXMLReader.readRGB(backgroundColorElement));
        if (swfVersion >= 8) {
            String access = RecordXMLReader.getStringAttribute("access", headerElement);
            if (access.equals("local")) {
                this.swfDocument.setAccessMode((byte)0);
            } else if (access.equals("network")) {
                this.swfDocument.setAccessMode((byte)1);
            }
            Element metadata = headerElement.element("metadata");
            if (metadata != null) {
                this.swfDocument.setMetadata(Base64.decodeString(metadata.getText()));
            }
        }
    }

    static ArrayList ra$tags(XMLReader xMLReader) {
        return xMLReader.tags;
    }

    static void mav$parseHeader(XMLReader xMLReader, Element element) {
        xMLReader.parseHeader(element);
    }

    private class TagHandler
    implements ElementHandler {
        private int tagCode;

        public TagHandler(int tagCode) {
            this.tagCode = tagCode;
        }

        public void onEnd(ElementPath path) {
            Element tagElement = path.getCurrent();
            Tag tag = TagXMLReader.readTag(tagElement, this.tagCode);
            XMLReader.ra$tags(XMLReader.this).add(tag);
            tagElement.detach();
            tagElement = null;
        }

        public void onStart(ElementPath path) {
        }
    }

    private class UnknownTagHandler
    implements ElementHandler {
        public void onEnd(ElementPath path) {
            Element tagElement = path.getCurrent();
            Tag tag = TagXMLReader.readUnknownTag(tagElement);
            XMLReader.ra$tags(XMLReader.this).add(tag);
            tagElement.detach();
        }

        public void onStart(ElementPath path) {
        }

        private UnknownTagHandler() {
        }

        UnknownTagHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class HeaderHandler
    implements ElementHandler {
        public void onEnd(ElementPath path) {
            Element headerElement = path.getCurrent();
            XMLReader.mav$parseHeader(XMLReader.this, headerElement);
            headerElement.detach();
            headerElement = null;
        }

        public void onStart(ElementPath path) {
        }

        private HeaderHandler() {
        }

        HeaderHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

