/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import oracle.dss.graph.flash.jswiff.SWFDocument;
import oracle.dss.graph.flash.jswiff.swfrecords.RGB;
import oracle.dss.graph.flash.jswiff.swfrecords.Rect;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;
import oracle.dss.graph.flash.jswiff.util.Base64;
import oracle.dss.graph.flash.jswiff.xml.RecordXMLWriter;
import oracle.dss.graph.flash.jswiff.xml.TagXMLWriter;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;

public class XMLWriter {
    private Document xmlDocument;
    private Element rootElement;
    private SWFDocument swfDocument;

    public XMLWriter(SWFDocument swfDocument) {
        this.swfDocument = swfDocument;
        this.xmlDocument = DocumentHelper.createDocument();
        this.rootElement = this.xmlDocument.addElement("swfdocument");
        this.writeHeader();
        this.writeTags();
    }

    public void write(OutputStream stream, boolean format) throws IOException {
        if (format) {
            OutputFormat formatter = OutputFormat.createPrettyPrint();
            formatter.setNewLineAfterDeclaration(false);
            formatter.setTrimText(false);
            org.dom4j.io.XMLWriter writer = new org.dom4j.io.XMLWriter(stream, formatter);
            writer.write(this.xmlDocument);
        } else {
            org.dom4j.io.XMLWriter writer = new org.dom4j.io.XMLWriter(stream);
            writer.write(this.xmlDocument);
        }
    }

    public void write(Writer writer, boolean format) throws IOException {
        if (format) {
            OutputFormat formatter = OutputFormat.createPrettyPrint();
            formatter.setNewLineAfterDeclaration(false);
            formatter.setTrimText(false);
            org.dom4j.io.XMLWriter xmlWriter = new org.dom4j.io.XMLWriter(writer, formatter);
            xmlWriter.write(this.xmlDocument);
        } else {
            org.dom4j.io.XMLWriter xmlWriter = new org.dom4j.io.XMLWriter(writer);
            xmlWriter.write(this.xmlDocument);
        }
    }

    private void writeHeader() {
        Element headerElement = this.rootElement.addElement("header");
        headerElement.addAttribute("swfversion", Integer.toString(this.swfDocument.getVersion()));
        if (this.swfDocument.isCompressed()) {
            headerElement.addAttribute("compressed", "true");
        }
        Element frames = headerElement.addElement("frames");
        frames.addAttribute("count", Integer.toString(this.swfDocument.getFrameCount()));
        frames.addAttribute("rate", Integer.toString(this.swfDocument.getFrameRate()));
        Rect size = this.swfDocument.getFrameSize();
        RecordXMLWriter.writeRect(frames, "size", size);
        RGB bgColor = this.swfDocument.getBackgroundColor();
        if (bgColor != null) {
            RecordXMLWriter.writeColor(headerElement, "bgcolor", bgColor);
        }
        if (this.swfDocument.getVersion() >= 8) {
            switch (this.swfDocument.getAccessMode()) {
                case 0: {
                    headerElement.addAttribute("access", "local");
                    break;
                }
                case 1: {
                    headerElement.addAttribute("access", "network");
                    break;
                }
            }
            String metadata = this.swfDocument.getMetadata();
            if (metadata != null) {
                headerElement.addElement("metadata").addText(Base64.encodeString(metadata));
            }
        }
    }

    private void writeTags() {
        List tags = this.swfDocument.getTags();
        for (Tag tag : tags) {
            TagXMLWriter.writeTag(this.rootElement, tag);
        }
    }
}

