/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.util;

import java.text.Bidi;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import oracle.dss.gauge.CommonGauge;
import oracle.dss.gauge.DataSpecification;
import oracle.dss.graph.DataCallback;
import oracle.dss.graph.pfj.Perspective;

public class ChartHelper {
    public static String[][] generateDataKeys(Perspective pfj) {
        DataCallback grid = pfj.getDataGridCallback();
        int numRows = grid.getRows();
        int numColumns = grid.getColumns();
        String[][] keys = new String[numColumns][];
        int i = 0;
        while (i < numColumns) {
            keys[i] = new String[numRows];
            ++i;
        }
        StringBuffer key = new StringBuffer();
        grid.setMetadataLabelFlag(true);
        grid.setMetadataValueSupported(true);
        int i2 = 0;
        while (i2 < numColumns) {
            int j = 0;
            while (j < numRows) {
                key.append(grid.columnLabel(i2));
                key.append(grid.rowLabel(j));
                keys[i2][j] = key.toString();
                key.setLength(0);
                ++j;
            }
            ++i2;
        }
        grid.setMetadataLabelFlag(false);
        grid.setMetadataValueSupported(false);
        return keys;
    }

    public static String[] generateSeriesLabels(Perspective pfj) {
        DataCallback grid = pfj.getDataGridCallback();
        int numRows = grid.getRows();
        String[] labels = new String[numRows];
        StringBuffer label = new StringBuffer();
        int i = 0;
        while (i < numRows) {
            label.append(grid.rowLabel(i));
            labels[i] = label.toString();
            label.setLength(0);
            ++i;
        }
        return labels;
    }

    public static String[] generateFunnelDataKeys(Perspective pfj) {
        DataCallback grid = pfj.getDataGridCallback();
        int numColumns = grid.getColumns();
        String[] keys = new String[numColumns];
        grid.setMetadataLabelFlag(true);
        grid.setMetadataValueSupported(true);
        int i = 0;
        while (i < numColumns) {
            keys[i] = grid.columnLabel(i).toString();
            ++i;
        }
        grid.setMetadataLabelFlag(false);
        grid.setMetadataValueSupported(false);
        return keys;
    }

    public static String[][] generateDataKeys(CommonGauge commonGauge) {
        String[][] keys = null;
        int gaugeRows = commonGauge.getRowCount();
        int gaugeCols = commonGauge.getColCount();
        keys = new String[gaugeRows][];
        int i = 0;
        while (i < gaugeRows) {
            keys[i] = new String[gaugeCols];
            ++i;
        }
        StringBuffer key = new StringBuffer();
        commonGauge.setMetadataLabelFlag(true);
        commonGauge.setMetadataValueSupported(true);
        try {
            int totalSlice = commonGauge.getDataAccess().getEdgeExtent(1);
            DataSpecification dataSpec = commonGauge.getDataSpecification();
            String metric = dataSpec.getMetric();
            String[] keyList = new String[totalSlice];
            int i2 = 0;
            while (i2 < totalSlice) {
                String rowLabel;
                String columnLabel = commonGauge.getColumnLabel(i2);
                if (columnLabel != null) {
                    key.append(columnLabel + " ");
                }
                if ((rowLabel = commonGauge.getRowLabel(i2)) != null) {
                    key.append(rowLabel);
                }
                if (metric != null) {
                    key.append(metric);
                }
                keyList[i2] = key.toString();
                key.setLength(0);
                ++i2;
            }
            int i3 = 0;
            int k = 0;
            while (i3 < gaugeRows) {
                int j = 0;
                while (j < gaugeCols) {
                    keys[i3][j] = keyList[k++];
                    ++j;
                }
                ++i3;
            }
            commonGauge.setMetadataLabelFlag(false);
            commonGauge.setMetadataValueSupported(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return keys;
    }

    public static boolean isBidiRequired(Locale locale) {
        String language;
        boolean bidiRequired = false;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((language = locale.getLanguage()).equals("ar") || language.equals("he") || language.equals("iw")) {
            bidiRequired = true;
        }
        return bidiRequired;
    }

    public static String applyBidi(String text) {
        StringBuffer strbuf = null;
        String bidiText = "";
        Bidi bidi = new Bidi(text, -2);
        byte[] levels = new byte[bidi.getRunCount()];
        Object[] str = new String[levels.length];
        int j = 0;
        while (j < levels.length) {
            int start = bidi.getRunStart(j);
            int limit = bidi.getRunLimit(j);
            int level = bidi.getRunLevel(j);
            strbuf = new StringBuffer(text.substring(start, limit));
            if (level == 1) {
                strbuf.reverse();
            }
            str[j] = strbuf.toString();
            levels[j] = (byte)level;
            ++j;
        }
        Bidi.reorderVisually(levels, 0, str, 0, levels.length);
        int j2 = 0;
        while (j2 < levels.length) {
            bidiText = bidiText + (String)str[j2];
            ++j2;
        }
        return bidiText;
    }

    public static String formatDate(String date, String yearFormat, String qtrFormat, String monthFormat, String dayFormat, String hourFormat) {
        Object strbuf = null;
        String returnDate = null;
        Date parsedDate = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:MM:SS z yyyy");
            parsedDate = sdf.parse(date);
        }
        catch (Exception e) {
            returnDate = date;
        }
        if (parsedDate != null) {
            if (!(yearFormat.equals("NONE") || qtrFormat.equals("NONE") || monthFormat.equals("NONE") || dayFormat.equals("NONE") || hourFormat.equals("NONE"))) {
                returnDate = date;
            } else {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.setLength(0);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(parsedDate);
                if (!yearFormat.equals("NONE")) {
                    int year = calendar.get(1);
                    strBuilder.append(year).append('/');
                }
                if (!qtrFormat.equals("NONE")) {
                    // empty if block
                }
                if (!monthFormat.equals("NONE")) {
                    int month = calendar.get(2);
                    strBuilder.append(month).append('/');
                }
                if (!dayFormat.equals("NONE")) {
                    int day = calendar.get(5);
                    strBuilder.append(day).append(' ');
                }
                if (!hourFormat.equals("NONE")) {
                    int hour = calendar.get(11);
                    strBuilder.append(hour).append(':');
                    int minute = calendar.get(12);
                    if (minute < 10) {
                        strBuilder.append('0').append(minute);
                    } else {
                        strBuilder.append(minute);
                    }
                }
                returnDate = strBuilder.toString();
            }
        }
        return returnDate;
    }
}

