/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.util;

import java.awt.geom.Point2D;
import java.util.Vector;

public class CurveHelper {
    public static Point2D getQuadraticBezierMidPoint(Point2D point0, Point2D point1, Point2D point2, double pt) {
        double tg = pt * pt;
        double pt1 = 1.0 - pt;
        double tg1 = pt1 * pt1;
        double tg4 = 2.0 * pt * pt1;
        double x = point0.getX() * tg1 + point1.getX() * tg4 + point2.getX() * tg;
        double y = point0.getY() * tg1 + point1.getY() * tg4 + point2.getY() * tg;
        return new Point2D.Double(x, y);
    }

    public static Point2D getCubicBezierMidPoint(Point2D point0, Point2D point1, Point2D point2, Point2D point3, double pt) {
        double tg = pt * pt;
        double tgt = tg * pt;
        double pt1 = 1.0 - pt;
        double tg1 = pt1 * pt1;
        double tg2 = tg1 * pt1;
        double tg3 = 3.0 * pt * tg1;
        double tg4 = 3.0 * tg * pt1;
        double x = point0.getX() * tg2 + point1.getX() * tg3 + point2.getX() * tg4 + point3.getX() * tgt;
        double y = point0.getY() * tg2 + point1.getY() * tg3 + point2.getY() * tg4 + point3.getY() * tgt;
        return new Point2D.Double(x, y);
    }

    public static Point2D[] CubicToQudratricBezier(Point2D point0, Point2D point1, Point2D point2, Point2D point3) {
        Vector quadPoints = new Vector();
        Point2D q0 = point0;
        Point2D q1 = CurveHelper.getIntersectionPoint(point0, point1, point2, point3);
        Point2D q2 = point3;
        CurveHelper.breakCubicIntoQuadratic(point0, point1, point2, point3, q0, q1, q2, 0.0, 1.0, quadPoints);
        Object[] res = new Point2D[quadPoints.size()];
        quadPoints.copyInto(res);
        return res;
    }

    private static void breakCubicIntoQuadratic(Point2D c0, Point2D c1, Point2D c2, Point2D c3, Point2D q0, Point2D q1, Point2D q2, double t0, double pt1, Vector result) {
        double mp = t0 + (pt1 - t0) * 0.5;
        Point2D cubic_mid_point = CurveHelper.getCubicBezierMidPoint(c0, c1, c2, c3, mp);
        Point2D quad_mid_point = CurveHelper.getQuadraticBezierMidPoint(q0, q1, q2, 0.5);
        double dist = quad_mid_point.distance(cubic_mid_point);
        if (dist < 1.0) {
            result.addElement(q0);
            result.addElement(q1);
            result.addElement(q2);
            return;
        }
        Point2D dl = CurveHelper.derivativeOfCubicBezier(c0, c1, c2, c3, mp);
        dl.setLocation(dl.getX() + cubic_mid_point.getX(), dl.getY() + cubic_mid_point.getY());
        Point2D qq1 = CurveHelper.getIntersectionPoint(q0, q1, cubic_mid_point, dl);
        CurveHelper.breakCubicIntoQuadratic(c0, c1, c2, c3, q0, qq1, cubic_mid_point, t0, mp, result);
        qq1 = CurveHelper.getIntersectionPoint(q2, q1, cubic_mid_point, dl);
        CurveHelper.breakCubicIntoQuadratic(c0, c1, c2, c3, cubic_mid_point, qq1, q2, mp, pt1, result);
    }

    private static Point2D derivativeOfCubicBezier(Point2D point0, Point2D point1, Point2D point2, Point2D point3, double pt) {
        double ax = 3.0 * point1.getX() - 3.0 * point2.getX() - point0.getX() + point3.getX();
        double bx = 3.0 * (point0.getX() - 2.0 * point1.getX() + point2.getX());
        double cx = 3.0 * (point1.getX() - point0.getX());
        double ay = 3.0 * point1.getY() - 3.0 * point2.getY() - point0.getY() + point3.getY();
        double by = 3.0 * (point0.getY() - 2.0 * point1.getY() + point2.getY());
        double cy = 3.0 * (point1.getY() - point0.getY());
        double x = 3.0 * ax * pt * pt + 2.0 * bx * pt + cx;
        double y = 3.0 * ay * pt * pt + 2.0 * by * pt + cy;
        return new Point2D.Double(x, y);
    }

    public static Point2D getIntersectionPoint(Point2D a0, Point2D a1, Point2D b0, Point2D b1) {
        double dAx = a1.getX() - a0.getX();
        double dAy = a1.getY() - a0.getY();
        double dBx = b1.getX() - b0.getX();
        double dBy = b1.getY() - b0.getY();
        double Fa = dAx * a0.getY() - dAy * a0.getX();
        double Fb = dBx * b0.getY() - dBy * b0.getX();
        double ddd = dBy * dAx - dBx * dAy;
        if (ddd != 0.0) {
            double x = (Fa * dBx - Fb * dAx) / ddd;
            double y = (Fa * dBy - Fb * dAy) / ddd;
            return new Point2D.Double(x, y);
        }
        return a0;
    }
}

