/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.SeparatorBorderPainter;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.bali.share.nls.LocaleUtils;
import oracle.dss.graph.Graph;
import oracle.dss.util.gui.FontButton;

public abstract class BasePanel
extends JPanel {
    protected Graph m_graph;
    protected JPanel m_mainPanel;
    protected JLabel m_label;
    protected JLabel m_statusLabel;
    protected StatusBar statusBar;
    protected ComponentAdapter m_componentListener;
    protected AncestorListener m_ancestorListener;
    protected static final int INSET_TOP_SPACING = 10;
    protected static final int INSET_LEFT_SPACING = 10;
    protected static final int INSET_BOTTOM_SPACING = 10;
    protected static final int INSET_RIGHT_SPACING = 10;
    protected static final int PANELTEXT_CONTROL_VSPACING = 15;
    protected static final int INTER_GROUP_HSPACING = 24;
    protected static final int INTER_GROUP_VSPACING = 15;
    protected static final int CONTROL_BUTTON_HSPACING = 12;
    protected static final int CONTROL_BUTTON_VSPACING = 5;
    protected static final int INTER_BUTTON_SPACING = 10;
    protected static final int GROUPTEXT_CONTROL_VSPACING = 5;
    protected static final int INDENT_SPACING = 24;
    protected static final int LABEL_CONTROL_HSPACING = 12;
    protected static final int COLUMN_HSPACING = 24;
    protected static final int CONTROL_VSPACING = 5;
    protected static final int GROUP_BUTTON_VSPACING = 10;
    protected static final int PANEL_BUTTON_VSPACING = 15;
    protected static final int CONTROL_CHECKBOX_HSPACING = 5;
    protected static final int DOUBLE_TEXT_FIELD_WIDTH = 110;
    protected static final int DOUBLE_TEXT_FIELD_HEIGHT = 20;
    protected static final int RADIOBUTTON_DIAMETER = 17;
    protected static final int COMBOBOX_WIDTH = 50;
    protected static final int COMBOBOX_HEIGHT = 25;
    protected static final int TEXTFIELD_WIDTH = 400;
    protected static final int TEXTFIELD_HEIGHT = 25;
    protected static final int CHECKBOX_ICONTEXT_HSPACING = 4;

    public BasePanel(Graph graph) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.m_graph = graph;
        this.m_label = new JLabel();
        this.statusBar = new StatusBar();
        this.m_statusLabel = new 1();
        this.m_label.setAlignmentX(0.0f);
        this.statusBar.setAlignmentX(0.0f);
        this.statusBar.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 0));
        this.statusBar.setMinimumSize(this.statusBar.getPreferredSize());
        this.statusBar.setMaximumSize(this.statusBar.getPreferredSize());
        this.statusBar.add((Component)this.m_statusLabel);
        this.statusBar.setVisible(false);
        this.add(this.m_label);
        this.add(Box.createVerticalStrut(15));
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setAlignmentX(0.0f);
        this.add(this.m_mainPanel);
        this.add((Component)this.statusBar);
        this.add(Box.createGlue());
        this.m_componentListener = new 2();
        this.addComponentListener(this.m_componentListener);
        this.m_ancestorListener = new 3();
        this.addAncestorListener(this.m_ancestorListener);
        if (!this.m_graph.isShowing()) {
            Dimension d = this.m_graph.getPFJ().getMinimumSize();
            ((Component)((Object)this.m_graph.getThickPFJ())).setBounds(0, 0, d.width, d.height);
        }
    }

    public boolean isShowing() {
        boolean flag = super.isShowing();
        if (flag && this.m_statusLabel != null) {
            this.m_statusLabel.setText("");
        }
        return flag;
    }

    public abstract void apply();

    public LWComponent createSeparator() {
        LWComponent c = new LWComponent();
        BorderAdapter b = new BorderAdapter((BorderPainter)new SeparatorBorderPainter(1, false, 0));
        c.setBorder((Border)b);
        c.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 2));
        c.setMinimumSize(c.getPreferredSize());
        c.setMaximumSize(c.getPreferredSize());
        c.setAlignmentX(0.0f);
        return c;
    }

    public void setTitleText(String str) {
        this.m_label.setText(str);
        this.m_label.setHorizontalAlignment(2);
    }

    public void setGraph(Graph graph) {
        if (graph != null) {
            this.m_graph = graph;
        }
    }

    public void cleanUp() {
        this.removeComponentListener(this.m_componentListener);
        this.m_componentListener = null;
        this.removeAncestorListener(this.m_ancestorListener);
        this.m_ancestorListener = null;
        this.statusBar.remove((Component)this.m_statusLabel);
        this.m_statusLabel = null;
        BasePanel.cleanUpChildren(this);
    }

    private static void cleanUpChildren(Container parent) {
        int i = 0;
        while (i < parent.getComponentCount()) {
            Component comp = parent.getComponent(i);
            if (comp instanceof FontButton) {
                ((FontButton)comp).cleanUp();
            } else if (comp instanceof Container) {
                BasePanel.cleanUpChildren((Container)comp);
            }
            ++i;
        }
    }

    protected ComponentOrientation getOrientation() {
        ComponentOrientation orientation = LocaleUtils.getReadingDirectionForLocale((Locale)this.m_graph.getLocale()) == 2 ? ComponentOrientation.RIGHT_TO_LEFT : (LocaleUtils.getReadingDirectionForLocale((Locale)this.m_graph.getLocale()) == 1 ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.UNKNOWN);
        return orientation;
    }

    final class 1
    extends JLabel {
        public void setText(String text) {
            String oldName = this.getText();
            super.setText(text);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleName", oldName, text);
            }
        }
    }

    final class 2
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            BasePanel.this.m_statusLabel.setText(BasePanel.this.m_label.getText());
        }
    }

    final class 3
    implements AncestorListener {
        public void ancestorAdded(AncestorEvent event) {
            BasePanel.this.m_statusLabel.setText(BasePanel.this.m_label.getText());
        }

        public void ancestorMoved(AncestorEvent event) {
        }

        public void ancestorRemoved(AncestorEvent event) {
        }
    }
}

