/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.UIView;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphTypeAndSubtype;
import oracle.dss.graph.GraphTypeConverter;
import oracle.dss.graph.Subtype;
import oracle.dss.graph.Type;
import oracle.dss.graph.UIGraphType;
import oracle.dss.graph.gui.GraphTypeConverterAdapter;
import oracle.dss.util.gui.ShortcutIcon;

public class GraphTypeTool
extends JToggleButton
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    public static final String PROPERTY_GRAPH_TYPE = "GraphType";
    Object m_selectedObject;
    protected UIView m_currentDataView;
    protected ToolBar m_toolBar;
    protected boolean m_enable;
    protected boolean m_bRolloverIconEnabled;
    private Vector m_types;
    private GraphTypeConverter m_graphTypeConverter;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private ResourceBundle rBundle;
    private boolean updateEnabled;
    private JToggleButton[] typeButtons;
    private GraphTypePopup popup;
    private ButtonGroup buttonGroup;
    private int oldType;
    private boolean m_bTypeChangedByTool;
    private MouseListener m_mouseListener;
    private ImageIcon[] graphTypeIcons;
    private int typeNumber;
    private String[] tooltips;

    public GraphTypeTool() {
        this.$init$();
        ImageIcon icon = this.makeImage("images/es_bar_vert_clust18t.gif");
        this.setIcon(this.getArrowIcon(icon));
        this.setDisabledIcon((Icon)new ShortcutIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())), this.makeImage("images/arrow_disabled.gif")));
        this.addActionListener(this);
        this.addMouseListener(new 1());
        this.addKeyListener(new 2());
        this.setModel(new Model(null));
        this.updateResourceBundle(Locale.getDefault());
        this.setToolTipText(this.rBundle.getString(PROPERTY_GRAPH_TYPE));
        this.setEnabled(false);
        this.setBorderPainted(false);
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            this.setPreferredSize(new Dimension(24, 24));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
            this.m_mouseListener = new 3();
            this.addMouseListener(this.m_mouseListener);
        }
    }

    public void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 9) {
            if (this.isDropDownVisible()) {
                e.consume();
            } else {
                super.processKeyEvent(e);
            }
        } else {
            super.processKeyEvent(e);
        }
    }

    private int findGraphType(Vector types, int type) {
        int index = -1;
        int j = 0;
        while (j < types.size()) {
            if (types.elementAt(j) != null && ((Type)types.elementAt((int)j)).id == type) {
                index = j;
                return index;
            }
            ++j;
        }
        return index;
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
        this.setToolTipText(this.rBundle.getString(PROPERTY_GRAPH_TYPE));
    }

    public void selectedAction(ControllerEvent e, UIView currentDataView, ToolBar toolBar) {
        if (this.m_bTypeChangedByTool) {
            this.m_bTypeChangedByTool = false;
            return;
        }
        if (currentDataView instanceof Graph) {
            GraphTypeConverter typeConverter = ((Graph)currentDataView).getGraphTypeConverter();
            if (typeConverter == null) {
                typeConverter = new GraphTypeConverterAdapter();
            }
            typeConverter.setLocale(((Graph)currentDataView).getLocale());
            ((Graph)currentDataView).setGraphTypeConverter(typeConverter);
            if (typeConverter.getTypes() == null) {
                return;
            }
            this.m_types = typeConverter.getTypes();
            this.typeNumber = typeConverter.getTypes().size();
            if (this.typeNumber < 1) {
                return;
            }
            this.m_graphTypeConverter = typeConverter;
            this.m_enable = false;
            if (this.m_currentDataView != currentDataView) {
                this.graphTypeIcons = new ImageIcon[this.typeNumber * 3];
                int i = 0;
                while (i < this.typeNumber) {
                    StringBuilder filename = new StringBuilder(((Type)this.m_types.elementAt((int)i)).sFileName);
                    filename.insert(((Type)this.m_types.elementAt((int)i)).sFileName.indexOf(".gif"), "18t");
                    this.graphTypeIcons[i] = this.makeImage(filename.toString());
                    this.graphTypeIcons[i].setDescription(((Type)this.m_types.elementAt((int)i)).name);
                    this.graphTypeIcons[this.typeNumber + i] = this.makeImage(((Type)this.m_types.elementAt((int)i)).fileName);
                    this.graphTypeIcons[this.typeNumber + i].setDescription(((Type)this.m_types.elementAt((int)i)).name);
                    this.graphTypeIcons[this.typeNumber * 2 + i] = this.makeImage(((Type)this.m_types.elementAt((int)i)).fileName);
                    this.graphTypeIcons[this.typeNumber * 2 + i].setDescription(((Type)this.m_types.elementAt((int)i)).name);
                    ++i;
                }
                if (this.typeButtons != null) {
                    int i2 = 0;
                    while (i2 < this.typeButtons.length) {
                        this.typeButtons[i2].removeActionListener(this);
                        this.typeButtons[i2].removeMouseListener(this.m_mouseListener);
                        ++i2;
                    }
                }
                this.typeButtons = new JToggleButton[this.typeNumber];
                this.buttonGroup = new ButtonGroup();
                int i3 = 0;
                while (i3 < this.typeNumber) {
                    this.typeButtons[i3] = new JToggleButton();
                    this.typeButtons[i3].setIcon(this.graphTypeIcons[i3]);
                    this.typeButtons[i3].addActionListener(this);
                    this.typeButtons[i3].addMouseListener(this.m_mouseListener);
                    this.typeButtons[i3].setBorderPainted(false);
                    this.typeButtons[i3].setSelected(false);
                    this.typeButtons[i3].setToolTipText(this.rBundle.getString(this.tooltips[i3]));
                    if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
                        this.typeButtons[i3].setPreferredSize(new Dimension(24, 24));
                        this.typeButtons[i3].setMinimumSize(this.typeButtons[i3].getPreferredSize());
                        this.typeButtons[i3].setMaximumSize(this.typeButtons[i3].getPreferredSize());
                    }
                    this.buttonGroup.add(this.typeButtons[i3]);
                    ++i3;
                }
            }
            this.popup = new GraphTypePopup();
            this.setEnabled(true);
            this.m_currentDataView = currentDataView;
            if (toolBar != null) {
                this.m_toolBar = toolBar;
            }
            int type = -1;
            int j = 0;
            while (j < this.m_graphTypeConverter.getTypes().size()) {
                if (((Type)this.m_graphTypeConverter.getTypes().elementAt((int)j)).id == this.m_graphTypeConverter.getTypeAndSubtype((UIGraphType)((Graph)this.m_currentDataView)).type) {
                    type = j;
                }
                ++j;
            }
            if (type != -1) {
                this.typeButtons[type].setSelected(true);
                this.typeButtons[type].setBorderPainted(true);
                this.oldType = type;
                this.setIcon(this.getArrowIcon(this.typeButtons[type].getIcon()));
                this.setDisabledIcon((Icon)new ShortcutIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())), this.makeImage("images/arrow_disabled.gif")));
            }
            this.setRolloverIconEnabled(this.isRolloverIconEnabled());
        } else {
            this.m_currentDataView = null;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.m_currentDataView == null) {
            return;
        }
        if (this.m_graphTypeConverter == null) {
            return;
        }
        int i = 0;
        while (i < this.typeButtons.length) {
            if (e.getSource() == this.typeButtons[i]) {
                if (this.typeButtons[i].isSelected()) {
                    this.typeButtons[i].setBorderPainted(true);
                    if (this.oldType != i) {
                        this.m_bTypeChangedByTool = true;
                    }
                } else {
                    this.typeButtons[i].setBorderPainted(false);
                }
                Type type = (Type)this.m_graphTypeConverter.getTypes().elementAt(i);
                Subtype subtype = (Subtype)type.subtypes.elementAt(0);
                this.m_graphTypeConverter.setTypeAndSubtype((Graph)this.m_currentDataView, new GraphTypeAndSubtype(type.id, subtype.id));
                this.setDropDownVisible(false);
                this.setIcon(this.getArrowIcon(this.typeButtons[i].getIcon()));
                this.setDisabledIcon((Icon)new ShortcutIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())), this.makeImage("images/arrow_disabled.gif")));
                if (this.isRolloverIconEnabled()) {
                    this.setRolloverIcon(this.getArrowIcon(this.graphTypeIcons[i + this.typeNumber]));
                    this.setRolloverSelectedIcon(this.getArrowIcon(this.graphTypeIcons[i + this.typeNumber]));
                } else {
                    this.setRolloverIcon(null);
                    this.setRolloverSelectedIcon(null);
                }
                this.setBorderPainted(false);
                if (this.tooltips[i].equals("Funnel")) {
                    ((Graph)this.m_currentDataView).setGraphicAntialiasing(true);
                }
                this.firePropertyChange(PROPERTY_GRAPH_TYPE, this.oldType, i);
                this.oldType = i;
                this.requestFocus();
                this.setSelected(false);
                return;
            }
            ++i;
        }
    }

    public void update() {
        if (!this.updateEnabled) {
            return;
        }
        this.selectedAction(null, this.m_currentDataView, null);
    }

    private ImageIcon makeImage(String fileName) {
        return new ImageIcon(ImageUtils.getImageResource(GraphTypeTool.class, (String)fileName));
    }

    private ImageIcon getArrowIcon(Icon icon) {
        if (icon != null) {
            return new ShortcutIcon((ImageIcon)icon, this.makeImage("images/arrow.gif"));
        }
        return null;
    }

    public boolean isPointType() {
        if (this.m_currentDataView == null) {
            return false;
        }
        return ((Graph)this.m_currentDataView).isLineDataLineDisplayed() ^ true;
    }

    private boolean isDropDownVisible() {
        return this.popup == null ? false : this.popup.isVisible();
    }

    private void setDropDownVisible(boolean visible) {
        if (this.popup == null) {
            this.popup = new GraphTypePopup();
            this.popup.setBackground(this.getBackground());
        }
        if (visible) {
            this.popup.show(this, 0, this.getHeight());
        } else {
            this.popup.setVisible(false);
            this.popup = null;
            this.requestFocus();
        }
        this.repaint();
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    public void cleanUp() {
        this.removeMouseListener(this.m_mouseListener);
        this.removeActionListener(this);
        if (this.popup != null) {
            this.popup.cleanUp();
        }
    }

    public void setRolloverIconEnabled(boolean bEnabled) {
        this.m_bRolloverIconEnabled = bEnabled;
        if (bEnabled) {
            if (this.typeButtons != null) {
                int i = 0;
                while (i < this.typeButtons.length) {
                    this.typeButtons[i].setIcon(this.graphTypeIcons[i + this.typeNumber * 2]);
                    this.typeButtons[i].setRolloverIcon(this.graphTypeIcons[i + this.typeNumber]);
                    this.typeButtons[i].setRolloverSelectedIcon(this.graphTypeIcons[i + this.typeNumber]);
                    if (this.typeButtons[i].isSelected()) {
                        this.setIcon(this.getArrowIcon(this.typeButtons[i].getIcon()));
                        this.setRolloverIcon(this.getArrowIcon(this.typeButtons[i].getRolloverIcon()));
                        this.setRolloverSelectedIcon(this.getArrowIcon(this.typeButtons[i].getRolloverSelectedIcon()));
                    }
                    ++i;
                }
            }
        } else {
            this.setRolloverIcon(null);
            this.setRolloverSelectedIcon(null);
            if (this.typeButtons != null) {
                int i = 0;
                while (i < this.typeButtons.length) {
                    this.typeButtons[i].setIcon(this.graphTypeIcons[i]);
                    this.typeButtons[i].setRolloverIcon(null);
                    this.typeButtons[i].setRolloverSelectedIcon(null);
                    if (this.typeButtons[i].isSelected()) {
                        this.setIcon(this.getArrowIcon(this.typeButtons[i].getIcon()));
                        this.setRolloverIcon(this.getArrowIcon(this.typeButtons[i].getRolloverIcon()));
                        this.setRolloverSelectedIcon(this.getArrowIcon(this.typeButtons[i].getRolloverSelectedIcon()));
                    }
                    ++i;
                }
            }
        }
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
    }

    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    private boolean isAnySelected() {
        boolean bReturn = false;
        int i = 0;
        while (i < this.typeButtons.length) {
            if (this.typeButtons[i].isSelected()) {
                bReturn = true;
                break;
            }
            ++i;
        }
        return bReturn;
    }

    private void internalKeyPressed(KeyEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        boolean consume = false;
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 37: 
            case 38: {
                if (!this.isDropDownVisible()) break;
                if (!this.isAnySelected()) {
                    this.typeButtons[this.typeButtons.length - 1].setBorderPainted(true);
                    this.typeButtons[this.typeButtons.length - 1].setSelected(true);
                } else {
                    int i = 0;
                    while (i < this.typeButtons.length) {
                        if (this.typeButtons[i].isSelected()) {
                            this.typeButtons[i].setBorderPainted(false);
                            this.typeButtons[i].setSelected(false);
                            if (--i < 0) {
                                i = this.typeButtons.length - 1;
                            }
                            this.typeButtons[i].setBorderPainted(true);
                            this.typeButtons[i].setSelected(true);
                            this.popup.sendAccessibleEvent(((ImageIcon)this.typeButtons[i].getIcon()).getDescription());
                            break;
                        }
                        ++i;
                    }
                }
                consume = true;
                break;
            }
            case 39: 
            case 40: {
                if (!this.isDropDownVisible()) break;
                if (!this.isAnySelected()) {
                    this.typeButtons[0].setBorderPainted(true);
                    this.typeButtons[0].setSelected(true);
                } else {
                    int i = 0;
                    while (i < this.typeButtons.length) {
                        if (this.typeButtons[i].isSelected()) {
                            this.typeButtons[i].setBorderPainted(false);
                            this.typeButtons[i].setSelected(false);
                            if (++i == this.typeButtons.length) {
                                i = 0;
                            }
                            this.typeButtons[i].setBorderPainted(true);
                            this.typeButtons[i].setSelected(true);
                            this.popup.sendAccessibleEvent(((ImageIcon)this.typeButtons[i].getIcon()).getDescription());
                            break;
                        }
                        ++i;
                    }
                }
                consume = true;
                break;
            }
            case 10: {
                if (!this.isDropDownVisible()) break;
                this.doEnter();
                this.setDropDownVisible(false);
                this.repaint();
                consume = true;
                break;
            }
            case 27: {
                if (!this.isDropDownVisible()) break;
                this.setDropDownVisible(false);
                this.repaint();
                break;
            }
            case 32: {
                if (!this.isDropDownVisible()) {
                    this.setDropDownVisible(true);
                    this.setBorderPainted(true);
                    break;
                }
                this.setDropDownVisible(false);
                this.repaint();
                break;
            }
        }
        if (consume) {
            e.consume();
        }
    }

    private void doEnter() {
        if (this.m_currentDataView == null) {
            return;
        }
        if (this.m_graphTypeConverter == null) {
            return;
        }
        int i = 0;
        while (i < this.typeButtons.length) {
            if (this.typeButtons[i].isSelected()) {
                Type type = (Type)this.m_graphTypeConverter.getTypes().elementAt(i);
                Subtype subtype = (Subtype)type.subtypes.elementAt(0);
                this.m_graphTypeConverter.setTypeAndSubtype((Graph)this.m_currentDataView, new GraphTypeAndSubtype(type.id, subtype.id));
                this.setIcon(this.typeButtons[i].getIcon());
                this.setDropDownVisible(false);
                this.setBorderPainted(false);
                this.requestFocus();
                return;
            }
            ++i;
        }
    }

    private void $init$() {
        this.m_selectedObject = null;
        this.m_currentDataView = null;
        this.m_toolBar = null;
        this.m_enable = true;
        this.m_bRolloverIconEnabled = false;
        this.m_types = null;
        this.rBundle = null;
        this.updateEnabled = true;
        this.m_bTypeChangedByTool = false;
        this.tooltips = new String[]{"BarGraph", "HorizontalBarGraph", "PieGraph", "LineGraph", "AreaGraph", "CombinationGraph", "ScatterBubbleGraph", "StockGraph", "CircularGraph", "ParetoGraph", "ThreeDGraph", "Funnel"};
    }

    static JToggleButton[] ra$typeButtons(GraphTypeTool graphTypeTool) {
        return graphTypeTool.typeButtons;
    }

    static boolean mav$isDropDownVisible(GraphTypeTool graphTypeTool) {
        return graphTypeTool.isDropDownVisible();
    }

    static void mav$setDropDownVisible(GraphTypeTool graphTypeTool, boolean bl) {
        graphTypeTool.setDropDownVisible(bl);
    }

    static void mav$internalKeyPressed(GraphTypeTool graphTypeTool, KeyEvent keyEvent) {
        graphTypeTool.internalKeyPressed(keyEvent);
    }

    final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (GraphTypeTool.this.isEnabled()) {
                GraphTypeTool.this.setBorderPainted(GraphTypeTool.this.isBorderPainted() ^ true);
                GraphTypeTool.mav$setDropDownVisible(GraphTypeTool.this, GraphTypeTool.mav$isDropDownVisible(GraphTypeTool.this) ^ true);
                GraphTypeTool.this.requestFocus();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (GraphTypeTool.mav$isDropDownVisible(GraphTypeTool.this)) {
                GraphTypeTool.this.setSelected(true);
            } else {
                GraphTypeTool.this.setSelected(false);
            }
        }
    }

    final class 2
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            GraphTypeTool.mav$internalKeyPressed(GraphTypeTool.this, e);
        }
    }

    final class 3
    extends MouseAdapter {
        public void mouseEntered(MouseEvent e) {
            if (!GraphTypeTool.this.isRolloverIconEnabled()) {
                ((JToggleButton)e.getSource()).setBorderPainted(true);
            }
            if (!GraphTypeTool.this.isEnabled()) {
                ((JToggleButton)e.getSource()).setBorderPainted(GraphTypeTool.this.isSelected());
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!GraphTypeTool.this.isRolloverIconEnabled()) {
                ((JToggleButton)e.getSource()).setBorderPainted(((JToggleButton)e.getSource()).isSelected());
            }
        }
    }

    class GraphTypePopup
    extends JPopupMenu {
        private JToolBar toolbar;
        private JLabel _statusBarLabel;
        private StatusBar _statusBar;

        public GraphTypePopup() {
            this.setLayout(new BoxLayout(this, 1));
            this.toolbar = new JToolBar();
            int i = 0;
            while (i < GraphTypeTool.ra$typeButtons(GraphTypeTool.this).length) {
                this.toolbar.add(GraphTypeTool.ra$typeButtons(GraphTypeTool.this)[i]);
                if (!GraphTypeTool.ra$typeButtons(GraphTypeTool.this)[i].isSelected()) {
                    GraphTypeTool.ra$typeButtons(GraphTypeTool.this)[i].setBorderPainted(false);
                } else {
                    GraphTypeTool.ra$typeButtons(GraphTypeTool.this)[i].setBorderPainted(true);
                }
                ++i;
            }
            this._statusBar = new StatusBar();
            this._statusBarLabel = new 1();
            this._statusBar.add((Component)this._statusBarLabel);
            this._statusBar.setVisible(false);
            this.add((Component)this._statusBar);
            this.toolbar.setOrientation(1);
            this.toolbar.setBorderPainted(false);
            if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                this.toolbar.setBorder(null);
            }
            this.add(this.toolbar);
        }

        public void sendAccessibleEvent(String text) {
            if (this._statusBarLabel != null) {
                this._statusBarLabel.setText(text);
            }
        }

        public void cleanUp() {
            this._statusBar.remove((Component)this._statusBarLabel);
            this._statusBarLabel = null;
        }

        protected void firePopupMenuWillBecomeInvisible() {
            super.firePopupMenuWillBecomeInvisible();
            GraphTypeTool.this.repaint();
        }

        protected void firePopupMenuCanceled() {
            super.firePopupMenuCanceled();
            GraphTypeTool.this.repaint();
        }

        final class 1
        extends JLabel {
            public void setText(String text) {
                String oldName = this.getText();
                super.setText(text);
                if (this.accessibleContext != null) {
                    this.accessibleContext.firePropertyChange("AccessibleName", oldName, text);
                }
            }
        }
    }

    private class Model
    extends JToggleButton.ToggleButtonModel {
        public boolean isPressed() {
            return GraphTypeTool.mav$isDropDownVisible(GraphTypeTool.this);
        }

        private Model() {
        }

        Model(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

