/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.graph.Graph;
import oracle.dss.graph.gui.BasePanel;
import oracle.dss.util.gui.BIColorChoice;
import oracle.dss.util.gui.FontButton;
import oracle.dss.util.help.HelpContext;

public class Legend
extends BasePanel
implements ActionListener,
ItemListener,
PropertyChangeListener,
HelpContext {
    public static final String PROPERTY_LEGEND_VISIBLE = "Legend Visible";
    public static final String PROPERTY_LEGEND_LOCATION = "Legend Location";
    public static final String PROPERTY_LEGEND_BORDER_COLOR = "Legend Border Color";
    public static final String PROPERTY_LEGEND_BACKGROUND_COLOR = "Legend background color";
    protected boolean m_showLegend;
    protected int m_legendLocation;
    protected JLabel m_locationLabel;
    protected JLabel m_borderColorLabel;
    protected JLabel m_bgroundColorLabel;
    protected Color m_borderColor;
    protected Color m_backgroundColor;
    protected Font m_font;
    protected Color m_fontColor;
    protected String[] m_locationRes;
    protected JCheckBox m_shLegendCBox;
    protected JComboBox m_locationComboBox;
    protected BIColorChoice m_bcbutton;
    protected BIColorChoice m_bgcbutton;
    protected FontButton m_fontbutton;
    protected JPanel m_propertiesPanel;
    protected int m_hAlignment;
    protected boolean m_bUnderline;
    protected boolean m_bColorPaletteSet;
    protected boolean m_bFontColorChange;
    protected boolean m_bFontNameChange;
    protected boolean m_bFontStyleChange;
    protected boolean m_bFontSizeChange;
    protected boolean m_bHorizontalAlignmentChange;
    protected boolean m_bFontColorChanged;
    protected boolean m_bFontNameChanged;
    protected boolean m_bFontBoldChanged;
    protected boolean m_bFontItalicChanged;
    protected boolean m_bFontUnderlineChanged;
    protected boolean m_bFontSizeChanged;
    protected boolean m_bHorizontalAlignmentChanged;
    protected boolean m_bShowLegendChanged;
    protected boolean m_bLegendLocationChanged;
    protected boolean m_bBorderColorChanged;
    protected boolean m_bBackgroundColorChanged;
    protected boolean m_bHelpEnabled;
    protected HelpProvider m_helpProvider;
    protected String m_strHelpContextID;
    protected Color m_bgColor;
    protected Color m_bdColor;
    protected Color m_oldFontColor;
    protected Color m_newFontColor;
    protected String m_oldFontName;
    protected String m_newFontName;
    protected int m_oldFontStyle;
    protected int m_newFontStyle;
    protected int m_oldFontSize;
    protected int m_newFontSize;
    protected int m_oldHAlignment;
    protected int m_newHAlignment;
    protected static final int LAP_AUTOMATIC = 4;
    protected boolean m_automaticInList;
    private ResourceBundle rBundle;
    private static Color c_Transparent = null;

    public Legend(Graph graphView) {
        super(graphView);
        this.$init$();
        this.m_graph = graphView;
        this.init();
        this.constructPanel();
    }

    public void setColorPalette(Color[][] colors) {
        ArrayTwoDModel colorPalette;
        if (colors != null) {
            colorPalette = FontButton.getArrayTwoDModel((Color[][])colors);
            this.m_bColorPaletteSet = true;
        } else {
            this.m_bColorPaletteSet = false;
            colorPalette = null;
        }
        this.m_fontbutton.setColorPalette(colorPalette);
        if (this.m_bgColor != null) {
            this.m_bgcbutton.setSelectedColor((Color)this.m_bgcbutton.getColorPalette().getData(0, 0));
            this.m_bgcbutton.setColorPalette((TwoDModel)colorPalette);
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_bgcbutton.getColorPalette(), (Color)this.m_bgColor)) {
                    this.m_bgcbutton.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_bgcbutton.getColorPalette(), (Color)this.m_bgColor, (boolean)this.m_bColorPaletteSet));
                }
                this.m_bgcbutton.setSelectedColor(this.m_bgColor);
            } else {
                this.m_bgcbutton.setSelectedColor(this.m_bgcbutton.getClosestColor(this.m_bgColor));
            }
        } else {
            this.m_bgcbutton.setColorPalette((TwoDModel)colorPalette);
        }
        if (this.m_bdColor != null) {
            this.m_bcbutton.setSelectedColor((Color)this.m_bcbutton.getColorPalette().getData(0, 0));
            this.m_bcbutton.setColorPalette((TwoDModel)colorPalette);
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_bcbutton.getColorPalette(), (Color)this.m_bdColor)) {
                    this.m_bcbutton.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_bcbutton.getColorPalette(), (Color)this.m_bdColor, (boolean)this.m_bColorPaletteSet));
                }
                this.m_bcbutton.setSelectedColor(this.m_bdColor);
            } else {
                this.m_bcbutton.setSelectedColor(this.m_bcbutton.getClosestColor(this.m_bdColor));
            }
        } else {
            this.m_bcbutton.setColorPalette((TwoDModel)colorPalette);
        }
    }

    public Color[][] getColorPalette() {
        return FontButton.getColorArray((TwoDModel)this.m_bcbutton.getColorPalette());
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
    }

    private void init() {
        this.updateResourceBundle(this.m_graph.getLocale());
        this.m_automaticInList = this.m_graph.getAutoLayout() == 2 || this.m_graph.getAutoLayout() == 1;
        if (this.m_automaticInList) {
            this.m_locationRes = new String[5];
            this.m_locationRes[0] = this.rBundle.getString("Automatic");
            this.m_locationRes[1] = this.rBundle.getString("Top");
            this.m_locationRes[2] = this.rBundle.getString("Bottom");
            this.m_locationRes[3] = this.rBundle.getString("Right");
            this.m_locationRes[4] = this.rBundle.getString("Left");
        } else {
            this.m_locationRes = new String[4];
            this.m_locationRes[0] = this.rBundle.getString("Top");
            this.m_locationRes[1] = this.rBundle.getString("Bottom");
            this.m_locationRes[2] = this.rBundle.getString("Right");
            this.m_locationRes[3] = this.rBundle.getString("Left");
        }
        if (this.m_locationComboBox != null) {
            this.m_locationComboBox.setModel(new DefaultComboBoxModel<String>(this.m_locationRes));
        }
        this.m_showLegend = this.m_graph.getGraphType() != 96 ? this.m_graph.getLegendArea().isVisible() : false;
        this.m_legendLocation = this.m_automaticInList && this.m_graph.getLegendArea().getAutomaticPlacement() == 1 ? 4 : this.m_graph.getLegendArea().getPosition();
        this.m_legendLocation = this.convertLegendLocationToComboOffset(this.m_legendLocation);
        this.m_borderColor = !this.m_graph.getLegendArea().isBorderTransparent() ? this.m_graph.getLegendArea().getBorderColor() : c_Transparent;
        this.m_bdColor = this.m_borderColor;
        this.m_backgroundColor = !this.m_graph.getLegendArea().isFillTransparent() ? this.m_graph.getLegendArea().getFillColor() : c_Transparent;
        this.m_bgColor = this.m_backgroundColor;
        this.m_fontColor = this.m_graph.getLegendText().getGraphFont().getGraphFontColor();
        int fontStyle = this.m_graph.getLegendText().getGraphFont().getGraphFontStyle();
        this.m_bUnderline = fontStyle == 7 || fontStyle == 6 || fontStyle == 5 || fontStyle == 4;
        this.m_hAlignment = this.m_graph.getLegendText().getHorizontalAlignment();
        this.m_font = this.m_graph.getLegendText().getFont();
    }

    public void setGraph(Graph graphView) {
        super.setGraph(graphView);
        this.init();
        if (this.m_graph.getGraphType() != 96) {
            this.m_shLegendCBox.setSelected(this.m_showLegend);
            this.m_shLegendCBox.setEnabled(true);
        } else {
            this.m_shLegendCBox.setSelected(false);
            this.m_shLegendCBox.setEnabled(false);
        }
        if (this.m_backgroundColor != c_Transparent) {
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_bgcbutton.getColorPalette(), (Color)this.m_backgroundColor)) {
                    this.m_bgcbutton.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_bgcbutton.getColorPalette(), (Color)this.m_backgroundColor, (boolean)this.m_bColorPaletteSet));
                }
                this.m_bgcbutton.setSelectedColor(this.m_backgroundColor);
            } else {
                this.m_bgcbutton.setSelectedColor(this.m_bgcbutton.getClosestColor(this.m_backgroundColor));
            }
        }
        this.m_bgcbutton.setEnabled(this.m_showLegend);
        this.m_bgcbutton.setLocale(graphView.getLocale());
        this.m_bgcbutton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        if (this.m_borderColor != c_Transparent) {
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_bcbutton.getColorPalette(), (Color)this.m_borderColor)) {
                    this.m_bcbutton.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_bcbutton.getColorPalette(), (Color)this.m_borderColor, (boolean)this.m_bColorPaletteSet));
                }
                this.m_bcbutton.setSelectedColor(this.m_borderColor);
            } else {
                this.m_bcbutton.setSelectedColor(this.m_bcbutton.getClosestColor(this.m_borderColor));
            }
        }
        this.m_bcbutton.setEnabled(this.m_showLegend);
        this.m_bcbutton.setLocale(graphView.getLocale());
        this.m_bcbutton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_locationComboBox.setEnabled(this.m_showLegend);
        this.m_locationComboBox.setSelectedIndex(this.m_legendLocation);
        this.m_fontbutton.setComponentFont(this.m_font);
        this.m_fontbutton.setEnabled(this.m_showLegend);
        this.m_fontbutton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        int iStyle = this.m_graph.getLegendText().getGraphFont().getGraphFontStyle();
        if ((iStyle & 4) == 4) {
            this.m_fontbutton.setUnderlineStyle(true);
        } else {
            this.m_fontbutton.setUnderlineStyle(false);
        }
        this.m_hAlignment = this.m_graph.getLegendText().getHorizontalAlignment();
        this.m_fontbutton.setPaneHorizontalAlignment(this.m_graph.getLegendText().getHorizontalAlignment());
        this.m_fontbutton.setComponentForeground(this.m_fontColor);
        this.m_bShowLegendChanged = false;
        this.m_bLegendLocationChanged = false;
        this.m_bBorderColorChanged = false;
        this.m_bBackgroundColorChanged = false;
        this.m_bFontNameChanged = false;
        this.m_bFontBoldChanged = false;
        this.m_bFontItalicChanged = false;
        this.m_bFontUnderlineChanged = false;
        this.m_bFontSizeChanged = false;
        this.m_bFontColorChanged = false;
    }

    private void constructPanel() {
        String aboutPanelStr = this.rBundle.getString("legend options");
        this.setTitleText(aboutPanelStr);
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 0));
        this.m_mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        JPanel propertiesPanel = new JPanel();
        propertiesPanel.setLayout(new BoxLayout(propertiesPanel, 1));
        propertiesPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 6));
        String translatedText = this.rBundle.getString("Show legend");
        this.m_shLegendCBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText), this.m_showLegend);
        this.m_shLegendCBox.setName("showLegend");
        this.m_shLegendCBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        if (this.m_graph.getGraphType() == 96) {
            this.m_shLegendCBox.setEnabled(false);
        } else {
            this.m_shLegendCBox.setEnabled(true);
        }
        JPanel legCBoxPanel = new JPanel();
        legCBoxPanel.setLayout(new BoxLayout(legCBoxPanel, 0));
        legCBoxPanel.add(this.m_shLegendCBox);
        this.m_shLegendCBox.setAlignmentX(0.0f);
        legCBoxPanel.setAlignmentX(0.0f);
        propertiesPanel.setAlignmentX(0.0f);
        JPanel locationPanel = new JPanel();
        locationPanel.setLayout(new BoxLayout(locationPanel, 0));
        locationPanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Location");
        this.m_locationLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_locationLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_locationLabel.setAlignmentX(0.0f);
        this.m_locationComboBox = new JComboBox<String>(this.m_locationRes);
        this.m_locationComboBox.setName("Location");
        this.m_locationComboBox.setAlignmentX(0.0f);
        this.m_locationComboBox.setSelectedIndex(this.m_legendLocation);
        this.m_locationComboBox.setEnabled(this.m_showLegend);
        this.m_locationLabel.setLabelFor(this.m_locationComboBox);
        locationPanel.add(this.m_locationLabel);
        locationPanel.add(Box.createHorizontalStrut(5));
        locationPanel.add(this.m_locationComboBox);
        JPanel borderColorPanel = new JPanel();
        borderColorPanel.setLayout(new BoxLayout(borderColorPanel, 0));
        borderColorPanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Border color");
        this.m_borderColorLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_borderColorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_borderColorLabel.setAlignmentX(0.0f);
        borderColorPanel.add(this.m_borderColorLabel);
        this.m_bcbutton = new BIColorChoice();
        this.m_bcbutton.setName("BorderColor");
        this.m_bcbutton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_borderColorLabel.setLabelFor((Component)this.m_bcbutton);
        if (this.m_borderColor != c_Transparent) {
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_bcbutton.getColorPalette(), (Color)this.m_borderColor)) {
                    this.m_bcbutton.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_bcbutton.getColorPalette(), (Color)this.m_borderColor, (boolean)this.m_bColorPaletteSet));
                }
                this.m_bcbutton.setSelectedColor(this.m_borderColor);
            } else {
                this.m_bcbutton.setSelectedColor(this.m_bcbutton.getClosestColor(this.m_borderColor));
            }
        }
        this.m_bcbutton.setEnabled(this.m_showLegend);
        this.m_bcbutton.setTransparentAllowed(true);
        this.m_bcbutton.setLocale(this.m_graph.getLocale());
        this.m_bBorderColorChanged = false;
        borderColorPanel.add(Box.createHorizontalStrut(5));
        borderColorPanel.add((Component)this.m_bcbutton);
        JPanel backgroundColorPanel = new JPanel();
        backgroundColorPanel.setLayout(new BoxLayout(backgroundColorPanel, 0));
        translatedText = this.rBundle.getString("Legend Bg color");
        this.m_bgroundColorLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_bgroundColorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_bgroundColorLabel.setAlignmentX(0.0f);
        this.setPerferLen();
        backgroundColorPanel.add(this.m_bgroundColorLabel);
        this.m_bgcbutton = new BIColorChoice();
        this.m_bgcbutton.setName("BackgroundColor");
        this.m_bgcbutton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_bgroundColorLabel.setLabelFor((Component)this.m_bgcbutton);
        if (this.m_backgroundColor != c_Transparent) {
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_bgcbutton.getColorPalette(), (Color)this.m_backgroundColor)) {
                    this.m_bgcbutton.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_bgcbutton.getColorPalette(), (Color)this.m_backgroundColor, (boolean)this.m_bColorPaletteSet));
                }
                this.m_bgcbutton.setSelectedColor(this.m_backgroundColor);
            } else {
                this.m_bgcbutton.setSelectedColor(this.m_bgcbutton.getClosestColor(this.m_backgroundColor));
            }
        }
        this.m_bgcbutton.setEnabled(this.m_showLegend);
        this.m_bgcbutton.setTransparentAllowed(true);
        this.m_bgcbutton.setLocale(this.m_graph.getLocale());
        this.m_bBackgroundColorChanged = false;
        backgroundColorPanel.add(Box.createHorizontalStrut(5));
        backgroundColorPanel.add((Component)this.m_bgcbutton);
        backgroundColorPanel.setAlignmentX(0.0f);
        Dimension bgcdim = backgroundColorPanel.getPreferredSize();
        Dimension bdrcdim = borderColorPanel.getPreferredSize();
        Dimension locdim = locationPanel.getPreferredSize();
        int maxPanelWidth = locdim.width >= bdrcdim.width ? (locdim.width >= bgcdim.width ? locdim.width : bgcdim.width) : (bdrcdim.width >= bgcdim.width ? bdrcdim.width : bgcdim.width);
        JPanel cmbPanel = new JPanel();
        cmbPanel.setLayout(new BoxLayout(cmbPanel, 1));
        cmbPanel.setAlignmentX(0.0f);
        cmbPanel.add(Box.createVerticalStrut(5));
        cmbPanel.add(legCBoxPanel);
        cmbPanel.add(Box.createVerticalStrut(10));
        cmbPanel.add(locationPanel);
        cmbPanel.add(Box.createVerticalStrut(10));
        cmbPanel.add(backgroundColorPanel);
        cmbPanel.add(Box.createVerticalStrut(10));
        cmbPanel.add(borderColorPanel);
        cmbPanel.add(Box.createVerticalStrut(10));
        if (maxPanelWidth < legCBoxPanel.getPreferredSize().width) {
            maxPanelWidth = legCBoxPanel.getPreferredSize().width;
        }
        legCBoxPanel.setPreferredSize(new Dimension(maxPanelWidth, legCBoxPanel.getPreferredSize().height));
        legCBoxPanel.setMaximumSize(legCBoxPanel.getPreferredSize());
        legCBoxPanel.setMinimumSize(legCBoxPanel.getPreferredSize());
        backgroundColorPanel.setPreferredSize(new Dimension(maxPanelWidth, backgroundColorPanel.getPreferredSize().height));
        backgroundColorPanel.setMaximumSize(backgroundColorPanel.getPreferredSize());
        backgroundColorPanel.setMinimumSize(backgroundColorPanel.getPreferredSize());
        borderColorPanel.setPreferredSize(new Dimension(maxPanelWidth, borderColorPanel.getPreferredSize().height));
        borderColorPanel.setMaximumSize(borderColorPanel.getPreferredSize());
        borderColorPanel.setMinimumSize(borderColorPanel.getPreferredSize());
        locationPanel.setPreferredSize(new Dimension(maxPanelWidth, locationPanel.getPreferredSize().height));
        locationPanel.setMaximumSize(locationPanel.getPreferredSize());
        locationPanel.setMinimumSize(locationPanel.getPreferredSize());
        JPanel fontPanel = new JPanel();
        fontPanel.setLayout(new BoxLayout(fontPanel, 0));
        fontPanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Legend Font");
        this.m_fontbutton = new FontButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_fontbutton.setName("LegendFont");
        this.m_fontbutton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_fontbutton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = this.rBundle.getString("Legend Font For FontButton");
        this.m_fontbutton.setDialogTitle(translatedText);
        this.m_fontbutton.setPaneLocale(this.m_graph.getLocale());
        this.m_fontbutton.setAlignmentX(0.0f);
        this.m_font = this.m_graph.getLegendText().getFont();
        this.m_fontbutton.setComponentFont(this.m_font);
        this.m_fontbutton.setEnabled(this.m_showLegend);
        int iStyle = this.m_graph.getLegendText().getGraphFont().getGraphFontStyle();
        if ((iStyle & 4) == 4) {
            this.m_fontbutton.setUnderlineStyle(true);
        }
        Dimension fbdim = this.m_fontbutton.getPreferredSize();
        if (fbdim.width > maxPanelWidth) {
            maxPanelWidth = fbdim.width;
        }
        this.m_fontbutton.setMaximumSize(this.m_fontbutton.getPreferredSize());
        this.m_fontbutton.setMinimumSize(this.m_fontbutton.getPreferredSize());
        fontPanel.add(Box.createHorizontalStrut(this.m_locationLabel.getPreferredSize().width + 5));
        fontPanel.add((Component)this.m_fontbutton);
        fontPanel.setPreferredSize(new Dimension(this.m_locationLabel.getPreferredSize().width + 5 + this.m_fontbutton.getPreferredSize().width, fontPanel.getPreferredSize().height));
        fontPanel.setMaximumSize(fontPanel.getPreferredSize());
        fontPanel.setMinimumSize(fontPanel.getPreferredSize());
        if (fontPanel.getPreferredSize().width > maxPanelWidth) {
            maxPanelWidth = fontPanel.getPreferredSize().width;
        }
        String translatedStr = this.rBundle.getString("legend options");
        JLabel tmpLabel = new JLabel(translatedStr);
        int width = tmpLabel.getPreferredSize().width;
        if (width > maxPanelWidth) {
            maxPanelWidth = width;
        }
        int tmpHeight = 0;
        tmpHeight = tmpLabel.getPreferredSize().height + 5 + legCBoxPanel.getPreferredSize().height + 10 + locationPanel.getPreferredSize().height + 10 + borderColorPanel.getPreferredSize().height + 10 + backgroundColorPanel.getPreferredSize().height + 10 + fontPanel.getPreferredSize().height;
        propertiesPanel.setPreferredSize(new Dimension(maxPanelWidth + 20, tmpHeight + 25));
        propertiesPanel.setMaximumSize(propertiesPanel.getPreferredSize());
        propertiesPanel.setMinimumSize(propertiesPanel.getPreferredSize());
        boolean drillingEnabled = this.m_graph.isDrillingEnabled();
        int sbutton = 3;
        if (!drillingEnabled) {
            sbutton |= 4;
        }
        int abutton = 30;
        this.m_fontbutton.setStyleButtonMask(sbutton);
        this.m_fontbutton.setAlignmentButtonMask(abutton);
        this.m_fontbutton.setColorComponentMask(1);
        this.m_fontbutton.setComponentForeground(this.m_fontColor);
        this.m_hAlignment = this.m_graph.getLegendText().getHorizontalAlignment();
        this.m_fontbutton.setPaneHorizontalAlignment(this.m_hAlignment);
        cmbPanel.add(fontPanel);
        propertiesPanel.add(cmbPanel);
        this.m_propertiesPanel = propertiesPanel;
        this.m_mainPanel.add(propertiesPanel);
        this.m_shLegendCBox.addItemListener(this);
        this.m_locationComboBox.addActionListener(this);
        this.m_fontbutton.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_bcbutton.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_bgcbutton.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.m_bcbutton) {
            if (e.getPropertyName().equals("selectedColor")) {
                this.m_bBorderColorChanged = true;
                this.firePropertyChange(PROPERTY_LEGEND_BORDER_COLOR, this.m_borderColor, this.m_bcbutton.getSelectedColor());
                this.m_borderColor = this.m_bcbutton.getSelectedColor();
            }
        } else if (e.getSource() == this.m_bgcbutton) {
            if (e.getPropertyName().equals("selectedColor")) {
                this.m_bBackgroundColorChanged = true;
                this.firePropertyChange(PROPERTY_LEGEND_BACKGROUND_COLOR, this.m_backgroundColor, this.m_bgcbutton.getSelectedColor());
                this.m_backgroundColor = this.m_bgcbutton.getSelectedColor();
            }
        } else if (e.getSource() == this.m_fontbutton) {
            String name = e.getPropertyName();
            if (name == "fontDialogCancelled") {
                Boolean b = (Boolean)e.getNewValue();
                boolean cancelled = b;
                if (!cancelled) {
                    this.m_font = this.m_fontbutton.getComponentFont();
                    if (this.m_bFontNameChange) {
                        this.firePropertyChange("fontName", this.m_oldFontName, this.m_newFontName);
                        this.m_bFontNameChange = false;
                        this.m_bFontNameChanged = true;
                    }
                    if (this.m_bFontStyleChange) {
                        this.firePropertyChange("fontStyle", this.m_oldFontStyle, this.m_newFontStyle);
                        this.m_bUnderline = this.m_newFontStyle >= 4;
                        int style = this.m_oldFontStyle ^ this.m_newFontStyle;
                        if ((style & 1) != 0) {
                            this.m_bFontBoldChanged = true;
                        }
                        if ((style & 2) != 0) {
                            this.m_bFontItalicChanged = true;
                        }
                        if ((style & 4) != 0) {
                            this.m_bFontUnderlineChanged = true;
                        }
                        this.m_bFontStyleChange = false;
                    }
                    if (this.m_bFontSizeChange) {
                        this.firePropertyChange("fontSize", this.m_oldFontSize, this.m_newFontSize);
                        this.m_bFontSizeChange = false;
                        this.m_bFontSizeChanged = true;
                    }
                    if (this.m_bFontColorChange) {
                        this.firePropertyChange("fontColor", this.m_oldFontColor, this.m_newFontColor);
                        this.m_fontColor = this.m_newFontColor;
                        this.m_bFontColorChange = false;
                        this.m_bFontColorChanged = true;
                    }
                    if (this.m_bHorizontalAlignmentChange) {
                        this.firePropertyChange("fontHorizontalAlignment", this.m_oldHAlignment, this.m_newHAlignment);
                        this.m_hAlignment = this.m_newHAlignment;
                        this.m_bHorizontalAlignmentChange = false;
                        this.m_bHorizontalAlignmentChanged = true;
                    }
                } else {
                    this.m_bFontColorChange = false;
                    this.m_bFontNameChange = false;
                    this.m_bFontStyleChange = false;
                    this.m_bFontSizeChange = false;
                    this.m_bHorizontalAlignmentChange = false;
                }
            }
            if (name == "fontColor") {
                if (!this.m_bFontColorChange) {
                    this.m_oldFontColor = (Color)e.getOldValue();
                }
                this.m_newFontColor = (Color)e.getNewValue();
                if ((Color)e.getOldValue() != this.m_newFontColor) {
                    this.m_bFontColorChange = true;
                }
            }
            if (name == "fontName") {
                if (!this.m_bFontNameChange) {
                    this.m_oldFontName = (String)e.getOldValue();
                }
                this.m_newFontName = (String)e.getNewValue();
                if ((String)e.getOldValue() != this.m_newFontName) {
                    this.m_bFontNameChange = true;
                }
            }
            if (name == "fontStyle") {
                Integer oldIntStyle = (Integer)e.getOldValue();
                if (!this.m_bFontStyleChange) {
                    this.m_oldFontStyle = oldIntStyle;
                }
                Integer newIntStyle = (Integer)e.getNewValue();
                this.m_newFontStyle = newIntStyle;
                if (oldIntStyle != this.m_newFontStyle) {
                    this.m_bFontStyleChange = true;
                }
            }
            if (name == "fontSize") {
                Integer oldIntSize = (Integer)e.getOldValue();
                if (!this.m_bFontSizeChange) {
                    this.m_oldFontSize = oldIntSize;
                }
                Integer newIntSize = (Integer)e.getNewValue();
                this.m_newFontSize = newIntSize;
                if (oldIntSize != this.m_newFontSize) {
                    this.m_bFontSizeChange = true;
                }
            }
            if (name == "fontHorizontalAlignment") {
                Integer oldAli = (Integer)e.getOldValue();
                if (!this.m_bHorizontalAlignmentChange) {
                    this.m_oldHAlignment = oldAli;
                }
                Integer newAli = (Integer)e.getNewValue();
                this.m_newHAlignment = newAli;
                if (oldAli != this.m_newHAlignment) {
                    this.m_bHorizontalAlignmentChange = true;
                }
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.m_shLegendCBox) {
            this.m_bShowLegendChanged = true;
            if (e.getStateChange() == 1) {
                this.firePropertyChange(PROPERTY_LEGEND_VISIBLE, false, true);
                this.m_showLegend = true;
                this.m_locationComboBox.setRequestFocusEnabled(true);
                this.m_bcbutton.setRequestFocusEnabled(true);
                this.m_bgcbutton.setRequestFocusEnabled(true);
                this.m_fontbutton.setRequestFocusEnabled(true);
            } else {
                this.firePropertyChange(PROPERTY_LEGEND_VISIBLE, true, false);
                this.m_showLegend = false;
                this.m_locationComboBox.setRequestFocusEnabled(false);
                this.m_bcbutton.setRequestFocusEnabled(false);
                this.m_bgcbutton.setRequestFocusEnabled(false);
                this.m_fontbutton.setRequestFocusEnabled(false);
            }
            this.m_locationComboBox.setEnabled(this.m_showLegend);
            this.m_bcbutton.setEnabled(this.m_showLegend);
            this.m_bgcbutton.setEnabled(this.m_showLegend);
            this.m_fontbutton.setEnabled(this.m_showLegend);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_locationComboBox) {
            this.m_bLegendLocationChanged = true;
            this.firePropertyChange(PROPERTY_LEGEND_LOCATION, this.convertComboOffsetToLegendLocation(this.m_legendLocation), this.convertComboOffsetToLegendLocation(this.m_locationComboBox.getSelectedIndex()));
            this.m_legendLocation = this.m_locationComboBox.getSelectedIndex();
        }
    }

    public void apply() {
        if (this.m_graph.getGraphType() == 96) {
            return;
        }
        if (this.m_bShowLegendChanged) {
            this.m_graph.getLegendArea().setVisible(this.m_showLegend);
        }
        if (this.m_bLegendLocationChanged) {
            int iTempLoc = this.convertComboOffsetToLegendLocation(this.m_locationComboBox.getSelectedIndex());
            if (!this.m_automaticInList) {
                if (iTempLoc != this.m_graph.getLegendArea().getPosition()) {
                    this.m_graph.getLegendArea().setPosition(iTempLoc);
                }
            } else if (iTempLoc == 4) {
                this.m_graph.getLegendArea().setAutomaticPlacement(1);
            } else {
                this.m_graph.getLegendArea().setAutomaticPlacement(0);
                this.m_graph.getLegendArea().setPosition(iTempLoc);
            }
        }
        if (this.m_bBorderColorChanged) {
            if (this.m_borderColor != c_Transparent) {
                if (!this.m_graph.getLegendArea().getBorderColor().equals(this.m_borderColor)) {
                    this.m_graph.getLegendArea().setBorderColor(this.m_borderColor);
                }
                this.m_graph.getLegendArea().setBorderTransparent(false);
            } else {
                this.m_graph.getLegendArea().setBorderTransparent(true);
            }
        }
        if (this.m_bBackgroundColorChanged) {
            if (this.m_backgroundColor != c_Transparent) {
                if (!this.m_graph.getLegendArea().getFillColor().equals(this.m_backgroundColor)) {
                    this.m_graph.getLegendArea().setFillColor(this.m_backgroundColor);
                }
                this.m_graph.getLegendArea().setFillTransparent(false);
            } else {
                this.m_graph.getLegendArea().setFillTransparent(true);
            }
        }
        if (this.m_bFontNameChanged) {
            this.m_graph.getLegendText().getGraphFont().setGraphFontTypeface(this.m_font.getFontName());
        }
        if (this.m_bFontSizeChanged) {
            this.m_graph.getLegendText().getGraphFont().setGraphFontSize(this.m_font.getSize());
        }
        if (this.m_bFontColorChanged) {
            this.m_graph.getLegendText().getGraphFont().setGraphFontColor(this.m_fontColor);
        }
        if (this.m_bHorizontalAlignmentChanged) {
            this.m_graph.getLegendText().setHorizontalAlignment(this.m_hAlignment);
        }
        if (this.m_bFontBoldChanged) {
            this.m_graph.getLegendText().getGraphFont().setFontBold(this.m_font.isBold());
        }
        if (this.m_bFontItalicChanged) {
            this.m_graph.getLegendText().getGraphFont().setFontItalic(this.m_font.isItalic());
        }
        if (this.m_bFontUnderlineChanged) {
            this.m_graph.getLegendText().getGraphFont().setUnderline(this.m_bUnderline);
        }
    }

    private int convertComboOffsetToLegendLocation(int iLoc) {
        if (!this.m_automaticInList) {
            return iLoc;
        }
        iLoc = iLoc == 0 ? 4 : --iLoc;
        return iLoc;
    }

    private int convertLegendLocationToComboOffset(int iLoc) {
        if (!this.m_automaticInList) {
            return iLoc;
        }
        iLoc = iLoc == 4 ? 0 : ++iLoc;
        return iLoc;
    }

    private int getUnderlineStyle(Font f) {
        int rtnStyle = 0;
        switch (f.getStyle()) {
            case 0: {
                rtnStyle = 4;
                break;
            }
            case 1: {
                rtnStyle = 6;
                break;
            }
            case 2: {
                rtnStyle = 5;
                break;
            }
            case 4: {
                rtnStyle = 4;
                break;
            }
            case 5: {
                rtnStyle = 6;
                break;
            }
            case 6: {
                rtnStyle = 5;
                break;
            }
            case 7: {
                rtnStyle = 7;
                break;
            }
        }
        return rtnStyle;
    }

    private void setPerferLen() {
        int locationWidth = this.getToolkit().getFontMetrics(this.m_locationLabel.getFont()).stringWidth(this.m_locationLabel.getText());
        int borderWidth = this.getToolkit().getFontMetrics(this.m_borderColorLabel.getFont()).stringWidth(this.m_borderColorLabel.getText());
        int backgroundWidth = this.getToolkit().getFontMetrics(this.m_bgroundColorLabel.getFont()).stringWidth(this.m_bgroundColorLabel.getText());
        int dataWidth = locationWidth;
        if (borderWidth > dataWidth) {
            dataWidth = borderWidth;
        }
        if (dataWidth < backgroundWidth) {
            dataWidth = backgroundWidth;
        }
        this.m_locationLabel.setPreferredSize(new Dimension(dataWidth, this.m_locationLabel.getPreferredSize().height));
        this.m_locationLabel.setMinimumSize(this.m_locationLabel.getPreferredSize());
        this.m_locationLabel.setMaximumSize(this.m_locationLabel.getPreferredSize());
        this.m_borderColorLabel.setPreferredSize(new Dimension(dataWidth, this.m_borderColorLabel.getPreferredSize().height));
        this.m_borderColorLabel.setMinimumSize(this.m_borderColorLabel.getPreferredSize());
        this.m_borderColorLabel.setMaximumSize(this.m_borderColorLabel.getPreferredSize());
        this.m_bgroundColorLabel.setPreferredSize(new Dimension(dataWidth, this.m_bgroundColorLabel.getPreferredSize().height));
        this.m_bgroundColorLabel.setMinimumSize(this.m_bgroundColorLabel.getPreferredSize());
        this.m_bgroundColorLabel.setMaximumSize(this.m_bgroundColorLabel.getPreferredSize());
    }

    public Dimension getPreferredSize() {
        int height = this.m_mainPanel.getPreferredSize().height;
        int width = this.m_mainPanel.getPreferredSize().width;
        return new Dimension(width, height);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
        this.m_fontbutton.setHelpProvider(helpProvider);
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_fontbutton.removePropertyChangeListener((PropertyChangeListener)this);
        this.m_bcbutton.removePropertyChangeListener((PropertyChangeListener)this);
        this.m_bgcbutton.removePropertyChangeListener((PropertyChangeListener)this);
        this.m_mainPanel.removeComponentListener(this.m_componentListener);
        this.m_componentListener = null;
    }

    private void $init$() {
        this.m_locationRes = null;
        this.m_bColorPaletteSet = false;
        this.m_bFontColorChange = false;
        this.m_bFontNameChange = false;
        this.m_bFontStyleChange = false;
        this.m_bFontSizeChange = false;
        this.m_bHorizontalAlignmentChange = false;
        this.m_bFontColorChanged = false;
        this.m_bFontNameChanged = false;
        this.m_bFontBoldChanged = false;
        this.m_bFontItalicChanged = false;
        this.m_bFontUnderlineChanged = false;
        this.m_bFontSizeChanged = false;
        this.m_bHorizontalAlignmentChanged = false;
        this.m_bShowLegendChanged = false;
        this.m_bLegendLocationChanged = false;
        this.m_bBorderColorChanged = false;
        this.m_bBackgroundColorChanged = false;
        this.m_bHelpEnabled = true;
        this.m_automaticInList = false;
        this.rBundle = null;
    }
}

