/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.UIView;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.graph.Graph;

public class LegendTool
extends JToggleButton
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    public static final String PROPERTY_LEGEND_VISIBLE = "LegendVisible";
    protected Object m_currentDataView;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private ResourceBundle rBundle;
    protected boolean m_enable;
    private MouseListener m_mouseListener;
    protected boolean m_bRolloverIconEnabled;

    public LegendTool() {
        this.$init$();
        this.setMargin(insets0);
        this.setEnabled(false);
        this.setIcon(this.makeImage("images/s_legend_18t.gif"));
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
        this.addActionListener(this);
        this.setBorderPainted(false);
        this.updateResourceBundle(Locale.getDefault());
        this.setToolTipText(this.rBundle.getString("ShowLegend"));
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            this.setPreferredSize(new Dimension(24, 24));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
            this.m_mouseListener = new 1();
            this.addMouseListener(this.m_mouseListener);
        }
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
        this.setToolTipText(this.rBundle.getString("ShowLegend"));
    }

    public void selectedAction(ControllerEvent e, UIView currentDataView, ToolBar toolBar) {
        this.m_enable = false;
        if (currentDataView instanceof Graph) {
            this.setSelected(((Graph)currentDataView).getLegendArea().isVisible());
            this.setBorderPainted(this.isSelected());
            if (((Graph)currentDataView).getGraphType() > 10 && ((Graph)currentDataView).getGraphType() != 96 && ((Graph)currentDataView).getGraphType() != 70 && ((Graph)currentDataView).getGraphType() != 84 && ((Graph)currentDataView).getGraphType() != 71 && ((Graph)currentDataView).getGraphType() != 72) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            this.m_currentDataView = currentDataView;
        } else {
            this.m_currentDataView = null;
        }
        this.m_enable = true;
    }

    public void actionPerformed(ActionEvent e) {
        if (e == null || !this.m_enable) {
            return;
        }
        if (e.getSource() == this) {
            ((Graph)this.m_currentDataView).getLegendArea().setVisible(this.isSelected());
            this.setBorderPainted(this.isSelected());
            this.firePropertyChange(PROPERTY_LEGEND_VISIBLE, this.isSelected() ^ true, this.isSelected());
        }
    }

    public void update() {
        if (this.m_currentDataView == null) {
            return;
        }
        if (((Graph)this.m_currentDataView).getGraphType() <= 10 || ((Graph)this.m_currentDataView).getGraphType() == 96 || ((Graph)this.m_currentDataView).getGraphType() == 70 || ((Graph)this.m_currentDataView).getGraphType() == 84 || ((Graph)this.m_currentDataView).getGraphType() == 71 || ((Graph)this.m_currentDataView).getGraphType() == 72) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    private ImageIcon makeImage(String fileName) {
        return new ImageIcon(ImageUtils.getImageResource(LegendTool.class, (String)fileName));
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    public void cleanUp() {
        this.removeMouseListener(this.m_mouseListener);
        this.removeActionListener(this);
    }

    public void setRolloverIconEnabled(boolean bEnabled) {
        this.m_bRolloverIconEnabled = bEnabled;
        if (bEnabled) {
            this.setIcon(this.makeImage("images/s_legend.gif"));
            this.setRolloverIcon(this.makeImage("images/l_legend.gif"));
            this.setRolloverSelectedIcon(this.makeImage("images/l_legend.gif"));
        } else {
            this.setIcon(this.makeImage("images/s_legend_18t.gif"));
            this.setRolloverIcon(null);
            this.setRolloverSelectedIcon(null);
        }
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
    }

    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    private void $init$() {
        this.m_currentDataView = null;
        this.rBundle = null;
        this.m_enable = true;
        this.m_bRolloverIconEnabled = false;
    }

    final class 1
    extends MouseAdapter {
        public void mouseEntered(MouseEvent e) {
            if (!LegendTool.this.isRolloverIconEnabled()) {
                LegendTool.this.setBorderPainted(true);
            }
            if (!LegendTool.this.isEnabled()) {
                LegendTool.this.setBorderPainted(LegendTool.this.isSelected());
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!LegendTool.this.isRolloverIconEnabled()) {
                LegendTool.this.setBorderPainted(LegendTool.this.isSelected());
            }
        }
    }
}

