/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.graph.Graph;
import oracle.dss.graph.ReferenceObject;
import oracle.dss.graph.gui.LineWidth;
import oracle.dss.graph.gui.Series;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.util.gui.BIColorChoice;
import oracle.dss.util.gui.FontButton;
import oracle.dss.util.gui.LimitedTextDocument;

public class ReferenceLine
extends JPanel {
    protected Graph m_graph;
    protected int m_componentID;
    protected int m_graphType;
    protected String[] m_referenceNames;
    protected TableColumn m_itemColumn;
    protected TableColumn m_colorColumn;
    protected TableColumn m_lineColumn;
    protected TableColumn m_labelColumn;
    protected TableColumn m_valueColumn;
    protected Object[][] m_data;
    protected String[] m_names;
    protected ReferenceJTable m_table;
    protected LineWidth lineWidth;
    protected CheckBoxEditor checkBoxEditor;
    protected ColorEditor colorEditor;
    protected ColorRenderer colorRenderer;
    protected CheckBoxRenderer itemLabelRenderer;
    protected LabelRenderer lineWidthRenderer;
    protected LabelRenderer labelRenderer;
    protected LabelRenderer crossRenderer;
    protected BIColorChoice button;
    protected Color[][] m_colors;
    protected ArrayTwoDModel m_colorPalette;
    protected boolean m_bColorPaletteSet;
    protected JScrollPane m_scrollPane;
    protected ActionListener editAction;
    protected boolean[] m_visibleChanged;
    protected boolean[] m_lineColorChanged;
    protected boolean[] m_lineWidthChanged;
    protected boolean[] m_textChanged;
    protected boolean[] m_valueChanged;
    private boolean m_focusOut;
    private boolean _flag;
    private NumberFormat m_numberFormat;
    private ResourceBundle rBundle;
    private Filter _filter;
    private int oldAnchorRow;
    private int oldAnchorColumn;
    private boolean editorFocus;
    private int m_colToSelect;
    private int m_rowToSelect;
    private int tableMnemonicKey;
    private boolean spacePressedInEditor;
    private boolean spacePressedInTable;

    public ReferenceLine(Graph graph, int componentID) {
        this.$init$();
        this.m_graph = graph;
        this.m_componentID = componentID;
        this.initAll();
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
        this.m_numberFormat = loc != null ? NumberFormat.getInstance(loc) : NumberFormat.getInstance();
        this.m_numberFormat.setGroupingUsed(false);
    }

    public JTable getTable() {
        return this.m_table;
    }

    private void initAll() {
        this.removeAll();
        this.m_numberFormat = this.m_graph.getLocale() != null ? NumberFormat.getInstance(this.m_graph.getLocale()) : NumberFormat.getInstance();
        this.m_numberFormat.setGroupingUsed(false);
        this.updateResourceBundle(this.m_graph.getLocale());
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        String translatedText = this.rBundle.getString("ReferenceLinePanelLabel");
        JLabel label = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.tableMnemonicKey = StringUtils.getMnemonicKeyCode((String)translatedText);
        label.setAlignmentX(0.0f);
        this.add(label);
        this.add(Box.createVerticalStrut(3));
        this._initialize();
        this.m_table = new ReferenceJTable(this.m_data, this.m_names);
        label.setLabelFor(this.m_table);
        this.m_table.setAlignmentX(0.0f);
        this.m_table.setRowHeight(24);
        this.m_table.setAutoResizeMode(4);
        this.m_table.setCellSelectionEnabled(true);
        this.m_table.getSelectionModel().setSelectionInterval(0, 0);
        this.m_table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
        this.editAction = new 1();
        this.m_table.registerKeyboardAction(this.editAction, KeyStroke.getKeyStroke(113, 0), 1);
        Object actionKey = new Object();
        2 ignoreKeyAction = new 2();
        this.m_table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), actionKey);
        this.m_table.getActionMap().put(actionKey, ignoreKeyAction);
        actionKey = new Object();
        3 tableMnemonicAction = new 3();
        this.m_table.getInputMap(2).put(KeyStroke.getKeyStroke(this.tableMnemonicKey, 8), actionKey);
        this.m_table.getInputMap(0).put(KeyStroke.getKeyStroke(this.tableMnemonicKey, 8), actionKey);
        this.m_table.getActionMap().put(actionKey, tableMnemonicAction);
        this.m_itemColumn = this.m_table.getColumnModel().getColumn(0);
        this._setupItemColumn();
        this.m_colorColumn = this.m_table.getColumnModel().getColumn(1);
        this._setupColorColumn();
        this.m_lineColumn = this.m_table.getColumnModel().getColumn(2);
        this._setupLineWidthColumn();
        this.m_labelColumn = this.m_table.getColumnModel().getColumn(3);
        this._setupLabelColumn();
        this.m_valueColumn = this.m_table.getColumnModel().getColumn(4);
        this._setupValueColumn();
        this.m_scrollPane = new JScrollPane(this.m_table);
        this.m_scrollPane.setAlignmentX(0.0f);
        this.m_scrollPane.setPreferredSize(new Dimension(this.m_table.getPreferredSize().width + 5, this.m_table.getPreferredSize().height + this.m_table.getTableHeader().getPreferredSize().height + 4));
        this.m_scrollPane.setMinimumSize(this.m_scrollPane.getPreferredSize());
        this.add(this.m_scrollPane);
        this.setMinimumSize(new Dimension(this.m_scrollPane.getMinimumSize().width + 20, this.getPreferredSize().height));
    }

    public void setGraph(Graph graph) {
        this.m_graph = graph;
        this.removeAll();
        this.m_table = null;
        this.resetFocus();
        this.initAll();
    }

    public void cleanUp() {
        this.m_table.getInputMap().clear();
        this.m_table.getActionMap().clear();
        this.m_table.unregisterKeyboardAction(KeyStroke.getKeyStroke(113, 0));
        this.editAction = null;
        this.m_scrollPane.setViewportView(null);
        this.m_table = null;
    }

    public void setColorPalette(Color[][] colors) {
        this.m_colors = colors;
        if (this.m_colors != null) {
            this.m_colorPalette = FontButton.getArrayTwoDModel((Color[][])colors);
            this.m_bColorPaletteSet = true;
        } else {
            this.m_bColorPaletteSet = false;
            this.m_colorPalette = null;
        }
        if (this.button != null) {
            this.button.setSelectedColor((Color)this.button.getColorPalette().getData(0, 0));
            this.button.setColorPalette((TwoDModel)this.m_colorPalette);
        }
    }

    public Color[][] getColorPalette() {
        if (this.m_colors != null) {
            return this.m_colors;
        }
        if (this.button != null) {
            return FontButton.getColorArray((TwoDModel)this.button.getColorPalette());
        }
        return FontButton.getDefaultColorArray();
    }

    public void setColorPalette(ArrayTwoDModel model) {
        this.m_bColorPaletteSet = model != null;
        this.m_colorPalette = model;
        if (this.button != null) {
            this.button.setSelectedColor((Color)this.button.getColorPalette().getData(0, 0));
            this.button.setColorPalette((TwoDModel)this.m_colorPalette);
        }
    }

    protected void resetFocus() {
        this.m_focusOut = true;
        this.m_colToSelect = 0;
        this.m_rowToSelect = 0;
    }

    protected void resetFocusLast() {
        this.m_focusOut = true;
        this.m_colToSelect = this.m_table.getColumnCount() - 1;
        this.m_rowToSelect = this.m_table.getRowCount() - 1;
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    private void _setupItemColumn() {
        int length = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[0]);
        int i = 0;
        while (i < 3) {
            int newLength = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_referenceNames[i]) + 20;
            if (newLength > length) {
                length = newLength;
            }
            ++i;
        }
        this.m_itemColumn.setPreferredWidth(length += 10);
        this.m_itemColumn.setMinWidth(this.m_itemColumn.getPreferredWidth());
        this.m_itemColumn.setMaxWidth(this.m_itemColumn.getPreferredWidth());
        this.m_itemColumn.setResizable(false);
        TabCheckBox m_checkBox = new TabCheckBox();
        this.m_itemColumn.setCellEditor(new CheckBoxEditor(m_checkBox));
        this.itemLabelRenderer = new CheckBoxRenderer();
        this.m_itemColumn.setCellRenderer(this.itemLabelRenderer);
    }

    private void _setupLineWidthColumn() {
        this.lineWidth = new LightLineWidth();
        this.lineWidth.setCellColor(Color.black);
        this.m_lineColumn.setCellEditor(new LineWidthEditor(this.lineWidth));
        LineWidthRenderer renderer = new LineWidthRenderer(true);
        this.m_lineColumn.setCellRenderer(renderer);
        this.m_lineColumn.setPreferredWidth(80);
        this.m_lineColumn.setMinWidth(this.m_lineColumn.getPreferredWidth());
        this.m_lineColumn.setMaxWidth(this.m_lineColumn.getPreferredWidth());
        this.m_lineColumn.setResizable(false);
    }

    private void _setupColorColumn() {
        this.button = new BIColorChoice();
        this.button.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        if (this.m_bColorPaletteSet) {
            this.button.setColorPalette((TwoDModel)this.m_colorPalette);
        }
        this.colorEditor = new ColorEditor(this.button);
        this.m_colorColumn.setCellEditor(this.colorEditor);
        this.colorRenderer = new ColorRenderer(true);
        this.m_colorColumn.setCellRenderer(this.colorRenderer);
        this.m_colorColumn.setPreferredWidth(this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[1]) + 10);
        this.m_colorColumn.setMinWidth(this.m_colorColumn.getPreferredWidth());
        this.m_colorColumn.setMaxWidth(this.m_colorColumn.getPreferredWidth());
        this.m_colorColumn.setResizable(false);
    }

    private void _setupLabelColumn() {
        LimitedTextDocument ltd = new LimitedTextDocument(1024);
        TabTextField label = new TabTextField((Document)ltd, "", 0);
        this.m_labelColumn.setCellEditor(new TextFieldEditor(label));
        this.m_labelColumn.setCellRenderer(new LabelRenderer(null));
        this.m_labelColumn.setPreferredWidth(this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[3]) + 30);
        this.m_labelColumn.setMinWidth(this.m_labelColumn.getPreferredWidth());
        this.m_labelColumn.setMaxWidth(this.m_labelColumn.getPreferredWidth());
        this.m_labelColumn.setResizable(false);
    }

    private void _setupValueColumn() {
        TabNumberTextField cross = new TabNumberTextField();
        if (this.m_graph.getLocale() != null) {
            cross.setLocale(this.m_graph.getLocale());
        }
        cross.setDataType(Double.class);
        this.m_valueColumn.setCellEditor(new TextFieldEditor((JTextField)((Object)cross)));
        this.m_valueColumn.setCellRenderer(new LabelRenderer(null));
        this.m_valueColumn.setPreferredWidth(this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[4]) + 20);
        this.m_valueColumn.setMinWidth(this.m_valueColumn.getPreferredWidth());
        this.m_valueColumn.setMaxWidth(this.m_valueColumn.getPreferredWidth());
        this.m_valueColumn.setResizable(false);
    }

    private ImageIcon _getImageIcon(String imageName) {
        return new ImageIcon(ImageUtils.getImageResource(Series.class, (String)imageName));
    }

    private void _initialize() {
        this.m_referenceNames = new String[3];
        this.m_referenceNames[0] = new String(MessageFormat.format(this.rBundle.getString("Reference Line"), "1"));
        this.m_referenceNames[1] = new String(MessageFormat.format(this.rBundle.getString("Reference Line"), "2"));
        this.m_referenceNames[2] = new String(MessageFormat.format(this.rBundle.getString("Reference Line"), "3"));
        Boolean[] m_referenceShow = new Boolean[3];
        Integer[] m_lineWidths = new Integer[3];
        Color[] m_colors = new Color[3];
        String[] m_labels = new String[3];
        String[] m_value = new String[3];
        this.m_visibleChanged = new boolean[3];
        this.m_lineColorChanged = new boolean[3];
        this.m_lineWidthChanged = new boolean[3];
        this.m_textChanged = new boolean[3];
        this.m_valueChanged = new boolean[3];
        List rl = this.m_graph.getReferenceObjects(this.m_componentID);
        if (rl != null) {
            int size = rl.size() <= 3 ? rl.size() : 3;
            int i = 0;
            while (i < size) {
                ReferenceObject r = (ReferenceObject)rl.get(i);
                m_referenceShow[i] = new Boolean(true);
                m_lineWidths[i] = new Integer(r.getLineWidth());
                m_colors[i] = r.getColor();
                m_labels[i] = r.getText();
                m_value[i] = this.m_numberFormat.format(r.getLineValue());
                ++i;
            }
            int j = size;
            while (j < 3) {
                m_referenceShow[j] = new Boolean(false);
                m_lineWidths[j] = (Integer)Attr.LineWidth.getDefault();
                m_colors[j] = (Color)Attr.ReferenceColor.getDefault();
                m_labels[j] = (String)Attr.ReferenceLegendText.getDefault();
                m_value[j] = this.m_numberFormat.format((Double)Attr.ReferenceLineValue.getDefault());
                ++j;
            }
        } else {
            int i = 0;
            while (i < 3) {
                m_referenceShow[i] = new Boolean(false);
                m_lineWidths[i] = (Integer)Attr.LineWidth.getDefault();
                m_colors[i] = (Color)Attr.ReferenceColor.getDefault();
                m_labels[i] = (String)Attr.ReferenceLegendText.getDefault();
                m_value[i] = this.m_numberFormat.format((Double)Attr.ReferenceLineValue.getDefault());
                ++i;
            }
        }
        this.m_names = new String[5];
        this.m_names[0] = this.rBundle.getString("ShowRefrenceLine");
        this.m_names[1] = this.rBundle.getString("Color");
        this.m_names[2] = this.rBundle.getString("Thickness");
        this.m_names[3] = this.rBundle.getString("ReferenceLineLabel");
        this.m_names[4] = this.rBundle.getString("ReferenceLineCrossAt");
        this.m_data = new Object[3][5];
        int i = 0;
        while (i < 3) {
            this.m_data[i][0] = m_referenceShow[i];
            this.m_data[i][1] = m_colors[i];
            this.m_data[i][2] = m_lineWidths[i];
            this.m_data[i][3] = m_labels[i];
            this.m_data[i][4] = m_value[i];
            ++i;
        }
    }

    private Icon _getColorIcon(Image image, int i) {
        this._filter.setColor(i);
        Image newImage = ReferenceLine._createFilteredImage(image, this._filter);
        return new ImageIcon(newImage);
    }

    private static Image _createFilteredImage(Image baseImage, ImageFilter imageFilter) {
        FilteredImageSource prod = new FilteredImageSource(baseImage.getSource(), imageFilter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }

    private void _processTabKey(KeyEvent e) {
        int anchorRow = this.m_table.getSelectionModel().getAnchorSelectionIndex();
        int anchorColumn = this.m_table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
        if (e.isControlDown()) {
            this.m_table.getCellEditor(anchorRow, anchorColumn).stopCellEditing();
            if (!e.isShiftDown()) {
                FocusManager.getCurrentManager().focusNextComponent(this.m_table);
            } else {
                FocusManager.getCurrentManager().focusPreviousComponent(this.m_table);
            }
            this.resetFocus();
        } else if (!e.isShiftDown()) {
            this.m_table.getCellEditor(anchorRow, anchorColumn).stopCellEditing();
            if (anchorRow == this.m_table.getRowCount() - 1 && anchorColumn == this.m_table.getColumnCount() - 1) {
                if (FocusManager.isFocusManagerEnabled()) {
                    FocusManager.getCurrentManager().focusNextComponent(this.m_table);
                    e.consume();
                }
            } else {
                this.m_table.moveRight();
            }
        } else {
            this.m_table.getCellEditor(anchorRow, anchorColumn).stopCellEditing();
            if (anchorRow == 0 && anchorColumn == 0) {
                if (FocusManager.isFocusManagerEnabled()) {
                    FocusManager.getCurrentManager().focusPreviousComponent(this.m_table);
                    e.consume();
                }
            } else {
                this.m_table.moveLeft();
            }
        }
    }

    public void apply() {
        int size = 0;
        List rl = this.m_graph.getReferenceObjects(this.m_componentID);
        if (rl != null) {
            size = rl.size() <= 3 ? rl.size() : 3;
            int i = 0;
            while (i < size) {
                ReferenceObject r = (ReferenceObject)rl.get(i);
                if (this.m_visibleChanged[i]) {
                    boolean visible = (Boolean)this.m_table.getValueAt(i, 0);
                    r.setDisplayedInLegend(visible);
                }
                if (this.m_lineColorChanged[i]) {
                    r.setColor((Color)this.m_table.getValueAt(i, 1));
                }
                if (this.m_lineWidthChanged[i]) {
                    r.setLineWidth(new Integer(this.m_table.getValueAt(i, 2).toString()));
                }
                if (this.m_textChanged[i]) {
                    r.setText((String)this.m_table.getValueAt(i, 3));
                }
                if (this.m_valueChanged[i]) {
                    try {
                        double d = this.m_numberFormat.parse((String)this.m_table.getValueAt(i, 4)).doubleValue();
                        r.setLineValue(d);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        int j = size;
        while (j < 3) {
            boolean visible = (Boolean)this.m_table.getValueAt(j, 0);
            if (visible) {
                ReferenceObject r = this.m_graph.createReferenceObject();
                if (this.m_visibleChanged[j]) {
                    r.setDisplayedInLegend(visible);
                }
                if (this.m_lineColorChanged[j]) {
                    r.setColor((Color)this.m_table.getValueAt(j, 1));
                }
                if (this.m_lineWidthChanged[j]) {
                    r.setLineWidth(new Integer(this.m_table.getValueAt(j, 2).toString()));
                }
                if (this.m_textChanged[j]) {
                    r.setText((String)this.m_table.getValueAt(j, 3));
                }
                if (this.m_valueChanged[j]) {
                    try {
                        double d = this.m_numberFormat.parse((String)this.m_table.getValueAt(j, 4)).doubleValue();
                        r.setLineValue(d);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (r != null) {
                    r.setAssociation(this.m_componentID);
                }
            }
            ++j;
        }
    }

    protected static int hexStringToInt(String str) {
        String noPound = str.substring(1);
        return Integer.parseInt(noPound, 16);
    }

    private void $init$() {
        this.m_colorPalette = null;
        this.m_bColorPaletteSet = false;
        this.m_focusOut = true;
        this._flag = false;
        this.rBundle = null;
        this._filter = new Filter();
        this.oldAnchorRow = 0;
        this.oldAnchorColumn = 0;
        this.editorFocus = false;
        this.m_colToSelect = 0;
        this.m_rowToSelect = 0;
        this.spacePressedInEditor = false;
        this.spacePressedInTable = false;
    }

    static void mav$_processTabKey(ReferenceLine referenceLine, KeyEvent keyEvent) {
        referenceLine._processTabKey(keyEvent);
    }

    static void wa$_flag(ReferenceLine referenceLine, boolean bl) {
        referenceLine._flag = bl;
    }

    static ResourceBundle ra$rBundle(ReferenceLine referenceLine) {
        return referenceLine.rBundle;
    }

    static void wa$spacePressedInEditor(ReferenceLine referenceLine, boolean bl) {
        referenceLine.spacePressedInEditor = bl;
    }

    static boolean ra$spacePressedInTable(ReferenceLine referenceLine) {
        return referenceLine.spacePressedInTable;
    }

    static void wa$spacePressedInTable(ReferenceLine referenceLine, boolean bl) {
        referenceLine.spacePressedInTable = bl;
    }

    static void wa$m_focusOut(ReferenceLine referenceLine, boolean bl) {
        referenceLine.m_focusOut = bl;
    }

    static Icon mav$_getColorIcon(ReferenceLine referenceLine, Image image, int n) {
        return referenceLine._getColorIcon(image, n);
    }

    static NumberFormat ra$m_numberFormat(ReferenceLine referenceLine) {
        return referenceLine.m_numberFormat;
    }

    static boolean ra$m_focusOut(ReferenceLine referenceLine) {
        return referenceLine.m_focusOut;
    }

    static int ra$m_rowToSelect(ReferenceLine referenceLine) {
        return referenceLine.m_rowToSelect;
    }

    static int ra$m_colToSelect(ReferenceLine referenceLine) {
        return referenceLine.m_colToSelect;
    }

    static boolean ra$spacePressedInEditor(ReferenceLine referenceLine) {
        return referenceLine.spacePressedInEditor;
    }

    static int ra$tableMnemonicKey(ReferenceLine referenceLine) {
        return referenceLine.tableMnemonicKey;
    }

    static boolean ra$_flag(ReferenceLine referenceLine) {
        return referenceLine._flag;
    }

    static void wa$m_rowToSelect(ReferenceLine referenceLine, int n) {
        referenceLine.m_rowToSelect = n;
    }

    static void wa$m_colToSelect(ReferenceLine referenceLine, int n) {
        referenceLine.m_colToSelect = n;
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ListSelectionModel rsm = ReferenceLine.this.m_table.getSelectionModel();
            int anchorRow = rsm.getAnchorSelectionIndex();
            ListSelectionModel csm = ReferenceLine.this.m_table.getColumnModel().getSelectionModel();
            int anchorColumn = csm.getAnchorSelectionIndex();
            ReferenceLine.this.m_table.editCellAt(anchorRow, anchorColumn);
            Component editor = ReferenceLine.this.m_table.getEditorComponent();
            if (editor != null) {
                editor.requestFocus();
            } else {
                ReferenceLine.this.m_table.requestFocus();
            }
        }
    }

    final class 2
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (ReferenceLine.this.getRootPane().getDefaultButton() != null) {
                ReferenceLine.this.getRootPane().getDefaultButton().requestFocus();
                ReferenceLine.this.m_table.getParent().dispatchEvent(new KeyEvent(ReferenceLine.this.m_table, 401, System.currentTimeMillis(), 0, 10, '\uffff'));
            }
        }
    }

    final class 3
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (!ReferenceLine.this.m_table.hasFocus()) {
                int row = ReferenceLine.this.m_table.getEditingRow();
                int col = ReferenceLine.this.m_table.getEditingColumn();
                if (row >= 0 && col >= 0) {
                    ReferenceLine.this.m_table.getCellEditor(row, col).cancelCellEditing();
                }
                ReferenceLine.this.m_table.requestFocus();
            } else {
                int selectedCol = ReferenceLine.this.m_table.getSelectedColumn();
                int selectedRow = ReferenceLine.this.m_table.getSelectedRow();
                if (selectedCol >= 0 && selectedCol < ReferenceLine.this.m_table.getColumnCount() && selectedRow >= 0 && selectedRow < ReferenceLine.this.m_table.getRowCount()) {
                    ReferenceLine.this.m_table.getCellEditor(selectedRow, selectedCol).cancelCellEditing();
                }
            }
            ReferenceLine.this.m_table.setRowSelectionInterval(0, 0);
            ReferenceLine.this.m_table.setColumnSelectionInterval(0, 0);
            ReferenceLine.wa$m_rowToSelect(ReferenceLine.this, 0);
            ReferenceLine.wa$m_colToSelect(ReferenceLine.this, 0);
        }
    }

    private class TabTextField
    extends JTextField
    implements FocusListener {
        private boolean keyTyped;
        private boolean startEditing;

        public TabTextField() {
            this.$init$();
            this.addFocusListener(this);
        }

        public TabTextField(Document doc, String text, int columns) {
            super(doc, text, columns);
            this.$init$();
            this.addFocusListener(this);
        }

        public void focusLost(FocusEvent e) {
        }

        public void focusGained(FocusEvent e) {
            this.keyTyped = false;
            ReferenceLine.wa$_flag(ReferenceLine.this, false);
            this.startEditing = false;
        }

        public void processMouseEvent(MouseEvent e) {
            this.startEditing = true;
            super.processMouseEvent(e);
        }

        public void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 9) {
                ReferenceLine.mav$_processTabKey(ReferenceLine.this, e);
            } else if (e.getKeyCode() == 0) {
                if (!this.keyTyped) {
                    this.selectAll();
                    return;
                }
            } else if (e.getKeyCode() == 32) {
                if (this.startEditing) {
                    this.keyTyped = true;
                } else {
                    this.startEditing = true;
                }
            } else if (!e.isActionKey() && e.getKeyCode() != 17 && e.getKeyCode() != 16 && e.getKeyCode() != 18 && e.getKeyCode() != 10) {
                this.keyTyped = true;
            }
            ReferenceLine.wa$_flag(ReferenceLine.this, this.keyTyped);
            super.processKeyEvent(e);
        }

        private void $init$() {
            this.keyTyped = false;
            this.startEditing = false;
        }
    }

    private class TabNumberTextField
    extends NumberTextField
    implements FocusListener {
        public boolean keyTyped;

        public TabNumberTextField() {
            this.$init$();
            this.addFocusListener(this);
        }

        public void focusLost(FocusEvent e) {
        }

        public void focusGained(FocusEvent e) {
            this.keyTyped = false;
            ReferenceLine.wa$_flag(ReferenceLine.this, false);
        }

        public boolean isValidValue() {
            return !this.getText().equals("-") && !this.getText().equals("+") && !this.getText().equals(".");
        }

        public void showErrorDialog() {
            String errorMsg = MessageFormat.format(ReferenceLine.ra$rBundle(ReferenceLine.this).getString("WrongCrossAtValue"), this.getText());
            JOptionPane jpane = new JOptionPane(errorMsg, 0, -1, new ImageIcon(ImageUtils.getImageResource(ReferenceLine.class, (String)"images/stop.gif")));
            jpane.getAccessibleContext().setAccessibleName(errorMsg);
            JDialog tmpDialog = jpane.createDialog(ReferenceLine.this.m_table, ReferenceLine.ra$rBundle(ReferenceLine.this).getString("Graph"));
            tmpDialog.show();
            SwingUtilities.invokeLater(new 1());
            this.selectAll();
        }

        public void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 9) {
                if (this.isValidValue()) {
                    ReferenceLine.mav$_processTabKey(ReferenceLine.this, e);
                } else {
                    this.showErrorDialog();
                    return;
                }
            }
            if (!e.isActionKey() && e.getKeyCode() != 17 && e.getKeyCode() != 16 && e.getKeyCode() != 18 && e.getKeyCode() != 10 && e.getKeyCode() != 0 && e.getKeyCode() != 32 && e.getKeyCode() != 521 && e.getKeyCode() != 45 && e.getKeyCode() != 46) {
                this.keyTyped = true;
            }
            ReferenceLine.wa$_flag(ReferenceLine.this, this.keyTyped);
            super.processKeyEvent(e);
        }

        private void $init$() {
            this.keyTyped = false;
        }

        final class 1
        implements Runnable {
            public void run() {
                TabNumberTextField.this.requestFocus();
            }
        }
    }

    private class TabCheckBox
    extends JCheckBox {
        public void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (e.getID() == 501) {
                ReferenceLine.wa$_flag(ReferenceLine.this, true);
            }
        }

        public void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 9) {
                ReferenceLine.mav$_processTabKey(ReferenceLine.this, e);
            } else {
                ReferenceLine.wa$_flag(ReferenceLine.this, true);
            }
            super.processKeyEvent(e);
        }
    }

    private class LightLineWidth
    extends LineWidth
    implements ActionListener {
        public LightLineWidth() {
            this.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        }

        public void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 9) {
                ReferenceLine.mav$_processTabKey(ReferenceLine.this, e);
            } else {
                if (e.getKeyCode() != 27 && !this.isPopupVisible()) {
                    ReferenceLine.this.m_table.requestFocus();
                    return;
                }
                if (e.getKeyCode() == 32) {
                    ReferenceLine.wa$spacePressedInEditor(ReferenceLine.this, true);
                    if (ReferenceLine.ra$spacePressedInTable(ReferenceLine.this)) {
                        ReferenceLine.wa$spacePressedInTable(ReferenceLine.this, false);
                        return;
                    }
                } else {
                    ReferenceLine.wa$spacePressedInEditor(ReferenceLine.this, false);
                }
            }
            super.processKeyEvent(e);
        }
    }

    private class ComboBoxCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        boolean stopEditing;

        private void $init$() {
            this.stopEditing = false;
        }

        public ComboBoxCellEditor(JComboBox comboBox) {
            super(comboBox);
            this.$init$();
            comboBox.addFocusListener(this);
            this.delegate = new 1(this, this, comboBox);
            comboBox.addItemListener(this.delegate);
        }

        public void fireEditingCanceled() {
            ReferenceLine.wa$_flag(ReferenceLine.this, false);
            super.fireEditingCanceled();
        }

        public void focusGained(FocusEvent e) {
            this.stopEditing = false;
            ReferenceLine.wa$m_focusOut(ReferenceLine.this, false);
        }

        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                this.stopEditing = true;
            }
        }

        static void mav$fireEditingStopped(ComboBoxCellEditor comboBoxCellEditor) {
            comboBoxCellEditor.fireEditingStopped();
        }

        final class 1
        extends DefaultCellEditor.EditorDelegate {
            private final /* synthetic */ JComboBox v$comboBox;
            final /* synthetic */ ComboBoxCellEditor this$0;

            public void actionPerformed(ActionEvent e) {
                if (this.this$0.stopEditing) {
                    ComboBoxCellEditor.mav$fireEditingStopped(this.this$0);
                } else {
                    this.this$0.stopEditing = true;
                }
            }

            public void itemStateChanged(ItemEvent e) {
                ReferenceLine.wa$_flag(this.this$0.ReferenceLine.this, true);
                ComboBoxCellEditor.mav$fireEditingStopped(this.this$0);
            }

            public void setValue(Object value) {
                this.v$comboBox.setSelectedItem(value);
            }

            public Object getCellEditorValue() {
                return this.v$comboBox.getSelectedItem();
            }

            public 1(ComboBoxCellEditor comboBoxCellEditor, DefaultCellEditor defaultCellEditor, JComboBox jComboBox) {
                this.v$comboBox = jComboBox;
                this.this$0 = comboBoxCellEditor;
                super(defaultCellEditor);
            }
        }
    }

    private class LineWidthEditor
    extends ComboBoxCellEditor {
        public LineWidthEditor(JComboBox box) {
            super(box);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.delegate.setValue(value.toString());
            LineWidth width = (LineWidth)this.editorComponent;
            if (ReferenceLine.this.lineWidth.getBackground().getRGB() == -1 && ((Color)ReferenceLine.this.m_table.getValueAt(row, 1)).getRGB() == -1) {
                width.setCellColor(Color.black);
            } else {
                width.setCellColor((Color)ReferenceLine.this.m_table.getValueAt(row, 1));
            }
            return this.editorComponent;
        }
    }

    private class Filter
    extends RGBImageFilter {
        private int _color;
        private final int _sCOLOR;

        public Filter() {
            this.$init$();
            this.canFilterIndexColorModel = true;
        }

        public void setColor(int i) {
            Color c = (Color)ReferenceLine.this.m_table.getValueAt(i, 1);
            if (c.getRGB() == -1) {
                c = Color.black;
            }
            this._color = c == null ? 0 : c.getRGB();
        }

        public int filterRGB(int x, int y, int rgb) {
            if (rgb == this._sCOLOR) {
                return this._color;
            }
            return rgb;
        }

        private void $init$() {
            this._sCOLOR = new Color(255, 0, 255).getRGB();
        }
    }

    class LineWidthRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder;
        Border selectedBorder;
        boolean isBordered;

        private void $init$() {
            this.unselectedBorder = null;
            this.selectedBorder = null;
            this.isBordered = true;
        }

        public LineWidthRenderer(boolean isBordered) {
            this.$init$();
            this.isBordered = isBordered;
            this.setBackground(Color.white);
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int width = new Integer(table.getValueAt(row, column).toString());
            this.setIcon(ReferenceLine.mav$_getColorIcon(ReferenceLine.this, ImageUtils.getImageResource(LineWidthRenderer.class, (String)("images/Line" + width + ".gif")), row));
            if (width == 1) {
                this.getAccessibleContext().setAccessibleName(ReferenceLine.ra$rBundle(ReferenceLine.this).getString("Single pixel"));
            } else {
                this.getAccessibleContext().setAccessibleName(MessageFormat.format(ReferenceLine.ra$rBundle(ReferenceLine.this).getString("pixels"), new Integer(width)));
            }
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black);
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            if (!hasFocus) {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, table.getBackground()));
            }
            return this;
        }
    }

    class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder;
        Border selectedBorder;
        boolean isBordered;

        private void $init$() {
            this.unselectedBorder = null;
            this.selectedBorder = null;
            this.isBordered = true;
        }

        public ColorRenderer(boolean isBordered) {
            this.$init$();
            this.isBordered = isBordered;
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            this.setText("");
            if (value instanceof Color) {
                this.setBackground((Color)value);
            } else {
                this.setBackground(Color.white);
            }
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black);
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            if (!hasFocus) {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, table.getBackground()));
            }
            return this;
        }

        public void cleanUp() {
            this.setBorder(null);
            this.unselectedBorder = null;
            this.selectedBorder = null;
        }
    }

    private class LabelRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null) {
                this.getAccessibleContext().setAccessibleName(value.toString());
            }
            renderer.setBackground(Color.white);
            renderer.setForeground(Color.black);
            if (isSelected) {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black));
            } else {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, table.getBackground()));
            }
            if (!hasFocus) {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, table.getBackground()));
            }
            return renderer;
        }

        private LabelRenderer() {
        }

        LabelRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class CheckBoxRenderer
    extends JPanel
    implements TableCellRenderer {
        JCheckBox checkBox;

        public CheckBoxRenderer() {
            this.setOpaque(true);
            this.setBackground(Color.white);
            this.setForeground(Color.black);
            this.setLayout(new BoxLayout(this, 0));
            this.checkBox = new JCheckBox();
            this.checkBox.setBackground(Color.white);
            this.checkBox.setForeground(Color.black);
            this.add(this.checkBox);
            this.checkBox.setAlignmentX(0.0f);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.checkBox.setSelected((Boolean)value);
            }
            this.checkBox.setText(ReferenceLine.this.m_referenceNames[row]);
            this.getAccessibleContext().setAccessibleName(this.checkBox.getText());
            if (isSelected) {
                this.setBorder(BorderFactory.createLineBorder(Color.black, 2));
            } else {
                this.setBorder(BorderFactory.createLineBorder(this.getBackground(), 2));
            }
            if (!hasFocus) {
                this.setBorder(BorderFactory.createLineBorder(this.getBackground(), 2));
            }
            return this;
        }
    }

    class ColorEditor
    extends DefaultCellEditor
    implements PropertyChangeListener {
        Color currentColor;

        private void $init$() {
            this.currentColor = null;
        }

        public ColorEditor(BIColorChoice b) {
            super(new JCheckBox());
            this.$init$();
            this.editorComponent = b;
            this.setClickCountToStart(1);
            this.editorComponent.addPropertyChangeListener(this);
            this.editorComponent.addKeyListener(new 1());
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("selectedColor")) {
                ReferenceLine.wa$_flag(ReferenceLine.this, true);
                this.fireEditingStopped();
            }
        }

        public void fireEditingStopped() {
            this.currentColor = ((BIColorChoice)this.editorComponent).getSelectedColor();
            super.fireEditingStopped();
        }

        public void fireEditingCanceled() {
            ReferenceLine.wa$_flag(ReferenceLine.this, false);
            super.fireEditingCanceled();
        }

        public Object getCellEditorValue() {
            return this.currentColor;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            BIColorChoice choice = (BIColorChoice)this.editorComponent;
            if (!ReferenceLine.this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)choice.getColorPalette(), (Color)((Color)value))) {
                    choice.setColorPalette(FontButton.getNewColorPalette((TwoDModel)choice.getColorPalette(), (Color)((Color)value), (boolean)ReferenceLine.this.m_bColorPaletteSet));
                }
                choice.setSelectedColor((Color)value);
            } else {
                choice.setSelectedColor(choice.getClosestColor((Color)value));
            }
            this.currentColor = (Color)value;
            return this.editorComponent;
        }

        final class 1
        extends KeyAdapter {
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ColorEditor.this.fireEditingCanceled();
                }
            }
        }
    }

    class CheckBoxEditor
    extends DefaultCellEditor
    implements ItemListener,
    FocusListener {
        public CheckBoxEditor(JCheckBox c) {
            super(c);
            c.removeItemListener(this);
            this.editorComponent = c;
            c.addItemListener(this);
            c.addFocusListener(this);
            this.setClickCountToStart(1);
        }

        public Object getCellEditorValue() {
            return new Boolean(((JCheckBox)this.editorComponent).isSelected());
        }

        public void itemStateChanged(ItemEvent e) {
            this.fireEditingStopped();
        }

        public void focusGained(FocusEvent e) {
            ReferenceLine.wa$m_focusOut(ReferenceLine.this, false);
        }

        public void focusLost(FocusEvent e) {
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ((JCheckBox)this.editorComponent).setSelected((Boolean)value);
            ((JCheckBox)this.editorComponent).setText(ReferenceLine.this.m_referenceNames[row]);
            return this.editorComponent;
        }
    }

    class TextFieldEditor
    extends DefaultCellEditor
    implements FocusListener,
    CaretListener {
        private JTextField textField;
        private int rowEdited;
        private int columnEdited;

        public TextFieldEditor(JTextField t) {
            super(t);
            this.textField = t;
            this.setClickCountToStart(1);
            this.textField.addFocusListener(this);
            this.textField.addCaretListener(this);
        }

        public void caretUpdate(CaretEvent e) {
            String text = this.textField.getText();
            int column = ReferenceLine.this.m_table.getEditingColumn();
            if (column < 0) {
                return;
            }
            int length = ReferenceLine.this.getToolkit().getFontMetrics(ReferenceLine.this.m_table.getFont()).stringWidth(ReferenceLine.this.m_names[column]) + 20;
            int i = 0;
            while (i < 3) {
                int newLength = 0;
                newLength = i == ReferenceLine.this.m_table.getEditingRow() ? ReferenceLine.this.getToolkit().getFontMetrics(ReferenceLine.this.m_table.getFont()).stringWidth(this.textField.getText()) : ReferenceLine.this.getToolkit().getFontMetrics(ReferenceLine.this.m_table.getFont()).stringWidth(ReferenceLine.this.m_table.getValueAt(i, column).toString());
                if (newLength > length) {
                    length = newLength;
                }
                ++i;
            }
            length += 10;
            if (column == 3) {
                ReferenceLine.this.m_labelColumn.setMaxWidth(length);
            } else {
                ReferenceLine.this.m_valueColumn.setMaxWidth(length);
            }
            ReferenceLine.this.m_table.revalidate();
        }

        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                if (this.textField instanceof TabNumberTextField) {
                    TabNumberTextField numTextField = (TabNumberTextField)((Object)this.textField);
                    if (numTextField.isValidValue()) {
                        this.fireEditingStopped();
                    } else if (numTextField.isShowing()) {
                        numTextField.showErrorDialog();
                    }
                } else {
                    this.fireEditingStopped();
                }
            }
        }

        public boolean stopCellEditing() {
            TabNumberTextField numTextField;
            if (this.textField instanceof TabNumberTextField && !(numTextField = (TabNumberTextField)((Object)this.textField)).isValidValue()) {
                return false;
            }
            return super.stopCellEditing();
        }

        public void fireEditingCanceled() {
            ReferenceLine.wa$_flag(ReferenceLine.this, false);
            super.fireEditingCanceled();
        }

        public void focusGained(FocusEvent e) {
            if (!ReferenceLine.this.m_table.isEditing()) {
                ReferenceLine.this.m_table.editCellAt(this.rowEdited, this.columnEdited);
            }
            if (ReferenceLine.this.m_table.getEditingColumn() != -1) {
                String name = ReferenceLine.this.m_names[ReferenceLine.this.m_table.getEditingColumn()];
                this.textField.getAccessibleContext().setAccessibleName(name);
            }
            this.textField.selectAll();
            ReferenceLine.wa$m_focusOut(ReferenceLine.this, false);
        }

        public Object getCellEditorValue() {
            if (this.textField instanceof NumberTextField) {
                if (this.textField.getText().length() == 0) {
                    return ReferenceLine.this.m_table.getValueAt(ReferenceLine.this.m_table.getEditingRow(), ReferenceLine.this.m_table.getEditingColumn());
                }
                if (((NumberTextField)this.textField).getNumber() != null) {
                    String val = ReferenceLine.ra$m_numberFormat(ReferenceLine.this).format(((NumberTextField)this.textField).getNumber().doubleValue());
                    return val;
                }
                return this.textField.getText();
            }
            return this.textField.getText();
        }
    }

    protected class ReferenceJTable
    extends JTable
    implements TableModelListener {
        private boolean helpKey;

        private void $init$() {
            this.helpKey = false;
        }

        public ReferenceJTable(Object[][] rowData, Object[] columnNames) {
            super(rowData, columnNames);
            this.$init$();
            this.getTableHeader().setReorderingAllowed(false);
        }

        public void setCellEditor(TableCellEditor editor) {
            super.setCellEditor(editor);
            if (editor != null) {
                ReferenceLine.wa$_flag(ReferenceLine.this, false);
            }
        }

        public void tableChanged(TableModelEvent e) {
            super.tableChanged(e);
            int column = e.getColumn();
            int row = e.getFirstRow();
            if (row < 0) {
                return;
            }
            if (!ReferenceLine.ra$_flag(ReferenceLine.this)) {
                return;
            }
            if (column == 0) {
                ReferenceLine.this.m_visibleChanged[row] = true;
                ReferenceLine.wa$_flag(ReferenceLine.this, false);
                return;
            }
            if (column == 1) {
                ReferenceLine.this.m_lineColorChanged[row] = true;
            } else if (column == 2) {
                ReferenceLine.this.m_lineWidthChanged[row] = true;
            } else if (column == 3) {
                ReferenceLine.this.m_textChanged[row] = true;
            } else if (column == 4) {
                ReferenceLine.this.m_valueChanged[row] = true;
            }
            if (!((Boolean)this.getValueAt(row, 0)).booleanValue()) {
                this.setValueAt(new Boolean(true), row, 0);
            }
            ReferenceLine.wa$_flag(ReferenceLine.this, false);
        }

        public void moveLeft() {
            this.requestFocus();
            int row = this.getSelectionModel().getAnchorSelectionIndex();
            int column = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (row == 0 && column == 0) {
                this.changeSelection(this.getRowCount() - 1, this.getColumnCount() - 1, false, false);
            } else if (column == 0) {
                this.changeSelection(row - 1, this.getColumnCount() - 1, false, false);
            } else {
                this.changeSelection(row, column - 1, false, false);
            }
            ReferenceLine.wa$_flag(ReferenceLine.this, false);
        }

        public void moveRight() {
            this.requestFocus();
            int row = this.getSelectionModel().getAnchorSelectionIndex();
            int column = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (row == this.getRowCount() - 1 && column == this.getColumnCount() - 1) {
                this.changeSelection(0, 0, false, false);
            } else if (column == this.getColumnCount() - 1) {
                this.changeSelection(row + 1, 0, false, false);
            } else {
                this.changeSelection(row, column + 1, false, false);
            }
            ReferenceLine.wa$_flag(ReferenceLine.this, false);
        }

        public void columnMarginChanged(ChangeEvent e) {
            TableCellEditor editor;
            if (this.isEditing() && (editor = this.getCellEditor()) != null) {
                Object value = editor.getCellEditorValue();
                this.setValueAt(value, this.getEditingRow(), this.getEditingColumn());
            }
            this.resizeAndRepaint();
        }

        protected void processKeyEvent(KeyEvent e) {
            int anchorRow = this.getSelectionModel().getAnchorSelectionIndex();
            int anchorColumn = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (e.getKeyCode() == 9 || e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                if (e.getKeyCode() == 9) {
                    if (e.isControlDown()) {
                        if (e.getID() != 402) {
                            this.getCellEditor(anchorRow, anchorColumn).stopCellEditing();
                            if (!e.isShiftDown()) {
                                FocusManager.getCurrentManager().focusNextComponent(this);
                            } else {
                                FocusManager.getCurrentManager().focusPreviousComponent(this);
                            }
                            ReferenceLine.this.resetFocus();
                        }
                    } else {
                        if (anchorColumn == this.getColumnCount() - 1 && anchorRow == this.getRowCount() - 1 && !e.isShiftDown() && e.getID() != 402) {
                            this.getCellEditor(anchorRow, anchorColumn).stopCellEditing();
                            if (FocusManager.isFocusManagerEnabled()) {
                                FocusManager.getCurrentManager().focusNextComponent(this);
                                e.consume();
                            }
                            return;
                        }
                        if (anchorColumn == 0 && anchorRow == 0 && e.isShiftDown() && e.getID() != 402) {
                            if (FocusManager.isFocusManagerEnabled()) {
                                FocusManager.getCurrentManager().focusPreviousComponent(this);
                                e.consume();
                            }
                            return;
                        }
                    }
                } else if (e.getKeyCode() == 40 && e.isAltDown() && e.getID() != 402 && (anchorColumn == 1 || anchorColumn == 2)) {
                    this.editCellAt(anchorRow, anchorColumn);
                    ReferenceLine.wa$_flag(ReferenceLine.this, false);
                    this.getEditorComponent().requestFocus();
                    if (this.getEditorComponent() instanceof JComboBox) {
                        this.getEditorComponent().setVisible(true);
                        ((JComboBox)this.getEditorComponent()).showPopup();
                    }
                }
            } else if (e.getKeyCode() == 32 && anchorColumn != 0) {
                if (!ReferenceLine.ra$spacePressedInEditor(ReferenceLine.this)) {
                    this.editCellAt(anchorRow, anchorColumn);
                    ReferenceLine.wa$_flag(ReferenceLine.this, false);
                    this.getEditorComponent().requestFocus();
                    if (this.getEditorComponent() instanceof JComboBox) {
                        this.getEditorComponent().setVisible(true);
                        ((JComboBox)this.getEditorComponent()).showPopup();
                    }
                    ReferenceLine.wa$spacePressedInTable(ReferenceLine.this, true);
                } else {
                    ReferenceLine.wa$spacePressedInEditor(ReferenceLine.this, false);
                }
            } else if (e.getKeyCode() == 72) {
                if (e.isAltDown() && e.getID() != 402) {
                    this.helpKey = true;
                } else if (anchorColumn == 3 || anchorColumn == 4) {
                    return;
                }
            } else if (!(anchorColumn != 3 && anchorColumn != 4 || this.isEditing() || e.getKeyCode() == 10 || e.isAltDown() && e.getKeyCode() == ReferenceLine.ra$tableMnemonicKey(ReferenceLine.this))) {
                return;
            }
            super.processKeyEvent(e);
        }

        protected void processFocusEvent(FocusEvent e) {
            if (e.getID() == 1004) {
                if (ReferenceLine.ra$m_focusOut(ReferenceLine.this)) {
                    int selectedCol = this.getSelectedColumn();
                    int selectedRow = this.getSelectedRow();
                    if (selectedCol >= 0 && selectedCol < this.getColumnCount() && selectedRow >= 0 && selectedRow < this.getRowCount()) {
                        this.getCellEditor(selectedRow, selectedCol).cancelCellEditing();
                    }
                    this.setRowSelectionInterval(ReferenceLine.ra$m_rowToSelect(ReferenceLine.this), ReferenceLine.ra$m_rowToSelect(ReferenceLine.this));
                    this.setColumnSelectionInterval(ReferenceLine.ra$m_colToSelect(ReferenceLine.this), ReferenceLine.ra$m_colToSelect(ReferenceLine.this));
                    ReferenceLine.wa$m_focusOut(ReferenceLine.this, false);
                }
            } else if (e.getID() == 1005 && this.helpKey) {
                int selectedCol = this.getSelectedColumn();
                int selectedRow = this.getSelectedRow();
                if (selectedCol >= 0 && selectedCol < this.getColumnCount() && selectedRow >= 0 && selectedRow < this.getRowCount()) {
                    this.getCellEditor(selectedRow, selectedCol).cancelCellEditing();
                }
                this.helpKey = false;
            }
            super.processFocusEvent(e);
        }
    }
}

