/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.dss.graph.gui.GraphStandardStyles;
import oracle.dss.graph.gui.StyleListEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleList
extends ArrayList {
    private ResourceBundle _bundle;
    private int defaultIndex;
    private int customIndex;

    public StyleList(int size) {
        super(size);
        this.$init$();
    }

    public StyleList(StyleList list) {
        super(list);
        this.$init$();
    }

    public void setLocale(Locale locale) {
        int i = 0;
        while (i < this.size()) {
            StyleListEntry entry = this.getStyleListEntry(i);
            if (entry != null) {
                entry.setLocale(locale);
            }
            ++i;
        }
    }

    public StyleListEntry getStyleListEntry(int index) {
        return (StyleListEntry)this.get(index);
    }

    public int getStyleIndex(String stylePath) {
        if (stylePath == null) {
            return this.getDefaultStyleIndex();
        }
        StyleListEntry entry = new StyleListEntry(stylePath, "", null);
        return this.indexOf(entry);
    }

    public int getDefaultStyleIndex() {
        if (this.defaultIndex == -1) {
            this.addRequiredStyles();
        }
        return this.defaultIndex;
    }

    public int getCustomStyleIndex() {
        if (this.customIndex == -1) {
            this.setRequiredStyleIndices();
        }
        return this.customIndex;
    }

    public int addCustomStyle() {
        if (this.customIndex == -1) {
            this.setRequiredStyleIndices();
            if (this.customIndex == -1) {
                StyleListEntry customEntry = GraphStandardStyles.CUSTOM_STYLE;
                this.customIndex = this.size();
                this.add(this.customIndex, customEntry);
            }
        }
        return this.customIndex;
    }

    public void addRequiredStyles() {
        this.setRequiredStyleIndices();
        if (this.defaultIndex == -1) {
            StyleListEntry defaultEntry = GraphStandardStyles.DEFAULT_STYLE;
            this.add(0, defaultEntry);
        }
    }

    private void setRequiredStyleIndices() {
        StyleListEntry defaultEntry = GraphStandardStyles.DEFAULT_STYLE;
        StyleListEntry customEntry = GraphStandardStyles.CUSTOM_STYLE;
        int i = 0;
        while (i < this.size()) {
            StyleListEntry entry = this.getStyleListEntry(i);
            if (entry != null) {
                if (entry == defaultEntry) {
                    this.defaultIndex = i;
                } else if (entry == customEntry) {
                    this.customIndex = i;
                }
            }
            ++i;
        }
    }

    private void $init$() {
        this.defaultIndex = -1;
        this.customIndex = -1;
    }
}

