/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.UIView;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.graph.Graph;
import oracle.dss.graph.Type;
import oracle.dss.graph.UIGraphType;
import oracle.dss.graph.gui.GraphTypeConverterAdapter;
import oracle.dss.graph.gui.LegendTool;

public class ThreeDEffectTool
extends JToggleButton
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    public static final String PROPERTY_THREED_EFFECT = "ThreeDEffect";
    protected Object m_currentDataView;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private ResourceBundle rBundle;
    protected boolean m_enable;
    private MouseListener m_mouseListener;
    protected boolean m_bRolloverIconEnabled;

    public ThreeDEffectTool() {
        this.$init$();
        this.setMargin(insets0);
        this.setEnabled(false);
        this.setIcon(this.makeImage("images/s_threeD_18t.gif"));
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
        this.addActionListener(this);
        this.setBorderPainted(false);
        this.updateResourceBundle(Locale.getDefault());
        this.setToolTipText(this.rBundle.getString("ShowThreeD"));
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            this.setPreferredSize(new Dimension(24, 24));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
            this.m_mouseListener = new 1();
            this.addMouseListener(this.m_mouseListener);
        }
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
        this.setToolTipText(this.rBundle.getString("ShowThreeD"));
    }

    public void selectedAction(ControllerEvent e, UIView currentDataView, ToolBar toolBar) {
        this.m_enable = false;
        if (currentDataView instanceof Graph) {
            this.setSelected(((Graph)currentDataView).is3DEffect());
            this.setBorderPainted(this.isSelected());
            this.m_currentDataView = currentDataView;
            int type = ((Graph)this.m_currentDataView).getGraphTypeConverter().getTypeAndSubtype((UIGraphType)((Graph)this.m_currentDataView)).type;
            Type graphType = ((GraphTypeConverterAdapter)((Graph)this.m_currentDataView).getGraphTypeConverter()).getType(type);
            if (graphType != null && graphType.supports3D && graphType.supportsNon3D && ((Graph)this.m_currentDataView).getGraphType() != 67 && ((Graph)this.m_currentDataView).getGraphType() != 69) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        } else {
            this.m_currentDataView = null;
            this.setEnabled(false);
        }
        this.m_enable = true;
    }

    public void actionPerformed(ActionEvent e) {
        if (e == null || !this.m_enable) {
            return;
        }
        if (e.getSource() == this) {
            ((Graph)this.m_currentDataView).set3DEffect(this.isSelected());
            this.setBorderPainted(this.isSelected());
            this.firePropertyChange(PROPERTY_THREED_EFFECT, this.isSelected() ^ true, this.isSelected());
        }
    }

    public void update() {
        if (this.m_currentDataView == null) {
            return;
        }
        int type = ((Graph)this.m_currentDataView).getGraphTypeConverter().getTypeAndSubtype((UIGraphType)((Graph)this.m_currentDataView)).type;
        Type graphType = ((GraphTypeConverterAdapter)((Graph)this.m_currentDataView).getGraphTypeConverter()).getType(type);
        if (graphType.supports3D && graphType.supportsNon3D && ((Graph)this.m_currentDataView).getGraphType() != 67 && ((Graph)this.m_currentDataView).getGraphType() != 69) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    private ImageIcon makeImage(String fileName) {
        return new ImageIcon(ImageUtils.getImageResource(LegendTool.class, (String)fileName));
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    public void cleanUp() {
        this.removeMouseListener(this.m_mouseListener);
        this.removeActionListener(this);
    }

    public void setRolloverIconEnabled(boolean bEnabled) {
        this.m_bRolloverIconEnabled = bEnabled;
    }

    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    private void $init$() {
        this.m_currentDataView = null;
        this.rBundle = null;
        this.m_enable = true;
        this.m_bRolloverIconEnabled = false;
    }

    final class 1
    extends MouseAdapter {
        public void mouseEntered(MouseEvent e) {
            if (!ThreeDEffectTool.this.isRolloverIconEnabled()) {
                ThreeDEffectTool.this.setBorderPainted(true);
            }
            if (!ThreeDEffectTool.this.isEnabled()) {
                ThreeDEffectTool.this.setBorderPainted(ThreeDEffectTool.this.isSelected());
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!ThreeDEffectTool.this.isRolloverIconEnabled()) {
                ThreeDEffectTool.this.setBorderPainted(ThreeDEffectTool.this.isSelected());
            }
        }
    }
}

