/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphFootnote;
import oracle.dss.graph.GraphSubtitle;
import oracle.dss.graph.GraphTitle;
import oracle.dss.graph.gui.BasePanel;
import oracle.dss.graph.gui.GraphGUINames;
import oracle.dss.util.gui.FontButton;
import oracle.dss.util.gui.InsertButton;
import oracle.dss.util.gui.LimitedTextDocument;
import oracle.dss.util.gui.ViewTextField;
import oracle.dss.util.help.HelpContext;

public class Title
extends BasePanel
implements ActionListener,
ItemListener,
PropertyChangeListener,
CaretListener,
HelpContext {
    public static final String PROPERTY_TITLE_VISIBLE = "Title Visible";
    public static final String PROPERTY_SUBTITLE_VISIBLE = "Subtitle Visible";
    public static final String PROPERTY_FOOTNOTE_VISIBLE = "Footnote Visible";
    public static final String PROPERTY_TITLE_TEXT = "Title Text";
    public static final String PROPERTY_SUBTITLE_TEXT = "Subtitle Text";
    public static final String PROPERTY_FOOTNOTE_TEXT = "Footnote Text";
    protected boolean m_showTitle;
    protected boolean m_showSubtitle;
    protected boolean m_showFootnote;
    protected JCheckBox m_shTitleCBox;
    protected JCheckBox m_shSubtitleCBox;
    protected JCheckBox m_shFootnoteCBox;
    protected ViewTextField m_TitleTxt;
    protected ViewTextField m_SubtitleTxt;
    protected ViewTextField m_FootnoteTxt;
    protected ViewTextField m_TextArea;
    protected Font m_TitleFont;
    protected Font m_SubtitleFont;
    protected Font m_FootnoteFont;
    protected Font m_Font;
    protected int m_textRotation;
    protected int m_TitleTextRotation;
    protected int m_SubtitleTextRotation;
    protected int m_FootnoteTextRotation;
    protected FontButton m_TitleFontButton;
    protected FontButton m_SubtitleFontButton;
    protected FontButton m_FootnoteFontButton;
    protected InsertButton m_InsertTitle;
    protected InsertButton m_InsertSubtitle;
    protected InsertButton m_InsertFootnote;
    protected InsertButton m_Insert;
    protected TokenSubstitution m_token;
    protected boolean m_bFontNameChange;
    protected boolean m_bFontStyleChange;
    protected boolean m_bFontSizeChange;
    protected boolean m_bHorizontalAlignmentChange;
    protected boolean m_bFontColorChange;
    protected boolean m_bTextRotationChange;
    protected boolean m_bHelpEnabled;
    protected boolean m_bTitleFontNameChanged;
    protected boolean m_bTitleFontBoldChanged;
    protected boolean m_bTitleFontItalicChanged;
    protected boolean m_bTitleFontUnderlineChanged;
    protected boolean m_bTitleFontSizeChanged;
    protected boolean m_bTitleAlignmentChanged;
    protected boolean m_bTitleFontColorChanged;
    protected boolean m_bTitleVisibleChanged;
    protected boolean m_bTitleRotationChanged;
    protected boolean m_bSubtitleFontNameChanged;
    protected boolean m_bSubtitleFontBoldChanged;
    protected boolean m_bSubtitleFontItalicChanged;
    protected boolean m_bSubtitleFontUnderlineChanged;
    protected boolean m_bSubtitleFontSizeChanged;
    protected boolean m_bSubtitleAlignmentChanged;
    protected boolean m_bSubtitleFontColorChanged;
    protected boolean m_bSubtitleVisibleChanged;
    protected boolean m_bSubtitleRotationChanged;
    protected boolean m_bFootnoteFontNameChanged;
    protected boolean m_bFootnoteFontBoldChanged;
    protected boolean m_bFootnoteFontItalicChanged;
    protected boolean m_bFootnoteFontUnderlineChanged;
    protected boolean m_bFootnoteFontSizeChanged;
    protected boolean m_bFootnoteAlignmentChanged;
    protected boolean m_bFootnoteFontColorChanged;
    protected boolean m_bFootnoteVisibleChanged;
    protected boolean m_bFootnoteRotationChanged;
    protected boolean m_bTitleTextChanged;
    protected boolean m_bSubtitleTextChanged;
    protected boolean m_bFootnoteTextChanged;
    protected String m_oldFontName;
    protected String m_newFontName;
    protected int m_oldFontStyle;
    protected int m_newFontStyle;
    protected int m_oldFontSize;
    protected int m_newFontSize;
    protected int m_oldHAlignment;
    protected int m_newHAlignment;
    protected int m_oldRotation;
    protected int m_newRotation;
    protected Color m_oldFontColor;
    protected Color m_newFontColor;
    protected Color m_oldFontBackgroundColor;
    protected Color m_newFontBackgroundColor;
    protected String m_oldTitle;
    protected String m_oldSubtitle;
    protected String m_oldFootnote;
    protected HelpProvider m_helpProvider;
    protected String m_strHelpContextID;
    protected Dimension prefSize;
    protected boolean insertButtonVisible;
    private ResourceBundle rBundle;
    private boolean m_bSuperCalled;
    private JPanel titlePanel;
    private JPanel subtitlePanel;
    private JPanel footnotePanel;
    private String[] tokenArray;

    public Title(Graph graphView) {
        super(graphView);
        this.$init$();
        this.m_bSuperCalled = true;
        this.m_graph = graphView;
        this.updateResourceBundle(this.m_graph.getLocale());
        this.init();
        this.constructPanel();
    }

    public void setGraph(Graph graphView) {
        super.setGraph(graphView);
        this.initFromGraph();
        this.resetValues();
    }

    public void setColorPalette(Color[][] colors) {
        this.m_TitleFontButton.setColorPalette(colors);
        this.m_SubtitleFontButton.setColorPalette(colors);
        this.m_FootnoteFontButton.setColorPalette(colors);
    }

    public Color[][] getColorPalette() {
        return this.m_TitleFontButton.getColorPalette();
    }

    public void cleanUp() {
    }

    private void init() {
        this.m_showTitle = this.m_graph.getTitle().isVisible();
        this.m_showSubtitle = this.m_graph.getSubtitle().isVisible();
        this.m_showFootnote = this.m_graph.getFootnote().isVisible();
        this.m_token = this.m_graph.getTokenSubstitution();
        if (this.m_token != null) {
            this.tokenArray = this.m_token.getListItems();
            int i = 0;
            while (i < this.tokenArray.length) {
                this.tokenArray[i] = this.m_token.getToken(this.tokenArray[i]);
                ++i;
            }
        }
        this.initTitle();
        this.initSubtitle();
        this.initFootnote();
    }

    private void initFromGraph() {
        this.m_showTitle = this.m_graph.getTitle().isVisible();
        this.m_showSubtitle = this.m_graph.getSubtitle().isVisible();
        this.m_showFootnote = this.m_graph.getFootnote().isVisible();
        this.m_token = this.m_graph.getTokenSubstitution();
        this.m_TitleFont = this.m_graph.getTitle().getFont();
        this.m_SubtitleFont = this.m_graph.getSubtitle().getFont();
        this.m_FootnoteFont = this.m_graph.getFootnote().getFont();
        this.m_InsertTitle.removeActionListener((ActionListener)this);
        this.m_InsertSubtitle.removeActionListener((ActionListener)this);
        this.m_InsertFootnote.removeActionListener((ActionListener)this);
        this.m_InsertTitle.setModel(new DefaultComboBoxModel<String>(this.m_token.getListItems()));
        this.m_shTitleCBox.setSelected(this.m_showTitle);
        this.m_TitleTxt.setText(this.m_token.getTokenString(this.m_graph.getTitle().getUnParseText()));
        this.m_TitleTxt.setFont(new Font(this.m_TitleFont.getName(), this.m_TitleFont.getStyle(), this.m_TitleTxt.getFont().getSize()));
        this.m_TitleTxt.setHorizontalAlignment(this.m_graph.getTitle().getHorizontalAlignment());
        this.m_TitleTxt.setForeground(((GraphTitle)this.m_graph.getTitle()).getGraphFont().getGraphFontColor());
        if (this.m_TitleTxt.getText() != null) {
            this.m_TitleTxt.setCaretPosition(this.m_TitleTxt.getText().length());
        }
        this.m_TitleFontButton.setComponentFont(this.m_TitleFont);
        if (((GraphTitle)this.m_graph.getTitle()).getGraphFont().getGraphFontStyle() >= 4) {
            this.m_TitleFontButton.setUnderlineStyle(true);
            this.m_TitleTxt.setUnderline(true);
        } else {
            this.m_TitleFontButton.setUnderlineStyle(false);
            this.m_TitleTxt.setUnderline(false);
        }
        this.m_TitleFontButton.setPaneHorizontalAlignment(this.m_TitleTxt.getHorizontalAlignment());
        this.m_TitleFontButton.setComponentForeground(((GraphTitle)this.m_graph.getTitle()).getGraphFont().getGraphFontColor());
        this.m_TitleFontButton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_InsertSubtitle.setModel(new DefaultComboBoxModel<String>(this.m_token.getListItems()));
        this.m_shSubtitleCBox.setSelected(this.m_showSubtitle);
        this.m_SubtitleTxt.setText(this.m_token.getTokenString(this.m_graph.getSubtitle().getUnParseText()));
        this.m_SubtitleTxt.setFont(new Font(this.m_SubtitleFont.getName(), this.m_SubtitleFont.getStyle(), this.m_SubtitleTxt.getFont().getSize()));
        this.m_SubtitleTxt.setHorizontalAlignment(this.m_graph.getSubtitle().getHorizontalAlignment());
        this.m_SubtitleTxt.setForeground(((GraphSubtitle)this.m_graph.getSubtitle()).getGraphFont().getGraphFontColor());
        if (this.m_SubtitleTxt.getText() != null) {
            this.m_SubtitleTxt.setCaretPosition(this.m_SubtitleTxt.getText().length());
        }
        this.m_SubtitleFontButton.setComponentFont(this.m_SubtitleFont);
        if (((GraphSubtitle)this.m_graph.getSubtitle()).getGraphFont().getGraphFontStyle() >= 4) {
            this.m_SubtitleFontButton.setUnderlineStyle(true);
            this.m_SubtitleTxt.setUnderline(true);
        } else {
            this.m_SubtitleFontButton.setUnderlineStyle(false);
            this.m_SubtitleTxt.setUnderline(false);
        }
        this.m_SubtitleFontButton.setPaneHorizontalAlignment(this.m_SubtitleTxt.getHorizontalAlignment());
        this.m_SubtitleFontButton.setComponentForeground(((GraphSubtitle)this.m_graph.getSubtitle()).getGraphFont().getGraphFontColor());
        this.m_SubtitleFontButton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_InsertFootnote.setModel(new DefaultComboBoxModel<String>(this.m_token.getListItems()));
        this.m_shFootnoteCBox.setSelected(this.m_showFootnote);
        this.m_FootnoteTxt.setText(this.m_token.getTokenString(this.m_graph.getFootnote().getUnParseText()));
        this.m_FootnoteTxt.setFont(new Font(this.m_FootnoteFont.getName(), this.m_FootnoteFont.getStyle(), this.m_FootnoteTxt.getFont().getSize()));
        this.m_FootnoteTxt.setHorizontalAlignment(this.m_graph.getFootnote().getHorizontalAlignment());
        this.m_FootnoteTxt.setForeground(((GraphFootnote)this.m_graph.getFootnote()).getGraphFont().getGraphFontColor());
        if (this.m_FootnoteTxt.getText() != null) {
            this.m_FootnoteTxt.setCaretPosition(this.m_FootnoteTxt.getText().length());
        }
        this.m_FootnoteFontButton.setComponentFont(this.m_FootnoteFont);
        if (((GraphFootnote)this.m_graph.getFootnote()).getGraphFont().getGraphFontStyle() >= 4) {
            this.m_FootnoteFontButton.setUnderlineStyle(true);
            this.m_FootnoteTxt.setUnderline(true);
        } else {
            this.m_FootnoteFontButton.setUnderlineStyle(false);
            this.m_FootnoteTxt.setUnderline(false);
        }
        this.m_FootnoteFontButton.setPaneHorizontalAlignment(this.m_FootnoteTxt.getHorizontalAlignment());
        this.m_FootnoteFontButton.setComponentForeground(((GraphFootnote)this.m_graph.getFootnote()).getGraphFont().getGraphFontColor());
        this.m_FootnoteFontButton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_TitleFontButton.setTextRotation(this.convertToFontButtonConstants(((GraphTitle)this.m_graph.getTitle()).getTextRotation()));
        this.m_SubtitleFontButton.setTextRotation(this.convertToFontButtonConstants(((GraphSubtitle)this.m_graph.getSubtitle()).getTextRotation()));
        this.m_FootnoteFontButton.setTextRotation(this.convertToFontButtonConstants(((GraphFootnote)this.m_graph.getFootnote()).getTextRotation()));
        this.m_InsertTitle.addActionListener((ActionListener)this);
        this.m_InsertSubtitle.addActionListener((ActionListener)this);
        this.m_InsertFootnote.addActionListener((ActionListener)this);
    }

    private void constructPanel() {
        int sbutton = 7;
        int abutton = 30;
        int rbutton = 14;
        if (this.m_graph.getAutoLayout() != 0) {
            rbutton = 0;
        }
        String aboutPanelStr = this.rBundle.getString("titles text");
        this.setTitleText(aboutPanelStr);
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 1));
        this.titlePanel = new JPanel();
        this.titlePanel.setLayout(new BoxLayout(this.titlePanel, 0));
        String translatedText = this.rBundle.getString("Show Title");
        this.m_shTitleCBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_shTitleCBox.setName(GraphGUINames.SHOWTITLE_CHECKBOX);
        this.m_shTitleCBox.setAlignmentY(1.0f);
        this.m_shTitleCBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_shTitleCBox.setSelected(this.m_showTitle);
        this.titlePanel.add(this.m_shTitleCBox);
        JPanel subPanel1 = new JPanel();
        subPanel1.setLayout(new BoxLayout(subPanel1, 0));
        subPanel1.setAlignmentY(1.0f);
        this.m_InsertTitle = new InsertButton((Object[])this.m_token.getListItems());
        this.m_InsertTitle.setName(GraphGUINames.INSERTTITLE_BUTTON);
        this.m_InsertTitle.setAlignmentY(1.0f);
        this.m_InsertTitle.setLocale(this.m_graph.getLocale());
        this.m_InsertTitle.setType(0);
        translatedText = this.rBundle.getString("Title Font");
        this.m_TitleFontButton = new FontButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_TitleFontButton.setName(GraphGUINames.TITLEFONT_BUTTON);
        this.m_TitleFontButton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_TitleFontButton.setAlignmentY(1.0f);
        this.m_TitleFontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = this.rBundle.getString("Title Font For FontButton");
        this.m_TitleFontButton.setDialogTitle(translatedText);
        this.m_TitleFontButton.setPaneLocale(this.m_graph.getLocale());
        this.m_TitleFontButton.setComponentFont(this.m_TitleFont);
        if (((GraphTitle)this.m_graph.getTitle()).getGraphFont().getGraphFontStyle() >= 4) {
            this.m_TitleFontButton.setUnderlineStyle(true);
            this.m_TitleTxt.setUnderline(true);
        }
        int scAlign = this.m_TitleTxt.getHorizontalAlignment();
        this.m_TitleFontButton.setPaneHorizontalAlignment(scAlign);
        this.m_TitleFontButton.setStyleButtonMask(sbutton);
        this.m_TitleFontButton.setAlignmentButtonMask(abutton);
        this.m_TitleFontButton.setRotationButtonMask(rbutton);
        this.m_TitleFontButton.setColorComponentMask(1);
        this.m_TitleFontButton.setComponentForeground(((GraphTitle)this.m_graph.getTitle()).getGraphFont().getGraphFontColor());
        subPanel1.add((Component)this.m_InsertTitle);
        subPanel1.add(Box.createHorizontalStrut(10));
        subPanel1.add((Component)this.m_TitleFontButton);
        JPanel flowPanel1 = new JPanel(new FlowLayout(2, 0, 0));
        flowPanel1.setAlignmentY(1.0f);
        flowPanel1.add(subPanel1);
        this.titlePanel.add(flowPanel1);
        int pWidth = this.m_shTitleCBox.getPreferredSize().width + subPanel1.getPreferredSize().width;
        int pHeight = Math.max(subPanel1.getPreferredSize().height, this.m_shTitleCBox.getPreferredSize().height);
        this.titlePanel.setPreferredSize(new Dimension(pWidth, pHeight));
        this.titlePanel.setMinimumSize(this.titlePanel.getPreferredSize());
        this.titlePanel.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, pHeight));
        this.subtitlePanel = new JPanel();
        this.subtitlePanel.setLayout(new BoxLayout(this.subtitlePanel, 0));
        translatedText = this.rBundle.getString("Show Subtitle");
        this.m_shSubtitleCBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_shSubtitleCBox.setName(GraphGUINames.SHOWSUBTITLE_CHECKBOX);
        this.m_shSubtitleCBox.setAlignmentY(1.0f);
        this.m_shSubtitleCBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_shSubtitleCBox.setSelected(this.m_showSubtitle);
        this.subtitlePanel.add(this.m_shSubtitleCBox);
        JPanel subPanel2 = new JPanel();
        subPanel2.setLayout(new BoxLayout(subPanel2, 0));
        subPanel2.setAlignmentY(1.0f);
        this.m_InsertSubtitle = new InsertButton((Object[])this.m_token.getListItems());
        this.m_InsertSubtitle.setName(GraphGUINames.INSERTSUBTITLE_BUTTON);
        this.m_InsertSubtitle.setAlignmentY(1.0f);
        this.m_InsertSubtitle.setLocale(this.m_graph.getLocale());
        this.m_InsertSubtitle.setType(1);
        translatedText = this.rBundle.getString("Subtitle Font");
        this.m_SubtitleFontButton = new FontButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_SubtitleFontButton.setName(GraphGUINames.SUBTITLEFONT_BUTTON);
        this.m_SubtitleFontButton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_SubtitleFontButton.setAlignmentY(1.0f);
        this.m_SubtitleFontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = this.rBundle.getString("Subtitle Font For FontButton");
        this.m_SubtitleFontButton.setDialogTitle(translatedText);
        this.m_SubtitleFontButton.setPaneLocale(this.m_graph.getLocale());
        this.m_SubtitleFontButton.setComponentFont(this.m_SubtitleFont);
        if (((GraphSubtitle)this.m_graph.getSubtitle()).getGraphFont().getGraphFontStyle() >= 4) {
            this.m_SubtitleFontButton.setUnderlineStyle(true);
            this.m_SubtitleTxt.setUnderline(true);
        }
        scAlign = this.m_SubtitleTxt.getHorizontalAlignment();
        this.m_SubtitleFontButton.setPaneHorizontalAlignment(scAlign);
        this.m_SubtitleFontButton.setStyleButtonMask(sbutton);
        this.m_SubtitleFontButton.setAlignmentButtonMask(abutton);
        this.m_SubtitleFontButton.setRotationButtonMask(rbutton);
        this.m_SubtitleFontButton.setColorComponentMask(1);
        this.m_SubtitleFontButton.setComponentForeground(((GraphSubtitle)this.m_graph.getSubtitle()).getGraphFont().getGraphFontColor());
        subPanel2.add((Component)this.m_InsertSubtitle);
        subPanel2.add(Box.createHorizontalStrut(10));
        subPanel2.add((Component)this.m_SubtitleFontButton);
        JPanel flowPanel2 = new JPanel(new FlowLayout(2, 0, 0));
        flowPanel2.setAlignmentY(1.0f);
        flowPanel2.add(subPanel2);
        this.subtitlePanel.add(flowPanel2);
        pWidth = this.m_shSubtitleCBox.getPreferredSize().width + subPanel2.getPreferredSize().width;
        pHeight = Math.max(subPanel2.getPreferredSize().height, this.m_shSubtitleCBox.getPreferredSize().height);
        this.subtitlePanel.setPreferredSize(new Dimension(pWidth, pHeight));
        this.subtitlePanel.setMinimumSize(this.subtitlePanel.getPreferredSize());
        this.subtitlePanel.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, pHeight));
        this.footnotePanel = new JPanel();
        this.footnotePanel.setLayout(new BoxLayout(this.footnotePanel, 0));
        translatedText = this.rBundle.getString("Show Footnote");
        this.m_shFootnoteCBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_shFootnoteCBox.setName(GraphGUINames.SHOWFOOTNOTE_CHECKBOX);
        this.m_shFootnoteCBox.setAlignmentY(1.0f);
        this.m_shFootnoteCBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_shFootnoteCBox.setSelected(this.m_showFootnote);
        this.footnotePanel.add(this.m_shFootnoteCBox);
        JPanel subPanel3 = new JPanel();
        subPanel3.setLayout(new BoxLayout(subPanel3, 0));
        subPanel3.setAlignmentY(1.0f);
        this.m_InsertFootnote = new InsertButton((Object[])this.m_token.getListItems());
        this.m_InsertFootnote.setName(GraphGUINames.INSERTFOOTNOTE_BUTTON);
        this.m_InsertFootnote.setAlignmentY(1.0f);
        this.m_InsertFootnote.setLocale(this.m_graph.getLocale());
        this.m_InsertFootnote.setType(2);
        translatedText = this.rBundle.getString("Footnote Font");
        this.m_FootnoteFontButton = new FontButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_FootnoteFontButton.setName(GraphGUINames.FOOTNOTEFONT_BUTTON);
        this.m_FootnoteFontButton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_FootnoteFontButton.setAlignmentY(1.0f);
        this.m_FootnoteFontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = this.rBundle.getString("Footnote Font For FontButton");
        this.m_FootnoteFontButton.setDialogTitle(translatedText);
        this.m_FootnoteFontButton.setPaneLocale(this.m_graph.getLocale());
        this.m_FootnoteFontButton.setComponentFont(this.m_FootnoteFont);
        if (((GraphFootnote)this.m_graph.getFootnote()).getGraphFont().getGraphFontStyle() >= 4) {
            this.m_FootnoteFontButton.setUnderlineStyle(true);
            this.m_FootnoteTxt.setUnderline(true);
        }
        scAlign = this.m_FootnoteTxt.getHorizontalAlignment();
        this.m_FootnoteFontButton.setPaneHorizontalAlignment(scAlign);
        this.m_FootnoteFontButton.setStyleButtonMask(sbutton);
        this.m_FootnoteFontButton.setAlignmentButtonMask(abutton);
        this.m_FootnoteFontButton.setRotationButtonMask(rbutton);
        this.m_FootnoteFontButton.setColorComponentMask(1);
        this.m_FootnoteFontButton.setComponentForeground(((GraphFootnote)this.m_graph.getFootnote()).getGraphFont().getGraphFontColor());
        this.m_TitleFontButton.setTextRotation(this.convertToFontButtonConstants(((GraphTitle)this.m_graph.getTitle()).getTextRotation()));
        this.m_SubtitleFontButton.setTextRotation(this.convertToFontButtonConstants(((GraphSubtitle)this.m_graph.getSubtitle()).getTextRotation()));
        this.m_FootnoteFontButton.setTextRotation(this.convertToFontButtonConstants(((GraphFootnote)this.m_graph.getFootnote()).getTextRotation()));
        this.m_TitleTextRotation = this.m_TitleFontButton.getTextRotation();
        this.m_SubtitleTextRotation = this.m_SubtitleFontButton.getTextRotation();
        this.m_FootnoteTextRotation = this.m_FootnoteFontButton.getTextRotation();
        subPanel3.add((Component)this.m_InsertFootnote);
        subPanel3.add(Box.createHorizontalStrut(10));
        subPanel3.add((Component)this.m_FootnoteFontButton);
        JPanel flowPanel3 = new JPanel(new FlowLayout(2, 0, 0));
        flowPanel3.setAlignmentY(1.0f);
        flowPanel3.add(subPanel3);
        this.footnotePanel.add(flowPanel3);
        pWidth = this.m_shFootnoteCBox.getPreferredSize().width + subPanel3.getPreferredSize().width;
        pHeight = Math.max(subPanel3.getPreferredSize().height, this.m_shFootnoteCBox.getPreferredSize().height);
        this.footnotePanel.setPreferredSize(new Dimension(pWidth, pHeight));
        this.footnotePanel.setMinimumSize(this.footnotePanel.getPreferredSize());
        this.footnotePanel.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, pHeight));
        int TitleFontWidth = this.m_TitleFontButton.getPreferredSize().width;
        int SubtitleFontWidth = this.m_SubtitleFontButton.getPreferredSize().width;
        int FootnoteFontWidth = this.m_FootnoteFontButton.getPreferredSize().width;
        int width = TitleFontWidth;
        if (SubtitleFontWidth > width) {
            width = SubtitleFontWidth;
        }
        if (FootnoteFontWidth > width) {
            width = FootnoteFontWidth;
        }
        this.m_TitleFontButton.setPreferredSize(new Dimension(width, this.m_TitleFontButton.getPreferredSize().height));
        this.m_TitleFontButton.setMinimumSize(this.m_TitleFontButton.getPreferredSize());
        this.m_TitleFontButton.setMaximumSize(this.m_TitleFontButton.getPreferredSize());
        this.m_SubtitleFontButton.setPreferredSize(this.m_TitleFontButton.getPreferredSize());
        this.m_SubtitleFontButton.setMinimumSize(this.m_TitleFontButton.getPreferredSize());
        this.m_SubtitleFontButton.setMaximumSize(this.m_TitleFontButton.getPreferredSize());
        this.m_FootnoteFontButton.setPreferredSize(this.m_TitleFontButton.getPreferredSize());
        this.m_FootnoteFontButton.setMinimumSize(this.m_TitleFontButton.getPreferredSize());
        this.m_FootnoteFontButton.setMaximumSize(this.m_TitleFontButton.getPreferredSize());
        this.m_mainPanel.add(this.titlePanel);
        this.m_mainPanel.add(Box.createVerticalStrut(5));
        this.m_mainPanel.add((Component)this.m_TitleTxt);
        this.m_mainPanel.add(Box.createVerticalStrut(15));
        this.m_mainPanel.add(this.subtitlePanel);
        this.m_mainPanel.add(Box.createVerticalStrut(5));
        this.m_mainPanel.add((Component)this.m_SubtitleTxt);
        this.m_mainPanel.add(Box.createVerticalStrut(15));
        this.m_mainPanel.add(this.footnotePanel);
        this.m_mainPanel.add(Box.createVerticalStrut(5));
        this.m_mainPanel.add((Component)this.m_FootnoteTxt);
        this.calculatePreferredSize();
        this.m_shTitleCBox.addItemListener(this);
        this.m_shSubtitleCBox.addItemListener(this);
        this.m_shFootnoteCBox.addItemListener(this);
        this.m_InsertTitle.addActionListener((ActionListener)this);
        this.m_InsertSubtitle.addActionListener((ActionListener)this);
        this.m_InsertFootnote.addActionListener((ActionListener)this);
        this.m_TitleFontButton.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_SubtitleFontButton.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_FootnoteFontButton.addPropertyChangeListener((PropertyChangeListener)this);
        this.resetValues();
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    public void initTitle() {
        LimitedTextDocument ltd = new LimitedTextDocument(1024, this.tokenArray);
        String text = this.m_token.getTokenString(this.m_graph.getTitle().getUnParseText());
        this.m_TitleTxt = new ViewTextField((Document)ltd, text, 0);
        this.m_TitleTxt.setName(GraphGUINames.TITLE_TEXTFIELD);
        this.m_TitleTxt.setComponentOrientation(this.getOrientation());
        this.m_TitleTxt.getAccessibleContext().setAccessibleName(this.rBundle.getString("Title TextField"));
        this.m_TitleTxt.setPreferredSize(new Dimension(400, 25));
        this.m_TitleTxt.setMinimumSize(this.m_TitleTxt.getPreferredSize());
        this.m_TitleTxt.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, this.m_TitleTxt.getPreferredSize().height));
        this.m_TitleFont = this.m_graph.getTitle().getFont();
        this.m_TitleTxt.setFont(new Font(this.m_TitleFont.getName(), this.m_TitleFont.getStyle(), this.m_TitleTxt.getFont().getSize()));
        this.m_TitleTxt.setHorizontalAlignment(this.m_graph.getTitle().getHorizontalAlignment());
        this.m_TitleTxt.setForeground(((GraphTitle)this.m_graph.getTitle()).getGraphFont().getGraphFontColor());
        this.m_TitleTxt.addCaretListener((CaretListener)this);
    }

    public void initSubtitle() {
        LimitedTextDocument ltd = new LimitedTextDocument(1024, this.tokenArray);
        String text = this.m_token.getTokenString(this.m_graph.getSubtitle().getUnParseText());
        this.m_SubtitleTxt = new ViewTextField((Document)ltd, text, 0);
        this.m_SubtitleTxt.setName(GraphGUINames.SUBTITLE_TEXTFIELD);
        this.m_SubtitleTxt.setComponentOrientation(this.getOrientation());
        this.m_SubtitleTxt.getAccessibleContext().setAccessibleName(this.rBundle.getString("Subtitle TextField"));
        this.m_SubtitleTxt.setPreferredSize(new Dimension(400, 25));
        this.m_SubtitleTxt.setMinimumSize(this.m_SubtitleTxt.getPreferredSize());
        this.m_SubtitleTxt.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, this.m_SubtitleTxt.getPreferredSize().height));
        this.m_SubtitleFont = this.m_graph.getSubtitle().getFont();
        this.m_SubtitleTxt.setFont(new Font(this.m_SubtitleFont.getName(), this.m_SubtitleFont.getStyle(), this.m_SubtitleTxt.getFont().getSize()));
        this.m_SubtitleTxt.setHorizontalAlignment(this.m_graph.getSubtitle().getHorizontalAlignment());
        this.m_SubtitleTxt.setForeground(((GraphSubtitle)this.m_graph.getSubtitle()).getGraphFont().getGraphFontColor());
        this.m_SubtitleTxt.addCaretListener((CaretListener)this);
    }

    public void initFootnote() {
        LimitedTextDocument ltd = new LimitedTextDocument(1024, this.tokenArray);
        String text = this.m_token.getTokenString(this.m_graph.getFootnote().getUnParseText());
        this.m_FootnoteTxt = new ViewTextField((Document)ltd, text, 0);
        this.m_FootnoteTxt.setName(GraphGUINames.FOOTNOTE_TEXTFIELD);
        this.m_FootnoteTxt.setComponentOrientation(this.getOrientation());
        this.m_FootnoteTxt.getAccessibleContext().setAccessibleName(this.rBundle.getString("Footnote TextField"));
        this.m_FootnoteTxt.setPreferredSize(new Dimension(400, 25));
        this.m_FootnoteTxt.setMinimumSize(this.m_FootnoteTxt.getPreferredSize());
        this.m_FootnoteTxt.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, this.m_FootnoteTxt.getPreferredSize().height));
        this.m_FootnoteFont = this.m_graph.getFootnote().getFont();
        this.m_FootnoteTxt.setFont(new Font(this.m_FootnoteFont.getName(), this.m_FootnoteFont.getStyle(), this.m_FootnoteTxt.getFont().getSize()));
        this.m_FootnoteTxt.setHorizontalAlignment(this.m_graph.getFootnote().getHorizontalAlignment());
        this.m_FootnoteTxt.setForeground(((GraphFootnote)this.m_graph.getFootnote()).getGraphFont().getGraphFontColor());
        this.m_FootnoteTxt.addCaretListener((CaretListener)this);
    }

    public void caretUpdate(CaretEvent e) {
        if (e.getSource() == this.m_TitleTxt) {
            String newText = this.m_TitleTxt.getText();
            if (newText.length() > 0) {
                this.m_oldTitle = newText;
                if (!this.m_showTitle) {
                    this.m_showTitle = true;
                    this.m_shTitleCBox.setSelected(this.m_showTitle);
                    this.firePropertyChange(PROPERTY_TITLE_TEXT, this.m_oldTitle, newText);
                }
                this.m_bTitleTextChanged = true;
            } else {
                this.m_showTitle = false;
                this.m_shTitleCBox.setSelected(this.m_showTitle);
                this.firePropertyChange(PROPERTY_TITLE_TEXT, this.m_oldTitle, newText);
                this.m_bTitleTextChanged = true;
            }
        } else if (e.getSource() == this.m_SubtitleTxt) {
            String newText = this.m_SubtitleTxt.getText();
            if (newText.length() > 0) {
                this.m_oldSubtitle = newText;
                if (!this.m_showSubtitle) {
                    this.m_showSubtitle = true;
                    this.m_shSubtitleCBox.setSelected(this.m_showSubtitle);
                    this.firePropertyChange(PROPERTY_SUBTITLE_TEXT, this.m_oldSubtitle, newText);
                }
                this.m_bSubtitleTextChanged = true;
            } else {
                this.m_showSubtitle = false;
                this.m_shSubtitleCBox.setSelected(this.m_showSubtitle);
                this.firePropertyChange(PROPERTY_SUBTITLE_TEXT, this.m_oldSubtitle, newText);
                this.m_bSubtitleTextChanged = true;
            }
        } else if (e.getSource() == this.m_FootnoteTxt) {
            String newText = this.m_FootnoteTxt.getText();
            if (newText.length() > 0) {
                this.m_oldFootnote = newText;
                if (!this.m_showFootnote) {
                    this.m_showFootnote = true;
                    this.m_shFootnoteCBox.setSelected(this.m_showFootnote);
                    this.firePropertyChange(PROPERTY_FOOTNOTE_TEXT, this.m_oldFootnote, newText);
                }
                this.m_bFootnoteTextChanged = true;
            } else {
                this.m_showFootnote = false;
                this.m_shFootnoteCBox.setSelected(this.m_showFootnote);
                this.firePropertyChange(PROPERTY_FOOTNOTE_TEXT, this.m_oldFootnote, newText);
                this.m_bFootnoteTextChanged = true;
            }
        }
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(loc);
        this.m_InsertTitle.setLocale(loc);
        this.m_InsertSubtitle.setLocale(loc);
        this.m_InsertFootnote.setLocale(loc);
        this.m_TitleTxt.getAccessibleContext().setAccessibleName(this.rBundle.getString("Title TextField"));
        this.m_SubtitleTxt.getAccessibleContext().setAccessibleName(this.rBundle.getString("Subtitle TextField"));
        this.m_FootnoteTxt.getAccessibleContext().setAccessibleName(this.rBundle.getString("Footnote TextField"));
    }

    public void propertyChange(PropertyChangeEvent e) {
        Boolean b;
        boolean cancelled;
        if (e.getSource() == this.m_TitleFontButton) {
            this.m_TextArea = this.m_TitleTxt;
            this.m_Font = this.m_TitleFont;
            this.m_textRotation = this.m_TitleTextRotation;
        } else if (e.getSource() == this.m_SubtitleFontButton) {
            this.m_TextArea = this.m_SubtitleTxt;
            this.m_Font = this.m_SubtitleFont;
            this.m_textRotation = this.m_SubtitleTextRotation;
        } else if (e.getSource() == this.m_FootnoteFontButton) {
            this.m_TextArea = this.m_FootnoteTxt;
            this.m_Font = this.m_FootnoteFont;
            this.m_textRotation = this.m_FootnoteTextRotation;
        }
        String name = e.getPropertyName();
        if (name == "fontDialogCancelled" && !(cancelled = (b = (Boolean)e.getNewValue()).booleanValue())) {
            if (this.m_bFontNameChange) {
                this.firePropertyChange("fontName", this.m_oldFontName, this.m_newFontName);
                if (this.m_TextArea == this.m_TitleTxt) {
                    this.m_bTitleFontNameChanged = true;
                } else if (this.m_TextArea == this.m_SubtitleTxt) {
                    this.m_bSubtitleFontNameChanged = true;
                } else {
                    this.m_bFootnoteFontNameChanged = true;
                }
                this.m_Font = new Font(this.m_newFontName, this.m_Font.getStyle(), this.m_Font.getSize());
                this.m_TextArea.setFont(new Font(this.m_newFontName, this.m_Font.getStyle(), this.m_TextArea.getFont().getSize()));
                this.m_bFontNameChange = false;
            }
            if (this.m_bFontStyleChange) {
                this.firePropertyChange("fontStyle", this.m_oldFontStyle, this.m_newFontStyle);
                if (this.m_newFontStyle >= 4) {
                    this.m_TextArea.setUnderline(true);
                } else {
                    this.m_TextArea.setUnderline(false);
                }
                boolean bold = false;
                boolean italic = false;
                if ((this.m_newFontStyle & 1) != 0) {
                    bold = true;
                }
                if ((this.m_newFontStyle & 2) != 0) {
                    italic = true;
                }
                this.m_Font = new Font(this.m_Font.getName(), this.m_newFontStyle, this.m_Font.getSize());
                this.m_TextArea.setFont(new Font(this.m_Font.getName(), ViewStyle.fontStyle(bold, italic), this.m_TextArea.getFont().getSize()));
                int style = this.m_oldFontStyle ^ this.m_newFontStyle;
                if ((style & 1) != 0) {
                    if (this.m_TextArea == this.m_TitleTxt) {
                        this.m_bTitleFontBoldChanged = true;
                    } else if (this.m_TextArea == this.m_SubtitleTxt) {
                        this.m_bSubtitleFontBoldChanged = true;
                    } else {
                        this.m_bFootnoteFontBoldChanged = true;
                    }
                }
                if ((style & 2) != 0) {
                    if (this.m_TextArea == this.m_TitleTxt) {
                        this.m_bTitleFontItalicChanged = true;
                    } else if (this.m_TextArea == this.m_SubtitleTxt) {
                        this.m_bSubtitleFontItalicChanged = true;
                    } else {
                        this.m_bFootnoteFontItalicChanged = true;
                    }
                }
                if ((style & 4) != 0) {
                    if (this.m_TextArea == this.m_TitleTxt) {
                        this.m_bTitleFontUnderlineChanged = true;
                    } else if (this.m_TextArea == this.m_SubtitleTxt) {
                        this.m_bSubtitleFontUnderlineChanged = true;
                    } else {
                        this.m_bFootnoteFontUnderlineChanged = true;
                    }
                }
                this.m_bFontStyleChange = false;
            }
            if (this.m_bFontSizeChange) {
                this.firePropertyChange("fontSize", this.m_oldFontSize, this.m_newFontSize);
                if (this.m_TextArea == this.m_TitleTxt) {
                    this.m_bTitleFontSizeChanged = true;
                } else if (this.m_TextArea == this.m_SubtitleTxt) {
                    this.m_bSubtitleFontSizeChanged = true;
                } else {
                    this.m_bFootnoteFontSizeChanged = true;
                }
                this.m_Font = new Font(this.m_Font.getName(), this.m_Font.getStyle(), this.m_newFontSize);
                this.m_bFontSizeChange = false;
            }
            if (this.m_bHorizontalAlignmentChange) {
                this.firePropertyChange("fontHorizontalAlignment", this.m_oldHAlignment, this.m_newHAlignment);
                this.m_TextArea.setHorizontalAlignment(this.m_newHAlignment);
                this.m_bHorizontalAlignmentChange = false;
                if (this.m_TextArea == this.m_TitleTxt) {
                    this.m_bTitleAlignmentChanged = true;
                } else if (this.m_TextArea == this.m_SubtitleTxt) {
                    this.m_bSubtitleAlignmentChanged = true;
                } else {
                    this.m_bFootnoteAlignmentChanged = true;
                }
            }
            if (this.m_bFontColorChange) {
                this.firePropertyChange("fontColor", this.m_oldFontColor, this.m_newFontColor);
                this.m_TextArea.setForeground(this.m_newFontColor);
                this.m_bFontColorChange = false;
                if (this.m_TextArea == this.m_TitleTxt) {
                    this.m_bTitleFontColorChanged = true;
                } else if (this.m_TextArea == this.m_SubtitleTxt) {
                    this.m_bSubtitleFontColorChanged = true;
                } else {
                    this.m_bFootnoteFontColorChanged = true;
                }
            }
            if (this.m_bTextRotationChange) {
                this.firePropertyChange("textRotation", this.m_oldRotation, this.m_newRotation);
                this.m_textRotation = this.m_newRotation;
                this.m_bTextRotationChange = false;
                if (this.m_TextArea == this.m_TitleTxt) {
                    this.m_bTitleRotationChanged = true;
                } else if (this.m_TextArea == this.m_SubtitleTxt) {
                    this.m_bSubtitleRotationChanged = true;
                } else {
                    this.m_bFootnoteRotationChanged = true;
                }
            }
            this.m_TextArea.repaint();
        }
        if (name == "fontHorizontalAlignment") {
            Integer oldAli = (Integer)e.getOldValue();
            Integer newAli = (Integer)e.getNewValue();
            if (!this.m_bHorizontalAlignmentChange) {
                this.m_oldHAlignment = oldAli;
            }
            this.m_newHAlignment = newAli;
            if (oldAli != this.m_newHAlignment) {
                this.m_bHorizontalAlignmentChange = true;
            }
        }
        if (name == "textRotation") {
            Integer oldRotation = (Integer)e.getOldValue();
            Integer newRotation = (Integer)e.getNewValue();
            if (!this.m_bTextRotationChange) {
                this.m_oldRotation = oldRotation;
            }
            this.m_newRotation = newRotation;
            if (oldRotation != this.m_newRotation) {
                this.m_bTextRotationChange = true;
            }
        }
        if (name == "fontColor") {
            Color oldColor = (Color)e.getOldValue();
            if (!this.m_bFontColorChange) {
                this.m_oldFontColor = oldColor;
            }
            this.m_newFontColor = (Color)e.getNewValue();
            if (oldColor != this.m_newFontColor) {
                this.m_bFontColorChange = true;
            }
        }
        if (name == "fontName") {
            String oldName = (String)e.getOldValue();
            if (!this.m_bFontNameChange) {
                this.m_oldFontName = oldName;
            }
            this.m_newFontName = (String)e.getNewValue();
            if (oldName != this.m_newFontName) {
                this.m_bFontNameChange = true;
            }
        }
        if (name == "fontStyle") {
            Integer oldIntStyle = (Integer)e.getOldValue();
            if (!this.m_bFontStyleChange) {
                this.m_oldFontStyle = oldIntStyle;
            }
            Integer newIntStyle = (Integer)e.getNewValue();
            this.m_newFontStyle = newIntStyle;
            if (oldIntStyle != this.m_newFontStyle) {
                this.m_bFontStyleChange = true;
            }
        }
        if (name == "fontSize") {
            Integer oldFontSize = (Integer)e.getOldValue();
            if (!this.m_bFontSizeChange) {
                this.m_oldFontSize = oldFontSize;
            }
            Integer newIntSize = (Integer)e.getNewValue();
            this.m_newFontSize = newIntSize;
            if (oldFontSize != this.m_newFontSize) {
                this.m_bFontSizeChange = true;
            }
        }
        if (e.getSource() == this.m_TitleFontButton) {
            this.m_TitleFont = this.m_Font;
            this.m_TitleTextRotation = this.m_textRotation;
        } else if (e.getSource() == this.m_SubtitleFontButton) {
            this.m_SubtitleFont = this.m_Font;
            this.m_SubtitleTextRotation = this.m_textRotation;
        } else if (e.getSource() == this.m_FootnoteFontButton) {
            this.m_FootnoteFont = this.m_Font;
            this.m_FootnoteTextRotation = this.m_textRotation;
        }
    }

    public void apply() {
        boolean style = false;
        int rotation = -1;
        if (this.m_bTitleTextChanged) {
            this.m_graph.getTitle().setText(this.m_token.getKeyString(this.m_TitleTxt.getText()));
        }
        if (this.m_bTitleVisibleChanged) {
            this.m_graph.getTitle().setVisible(this.m_showTitle);
        }
        if (this.m_bTitleFontNameChanged) {
            ((GraphTitle)this.m_graph.getTitle()).getGraphFont().setGraphFontTypeface(this.m_TitleFont.getFamily());
        }
        if (this.m_bTitleFontBoldChanged) {
            ((GraphTitle)this.m_graph.getTitle()).getGraphFont().setFontBold(this.m_TitleFont.isBold());
        }
        if (this.m_bTitleFontItalicChanged) {
            ((GraphTitle)this.m_graph.getTitle()).getGraphFont().setFontItalic(this.m_TitleFont.isItalic());
        }
        if (this.m_bTitleFontUnderlineChanged) {
            ((GraphTitle)this.m_graph.getTitle()).getGraphFont().setUnderline(this.m_TitleTxt.isUnderline());
        }
        if (this.m_bTitleFontSizeChanged) {
            ((GraphTitle)this.m_graph.getTitle()).getGraphFont().setGraphFontSize(this.m_TitleFont.getSize());
        }
        if (this.m_bTitleAlignmentChanged) {
            ((GraphTitle)this.m_graph.getTitle()).setHorizontalAlignment(this.m_TitleTxt.getHorizontalAlignment());
        }
        if (this.m_bTitleFontColorChanged) {
            ((GraphTitle)this.m_graph.getTitle()).getGraphFont().setGraphFontColor(this.m_TitleTxt.getForeground());
        }
        if (this.m_bTitleRotationChanged && (rotation = this.convertFromFontButtonConstants(this.m_TitleTextRotation)) != -1) {
            ((GraphTitle)this.m_graph.getTitle()).setTextRotation(rotation);
        }
        if (this.m_bSubtitleTextChanged) {
            this.m_graph.getSubtitle().setText(this.m_token.getKeyString(this.m_SubtitleTxt.getText()));
        }
        if (this.m_bSubtitleVisibleChanged) {
            this.m_graph.getSubtitle().setVisible(this.m_showSubtitle);
        }
        if (this.m_bSubtitleFontNameChanged) {
            ((GraphSubtitle)this.m_graph.getSubtitle()).getGraphFont().setGraphFontTypeface(this.m_SubtitleFont.getFamily());
        }
        if (this.m_bSubtitleFontBoldChanged) {
            ((GraphSubtitle)this.m_graph.getSubtitle()).getGraphFont().setFontBold(this.m_SubtitleFont.isBold());
        }
        if (this.m_bSubtitleFontItalicChanged) {
            ((GraphSubtitle)this.m_graph.getSubtitle()).getGraphFont().setFontItalic(this.m_SubtitleFont.isItalic());
        }
        if (this.m_bSubtitleFontUnderlineChanged) {
            ((GraphSubtitle)this.m_graph.getSubtitle()).getGraphFont().setUnderline(this.m_SubtitleTxt.isUnderline());
        }
        if (this.m_bSubtitleFontSizeChanged) {
            ((GraphSubtitle)this.m_graph.getSubtitle()).getGraphFont().setGraphFontSize(this.m_SubtitleFont.getSize());
        }
        if (this.m_bSubtitleAlignmentChanged) {
            this.m_graph.getSubtitle().setHorizontalAlignment(this.m_SubtitleTxt.getHorizontalAlignment());
        }
        if (this.m_bSubtitleFontColorChanged) {
            ((GraphSubtitle)this.m_graph.getSubtitle()).getGraphFont().setGraphFontColor(this.m_SubtitleTxt.getForeground());
        }
        if (this.m_bSubtitleRotationChanged && (rotation = this.convertFromFontButtonConstants(this.m_SubtitleTextRotation)) != -1) {
            ((GraphSubtitle)this.m_graph.getSubtitle()).setTextRotation(rotation);
        }
        if (this.m_bFootnoteTextChanged) {
            this.m_graph.getFootnote().setText(this.m_token.getKeyString(this.m_FootnoteTxt.getText()));
        }
        if (this.m_bFootnoteVisibleChanged) {
            this.m_graph.getFootnote().setVisible(this.m_showFootnote);
        }
        if (this.m_bFootnoteFontNameChanged) {
            ((GraphFootnote)this.m_graph.getFootnote()).getGraphFont().setGraphFontTypeface(this.m_FootnoteFont.getFamily());
        }
        if (this.m_bFootnoteFontBoldChanged) {
            ((GraphFootnote)this.m_graph.getFootnote()).getGraphFont().setFontBold(this.m_FootnoteFont.isBold());
        }
        if (this.m_bFootnoteFontItalicChanged) {
            ((GraphFootnote)this.m_graph.getFootnote()).getGraphFont().setFontItalic(this.m_FootnoteFont.isItalic());
        }
        if (this.m_bFootnoteFontUnderlineChanged) {
            ((GraphFootnote)this.m_graph.getFootnote()).getGraphFont().setUnderline(this.m_FootnoteTxt.isUnderline());
        }
        if (this.m_bFootnoteFontSizeChanged) {
            ((GraphFootnote)this.m_graph.getFootnote()).getGraphFont().setGraphFontSize(this.m_FootnoteFont.getSize());
        }
        if (this.m_bFootnoteAlignmentChanged) {
            this.m_graph.getFootnote().setHorizontalAlignment(this.m_FootnoteTxt.getHorizontalAlignment());
        }
        if (this.m_bFootnoteFontColorChanged) {
            ((GraphFootnote)this.m_graph.getFootnote()).getGraphFont().setGraphFontColor(this.m_FootnoteTxt.getForeground());
        }
        if (this.m_bFootnoteRotationChanged && (rotation = this.convertFromFontButtonConstants(this.m_FootnoteTextRotation)) != -1) {
            ((GraphFootnote)this.m_graph.getFootnote()).setTextRotation(rotation);
        }
    }

    private int getUnderlineStyle(Font f) {
        int rtnStyle = 0;
        switch (f.getStyle()) {
            case 0: {
                rtnStyle = 4;
                break;
            }
            case 1: {
                rtnStyle = 6;
                break;
            }
            case 2: {
                rtnStyle = 5;
                break;
            }
            case 4: {
                rtnStyle = 4;
                break;
            }
            case 5: {
                rtnStyle = 6;
                break;
            }
            case 6: {
                rtnStyle = 5;
                break;
            }
            case 7: {
                rtnStyle = 7;
                break;
            }
        }
        return rtnStyle;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_InsertTitle) {
            this.m_TextArea = this.m_TitleTxt;
            this.m_Insert = this.m_InsertTitle;
        } else if (e.getSource() == this.m_InsertSubtitle) {
            this.m_TextArea = this.m_SubtitleTxt;
            this.m_Insert = this.m_InsertSubtitle;
        } else if (e.getSource() == this.m_InsertFootnote) {
            this.m_TextArea = this.m_FootnoteTxt;
            this.m_Insert = this.m_InsertFootnote;
        }
        String insertStr = this.m_Insert.getSelectedItem();
        if (insertStr != null) {
            String originalStr = this.m_TextArea.getText();
            String newStr = originalStr.substring(0, this.m_TextArea.getCaretPosition()) + this.m_token.getToken(insertStr) + originalStr.substring(this.m_TextArea.getCaretPosition(), originalStr.length());
            this.firePropertyChange(PROPERTY_TITLE_TEXT, originalStr, newStr);
            if (e.getSource() == this.m_InsertTitle) {
                this.m_showTitle = true;
                this.m_shTitleCBox.setSelected(this.m_showTitle);
            } else if (e.getSource() == this.m_InsertSubtitle) {
                this.m_showSubtitle = true;
                this.m_shSubtitleCBox.setSelected(this.m_showSubtitle);
            } else if (e.getSource() == this.m_InsertFootnote) {
                this.m_showFootnote = true;
                this.m_shFootnoteCBox.setSelected(this.m_showFootnote);
            }
            String posStr = originalStr.substring(0, this.m_TextArea.getCaretPosition()) + this.m_token.getToken(insertStr);
            this.m_TextArea.setText(newStr);
            this.m_TextArea.requestFocus();
            if (posStr.length() > 1024) {
                this.m_TextArea.setCaretPosition(this.m_TextArea.getText().length());
            } else {
                this.m_TextArea.setCaretPosition(posStr.length());
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.m_shTitleCBox) {
            if (e.getStateChange() == 1) {
                this.firePropertyChange(PROPERTY_TITLE_VISIBLE, false, true);
                this.m_showTitle = true;
            } else {
                this.firePropertyChange(PROPERTY_TITLE_VISIBLE, true, false);
                this.m_showTitle = false;
            }
            this.m_bTitleVisibleChanged = true;
        }
        if (e.getSource() == this.m_shSubtitleCBox) {
            if (e.getStateChange() == 1) {
                this.firePropertyChange(PROPERTY_SUBTITLE_VISIBLE, false, true);
                this.m_showSubtitle = true;
            } else {
                this.firePropertyChange(PROPERTY_SUBTITLE_VISIBLE, true, false);
                this.m_showSubtitle = false;
            }
            this.m_bSubtitleVisibleChanged = true;
        }
        if (e.getSource() == this.m_shFootnoteCBox) {
            if (e.getStateChange() == 1) {
                this.firePropertyChange(PROPERTY_FOOTNOTE_VISIBLE, false, true);
                this.m_showFootnote = true;
            } else {
                this.firePropertyChange(PROPERTY_FOOTNOTE_VISIBLE, true, false);
                this.m_showFootnote = false;
            }
            this.m_bFootnoteVisibleChanged = true;
        }
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    private void calculatePreferredSize() {
        int maxWidth = 0;
        int pWidth = this.titlePanel.getPreferredSize().width;
        if (maxWidth < pWidth) {
            maxWidth = pWidth;
        }
        if (maxWidth < (pWidth = this.m_TitleTxt.getPreferredSize().width)) {
            maxWidth = pWidth;
        }
        if (maxWidth < (pWidth = this.subtitlePanel.getPreferredSize().width)) {
            maxWidth = pWidth;
        }
        if (maxWidth < (pWidth = this.m_SubtitleTxt.getPreferredSize().width)) {
            maxWidth = pWidth;
        }
        if (maxWidth < (pWidth = this.footnotePanel.getPreferredSize().width)) {
            maxWidth = pWidth;
        }
        if (maxWidth < (pWidth = this.m_FootnoteTxt.getPreferredSize().width)) {
            maxWidth = pWidth;
        }
        pWidth = maxWidth + 10 + 10;
        int pHeight = this.m_mainPanel.getPreferredSize().height + this.m_label.getPreferredSize().height + 10 + 10 + 15;
        this.prefSize = new Dimension(pWidth, pHeight);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
        this.m_TitleFontButton.setHelpProvider(helpProvider);
        this.m_SubtitleFontButton.setHelpProvider(helpProvider);
        this.m_FootnoteFontButton.setHelpProvider(helpProvider);
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void setInsertButtonVisible(boolean visible) {
        this.m_InsertTitle.setVisible(visible);
        this.m_InsertSubtitle.setVisible(visible);
        this.m_InsertFootnote.setVisible(visible);
        this.insertButtonVisible = visible;
    }

    public boolean isInsertButtonVisible() {
        return this.insertButtonVisible;
    }

    protected int convertToFontButtonConstants(int beanConstant) {
        int fontConstant;
        switch (beanConstant) {
            case 0: {
                fontConstant = 1;
                break;
            }
            case 1: {
                fontConstant = 2;
                break;
            }
            case 2: {
                fontConstant = 3;
                break;
            }
            default: {
                fontConstant = -1;
                break;
            }
        }
        return fontConstant;
    }

    protected int convertFromFontButtonConstants(int fontConstant) {
        int beanConstant;
        switch (fontConstant) {
            case 1: {
                beanConstant = 0;
                break;
            }
            case 2: {
                beanConstant = 1;
                break;
            }
            case 3: {
                beanConstant = 2;
                break;
            }
            default: {
                beanConstant = -1;
                break;
            }
        }
        return beanConstant;
    }

    private void resetValues() {
        this.m_bTitleFontNameChanged = false;
        this.m_bTitleFontBoldChanged = false;
        this.m_bTitleFontItalicChanged = false;
        this.m_bTitleFontUnderlineChanged = false;
        this.m_bTitleFontSizeChanged = false;
        this.m_bTitleAlignmentChanged = false;
        this.m_bTitleFontColorChanged = false;
        this.m_bTitleVisibleChanged = false;
        this.m_bSubtitleFontNameChanged = false;
        this.m_bSubtitleFontBoldChanged = false;
        this.m_bSubtitleFontItalicChanged = false;
        this.m_bSubtitleFontUnderlineChanged = false;
        this.m_bSubtitleFontSizeChanged = false;
        this.m_bSubtitleAlignmentChanged = false;
        this.m_bSubtitleFontColorChanged = false;
        this.m_bSubtitleVisibleChanged = false;
        this.m_bFootnoteFontNameChanged = false;
        this.m_bFootnoteFontBoldChanged = false;
        this.m_bFootnoteFontItalicChanged = false;
        this.m_bFootnoteFontUnderlineChanged = false;
        this.m_bFootnoteFontSizeChanged = false;
        this.m_bFootnoteAlignmentChanged = false;
        this.m_bFootnoteFontColorChanged = false;
        this.m_bFootnoteVisibleChanged = false;
        this.m_bTitleTextChanged = false;
        this.m_bSubtitleTextChanged = false;
        this.m_bFootnoteTextChanged = false;
        this.m_bTitleRotationChanged = false;
        this.m_bSubtitleRotationChanged = false;
        this.m_bFootnoteRotationChanged = false;
    }

    private void $init$() {
        this.m_bFontNameChange = false;
        this.m_bFontStyleChange = false;
        this.m_bFontSizeChange = false;
        this.m_bHorizontalAlignmentChange = false;
        this.m_bFontColorChange = false;
        this.m_bTextRotationChange = false;
        this.m_bTitleFontNameChanged = false;
        this.m_bTitleFontBoldChanged = false;
        this.m_bTitleFontItalicChanged = false;
        this.m_bTitleFontUnderlineChanged = false;
        this.m_bTitleFontSizeChanged = false;
        this.m_bTitleAlignmentChanged = false;
        this.m_bTitleFontColorChanged = false;
        this.m_bTitleVisibleChanged = false;
        this.m_bTitleRotationChanged = false;
        this.m_bSubtitleFontNameChanged = false;
        this.m_bSubtitleFontBoldChanged = false;
        this.m_bSubtitleFontItalicChanged = false;
        this.m_bSubtitleFontUnderlineChanged = false;
        this.m_bSubtitleFontSizeChanged = false;
        this.m_bSubtitleAlignmentChanged = false;
        this.m_bSubtitleFontColorChanged = false;
        this.m_bSubtitleVisibleChanged = false;
        this.m_bSubtitleRotationChanged = false;
        this.m_bFootnoteFontNameChanged = false;
        this.m_bFootnoteFontBoldChanged = false;
        this.m_bFootnoteFontItalicChanged = false;
        this.m_bFootnoteFontUnderlineChanged = false;
        this.m_bFootnoteFontSizeChanged = false;
        this.m_bFootnoteAlignmentChanged = false;
        this.m_bFootnoteFontColorChanged = false;
        this.m_bFootnoteVisibleChanged = false;
        this.m_bFootnoteRotationChanged = false;
        this.m_bTitleTextChanged = false;
        this.m_bSubtitleTextChanged = false;
        this.m_bFootnoteTextChanged = false;
        this.m_oldTitle = null;
        this.m_oldSubtitle = null;
        this.m_oldFootnote = null;
        this.insertButtonVisible = true;
        this.rBundle = null;
        this.m_bSuperCalled = false;
        this.titlePanel = null;
        this.subtitlePanel = null;
        this.footnotePanel = null;
        this.tokenArray = null;
    }
}

