/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Image;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.ImageLoader;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class Alerts
implements Serializable {
    protected Perspective m_Perspective;
    protected JChart_2D_Standard m_chart;
    protected JGraphType m_gt;

    private void $init$() {
        this.m_chart = null;
        this.m_gt = null;
    }

    public Alerts(Perspective perspective) {
        this.$init$();
        this.m_Perspective = perspective;
        this.m_gt = this.m_Perspective.getJGraphType();
    }

    public void calc() {
        if (this.m_Perspective.getAlertsVisibility() != 1) {
            return;
        }
        if (!(this.m_gt.isBLAType() || this.m_gt.isPolar() || this.m_gt.isRadarType() || this.m_gt.isScatter() || this.m_gt.isBubble() || this.m_gt.isParetoType() || this.m_gt.isStockType())) {
            return;
        }
        this.m_chart = (JChart_2D_Standard)this.m_Perspective.getGraphObject();
        int count = 0;
        if (this.m_Perspective.getAlerts() != null) {
            count = this.m_Perspective.getAlerts().size();
        }
        int i = 0;
        while (i < count) {
            IdentObj id = (IdentObj)this.m_Perspective.getAlerts().get(i);
            if (this.m_Perspective.getDisplay(id)) {
                this.calcOne(id);
            }
            ++i;
        }
    }

    public void calcOne(IdentObj id) {
        String url = this.m_Perspective.getTexture(id);
        Image image = this.m_Perspective.getTexture(url);
        if (image == null) {
            image = TextStyleObj.getImageResource(TextStyleObj.class, "images/alert.gif");
            this.m_Perspective.setTextureURL(id, url, image);
        }
        boolean loaded = ImageLoader.loadImage(image);
        int yAxis = this.m_Perspective.getAlertYAssignment(id);
        if (yAxis == 51 && !this.m_gt.isDualY()) {
            return;
        }
        if (!loaded) {
            return;
        }
        int imgHeight = this.m_Perspective.getVC().destToVirtHeight(image.getHeight(null));
        int imgWidth = this.m_Perspective.getVC().destToVirtWidth(image.getWidth(null));
        int yAxisID = 2004;
        Double yValue = this.m_Perspective.getAlertYValue(id);
        Object xValue = this.m_Perspective.getAlertXValue(id);
        if (xValue == null || yValue == null) {
            return;
        }
        JChart_2D_Standard ch2 = this.m_chart;
        RelativeAxisObj yObj = yAxis == 46 ? ch2.getY1Axis() : ch2.getY2Axis();
        RelativeAxisObj xObj = ch2.getO1Axis();
        double max = yObj.getMaxValue();
        double min = yObj.getMinValue();
        if (this.m_gt.isParetoType() && yAxisID == 2005) {
            yValue = yObj.getValueFromRelCoord(yValue / 100.0);
        } else if (this.m_gt.isPercent() && yValue > 1.0 && yValue <= 100.0 && ((yValue = Double.valueOf(yValue / 100.0)) > max || yValue < min)) {
            return;
        }
        int relYValue = (int)yObj.getValueCoord(yValue);
        if (this.getXCoord(xValue) == null) {
            return;
        }
        int relXValue = (int)this.getXCoord(xValue).doubleValue();
        BlackBoxObj bbBox = new BlackBoxObj(this.m_Perspective, id);
        if (this.m_gt.isOrientHorz()) {
            new DetRect(this.m_Perspective.getDetectiv(), id, relYValue - imgWidth / 2, relXValue - imgHeight / 2, imgWidth, imgHeight, bbBox, null, false, true, true);
        } else {
            new DetRect(this.m_Perspective.getDetectiv(), id, relXValue - imgWidth / 2, relYValue - imgHeight / 2, imgWidth, imgHeight, bbBox, null, false, true, true);
        }
    }

    public Double getXCoord(Object xValue) {
        Vector groupLabels = this.m_Perspective.getGroupLabels();
        int numGroups = this.m_Perspective.getNumGroups();
        if (xValue instanceof String) {
            if (this.m_Perspective.isTimeAxis() || this.m_Perspective.isContinuousTimeAxis()) {
                try {
                    long val = Long.parseLong((String)xValue);
                    xValue = new Date(val);
                    System.out.println(xValue);
                }
                catch (NumberFormatException nfe) {
                    Double d = null;
                    return d;
                }
            } else if (this.m_gt.isPolar() || this.m_gt.isScatter()) {
                try {
                    xValue = Double.parseDouble((String)xValue);
                }
                catch (NumberFormatException nfe) {
                    Double d = null;
                    return d;
                }
            } else {
                int i = 0;
                while (i < numGroups) {
                    if (xValue.equals(this.m_Perspective.getGroupLabel(i))) {
                        return this.m_chart.getO1Axis().getCenterCoord(i);
                    }
                    ++i;
                }
            }
        }
        if (xValue instanceof Double) {
            if (!this.m_gt.isPolar() && !this.m_gt.isScatter()) {
                return null;
            }
            return this.m_chart.getX1Axis().getValueCoord((Double)xValue);
        }
        if (xValue instanceof Date) {
            if (this.m_Perspective.isTimeAxis() || this.m_Perspective.isContinuousTimeAxis()) {
                Date date = (Date)xValue;
                if (this.m_Perspective.isContinuousTimeAxis()) {
                    long time = date.getTime();
                    return this.m_chart.getO1Axis().getValueCoord(time);
                }
                if (numGroups == 0) {
                    return null;
                }
                Date lastDate = (Date)groupLabels.elementAt(numGroups - 1);
                Date firstDate = (Date)groupLabels.elementAt(0);
                if (date.after(lastDate) || date.before(firstDate)) {
                    return null;
                }
                int group = -3;
                int i = 0;
                while (i < numGroups - 1) {
                    Date gdate = (Date)groupLabels.elementAt(i);
                    Date gdateNext = (Date)groupLabels.elementAt(i + 1);
                    if (date.equals(gdate)) {
                        group = i;
                    }
                    if (date.after(gdate)) {
                        if (date.equals(gdateNext)) {
                            group = i + 1;
                        }
                        if (date.before(gdateNext)) {
                            group = i;
                        }
                    }
                    if (group >= 0) {
                        return this.m_chart.getO1Axis().getCenterCoord(group);
                    }
                    ++i;
                }
            } else {
                return null;
            }
        }
        return null;
    }
}

