/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class Annotations
implements Serializable {
    protected Perspective m_Perspective;
    protected JChart_Base m_chart;
    protected int MAX_WIDTH;
    protected int defaultDistance;
    protected boolean[] m_isCalced;
    protected boolean[] m_isReveresed;
    protected Rectangle m_pRect;

    private void $init$() {
        this.m_chart = null;
        this.MAX_WIDTH = 10000;
        this.defaultDistance = 600;
        this.m_isCalced = null;
        this.m_isReveresed = null;
    }

    public Annotations(Perspective perspective) {
        this.$init$();
        this.m_Perspective = perspective;
        this.m_pRect = this.m_Perspective.getRect(new IdentObj(2));
    }

    public void calc() {
        if (!(this.m_Perspective.m_chart instanceof JChart_2D_Standard)) {
            return;
        }
        int numGroups = this.m_Perspective.m_chart.getResetGroupsEnumerator().getNumGroups();
        int numSeries = this.m_Perspective.m_chart.getResetSeriesEnumerator().getNumSeries();
        int count = 0;
        if (this.m_Perspective.getAnnotations() != null) {
            count = this.m_Perspective.getAnnotations().size();
        }
        this.m_isCalced = new boolean[count];
        this.m_isReveresed = new boolean[count];
        int i = 0;
        while (i < count) {
            this.m_isCalced[i] = false;
            this.m_isReveresed[i] = false;
            ++i;
        }
        int i2 = 0;
        while (i2 < count) {
            if (!this.m_isCalced[i2]) {
                ArrayList<IdentObj> idList = new ArrayList<IdentObj>();
                IdentObj id = (IdentObj)this.m_Perspective.getAnnotations().get(i2);
                if (id.getSeriesID() >= numSeries || id.getGroupID() >= numGroups || !this.m_Perspective.getDisplay(id)) {
                    this.m_isCalced[i2] = true;
                } else {
                    idList.add(id);
                    this.m_isCalced[i2] = true;
                    int j = i2 + 1;
                    while (j < count) {
                        IdentObj id1 = (IdentObj)this.m_Perspective.getAnnotations().get(j);
                        if (id.getSeriesID() == id1.getSeriesID() && id.getGroupID() == id1.getGroupID()) {
                            if (!this.m_Perspective.getDisplay(id1)) {
                                this.m_isCalced[j] = true;
                            } else {
                                idList.add(id1);
                                this.m_isCalced[j] = true;
                            }
                        }
                        ++j;
                    }
                    if (idList.size() > 1) {
                        this.calcMultiple(idList);
                    } else {
                        this.calcOne(id);
                    }
                }
            }
            ++i2;
        }
    }

    public void calcMultiple(ArrayList idList) {
        int count = idList.size();
        IdentObj[] idBox = new IdentObj[count];
        TextStyleObj[] textStyleObj = new TextStyleObj[count];
        Dimension[] dimensions = new Dimension[count];
        int i = 0;
        while (i < count) {
            IdentObj id = (IdentObj)idList.get(i);
            idBox[i] = this.m_Perspective.getAnnotationBox(id);
            textStyleObj[i] = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), true, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), this.m_Perspective.getTextJustHoriz(id), this.m_Perspective.getTextJustVert(id), this.m_Perspective.getAutofit(id), false, this.m_Perspective.getTextWrap(id));
            textStyleObj[i].setTextTruncate(true, -1, 2);
            dimensions[i] = this.calcDim(id, textStyleObj[i]);
            ++i;
        }
        IdentObj id = (IdentObj)idList.get(0);
        Point valueCoord = ((JChart_2D_Standard)this.m_Perspective.m_chart).getCoords(id.getSeriesID(), id.getGroupID());
        Dimension d = this.calcMultiDim(dimensions);
        Point start = this.calcAnnotionStartPoint(d, valueCoord, id);
        boolean pointerOnTop = valueCoord.y > start.y && valueCoord.y >= start.y + d.height;
        Rectangle[] rect = this.calcMultiRect(start, dimensions);
        int i2 = 0;
        while (i2 < count) {
            id = (IdentObj)idList.get(i2);
            String text = this.m_Perspective.getTextString(id);
            if (text != null || !text.equals("")) {
                BlackBoxObj bbText = new BlackBoxObj(this.m_Perspective, id);
                BlackBoxObj bbBox = new BlackBoxObj(this.m_Perspective, idBox[i2]);
                if (i2 == 0 && !pointerOnTop || i2 == count - 1 && pointerOnTop) {
                    new DetPolygon(this.m_Perspective.getDetectiv(), idBox[i2], this.calcPolyWithPointer(rect[i2], valueCoord, pointerOnTop), (BlackBoxIF)bbBox, 1.0);
                } else {
                    new DetRect(this.m_Perspective.getDetectiv(), idBox[i2], rect[i2].x, rect[i2].y, rect[i2].width, rect[i2].height, bbBox);
                }
                new DetLabel(this.m_Perspective.getDetectiv(), id, text, rect[i2], textStyleObj[i2], bbText, true);
            }
            ++i2;
        }
    }

    public Dimension calcMultiDim(Dimension[] dimensions) {
        int count = dimensions.length;
        int width = dimensions[0].width;
        int height = dimensions[0].height;
        int i = 1;
        while (i < count) {
            if (dimensions[i].width > width) {
                width = dimensions[i].width;
            }
            height += dimensions[i].height;
            ++i;
        }
        return new Dimension(width, height);
    }

    public Rectangle[] calcMultiRect(Point start, Dimension[] dimensions) {
        int count = dimensions.length;
        Rectangle[] rect = new Rectangle[count];
        int newY = start.y;
        int i = 0;
        while (i < count) {
            rect[i] = new Rectangle(start.x, newY, dimensions[i].width, dimensions[i].height);
            newY += dimensions[i].height;
            ++i;
        }
        return rect;
    }

    public void calcOne(IdentObj id) {
        if (!(this.m_Perspective.m_chart instanceof JChart_2D_Standard)) {
            return;
        }
        IdentObj idBox = this.m_Perspective.getAnnotationBox(id);
        String text = this.m_Perspective.getTextString(id);
        if (text == null || text.equals("")) {
            return;
        }
        BlackBoxObj bbText = new BlackBoxObj(this.m_Perspective, id);
        BlackBoxObj bbBox = new BlackBoxObj(this.m_Perspective, idBox);
        TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), true, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), this.m_Perspective.getTextJustHoriz(id), this.m_Perspective.getTextJustVert(id), this.m_Perspective.getAutofit(id), false, this.m_Perspective.getTextWrap(id));
        textStyleObj.setTextTruncate(true, -1, 2);
        Point valueCoord = ((JChart_2D_Standard)this.m_Perspective.m_chart).getCoords(id.getSeriesID(), id.getGroupID());
        Dimension d = this.calcDim(id, textStyleObj);
        Point start = this.calcAnnotionStartPoint(d, valueCoord, id);
        Rectangle bounds = new Rectangle(start.x, start.y, d.width, d.height);
        new DetPolygon(this.m_Perspective.getDetectiv(), idBox, this.calcPoly(bounds, valueCoord), (BlackBoxIF)bbBox, 1.0);
        new DetLabel(this.m_Perspective.getDetectiv(), id, text, bounds, textStyleObj, bbText, true);
    }

    public Dimension calcDim(IdentObj id, TextStyleObj textStyleObj) {
        int availableWidth = this.MAX_WIDTH;
        if (!this.m_Perspective.getDisplay(id)) {
            return new Dimension(0, 0);
        }
        String text = this.m_Perspective.getTextString(id);
        boolean bTitleFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(id);
        int fontSize = !this.m_Perspective.getFontSizeAbsolute(id) ? this.m_Perspective.getVC().virtToDestHeight(this.m_Perspective.getFontSizeVC(id)) : this.m_Perspective.getFontSize(id);
        int fontStyle = this.m_Perspective.getFontStyle(id);
        String fontName = this.m_Perspective.getFontName(id);
        Font font = new Font(fontName, fontStyle, fontSize);
        FontMetrics fm = this.m_Perspective.getGraphicsContext().getFontMetrics(font);
        int fontHeight = TextStyleObj.getFontHeight(fm, this.m_Perspective.getFontMetricsResolver());
        int fontHeightVc = this.m_Perspective.getVC().destToVirtHeight(fontHeight);
        Vector strs = new Vector();
        int numWrappedLines = textStyleObj.extractLinesWordWrap(text, strs, this.m_Perspective.getVC().virtToDestWidth(availableWidth), fm, this.m_Perspective.getFontMetricsResolver());
        int height = fontHeightVc * (numWrappedLines + 1);
        int width = availableWidth;
        if (numWrappedLines == 1) {
            width = this.m_Perspective.getVC().destToVirtWidth(fm.stringWidth(text));
        }
        return new Dimension(width += this.m_Perspective.getVC().destToVirtWidth(fm.stringWidth("W")), height);
    }

    public Point calcAnnotionStartPoint(Dimension d, Point valueCoord, IdentObj id) {
        int y;
        int x;
        block16: {
            int x_middle = valueCoord.x - d.width / 2;
            int x_left = valueCoord.x - d.width;
            int x_right = valueCoord.x;
            int y_top = valueCoord.y + this.defaultDistance;
            int y_bottom = valueCoord.y - (this.defaultDistance + d.height);
            x = x_middle;
            y = y_top;
            if (this.m_Perspective.isChartLine()) {
                int sID = id.getSeriesID();
                int gID = id.getGroupID();
                Point leftCoord = gID - 1 >= 0 ? ((JChart_2D_Standard)this.m_Perspective.m_chart).getCoords(sID, gID - 1) : valueCoord;
                Point rightCoord = gID + 1 < this.m_Perspective.m_chart.getResetGroupsEnumerator().getNumGroups() ? ((JChart_2D_Standard)this.m_Perspective.m_chart).getCoords(sID, gID + 1) : valueCoord;
                if (leftCoord.y <= valueCoord.y) {
                    if (rightCoord.y > valueCoord.y) {
                        x = x_left;
                        if (x_left < this.m_pRect.x && x_right <= this.m_pRect.x + this.m_pRect.width) {
                            x = x_right;
                            y = y_bottom;
                        }
                    }
                } else if (rightCoord.y >= valueCoord.y) {
                    y = y_bottom;
                } else {
                    x = x_right;
                    if (x_right > this.m_pRect.x + this.m_pRect.width && x_left >= this.m_pRect.x) {
                        x = x_left;
                        y = y_bottom;
                    }
                }
            }
            Rectangle rect = new Rectangle(x, y, d.width, d.height);
            while (true) {
                if (this.m_pRect.x >= x) {
                    x = this.m_pRect.x + d.width / 16;
                }
                if (this.m_pRect.x + this.m_pRect.width <= x + d.width) {
                    x = this.m_pRect.x + this.m_pRect.width - (d.width + d.width / 16);
                }
                if (y + d.height >= this.m_pRect.y + this.m_pRect.height) {
                    y = this.m_pRect.y + this.m_pRect.height - (d.height + d.height / 12);
                }
                if (y <= this.m_pRect.y) {
                    y = this.m_pRect.y + d.height / 12;
                }
                if (!(rect = new Rectangle(x, y, d.width, d.height)).contains(valueCoord)) break block16;
                if (y + d.height > this.m_pRect.y) {
                    y -= d.height / 4;
                    continue;
                }
                if (x - d.width >= this.m_pRect.x) break;
                x += d.width / 4;
            }
            if (y + d.height == valueCoord.y) {
                y -= d.height / 10;
            }
            if (x - d.width == valueCoord.x) {
                x += d.width / 16;
            }
            rect = this.calcPoly(rect, valueCoord).getBounds();
            x = rect.x;
            y = rect.y;
        }
        return new Point(x, y);
    }

    public Polygon calcPoly(Rectangle rect, Point valueCoord) {
        int xPointerEnd;
        Polygon p = new Polygon();
        if (rect.contains(valueCoord) || rect.y <= valueCoord.y && valueCoord.y <= rect.y + rect.height) {
            p.addPoint(rect.x, rect.y);
            p.addPoint(rect.x + rect.width, rect.y);
            p.addPoint(rect.x + rect.width, rect.y + rect.height);
            p.addPoint(rect.x, rect.y + rect.height);
            return p;
        }
        boolean isReveresed = valueCoord.y > rect.y;
        boolean pointTowardsEnd = rect.x + rect.width / 2 < valueCoord.x;
        int xPointerBegin = pointTowardsEnd ? rect.x + rect.width - rect.width / 10 : rect.x + rect.width / 5;
        int n = xPointerEnd = pointTowardsEnd ? rect.x + rect.width - rect.width / 5 : rect.x + rect.width / 10;
        if (isReveresed) {
            p.addPoint(rect.x, rect.y);
            p.addPoint(rect.x + rect.width, rect.y);
            p.addPoint(rect.x + rect.width, rect.y + rect.height);
            p.addPoint(xPointerBegin, rect.y + rect.height);
            p.addPoint(valueCoord.x, valueCoord.y);
            p.addPoint(xPointerEnd, rect.y + rect.height);
            p.addPoint(rect.x, rect.y + rect.height);
        } else {
            p.addPoint(rect.x, rect.y);
            p.addPoint(xPointerEnd, rect.y);
            p.addPoint(valueCoord.x, valueCoord.y);
            p.addPoint(xPointerBegin, rect.y);
            p.addPoint(rect.x + rect.width, rect.y);
            p.addPoint(rect.x + rect.width, rect.y + rect.height);
            p.addPoint(rect.x, rect.y + rect.height);
        }
        return p;
    }

    public Polygon calcPolyWithPointer(Rectangle rect, Point valueCoord, boolean pointerOnTop) {
        Polygon p = new Polygon();
        if (rect.contains(valueCoord) || rect.y <= valueCoord.y && valueCoord.y <= rect.y + rect.height) {
            p.addPoint(rect.x, rect.y);
            p.addPoint(rect.x + rect.width, rect.y);
            p.addPoint(rect.x + rect.width, rect.y + rect.height);
            p.addPoint(rect.x, rect.y + rect.height);
            return p;
        }
        boolean pointTowardsEnd = rect.x + rect.width / 2 < valueCoord.x;
        int xPointerBegin = rect.x + rect.width / 5;
        int xPointerEnd = rect.x + rect.width / 10;
        if (pointTowardsEnd) {
            boolean pointCloserToCenter;
            boolean bl = pointCloserToCenter = rect.x + rect.width / 4 < valueCoord.x;
            if (pointCloserToCenter) {
                xPointerBegin = rect.x + rect.width - rect.width / 10;
                xPointerEnd = rect.x + rect.width - rect.width / 5;
            } else {
                xPointerBegin = rect.x + rect.width - rect.width * 3 / 10;
                xPointerEnd = rect.x + rect.width - rect.width * 4 / 10;
            }
        } else {
            boolean pointCloserToCenter;
            boolean bl = pointCloserToCenter = rect.x + rect.width - rect.width / 4 > valueCoord.x;
            if (pointCloserToCenter && !pointerOnTop) {
                xPointerBegin = rect.x + rect.width * 4 / 10;
                xPointerEnd = rect.x + rect.width * 3 / 10;
            }
        }
        if (pointerOnTop) {
            p.addPoint(rect.x, rect.y);
            p.addPoint(rect.x + rect.width, rect.y);
            p.addPoint(rect.x + rect.width, rect.y + rect.height);
            p.addPoint(xPointerBegin, rect.y + rect.height);
            p.addPoint(valueCoord.x, valueCoord.y);
            p.addPoint(xPointerEnd, rect.y + rect.height);
            p.addPoint(rect.x, rect.y + rect.height);
        } else {
            p.addPoint(rect.x, rect.y);
            p.addPoint(xPointerEnd, rect.y);
            p.addPoint(valueCoord.x, valueCoord.y);
            p.addPoint(xPointerBegin, rect.y);
            p.addPoint(rect.x + rect.width, rect.y);
            p.addPoint(rect.x + rect.width, rect.y + rect.height);
            p.addPoint(rect.x, rect.y + rect.height);
        }
        return p;
    }
}

