/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.NYDescriptor;
import oracle.dss.graph.pfj.Perspective;

public class AxisSplits {
    protected static final int Y1 = 0;
    protected static final int Y2 = 1;
    protected static final int Y3 = 2;
    protected static final int Y4 = 3;
    protected static final int Y5 = 4;
    protected static final int NUM_Y_AXES = 5;
    Perspective m_Perspective;
    protected int[] m_offsetArray;
    protected int[] m_sizeArray;

    public AxisSplits(Perspective perspective) {
        this.m_Perspective = perspective;
    }

    public int[] getAxisOffsets() {
        return this.m_offsetArray;
    }

    public int[] getAxisSizes() {
        return this.m_sizeArray;
    }

    public void calc() {
        int nY1Size = this.m_Perspective.getAxisSize(this.m_Perspective.getY1Axis());
        int nY2Size = this.m_Perspective.getAxisSize(this.m_Perspective.getY2Axis());
        int nY3Size = this.m_Perspective.getAxisSize(this.m_Perspective.getY3Axis());
        int nY4Size = this.m_Perspective.getAxisSize(this.m_Perspective.getY4Axis());
        int nY5Size = this.m_Perspective.getAxisSize(this.m_Perspective.getY5Axis());
        JGraphType gt = this.m_Perspective.getJGraphType();
        if (gt.isThreeY()) {
            boolean[] usageValues = NYDescriptor.usageValuesThreeY;
            if (nY1Size == 0 && nY2Size == 0 && nY3Size == 0) {
                this.setMultiYDefaultSplits(usageValues);
            } else {
                this.setThreeYSplits(usageValues);
            }
        } else if (gt.isFourY()) {
            boolean[] usageValues = NYDescriptor.usageValuesFourY;
            if (nY1Size == 0 && nY2Size == 0 && nY3Size == 0 && nY4Size == 0) {
                this.setMultiYDefaultSplits(usageValues);
            } else {
                this.setFourYSplits(usageValues);
            }
        } else if (gt.isFiveY()) {
            boolean[] usageValues = NYDescriptor.usageValuesFiveY;
            if (nY1Size == 0 && nY2Size == 0 && nY3Size == 0 && nY4Size == 0 && nY5Size == 0) {
                this.setMultiYDefaultSplits(usageValues);
            } else {
                this.setFourYSplits(usageValues);
                this.m_sizeArray[4] = this.m_Perspective.getAxisSize(this.m_Perspective.getY5Axis());
                this.m_offsetArray[4] = this.m_Perspective.getAxisOffset(this.m_Perspective.getY5Axis());
            }
        } else {
            boolean[] usageValues = NYDescriptor.usageValuesTwoY;
            NYDescriptor nyDescriptor = new NYDescriptor(usageValues);
            if (gt.isBipolar()) {
                this.setBipolarSplits(usageValues);
            } else {
                this.setShareSpaceSplits(usageValues);
            }
        }
    }

    protected void setThreeYSplits(boolean[] usageValues) {
        this.m_offsetArray = new int[usageValues.length];
        this.m_offsetArray[0] = this.m_Perspective.getAxisOffset(this.m_Perspective.getY1Axis());
        this.m_offsetArray[1] = this.m_Perspective.getAxisOffset(this.m_Perspective.getY2Axis());
        this.m_offsetArray[2] = this.m_Perspective.getAxisOffset(this.m_Perspective.getY3Axis());
        this.m_sizeArray = new int[usageValues.length];
        this.m_sizeArray[0] = this.m_Perspective.getAxisSize(this.m_Perspective.getY1Axis());
        this.m_sizeArray[1] = this.m_Perspective.getAxisSize(this.m_Perspective.getY2Axis());
        this.m_sizeArray[2] = this.m_Perspective.getAxisSize(this.m_Perspective.getY3Axis());
    }

    protected void setFourYSplits(boolean[] usageValues) {
        this.setThreeYSplits(usageValues);
        this.m_sizeArray[3] = this.m_Perspective.getAxisSize(this.m_Perspective.getY4Axis());
        this.m_offsetArray[3] = this.m_Perspective.getAxisOffset(this.m_Perspective.getY4Axis());
    }

    protected void setBipolarSplits(boolean[] usageValues) {
        int nSplit;
        this.m_offsetArray = new int[usageValues.length];
        this.m_sizeArray = new int[usageValues.length];
        this.m_offsetArray[0] = nSplit = this.m_Perspective.getDualAxisSplitPosition();
        this.m_sizeArray[0] = 100 - this.m_offsetArray[0];
        this.m_offsetArray[1] = 0;
        this.m_sizeArray[1] = 100 - this.m_sizeArray[0];
    }

    protected void setShareSpaceSplits(boolean[] usageValues) {
        this.m_offsetArray = new int[usageValues.length];
        this.m_sizeArray = new int[usageValues.length];
        int i = 0;
        while (i < this.m_offsetArray.length) {
            this.m_offsetArray[i] = 0;
            this.m_sizeArray[i] = 100;
            ++i;
        }
    }

    protected void setMultiYDefaultSplits(boolean[] usageValues) {
        NYDescriptor nyDescriptor = new NYDescriptor(usageValues);
        this.m_offsetArray = new int[usageValues.length];
        this.m_sizeArray = new int[usageValues.length];
        int i = 0;
        while (i < usageValues.length) {
            this.m_sizeArray[i] = (int)(100.0f * nyDescriptor.getSize(i));
            this.m_offsetArray[i] = (int)(100.0f * nyDescriptor.getOffset(i));
            ++i;
        }
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }
}

