/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;
import oracle.dss.graph.pfj.draw.IdentObj;

public class AxisTemplate
implements Serializable {
    public static final int ID_NOAXIS = -1;
    public static final int ID_Y1 = 0;
    public static final int ID_Y2 = 1;
    public static final int ID_Y3 = 2;
    public static final int ID_Y4 = 3;
    public static final int ID_Y5 = 4;
    public static final int ID_O1 = 5;
    public static final int ID_O2 = 6;
    public static final int ID_X1 = 7;
    public static final int ID_Z1 = 8;
    private int m_nObjId;
    private IdentObj m_axis;
    private IdentObj m_body;
    private IdentObj m_label;
    private IdentObj m_majorGrid;
    private IdentObj m_minorGrid;
    private IdentObj m_zeroLine;
    private IdentObj m_title;
    private IdentObj m_titleBox;
    private IdentObj m_drillLabel;
    private IdentObj m_drillLabelBox;
    private String m_displayString;
    public static final AxisTemplate O1_AXIS = new AxisTemplate(5, 2001, 269, 270, 271, 272, -3, 8, 49, 232, 230, "O1 Axis");
    public static final AxisTemplate O2_AXIS = new AxisTemplate(6, 2002, 273, 274, 275, 276, -3, 9, 50, 233, 231, "O2 Axis");
    public static final AxisTemplate X1_AXIS = new AxisTemplate(7, 2003, 279, 280, 281, 282, 291, 10, 51, -3, -3, "X Axis");
    public static final AxisTemplate Y1_AXIS = new AxisTemplate(0, 2004, 283, 284, 285, 286, 292, 6, 47, -3, -3, "Y1 Axis");
    public static final AxisTemplate Y2_AXIS = new AxisTemplate(1, 2005, 287, 288, 289, 290, 293, 7, 48, -3, -3, "Y2 Axis");
    public static final AxisTemplate Z1_AXIS = new AxisTemplate(8, 2006, 323, 324, 325, 326, 327, 11, 52, -3, -3, "Z Axis");
    public static final AxisTemplate Y3_AXIS = new AxisTemplate(2, 2012, 440, 441, 442, 443, 444, 67, 68, -3, -3, "Y3 Axis");
    public static final AxisTemplate Y4_AXIS = new AxisTemplate(3, 2013, 445, 446, 447, 448, 449, 69, 70, -3, -3, "Y4 Axis");
    public static final AxisTemplate Y5_AXIS = new AxisTemplate(4, 2014, 450, 451, 452, 453, 454, 71, 72, -3, -3, "Y5 Axis");

    private AxisTemplate(int nId, int nAxis, int nBody, int nLabel, int nMajor, int nMinor, int nZero, int nTitle, int nTitleBox, int nDrillLabel, int nDrillLabelBox, String displayString) {
        this.m_nObjId = nId;
        this.m_axis = new IdentObj(nAxis);
        this.m_body = new IdentObj(nBody);
        this.m_displayString = displayString;
        this.m_label = nLabel == 270 ? new IdentObj(nLabel, -3, 0) : (nLabel == 274 ? new IdentObj(nLabel, 0, -3) : new IdentObj(nLabel));
        this.m_majorGrid = new IdentObj(nMajor, true);
        this.m_minorGrid = new IdentObj(nMinor, true);
        this.m_zeroLine = new IdentObj(nZero);
        this.m_title = new IdentObj(nTitle);
        this.m_titleBox = new IdentObj(nTitleBox);
        this.m_drillLabel = new IdentObj(nDrillLabel);
        this.m_drillLabelBox = new IdentObj(nDrillLabelBox);
    }

    public final IdentObj getAxis() {
        return this.m_axis;
    }

    public int getAxisObjID() {
        return this.m_nObjId;
    }

    public final IdentObj getBody() {
        return this.m_body;
    }

    public final IdentObj getLabel() {
        return this.m_label;
    }

    public final IdentObj getMajor() {
        return this.m_majorGrid;
    }

    public final IdentObj getMinor() {
        return this.m_minorGrid;
    }

    public final IdentObj getTitle() {
        return this.m_title;
    }

    public final IdentObj getTitleBox() {
        return this.m_titleBox;
    }

    public final IdentObj getZeroLine() {
        return this.m_zeroLine;
    }

    public final IdentObj getDrillLabel() {
        return this.m_drillLabel;
    }

    public final IdentObj getDrillLabelBox() {
        return this.m_drillLabelBox;
    }

    public String getDisplayString() {
        return this.m_displayString;
    }

    public final boolean isNumeric() {
        return this.m_body.getObjectID() != 269 && this.m_body.getObjectID() != 273;
    }

    public static boolean isSameType(int assocAxis, int axis) {
        boolean bSameType = assocAxis == axis;
        bSameType |= assocAxis == 0 && axis == 1;
        bSameType |= assocAxis == 1 && axis == 0;
        bSameType |= assocAxis == 5 && axis == 6;
        bSameType |= assocAxis == 6 && axis == 5;
        switch (axis) {
            case 2: 
            case 3: 
            case 4: {
                bSameType = true;
            }
        }
        return bSameType;
    }
}

