/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.DataItem;

public class DataFormat
implements Serializable {
    private String m_name;
    private int m_rowsPerNode;
    private int m_colsPerNode;
    private DataItem[] m_dataItems;
    private static final DataItem[] DFITEMS_GENERAL = new DataItem[]{DataItem.DI_GENERAL};
    private static final DataItem[] DFITEMS_XY = new DataItem[]{DataItem.DI_XY_X, DataItem.DI_XY_Y};
    private static final DataItem[] DFITEMS_XY_LBL = new DataItem[]{DataItem.DI_XY_LBL_X, DataItem.DI_XY_LBL_Y, DataItem.DI_XY_LBL_LBL};
    private static final DataItem[] DFITEMS_XYZ = new DataItem[]{DataItem.DI_XYZ_X, DataItem.DI_XYZ_Y, DataItem.DI_XYZ_Z};
    private static final DataItem[] DFITEMS_XYZ_LBL = new DataItem[]{DataItem.DI_XYZ_LBL_X, DataItem.DI_XYZ_LBL_Y, DataItem.DI_XYZ_LBL_Z, DataItem.DI_XYZ_LBL_LBL};
    private static final DataItem[] DFITEMS_GANTT = new DataItem[]{DataItem.DI_GANTT_STARTDATE, DataItem.DI_GANTT_STOPDATE, DataItem.DI_GANTT_PERCENT_COMPLETE, DataItem.DI_GANTT_SECOND_STARTDATE, DataItem.DI_GANTT_SECOND_STOPDATE, DataItem.DI_GANTT_CHILDLINKLINE, DataItem.DI_GANTT_PARENT_IF_ROLLEDUP};
    private static final DataItem[] DFITEMS_HL = new DataItem[]{DataItem.DI_HL_H, DataItem.DI_HL_L};
    private static final DataItem[] DFITEMS_HLC = new DataItem[]{DataItem.DI_HLC_H, DataItem.DI_HLC_L, DataItem.DI_HLC_C};
    private static final DataItem[] DFITEMS_OHLC = new DataItem[]{DataItem.DI_OHLC_O, DataItem.DI_OHLC_H, DataItem.DI_OHLC_L, DataItem.DI_OHLC_C};
    private static final DataItem[] DFITEMS_HL_VOL = new DataItem[]{DataItem.DI_HL_VOL_H, DataItem.DI_HL_VOL_L, DataItem.DI_HL_VOL_VOL};
    private static final DataItem[] DFITEMS_HLC_VOL = new DataItem[]{DataItem.DI_HLC_VOL_H, DataItem.DI_HLC_VOL_L, DataItem.DI_HLC_VOL_C, DataItem.DI_HLC_VOL_VOL};
    private static final DataItem[] DFITEMS_OHLC_VOL = new DataItem[]{DataItem.DI_OHLC_VOL_O, DataItem.DI_OHLC_VOL_H, DataItem.DI_OHLC_VOL_L, DataItem.DI_OHLC_VOL_C, DataItem.DI_OHLC_VOL_VOL};
    private static final DataItem[] DFITEMS_OC = new DataItem[]{DataItem.DI_OC_O, DataItem.DI_OC_C};
    private static final DataItem[] DFITEMS_OC_VOL = new DataItem[]{DataItem.DI_OC_VOL_O, DataItem.DI_OC_VOL_C, DataItem.DI_OC_VOL_VOL};
    private static final DataItem[] DFITEMS_RESOURCE = new DataItem[]{DataItem.DI_RESOURCE_X, DataItem.DI_RESOURCE_Y};
    private static final DataItem[] DFITEMS_BREAKEVEN = new DataItem[]{DataItem.DI_BREAKEVEN_X_MIN, DataItem.DI_BREAKEVEN_Y_MIN, DataItem.DI_BREAKEVEN_X_MAX, DataItem.DI_BREAKEVEN_Y_MAX};
    public static final DataFormat DF_GENERAL = new DataFormat("DF_GENERAL", 1, 1, DFITEMS_GENERAL);
    public static final DataFormat DF_XY = new DataFormat("DF_XY", 1, 2, DFITEMS_XY);
    public static final DataFormat DF_XY_LBL = new DataFormat("DF_XY_LBL", 1, 3, DFITEMS_XY_LBL);
    public static final DataFormat DF_XYZ = new DataFormat("DF_XYZ", 1, 3, DFITEMS_XYZ);
    public static final DataFormat DF_XYZ_LBL = new DataFormat("DF_XYZ_LBL", 1, 4, DFITEMS_XYZ_LBL);
    public static final DataFormat DF_GANTT = new DataFormat("DF_GANTT", 1, 7, DFITEMS_GANTT);
    public static final DataFormat DF_HL = new DataFormat("DF_HL", 1, 2, DFITEMS_HL);
    public static final DataFormat DF_HLC = new DataFormat("DF_HLC", 1, 3, DFITEMS_HLC);
    public static final DataFormat DF_OHLC = new DataFormat("DF_OHLC", 1, 4, DFITEMS_OHLC);
    public static final DataFormat DF_HL_VOL = new DataFormat("DF_HL_VOL", 1, 3, DFITEMS_HL_VOL);
    public static final DataFormat DF_HLC_VOL = new DataFormat("DF_HLC_VOL", 1, 4, DFITEMS_HLC_VOL);
    public static final DataFormat DF_OHLC_VOL = new DataFormat("DF_OHLC_VOL", 1, 5, DFITEMS_OHLC_VOL);
    public static final DataFormat DF_OC = new DataFormat("DF_OC", 1, 2, DFITEMS_OC);
    public static final DataFormat DF_OC_VOL = new DataFormat("DF_OC_VOL", 1, 3, DFITEMS_OC_VOL);
    public static final DataFormat DF_RESOURCE = new DataFormat("DF_RESOURCE", 1, 2, DFITEMS_RESOURCE);
    public static final DataFormat DF_BREAKEVEN = new DataFormat("DF_BREAKEVEN", 1, 4, DFITEMS_BREAKEVEN);

    private DataFormat(String name, int nRows, int nCols, DataItem[] dataItems) {
        if (nRows < 1) {
            throw new AssertionException("DataFormat cannot be constructed with nRows < 0");
        }
        if (nCols < 1) {
            throw new AssertionException("DataFormat cannot be constructed with nCols < 0");
        }
        if (dataItems == null) {
            throw new AssertionException("DataFormat cannot be constructed with null dataItems array");
        }
        if (dataItems.length < 1) {
            throw new AssertionException("DataFormat cannot be constructed with dataItems array of length < 1");
        }
        this.m_name = name;
        this.m_rowsPerNode = nRows;
        this.m_colsPerNode = nCols;
        this.m_dataItems = dataItems;
    }

    public boolean equals(Object x) {
        if (!(x instanceof DataFormat)) {
            return false;
        }
        DataFormat xDF = (DataFormat)x;
        if (!this.m_name.equals(xDF.m_name)) {
            return false;
        }
        if (this.m_rowsPerNode != xDF.m_rowsPerNode) {
            return false;
        }
        if (this.m_colsPerNode != xDF.m_colsPerNode) {
            return false;
        }
        return this.m_dataItems == xDF.m_dataItems;
    }

    public int getColsPerNode() {
        return this.m_colsPerNode;
    }

    public DataItem getDataItem(int i) {
        if (i < 0 || i >= this.m_dataItems.length) {
            throw new AssertionException(0, this.m_dataItems.length, i);
        }
        return this.m_dataItems[i];
    }

    public int getNumDataItems() {
        return this.m_dataItems.length;
    }

    public int getRowsPerNode() {
        return this.m_rowsPerNode;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        return this.m_name + ": " + this.m_rowsPerNode + " rows, " + this.m_colsPerNode + " cols";
    }
}

